/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.coalescent;

import dr.evomodel.bigfasttree.BigFastTreeIntervals;
import dr.evomodel.coalescent.SingleTreeGriddedNodesTimeline;
import dr.inference.model.AbstractModelLikelihood;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.util.Author;
import dr.util.Citable;
import dr.util.Citation;
import dr.xml.Reportable;
import java.util.Arrays;
import java.util.List;

public class MultilocusNonparametricCoalescentLikelihood
extends AbstractModelLikelihood
implements Citable,
Reportable {
    private final int numGridPoints;
    private int[] numCoalEvents;
    private int[] storedNumCoalEvents;
    private double[] sufficientStatistics;
    private double[] storedSufficientStatistics;
    private final Parameter ploidyFactors;
    private double[] ploidySums;
    private double[] storedPloidySums;
    private final List<BigFastTreeIntervals> intervalsList;
    private final Parameter logPopSizes;
    private final Parameter gridPoints;
    private double logLikelihood;
    private double storedLogLikelihood;
    private boolean intervalsKnown;
    private boolean storedIntervalsKnown;
    private boolean likelihoodKnown;
    double[] fullTimeLine;
    int[] gridIndices;
    int[] numLineages;

    public MultilocusNonparametricCoalescentLikelihood(List<BigFastTreeIntervals> list, Parameter parameter, Parameter parameter2, Parameter parameter3) {
        super("Multilocus Nonparametric Coalescent Likelihood");
        this.addKeyword("skygrid");
        if (list.size() > 1) {
            this.addKeyword("multilocus");
        }
        this.intervalsList = list;
        this.logPopSizes = parameter;
        this.gridPoints = parameter2;
        this.ploidyFactors = parameter3;
        this.numGridPoints = parameter2.getDimension();
        this.addVariable(parameter);
        this.addVariable(parameter2);
        this.addVariable(parameter3);
        for (BigFastTreeIntervals bigFastTreeIntervals : list) {
            this.addModel(bigFastTreeIntervals);
        }
        if (parameter3.getDimension() != list.size()) {
            throw new IllegalArgumentException("Ploidy factors parameter should have length " + list.size());
        }
        int n = parameter.getDimension();
        this.sufficientStatistics = new double[n];
        this.storedSufficientStatistics = new double[n];
        this.numCoalEvents = new int[n];
        this.storedNumCoalEvents = new int[n];
        this.ploidySums = new double[n];
        this.storedPloidySums = new double[n];
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
        if (model instanceof BigFastTreeIntervals) {
            BigFastTreeIntervals bigFastTreeIntervals = (BigFastTreeIntervals)model;
            int n2 = this.intervalsList.indexOf(bigFastTreeIntervals);
            if (n2 < 0) {
                throw new RuntimeException("Unknown tree");
            }
        } else {
            throw new RuntimeException("Unknown object");
        }
        this.intervalsKnown = false;
        this.likelihoodKnown = false;
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        this.likelihoodKnown = false;
    }

    private void setupSufficientStatistics() {
        Arrays.fill(this.sufficientStatistics, 0.0);
        Arrays.fill(this.ploidySums, 0.0);
        for (int i = 0; i < this.intervalsList.size(); ++i) {
            double d;
            int n;
            double d2 = 1.0 / this.getPopulationFactor(i);
            SingleTreeGriddedNodesTimeline singleTreeGriddedNodesTimeline = new SingleTreeGriddedNodesTimeline(this.intervalsList.get(i), this.gridPoints);
            this.fullTimeLine = singleTreeGriddedNodesTimeline.getMergedTimeLine();
            this.numLineages = singleTreeGriddedNodesTimeline.getMergedNumLineages();
            this.gridIndices = singleTreeGriddedNodesTimeline.getGridIndices();
            this.numCoalEvents = singleTreeGriddedNodesTimeline.getNumCoalEvents();
            for (n = 0; this.gridIndices[n] == n; ++n) {
            }
            boolean bl = true;
            for (int j = n; j < this.numGridPoints; ++j) {
                while (n <= this.gridIndices[j]) {
                    if (!bl) {
                        d = this.fullTimeLine[n] - this.fullTimeLine[n - 1];
                        int n2 = j;
                        this.sufficientStatistics[n2] = this.sufficientStatistics[n2] + 0.5 * (double)this.numLineages[n - 1] * (double)(this.numLineages[n - 1] - 1) * d * d2;
                        int n3 = j;
                        this.ploidySums[n3] = this.ploidySums[n3] + Math.log(d2) * (double)this.numCoalEvents[j];
                    } else {
                        bl = false;
                    }
                    ++n;
                }
            }
            if (n >= this.fullTimeLine.length) continue;
            while (n < this.fullTimeLine.length) {
                d = this.fullTimeLine[n] - this.fullTimeLine[n - 1];
                int n4 = this.numGridPoints;
                this.sufficientStatistics[n4] = this.sufficientStatistics[n4] + 0.5 * (double)this.numLineages[n - 1] * (double)(this.numLineages[n - 1] - 1) * d * d2;
                int n5 = this.numGridPoints;
                this.ploidySums[n5] = this.ploidySums[n5] + Math.log(d2) * (double)this.numCoalEvents[this.numGridPoints];
                ++n;
            }
        }
    }

    protected double calculateLogCoalescentLikelihood() {
        this.computeSufficientStatistics();
        double d = 0.0;
        for (int i = 0; i < this.logPopSizes.getDimension(); ++i) {
            double d2 = this.logPopSizes.getParameterValue(i);
            d += (double)(-this.numCoalEvents[i]) * d2 + this.ploidySums[i] - this.sufficientStatistics[i] * Math.exp(-d2);
        }
        return d;
    }

    @Override
    public Model getModel() {
        return this;
    }

    @Override
    public double getLogLikelihood() {
        if (!this.likelihoodKnown) {
            this.logLikelihood = this.calculateLogCoalescentLikelihood();
            this.likelihoodKnown = true;
        }
        return this.logLikelihood;
    }

    @Override
    public void makeDirty() {
        this.intervalsKnown = false;
        this.likelihoodKnown = false;
    }

    private double getPopulationFactor(int n) {
        return this.ploidyFactors.getParameterValue(n);
    }

    protected int getNGridPoints() {
        return this.gridPoints.getDimension();
    }

    protected double getPopulationSize(int n) {
        return Math.exp(this.logPopSizes.getParameterValue(n));
    }

    protected double getLogPopulationSize(int n) {
        return this.logPopSizes.getParameterValue(n);
    }

    protected Parameter getLogPopSizes() {
        return this.logPopSizes;
    }

    protected int getPopSizeDimension() {
        return this.logPopSizes.getDimension();
    }

    @Override
    protected void storeState() {
        System.arraycopy(this.numCoalEvents, 0, this.storedNumCoalEvents, 0, this.numCoalEvents.length);
        System.arraycopy(this.ploidySums, 0, this.storedPloidySums, 0, this.ploidySums.length);
        System.arraycopy(this.sufficientStatistics, 0, this.storedSufficientStatistics, 0, this.sufficientStatistics.length);
        this.storedIntervalsKnown = this.intervalsKnown;
        this.storedLogLikelihood = this.logLikelihood;
    }

    @Override
    protected void restoreState() {
        int[] nArray = this.numCoalEvents;
        this.numCoalEvents = this.storedNumCoalEvents;
        this.storedNumCoalEvents = nArray;
        double[] dArray = this.ploidySums;
        this.ploidySums = this.storedPloidySums;
        this.storedPloidySums = dArray;
        double[] dArray2 = this.sufficientStatistics;
        this.sufficientStatistics = this.storedSufficientStatistics;
        this.storedSufficientStatistics = dArray2;
        this.intervalsKnown = this.storedIntervalsKnown;
        this.logLikelihood = this.storedLogLikelihood;
    }

    @Override
    protected void acceptState() {
    }

    private double[] getGradientLogDensity() {
        return this.getGradientLogDensity(this.logPopSizes.getParameterValues());
    }

    public double[] getGradientLogDensity(Object object) {
        double[] dArray = (double[])object;
        this.computeSufficientStatistics();
        int n = dArray.length;
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray2[i] = (double)(-this.numCoalEvents[i]) + this.sufficientStatistics[i] * Math.exp(-dArray[i]);
        }
        return dArray2;
    }

    private void computeSufficientStatistics() {
        if (!this.intervalsKnown) {
            this.setupSufficientStatistics();
            this.intervalsKnown = true;
        }
    }

    @Override
    public String getReport() {
        return "Non-parametric Coalescent LogLikelihood: " + this.getLogLikelihood() + "\nSufficient statistics: " + Arrays.toString(this.sufficientStatistics) + "\nPloidy factors: " + Arrays.toString(this.ploidyFactors.getParameterValues()) + "\nGrid points: " + Arrays.toString(this.gridPoints.getParameterValues()) + "\nLog population sizes: " + Arrays.toString(this.logPopSizes.getParameterValues()) + "\nFull time line: " + Arrays.toString(this.fullTimeLine) + "\n";
    }

    @Override
    public Citation.Category getCategory() {
        return Citation.Category.TREE_PRIORS;
    }

    @Override
    public String getDescription() {
        return "Non-parametric coalescent";
    }

    @Override
    public List<Citation> getCitations() {
        return Arrays.asList(new Citation(new Author[]{new Author("MS", "Gill"), new Author("P", "Lemey"), new Author("NR", "Faria"), new Author("A", "Rambaut"), new Author("B", "Shapiro"), new Author("MA", "Suchard")}, "Improving Bayesian population dynamics inference: a coalescent-based model for multiple loci", 2013, "Mol Biol Evol", 30, 713, 724), new Citation(new Author[]{new Author("VN", "Minin"), new Author("EW", "Bloomquist"), new Author("MA", "Suchard")}, "Smooth skyride through a rough skyline: Bayesian coalescent-based inference of population dynamics", 2008, "Mol Biol Evol", 25, 1459, 1471, "10.1093/molbev/msn090"));
    }
}

