/*
 *  Print Dialog for Canon LIPS/PS/LIPSLX/UFR2/CAPT Printer.
 *  Copyright (C) 2004-2008 CANON INC.
 *  All Rights Reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "uimain.h"
#include "widgets.h"
#include "mltlang.h"
#include "callbacks.h"
#include "interface.h"
#include "support.h"

UIPassWdDlg* CreatePassWdDlg(UIDialog *parent, int type)
{
        UIPassWdDlg *dialog;

        dialog = (UIPassWdDlg *)CreateDialog(sizeof(UIPassWdDlg), parent);

	if(dialog == NULL)
		return NULL;

        UI_DIALOG(dialog)->window = create_IdPassWdDlg();

	dialog->print = 0;
	if(type == 0 && UI_DLG_TOP(dialog)->file_name != NULL){
		char *file;
		if((file = strrchr(UI_DLG_TOP(dialog)->file_name, '/')) != NULL)
			file++;
		else
			file = UI_DLG_TOP(dialog)->file_name;
		UpdateData(ID_SECURED_DOCNAME, file);
	}

	SetEntryVisibility(UI_DIALOG(dialog)->window, "PassWd_entry");
        return dialog;
}

int GetCharSet(void)
{
	char *lang = NULL;

	if((lang = getenv("LC_CTYPE")) == NULL)
		lang = getenv("LANG");
	if(lang != NULL){
		if(strncasecmp("ja", lang, 2) == 0){
#ifndef OLD_GTK
			return 2;
#endif
			char *tmp = lang;
			while(1){
				if(*tmp == '.'){
					tmp++;
					break;
				}
				if(*tmp == '\0'){
					return 0;
				}
				tmp++;
			}
			if(strncasecmp(tmp, "UTF-8", 5) == 0)
				return 2;
			else if(strncasecmp(tmp, "euc", 3) == 0)
				return 1;
		}
	}
	return 0;
}

void ShowPassWdDlg(UIPassWdDlg *dialog, int print, int type, int doc, int id, int pswd)
{
	if(print == PASSWDDLG_PRINT)
		dialog->print = 1;

	dialog->type = type;
	UI_DLG_TOP(dialog)->prop->show_passwd = type;

	dialog->code = GetCharSet();
	SigDisable();
	UpdatePassWdWidgets(dialog, doc, id, pswd);
	SigEnable();
	ShowDialog((UIDialog *)dialog, NULL);
}

void HidePassWdDlg(UIPassWdDlg *dialog, int apply)
{
	if(apply){
		char *ps = NULL, *usr = NULL;
		ps = GetTextEntry(UI_DIALOG(dialog)->window, "PassWd_entry");
		usr = GetTextEntry(UI_DIALOG(dialog)->window, "ID_entry");

		if(dialog->type == PASSWDDLG_SECURED){
			if(dialog->print == PASSWDDLG_PRINT){
				if(strlen(ps) == 0
				|| strlen(usr) == 0)
					return;
				UI_DLG_TOP(dialog)->print_ok = 1;
			}
			cngplpSetData(UI_DLG_TOP(dialog)->data, ID_OK, "Secured");
		}else{
			if(dialog->print == PASSWDDLG_PRINT){
				if(strlen(ps) == 0
				|| strlen(usr) == 0)
					return;
				UI_DLG_TOP(dialog)->print_ok = 1;
			}
			cngplpSetData(UI_DLG_TOP(dialog)->data, ID_OK, "JobAccount");
		}
	}else{
		if(dialog->type == PASSWDDLG_SECURED)
			cngplpSetData(UI_DLG_TOP(dialog)->data, ID_CANCEL, "Secured");
		else
			cngplpSetData(UI_DLG_TOP(dialog)->data, ID_CANCEL, "JobAccount");
	}
	UI_DLG_TOP(dialog)->prop->show_passwd = -1;
	HideDialog((UIDialog *)dialog);
}

void UpdatePassWdWidgets(UIPassWdDlg *dialog, int doc, int id, int pswd)
{
	GtkWidget *window;
	gchar *text, *value;
	int max_doc_length;

	window = UI_DIALOG(dialog)->window;

	if(dialog->type == PASSWDDLG_JOBACCOUNT)
		text = NameToText(ID_JOBACCOUNT, "JobAccount");
	else
		text = NameToText(ID_SECURED_PASSWD, "Secured");
	SetDialogTitle(window, text);

	max_doc_length = GetCurrOptInt(ID_DOC_LENGTH, 32);

	if(doc && UI_DLG_TOP(dialog)->file_name != NULL){
		char *file = NULL;

		file = GetCurrOpt(ID_SECURED_DOCNAME, NULL);

		ShowWidget(window, "DocName_label");
		ShowWidget(window, "DocName_entry");
		SetTextMaxLength(window, "DocName_entry", max_doc_length);
		if(dialog->type == PASSWDDLG_SECURED && dialog->print == PASSWDDLG_PRINT && file != NULL)
			SetTextEntry(window, "DocName_entry", file);
		memFree(file);
	}else{
		HideWidget(window, "DocName_label");
		HideWidget(window, "DocName_entry");
	}

	if(id){
		ShowWidget(window, "UsrName_ID_label");
		ShowWidget(window, "ID_entry");
		value = NULL;
		if(dialog->type == PASSWDDLG_SECURED){
			ShowWidget(window, "UsrName_ID_Text_label");
			SetTextMaxLength(window, "ID_entry", max_doc_length);
			value = GetCurrOpt(ID_SECURED_USRNAME, NULL);
		}else{
			SetTextToLabel(window, "UsrName_ID_label", "ID");
			SetTextMaxLength(window, "ID_entry", 7);
			value = GetCurrOpt(ID_JOBACCOUNT_ID, NULL);
		}
		if(value != NULL)
			SetTextEntry(window, "ID_entry", value);
		memFree(value);
	}

	if(pswd){
		ShowWidget(window, "Passwd_label");
		ShowWidget(window, "PassWd_entry");
		value = NULL;
		if(dialog->type == PASSWDDLG_SECURED){
			ShowWidget(window, "PasswdText_label");
			value = GetCurrOpt(ID_SECURED_PASSWD, NULL);
		}else{
			value = GetCurrOpt(ID_JOBACCOUNT_PASSWD, NULL);
		}
		if(value != NULL)
			SetTextEntry(window, "PassWd_entry", value);
		memFree(value);
	}else{
		HideWidget(window, "Passwd_label");
		HideWidget(window, "PassWd_entry");
	}
}


