/*
 *  Print Dialog for Canon LIPS/PS/LIPSLX/UFR2/CAPT Printer.
 *  Copyright (C) 2004-2008 CANON INC.
 *  All Rights Reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "cngplpmod.h"
#include "cupsoption.h"
#include "ppdoptions.h"
#include "ppdkeys.h"


#ifndef __APPLE__
#include <locale.h>
#endif

char *MakeDuplexBoolList(PPDOptions *ppd_opt);

char* AddList(char *list, char *add)
{
	char *tmp;

	if(list == NULL){
		tmp = strdup(add);
		if(tmp == NULL)
			return NULL;
	}else{
		int size;
		size = strlen(list) + strlen(add) + 4;
		tmp = (char *)malloc(size);
		memset(tmp, 0, size);
		strcpy(tmp, list);
		strcat(tmp, ",");
		strcat(tmp, add);
		MemFree(list);
	}
	return tmp;
}

char* MakePPDOptionList(PPDOptions *ppd_opt, char *item_name)
{
	char *glist = NULL;
	char curr[256];
	int flag = 1;
	UIItemsList *item;
	UIOptionList *tmp_opt_list;

	item = FindItemsList(ppd_opt->items_list, item_name);
	if(item == NULL)
		return NULL;

	memset(curr, 0, 256);
	if(item->current_option && item->current_option->name)
		snprintf(curr, 255, "%s:", item->current_option->name);
	else
		snprintf(curr, 255, "%s:", item->opt_lists->name);

	tmp_opt_list = item->opt_lists;
	while(1){
		char tmp[256];
		memset(tmp, 0, 256);
		if(strcmp(item_name, "StapleLocation") == 0
		|| strcmp(item_name, "Booklet") == 0){
			if(strcmp(tmp_opt_list->name, "None") == 0){
				if(tmp_opt_list->next == NULL)
					break;
				tmp_opt_list = tmp_opt_list->next;
			}
		}
		if(flag){
			if(strcmp(item_name, "PageSize") == 0
			|| strcmp(item_name, "BindEdge") == 0){
				snprintf(tmp, 255, "%s%s<%d>", curr, tmp_opt_list->name, 0);
			}else{
				int disable = 0;
				if(strcmp(tmp_opt_list->name, item->current_option->name) == 0)
					disable = 0;
				else
					disable = tmp_opt_list->disable;
				snprintf(tmp, 255, "%s%s<%d>", curr, tmp_opt_list->name, disable);
			}
			glist = AddList(glist, tmp);
			flag = 0;
		}else{
			if(strcmp(item_name, "PageSize") == 0){
				int disable = 0;
				if(strcmp(tmp_opt_list->name, "Custom") == 0
				&& strcmp(item->current_option->name, "Custom"))
					disable = 1;
				else
					disable = 0;
				snprintf(tmp, 255, "%s<%d>", tmp_opt_list->name, disable);
			}else if(strcmp(item_name, "BindEdge") == 0){
				snprintf(tmp, 255, "%s<%d>", tmp_opt_list->name, 0);
			}else{
				int disable = 0;
				if(strcmp(tmp_opt_list->name, item->current_option->name) == 0)
					disable = 0;
				else
					disable = tmp_opt_list->disable;
				snprintf(tmp, 255, "%s<%d>", tmp_opt_list->name, disable);
			}
			glist = AddList(glist, tmp);
		}
		if(tmp_opt_list->next == NULL)
			break;
		tmp_opt_list = tmp_opt_list->next;
	}
	return glist;
}

char *MakeCNPunchBoolList(PPDOptions *ppd_opt, char *item_name)
{
	char *glist = NULL;
	char curr[256];
	char *punch;
	UIItemsList *item;

	item = FindItemsList(ppd_opt->items_list, item_name);
	if(item == NULL)
		return NULL;

	memset(curr, 0, 256);
	punch = FindCurrOpt(ppd_opt->items_list, item_name);
	if(punch != NULL){
		if(strcmp(punch, "Left") == 0
		|| strcmp(punch, "Right") == 0
		|| strcmp(punch, "Top") == 0
		|| strcmp(punch, "Bottom") == 0){
			strcpy(curr, "True:True<0>,False<0>");
		}else{
			char *bind;
			int dis = 1;
			bind = FindCurrOpt(ppd_opt->items_list, "BindEdge");
			if(bind != NULL){
				dis = GetDisableOpt(ppd_opt->items_list, item_name, bind);
			}
			if(dis == 0)
				strcpy(curr, "False:True<0>,False<0>");
			else
				strcpy(curr, "False:True<4>,False<0>");
		}
	}
	return glist = strdup(curr);
}

char *MakePPDBoolList(PPDOptions *ppd_opt, char *item_name)
{
	char *glist = NULL;
	char curr[256];
	int disable;
	UIItemsList *item;

	item = FindItemsList(ppd_opt->items_list, item_name);
	if(item == NULL)
		return NULL;

	disable = GetDisable(ppd_opt->items_list, item_name);

	memset(curr, 0, 256);
	if(item->current_option && item->current_option->name){
		if(strcmp(item->current_option->name, "False") == 0
		|| strcmp(item->current_option->name, "None") == 0)
			snprintf(curr, 255, "False:True<%d>,False<0>",disable);
		else
			snprintf(curr, 255, "True:True<%d>,False<0>", disable);
	}else{
		if(strcmp(item->opt_lists->name, "False") == 0
		|| strcmp(item->opt_lists->name, "None") == 0)
			snprintf(curr, 255, "False:True<%d>,False<0>", disable);
		else
			snprintf(curr, 255, "True:True<%d>,False<0>", disable);
	}

	return glist = strdup(curr);
}

#ifndef __APPLE__

char* DoubleToChar(double value)
{
	char *num;
	num = (char *)malloc(256);
	memset(num, 0, 256);
    setlocale (LC_NUMERIC, "C");
	snprintf(num, 255, "%f", value);
    setlocale (LC_NUMERIC, "");
	return num;
}
char* DoubleToChar2(double value)
{
	char *num;
	num = (char *)malloc(256);
	memset(num, 0, 256);
        setlocale (LC_NUMERIC, "C");
	snprintf(num, 255, "%.2f", value);
        setlocale (LC_NUMERIC, "");
	return num;
}

#else

char* DoubleToChar(double value)
{
	char *num;
	num = (char *)malloc(256);
	memset(num, 0, 256);
	snprintf(num, 255, "%f", value);
	return num;
}
char* DoubleToChar2(double value)
{
	char *num;
	num = (char *)malloc(256);
	memset(num, 0, 256);
	snprintf(num, 255, "%.2f", value);
	return num;
}

#endif


char* IntToChar(int value)
{
	char *num;
	num = (char *)malloc(256);
	memset(num, 0, 256);
	snprintf(num, 255, "%d", value);
	return num;
}

char* ToChar(char *value)
{
	char *ret = NULL;
	int size = 0;
	if(value != NULL){
		size = strlen(value) + 1;
		ret = (char *)malloc(size);
		if(ret == NULL)
			return NULL;

		memset(ret, 0, size);
		strncpy(ret, value, size - 1);
	}
	return ret;
}

char* GetDataCommonOption(cngplpData *data, int id)
{
	char *list = NULL;
	int i;
	char curr[256];
	char *option = NULL;
	int index = id - ID_COMMON_OPTION - 1;
	option = IDtoCommonOption(index);

	memset(curr, 0, 255);

	switch(id){
	case ID_PRINTERNAME:
		snprintf(curr, 255, "%s:%s<0>", data->curr_printer, data->printer_names[0]);
		list = AddList(list, curr);
		for(i = 1; i < data->printer_num; i++){
			char tmp[256];
			memset(tmp, 0, 255);
			snprintf(tmp, 255, "%s<0>", data->printer_names[i]);
			list = AddList(list, tmp);
		}
		break;
	case ID_NUMBER_UP:
		snprintf(curr, 255, "%s:%s<0>", GetCupsValue(data->cups_opt->common->option, "number-up"), NupTextValue_table[0].text);
		list = AddList(list, curr);
		for(i = 1; NupTextValue_table[i].text != NULL; i++){
			char tmp[256];
			memset(tmp, 0, 255);
			snprintf(tmp, 255, "%s<0>", NupTextValue_table[i].text);
			list = AddList(list, tmp);
		}
		break;
	case ID_FILTER:
		snprintf(curr, 255, "%s:%s<0>", GetCupsValue(data->cups_opt->common->option, "Filter"), g_filter_options[0]);
		list = AddList(list, curr);
		for(i = 1; g_filter_options[i] != NULL; i++){
			char tmp[256];
			memset(tmp, 0, 255);
			snprintf(tmp, 255, "%s<0>", g_filter_options[i]);
			list = AddList(list, tmp);
		}
		break;
	case ID_JOB_SHEETS_START:
		snprintf(curr, 255, "%s:%s<0>", GetCupsValue(data->cups_opt->common->option, "job-sheets-start"), g_banner_option[0]);
		list = AddList(list, curr);
		for(i = 1; g_banner_option[i] != NULL; i++){
			char tmp[256];
			memset(tmp, 0, 255);
			snprintf(tmp, 255, "%s<0>", g_banner_option[i]);
			list = AddList(list, tmp);
		}
		break;
	case ID_JOB_SHEETS_END:
		snprintf(curr, 255, "%s:%s<0>", GetCupsValue(data->cups_opt->common->option, "job-sheets-end"), g_banner_option[0]);
		list = AddList(list, curr);
		for(i = 1; g_banner_option[i] != NULL; i++){
			char tmp[256];
			memset(tmp, 0, 255);
			snprintf(tmp, 255, "%s<0>", g_banner_option[i]);
			list = AddList(list, tmp);
		}
		break;
	default:
		if(option != NULL)
			return ToChar(GetCupsValue(data->cups_opt->common->option, option));
		break;
	}
	return list;
}

char* GetDataPPDOption(cngplpData *data, int id)
{
	char *option = NULL;

	switch(id){
	case ID_SELECTBY:
		return IntToChar(data->ppd_opt->selectby);
	case ID_JOBACCOUNT:
		if(data->ppd_opt->special == NULL)
			return NULL;
		else{
#ifndef	__APPLE__
			return IntToChar(data->ppd_opt->special->job_account);
#else
			return ToChar(data->ppd_opt->special->job_account == 0 ? "False" : "True");
#endif
		}
	case ID_JOBACCOUNT_ID:
		if(data->ppd_opt->special == NULL)
			return NULL;
		else
		return ToChar(data->ppd_opt->special->job_account_id);
	case ID_JOBACCOUNT_PASSWD:
		if(data->ppd_opt->special == NULL)
			return NULL;
		else
		return ToChar(data->ppd_opt->special->job_account_passwd);
	case ID_DATANAME:
		if(data->ppd_opt->special == NULL)
			return NULL;
		else
		return IntToChar(data->ppd_opt->special->data_name);
	case ID_ENTERNAME:
		if(data->ppd_opt->special == NULL)
			return NULL;
		else
		return ToChar(data->ppd_opt->special->enter_name);
	case ID_BOXIDNUM:
		if(data->ppd_opt->special == NULL)
			return NULL;
		else
#ifndef __APPLE__
		return IntToChar(data->ppd_opt->special->box_num);
#else
		return ToChar(data->ppd_opt->special->box_num);
#endif
	case ID_MAX_BOXIDNUM:
		return IntToChar(data->ppd_opt->max_box_num);
	case ID_GUTTER:
		if(data->ppd_opt->summary_flag & CNSUMMARY_FLG_GUTTER)
			return NULL;
                if(data->ppd_opt->us_type)
                        return DoubleToChar(data->ppd_opt->gutter_value_d);
                else
                        return IntToChar(data->ppd_opt->gutter_value);
	case ID_MAX_GUTTER:
                if(data->ppd_opt->us_type)
                        return DoubleToChar(data->ppd_opt->max_gutter_value_d);
                else
                        return IntToChar(data->ppd_opt->max_gutter_value);
        case ID_USTYPE:
                return ToChar(data->ppd_opt->us_type == 0 ? "False" : "True");
	case ID_LIST_MEDIATYPE:
		return IntToChar(data->ppd_opt->list_mediatype_value);
  case ID_LIST_PAGESIZE:
      return IntToChar(data->ppd_opt->list_pagesize_value);
	case ID_SECURED_DOCNAME:
		if(data->ppd_opt->special == NULL)
			return NULL;
		else
		return ToChar(data->ppd_opt->special->doc_name);
	case ID_SECURED_USRNAME:
		if(data->ppd_opt->special == NULL)
			return NULL;
		else
		return ToChar(data->ppd_opt->special->usr_name);
	case ID_SECURED_PASSWD:
		if(data->ppd_opt->special == NULL)
			return NULL;
		else
		return ToChar(data->ppd_opt->special->passwd_array);
	case ID_COLOR_MODE:
		return IntToChar(data->ppd_opt->color_mode);
	case ID_PRINTERTYPE:
		return IntToChar(data->ppd_opt->printer_type);
	case ID_MAX_COPIES:
		return IntToChar(data->ppd_opt->max_copy_num);
	case ID_SPECIAL_FUNC:
		return ToChar(data->ppd_opt->special != NULL ? "1" : "0");
	case ID_DOC_LENGTH:
		return IntToChar(data->ppd_opt->max_doc_length);
	case ID_DUPLEX:
		option = IDtoPPDOption(id - 1);
		if(option == NULL)
			return NULL;
		return MakeDuplexBoolList(data->ppd_opt);
	case ID_BOOKLET:
	case ID_CNSADDLESTITCH:
	case ID_CNTRIMMING:
	case ID_CNZFOLDING:
	case ID_CNINSERTER:
	case ID_CNPUREBLACKPROCESS:
	case ID_CNPUNCHER:
	case ID_CNFOLDER:
	case ID_CNINSERTUNIT:
	case ID_CNTRIMMER:
	case ID_CNDUPLEXUNIT:
	case ID_CNSUPERSMOOTH:
	case ID_CNBACKPAPERPRINT:
	case ID_CNROTATEPRINT:
	case ID_CNCOPYSETNUMBERING:
	case ID_CNINTERLEAFSHEET:
	case ID_CNINTERLEAFPRINT:
	case ID_CNSKIPBLANK:
	case ID_CNDETECTPAPERSIZE:
	case ID_CNRGBPUREBLACKPROCESS:
	case ID_CNUSEGRAYSCALEPROFILE:
	case ID_CNLASTPAGEPRINTMODE:
	case ID_CNSET_FRONT_COVER:
	case ID_CNSET_BACK_COVER:
		option = IDtoPPDOption(id - 1);
		if(option == NULL)
			return NULL;
#ifdef	__APPLE__
		if(data->ppd_opt->printer_type != PRINTER_TYPE_CAPT)
		{
			switch(id){
			case ID_CNPUNCHER:
			case ID_BOOKLET:
			case ID_CNFOLDER:
			case ID_CNTRIMMER:
			case ID_CNINSERTUNIT:
				return MakePPDOptionList(data->ppd_opt, option);
			default:
				return MakePPDBoolList(data->ppd_opt, option);
			}
		}
		else {
			switch(id){
			case ID_CNSUPERSMOOTH:
				return MakePPDOptionList(data->ppd_opt, option);
			default:
				return MakePPDBoolList(data->ppd_opt, option);
			}
#endif
			return MakePPDBoolList(data->ppd_opt, option);
#ifdef	__APPLE__
		}
#endif
	case ID_CNPUNCH:
		option = IDtoPPDOption(id - 1);
		if(option == NULL)
			return NULL;
		return MakeCNPunchBoolList(data->ppd_opt, option);
	case ID_BOOKLET_DLG:
		option = IDtoPPDOption(ID_BOOKLET - 1);
		if(option == NULL)
			return NULL;
		return MakePPDOptionList(data->ppd_opt, option);
	case ID_STARTNUM:
		return IntToChar(data->ppd_opt->startnum_value);
	case ID_USERID:
		return IntToChar(getuid());
	case ID_BACKPAPERPRINT_LABEL:
		return ToChar(GetItemString(data->ppd_opt->items_list, "CNBackPaperPrint"));
	case ID_DISABLE_JOBACCOUNT_BW:
		if(data->ppd_opt->special == NULL)
			return NULL;
		else
#ifndef	__APPLE__
			return IntToChar(data->ppd_opt->special->disable_job_account_bw);
#else
			return ToChar(data->ppd_opt->special->disable_job_account_bw == 0 ? "False:True<0>,False<0>" : "True:True<0>,False<0>");
#endif
	case ID_SHOW_DISABLE_JOBACCOUNT_BW:
		if(data->ppd_opt->special == NULL)
			return NULL;
		else
		return IntToChar(data->ppd_opt->special->show_disable_job_account_bw);
	case ID_DETECTPAPER_LABEL:
		return ToChar(GetItemString(data->ppd_opt->items_list, "CNDetectPaperSize"));
	case ID_CNDPICONPICTID:
		if(data->ppd_opt->dpicon_pictid > 0)
			return IntToChar(data->ppd_opt->dpicon_pictid);
		break;
	case ID_CNENABLEFINISHFLAG:
		if(data->ppd_opt->enable_finishflag > 0)
			return IntToChar(data->ppd_opt->enable_finishflag);
		break;
	case ID_CNENABLEINPUTFLAG:
		if(data->ppd_opt->enable_inputflag > 0)
			return IntToChar(data->ppd_opt->enable_inputflag);
		break;
	case ID_CNENABLEQUALITYTYPE:
		if(data->ppd_opt->enable_qualitytype > 0)
			return IntToChar(data->ppd_opt->enable_qualitytype);
		break;
	case ID_INPUTSLOT_TYPE:
		return IntToChar(data->ppd_opt->input_slot_type);

	case ID_CNSHIFTTYPE:
		return IntToChar(data->ppd_opt->shift_pos_type);
	case ID_CNSHIFTUPWARDS:
		if((option = GetUIValue(data, "CNEnableDetailShiftPosition")) != NULL){
			if(strcasecmp(option,"True") == 0){
				return DoubleToChar(data->ppd_opt->detail_shift_upwards);
			}
		}
		return IntToChar(data->ppd_opt->shift_upwards);
	case ID_CNSHIFTRIGHT:
		if((option = GetUIValue(data, "CNEnableDetailShiftPosition")) != NULL){
			if(strcasecmp(option,"True") == 0){
				return DoubleToChar(data->ppd_opt->detail_shift_right);
			}
		}
		return IntToChar(data->ppd_opt->shift_right);
	case ID_CNSHIFTFRLONGEDGE:
		if((option = GetUIValue(data, "CNEnableDetailShiftPosition")) != NULL){
			if(strcasecmp(option,"True") == 0){
				return DoubleToChar(data->ppd_opt->detail_shift_front_long);
			}
		}
		return IntToChar(data->ppd_opt->shift_front_long);
	case ID_CNSHIFTFRSHORTEDGE:
		if((option = GetUIValue(data, "CNEnableDetailShiftPosition")) != NULL){
			if(strcasecmp(option,"True") == 0){
				return DoubleToChar(data->ppd_opt->detail_shift_front_short);
			}
		}
		return IntToChar(data->ppd_opt->shift_front_short);
	case ID_CNSHIFTBKLONGEDGE:
		if((option = GetUIValue(data, "CNEnableDetailShiftPosition")) != NULL){
			if(strcasecmp(option,"True") == 0){
				return DoubleToChar(data->ppd_opt->detail_shift_back_long);
			}
		}
		return IntToChar(data->ppd_opt->shift_back_long);
	case ID_CNSHIFTBKSHORTEDGE:
		if((option = GetUIValue(data, "CNEnableDetailShiftPosition")) != NULL){
			if(strcasecmp(option,"True") == 0){
				return DoubleToChar(data->ppd_opt->detail_shift_back_short);
			}
		}
		return IntToChar(data->ppd_opt->shift_back_short);
	case ID_CNSHIFTPOSITIONMAX:
		return cngplpGetValue(data,kPPD_Items_CNShiftPositionMax);
	case ID_CNSHIFTPOSITIONMIN:
		return cngplpGetValue(data,kPPD_Items_CNShiftPositionMin);
	case ID_CNJOBNOTE:
		if(data->ppd_opt->job_note == NULL)
			return NULL;
		else
		return ToChar(data->ppd_opt->job_note->note);
	case ID_CNJOBDETAILS:
		if(data->ppd_opt->job_note == NULL)
			return NULL;
		else
		return ToChar(data->ppd_opt->job_note->details);
	case ID_CNFINDETAILS:
      option = GetUIValue(data, kPPD_Items_CNFinDetails);
      if(option == NULL)
		return 0;
      return IntToChar((strcasecmp(option, "true") == 0) ? 1 : 0);
	case ID_CNOFFSETNUM:
		return IntToChar(data->ppd_opt->offset_num);
	case ID_CNUIOFFSETMAX:
		return cngplpGetValue(data,kPPD_Items_CNUIOffsetMax);
	case ID_CNGUTTERSHIFTNUM:
		return DoubleToChar2(data->ppd_opt->guttershiftnum_value_d);

	case ID_MAX_GUTTER_SHIFT_NUM:
		return cngplpGetValue(data,kPPD_Items_CNMAXGutterShiftNum);
	case ID_MIN_GUTTER_SHIFT_NUM:
		return cngplpGetValue(data,kPPD_Items_CNMINGutterShiftNum);
	case ID_CNTABSHIFT:
		return DoubleToChar(data->ppd_opt->tab_shift);
	case ID_DRIVERROOTPATH:
		if(data->ppd_opt->drv_root_path == NULL)
			return NULL;
		else
			return ToChar(data->ppd_opt->drv_root_path);
	case ID_CNMEDIABRANDLIST:
		return MakeMediaBrandListChar(data->ppd_opt);
	case ID_CNMEDIABRAND:
		return MakeMediaBrandChar(data->ppd_opt);
	case ID_CNINSERTMEDIABRANDLIST:
		return MakeInsertMediaBrandListChar(data->ppd_opt);
	case ID_CNINSERTMEDIABRAND:
		return MakeInsertMediaBrandChar(data->ppd_opt);
	case ID_CNINTERLEAFMEDIABRANDLIST:
		return MakeInterleafMediaBrandListChar(data->ppd_opt);
	case ID_CNINTERLEAFMEDIABRAND:
		return MakeInterleafMediaBrandChar(data->ppd_opt);
	case ID_CNINSERTTABSHIFT:
		return DoubleToChar(data->ppd_opt->ins_tab_shift);
	case ID_CNINSERTPOS:
		return ToChar(data->ppd_opt->ins_pos);
	case ID_CNTABINSERTPOS:
		return ToChar(data->ppd_opt->tab_ins_pos);
	case ID_CNOVERLAYFILENAME:
		if(data->ppd_opt->special == NULL)
			return NULL;
		else
		return ToChar(data->ppd_opt->special->form_name);
	case ID_CNFORMHANDLE:
		if(data->ppd_opt->special == NULL)
			return NULL;
		else
		return ToChar(data->ppd_opt->special->form_handle);
	case ID_CNADJUSTTRIMNUM:
		return DoubleToChar(data->ppd_opt->adjust_trim_num);
	case ID_CNUITRIMVALMAX:
		return cngplpGetValue(data, kPPD_Items_CNUITrimValMax);
	case ID_CNUITRIMVALMIN:
		return cngplpGetValue(data, kPPD_Items_CNUITrimValMin);
	case ID_CNSENDTIMENUM:
		if(data->ppd_opt->fax_setting == NULL)
			return NULL;
		else
		return ToChar(data->ppd_opt->fax_setting->send_time);
	case ID_CNOUTSIDELINENUMBER:
		if(data->ppd_opt->fax_setting == NULL)
			return NULL;
		else
		return ToChar(data->ppd_opt->fax_setting->outside_line_number);
	case ID_CNSENDER:
		if(data->ppd_opt->fax_setting == NULL)
			return NULL;
		else
			return ToChar(data->ppd_opt->fax_setting->sender_name);
	case ID_HOLD_NAME:
		if(data->ppd_opt->special == NULL)
			return NULL;
		else
		return ToChar(data->ppd_opt->special->hold_name);
	case ID_HOLDQUEUE_DATANAME:
		if(data->ppd_opt->special == NULL)
			return NULL;
		else
		return IntToChar(data->ppd_opt->special->holddata_name);
	default:
		option = IDtoPPDOption(id - 1);
		if(option == NULL)
			return NULL;
		return MakePPDOptionList(data->ppd_opt, option);
	}

	return NULL;
}

char* GetDataImageOption(cngplpData *data, int id)
{
	if(id <= ID_POSITION){
		char *option = NULL;
		int index = id - ID_IMAGE_OPTION - 1;
		if((option = IDtoImageOption(index)) != NULL)
			return ToChar(GetCupsValue(data->cups_opt->image->option, option));
	}else if(id == ID_RESO_SCALE){
		return IntToChar(data->cups_opt->image->img_reso_scale);
	}
	return NULL;
}

char* GetDataTextOption(cngplpData *data, int id)
{
	if(id <= ID_PRETTYPRINT){
		char *option = NULL;
		int index = id - ID_TEXT_OPTION - 1;
		if((option = IDtoTextOption(index)) != NULL)
			return ToChar(GetCupsValue(data->cups_opt->text->option, option));
	}else if(id == ID_MARGIN){
		return IntToChar(data->cups_opt->text->margin_on);
	}
	return NULL;
}

char* GetDataHPGLOption(cngplpData *data, int id)
{
	char *option = NULL;
	int index = id - ID_HPGL_OPTION - 1;
	if((option = IDtoHPGLOption(index)) != NULL)
		return ToChar(GetCupsValue(data->cups_opt->hpgl->option, option));
	return NULL;
}

char* GetAllOptionID(cngplpData *data)
{
	PPDOptions *ppd_opt = data->ppd_opt;
	UIItemsList *items_list;
	char *list = 0;
	int i;
	items_list = ppd_opt->items_list;

	while(1){
		if(strcmp(items_list->name, "InputSlot") != 0
		&& strcmp(items_list->name, "MediaType") != 0){
			if(strcmp(items_list->name, "Resolution") == 0){
				if(items_list->num_options > 1)
					list = IDAddList(list, ToID(items_list->name));
			}else{
				list = IDAddList(list, ToID(items_list->name));
			}
		}
#if _UI_DEBUG
DebugDisable(data, ToID(items_list->name));
#endif
		if(items_list->next == NULL)
			break;
		items_list = items_list->next;
	}

	switch(ppd_opt->selectby){
	case SELECTBY_INPUTSLOT:
		list = IDAddList(list, ToID("InputSlot"));
		list = IDAddList(list, ID_INPUTSLOT_TYPE);
		break;
	case SELECTBY_MEDIATYPE:
		list = IDAddList(list, ToID("MediaType"));
		list = IDAddList(list, ID_LIST_MEDIATYPE);
		break;
	case SELECTBY_NONE:
		list = IDAddList(list, ToID("InputSlot"));
		list = IDAddList(list, ToID("MediaType"));
		list = IDAddList(list, ID_LIST_MEDIATYPE);
		break;
	}

	list = IDAddList(list, ID_SIDED1PRINT);
	if(ppd_opt->selectby)
		list = IDAddList(list, ID_SELECTBY);

	if(FindItemsList(ppd_opt->items_list, "Booklet") != NULL)
		list = IDAddList(list, ID_BOOKLET_DLG);

	if(ppd_opt->special != NULL){
		list = IDAddList(list, ID_DATANAME);
		list = IDAddList(list, ID_ENTERNAME);
		list = IDAddList(list, ID_BOXIDNUM);
		list = IDAddList(list, ID_MAX_BOXIDNUM);
		list = IDAddList(list, ID_SECURED_DOCNAME);
		list = IDAddList(list, ID_SECURED_USRNAME);
		list = IDAddList(list, ID_SECURED_PASSWD);
		list = IDAddList(list, ID_JOBACCOUNT);
		list = IDAddList(list, ID_JOBACCOUNT_ID);
		list = IDAddList(list, ID_JOBACCOUNT_PASSWD);
		list = IDAddList(list, ID_SPECIAL_FUNC);
		list = IDAddList(list, ID_DOC_LENGTH);
		list = IDAddList(list, ID_DISABLE_JOBACCOUNT_BW);
		list = IDAddList(list, ID_SHOW_DISABLE_JOBACCOUNT_BW);
		list = IDAddList(list, ID_CNFORMHANDLE);
		list = IDAddList(list, ID_CNOVERLAYFILENAME);
		list = IDAddList(list, ID_HOLD_NAME);
		list = IDAddList(list, ID_HOLDQUEUE_DATANAME);
	}

	if(FindItemsList(ppd_opt->items_list, "BindEdge") != NULL){
		list = IDAddList(list, ID_GUTTER);
		list = IDAddList(list, ID_MAX_GUTTER);
	}
	list = IDAddList(list, ID_PRINTERTYPE);
	list = IDAddList(list, ID_COLOR_MODE);
	list = IDAddList(list, ID_MAX_COPIES);

	if(FindItemsList(ppd_opt->items_list, "CNCopySetNumbering") != NULL){
		list = IDAddList(list, ID_STARTNUM);
	}

	if(ppd_opt->shift_pos_type == 1) {
		list = IDAddList(list, ID_CNSHIFTTYPE);
		list = IDAddList(list, ID_CNSHIFTFRLONGEDGE);
		list = IDAddList(list, ID_CNSHIFTFRSHORTEDGE);
		list = IDAddList(list, ID_CNSHIFTBKLONGEDGE);
		list = IDAddList(list, ID_CNSHIFTBKSHORTEDGE);
	}else if(ppd_opt->shift_pos_type == 2) {
		list = IDAddList(list, ID_CNSHIFTTYPE);
		list = IDAddList(list, ID_CNSHIFTUPWARDS);
		list = IDAddList(list, ID_CNSHIFTRIGHT);
	}

	if(ppd_opt->job_note != NULL){
		list = IDAddList(list, ID_CNJOBNOTE);
		list = IDAddList(list, ID_CNJOBDETAILS);
	}
	if(FindOptionList(ppd_opt->items_list, kPPD_Items_CNOutputPartition, "offset")){
		char *val;
		if((val = GetUIValue(data, kPPD_Items_EnableCNOffsetNum)) != NULL){
			if(strcasecmp(val,"True") == 0){
		list = IDAddList(list, ID_CNOFFSETNUM);
			}
		}
	}
	if(FindOptionList(ppd_opt->items_list, kPPD_Items_CNDisplacementCorrection, "Manual")){
		list = IDAddList(list, ID_CNGUTTERSHIFTNUM);
	}
	{
		char *val;
		if((val = GetUIValue(data, "EnableCNTabShift")) != NULL){
			if(strcasecmp(val,"True") == 0){
				list = IDAddList(list, ID_CNTABSHIFT);
			}
		}
		if((val = GetUIValue(data, "EnableCNInsertTabShift")) != NULL){
			if(strcasecmp(val,"True") == 0){
				list = IDAddList(list, ID_CNINSERTTABSHIFT);
			}
		}
		if((val = GetUIValue(data, "EnableCNSender")) != NULL){
			if(strcasecmp(val,"True") == 0){
				list = IDAddList(list, ID_CNSENDER);
			}
		}
	}
	if(FindItemsList(ppd_opt->items_list, kPPD_Items_CNSheetForInsertion) != NULL){
		list = IDAddList(list, ID_CNINSERTPOS);
	}
	if((FindOptionList(ppd_opt->items_list, kPPD_Items_CNSheetForInsertion, "TAB"))
	 || (FindOptionList(ppd_opt->items_list, kPPD_Items_CNSheetForInsertion, "TAB1"))){
		list = IDAddList(list, ID_CNTABINSERTPOS);
	}
	if(FindItemsList(ppd_opt->items_list, kPPD_Items_CNAdjustTrim) != NULL){
		list = IDAddList(list, ID_CNADJUSTTRIMNUM);
	}
	if(FindItemsList(ppd_opt->items_list, kPPD_Items_CNSendTime) != NULL){
		list = IDAddList(list, ID_CNSENDTIMENUM);
	}
	if(FindItemsList(ppd_opt->items_list, kPPD_Items_CNUseOutsideLineNum) != NULL){
		list = IDAddList(list, ID_CNOUTSIDELINENUMBER);
	}
	for(i = ID_CNCOPIES; i <= ID_FILTER; i++){
		list = IDAddList(list, i);
	}

	if(ppd_opt->color_mode){
		list = IDAddList(list, ID_HUE);
		list = IDAddList(list, ID_SATURATION);
	}

	for(i = ID_PPI; i <= ID_RESO_SCALE; i++){
		list = IDAddList(list, i);
	}

	if(ppd_opt->color_mode)
		list = IDAddList(list, ID_BLACKPLOT);
	list = IDAddList(list, ID_FITPLOT);
	list = IDAddList(list, ID_PENWIDTH);

	for(i = ID_SETDEFAULT; i <= ID_CANCEL; i++){
		list = IDAddList(list, i);
	}

	return list;
}



char *MakeDuplexBoolList(PPDOptions *ppd_opt)
{
	if(ppd_opt->duplex_valtype != DUPLEX_VALTYPE_TUMBLE){
		return MakePPDBoolList(ppd_opt, "Duplex");
	}else{
		char *glist = NULL;
		char curr[256];
		int dis_tumble, dis_notumble, none;
		UIItemsList *item;

		item = FindItemsList(ppd_opt->items_list, "Duplex");
		if(item == NULL)
			return NULL;

		dis_tumble = GetDisableOpt(ppd_opt->items_list, "Duplex", "DuplexTumble");
		dis_notumble = GetDisableOpt(ppd_opt->items_list, "Duplex", "DuplexNoTumble");
		none = GetDisableOpt(ppd_opt->items_list, "Duplex", "None");

		memset(curr, 0, 256);
		if(item->current_option && item->current_option->name){
			if(strcmp(item->current_option->name, "False") == 0
			|| strcmp(item->current_option->name, "None") == 0){
				if(dis_tumble != 0 && dis_notumble != 0)
					snprintf(curr, 255, "False:True<1>,False<0>");
				else
					snprintf(curr, 255, "False:True<0>,False<0>");
			}else if(dis_tumble != 0 && dis_notumble != 0){
				if(none == 0)
					snprintf(curr, 255, "False:True<1>,False<0>");
				else
					snprintf(curr, 255, "True:True<0>,False<1>");
			}else{
				if(none == 0)
					snprintf(curr, 255, "True:True<0>,False<0>");
				else
					snprintf(curr, 255, "True:True<0>,False<1>");
			}
		}

		return glist = strdup(curr);
	}
}


