/*
 * Decompiled with CFR 0.152.
 */
package net.sf.phpeasyvcs;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;
import net.sf.phpeasyvcs.JSON;
import net.sf.phpeasyvcs.ProgressEvent;
import net.sf.phpeasyvcs.ProgressListener;
import net.sf.phpeasyvcs.Uploader;
import netscape.javascript.JSObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UploadApplet
extends Applet
implements ProgressListener,
DropTargetListener {
    private static final long serialVersionUID = 1L;
    private JSObject window;
    private JLabel target;
    private URL remoteRoot = null;
    private String comment = "";
    private Set<File> filesToUpload = new LinkedHashSet<File>();
    private Map<String, String> cookieMap = new HashMap<String, String>();
    private Status status = Status.NONE;
    private String initCallback = "showUpload";
    private String errorCallback = "showError";
    private String selectResultCallback = "showSelectResult";
    private String uploadProgressCallback = "showUploadProgress";
    private String uploadResultCallback = "showUploadResult";

    @Override
    public void init() {
        String label = "Drag and drop files here";
        try {
            UIManager.setLookAndFeel("org.fife.plaf.Office2003.Office2003LookAndFeel");
        }
        catch (Exception e1) {
            try {
                UIManager.setLookAndFeel("com.sun.java.swing.plaf.nimbus.NimbusLookAndFeel");
            }
            catch (Exception e) {
                try {
                    UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
                }
                catch (Exception e2) {
                    // empty catch block
                }
            }
        }
        this.setLayout(new BorderLayout());
        this.target = new JLabel(label);
        this.target.setVerticalAlignment(0);
        this.target.setHorizontalAlignment(0);
        this.target.setBorder(new LineBorder(Color.black));
        this.target.setOpaque(true);
        this.target.setEnabled(true);
        this.add((Component)this.target, "Center");
        try {
            new DropTarget(this.target, this);
            this.window = JSObject.getWindow((Applet)this);
            this.getCookies();
            this.remoteRoot = new URL(this.getParameter("root"));
            if (this.getParameter("showError") != null) {
                this.errorCallback = this.getParameter("showError");
            }
            if (this.getParameter("showUpload") != null) {
                this.initCallback = this.getParameter("showUpload");
            }
            if (this.getParameter("showSelectResult") != null) {
                this.selectResultCallback = this.getParameter("showSelectResult");
            }
            if (this.getParameter("showUploadProgress") != null) {
                this.uploadProgressCallback = this.getParameter("showUploadProgress");
            }
            if (this.getParameter("showUploadResult") != null) {
                this.uploadResultCallback = this.getParameter("showUploadResult");
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    UploadApplet.this.window.call(UploadApplet.this.initCallback, new Object[0]);
                }
            });
        }
        catch (Exception e) {
            this.target.setText("Error: " + e.getMessage());
        }
    }

    private void getCookies() {
        JSObject document = (JSObject)this.window.getMember("document");
        String cookies = (String)document.getMember("cookie");
        if (cookies != null) {
            for (String cookie : cookies.split(";")) {
                int pos = cookie.indexOf(61);
                if (pos <= 0) continue;
                this.cookieMap.put(cookie.substring(0, pos), cookie.substring(pos + 1));
            }
        }
    }

    public void setComment(String comment) {
        this.comment = comment != null ? comment : "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean selectLocalFiles() {
        UploadApplet uploadApplet = this;
        synchronized (uploadApplet) {
            if (this.status != Status.NONE) {
                return false;
            }
            this.status = Status.SELECTING;
        }
        Runnable selector = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    List<String> paths = AccessController.doPrivileged(new PrivilegedAction<List<String>>(){

                        @Override
                        public List<String> run() {
                            ArrayList<String> paths = new ArrayList<String>();
                            JFileChooser chooser = new JFileChooser();
                            chooser.setMultiSelectionEnabled(true);
                            chooser.setFileSelectionMode(2);
                            if (chooser.showOpenDialog(UploadApplet.this) == 0) {
                                File[] files;
                                for (File file : files = chooser.getSelectedFiles()) {
                                    if (UploadApplet.this.filesToUpload.contains(file)) continue;
                                    UploadApplet.this.filesToUpload.add(file);
                                    paths.add(file.getPath());
                                }
                            }
                            return paths;
                        }
                    });
                    Collections.sort(paths);
                    for (String path : paths) {
                        UploadApplet.this.window.call(UploadApplet.this.selectResultCallback, path);
                    }
                }
                finally {
                    UploadApplet uploadApplet = UploadApplet.this;
                    synchronized (uploadApplet) {
                        UploadApplet.this.status = Status.NONE;
                    }
                }
            }
        };
        new Thread(selector).start();
        return true;
    }

    public boolean removeLocalFile(String path) {
        this.filesToUpload.remove(new File(path));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean upload(final boolean doExtract) {
        UploadApplet uploadApplet = this;
        synchronized (uploadApplet) {
            if (this.status != Status.NONE) {
                return false;
            }
            this.status = Status.UPLOADING;
        }
        Runnable selector = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    final List<String> failedFiles = AccessController.doPrivileged(new PrivilegedAction<List<String>>(){

                        @Override
                        public List<String> run() {
                            ArrayList<String> failedFiles = new ArrayList<String>();
                            String cookies = "PHPSESSID=" + (String)UploadApplet.this.cookieMap.get("PHPSESSID");
                            Uploader uploader = new Uploader(UploadApplet.this.remoteRoot, cookies);
                            uploader.addProgressListener(UploadApplet.this);
                            boolean result = true;
                            for (final File file : UploadApplet.this.filesToUpload) {
                                boolean ok;
                                try {
                                    ok = uploader.uploadFile(file, UploadApplet.this.comment, doExtract);
                                }
                                catch (Exception e) {
                                    ok = false;
                                }
                                if (!ok) {
                                    failedFiles.add(file.getPath());
                                    SwingUtilities.invokeLater(new Runnable(){

                                        public void run() {
                                            UploadApplet.this.window.call(UploadApplet.this.uploadProgressCallback, file.getPath(), -1, -1, 100);
                                        }
                                    });
                                }
                                result = ok && result;
                            }
                            return failedFiles;
                        }
                    });
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            UploadApplet.this.window.call(UploadApplet.this.uploadResultCallback, failedFiles.size() > 0 ? JSON.encode(failedFiles) : Boolean.valueOf(true));
                        }
                    });
                }
                catch (Exception e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            UploadApplet.this.window.call(UploadApplet.this.errorCallback, e.getMessage());
                        }
                    });
                }
                finally {
                    UploadApplet uploadApplet = UploadApplet.this;
                    synchronized (uploadApplet) {
                        UploadApplet.this.status = Status.NONE;
                    }
                }
            }
        };
        new Thread(selector).start();
        return true;
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        DataFlavor uriListFlavor = null;
        try {
            uriListFlavor = new DataFlavor("text/uri-list;class=java.lang.String");
        }
        catch (ClassNotFoundException e1) {
            // empty catch block
        }
        try {
            dtde.acceptDrop(dtde.getDropAction());
            try {
                List<File> files = null;
                if (dtde.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                    files = (List)dtde.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
                } else if (uriListFlavor != null && dtde.isDataFlavorSupported(uriListFlavor)) {
                    String uriList = (String)dtde.getTransferable().getTransferData(uriListFlavor);
                    files = UploadApplet.convertUriListToFileList(uriList);
                }
                for (File file : files) {
                    if (this.filesToUpload.contains(file)) continue;
                    this.filesToUpload.add(file);
                    this.window.call(this.selectResultCallback, file.getPath());
                }
                dtde.dropComplete(true);
            }
            catch (UnsupportedFlavorException e) {
            }
            catch (IOException e) {}
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static List<File> convertUriListToFileList(String data) {
        ArrayList<File> list = new ArrayList<File>();
        for (String s : data.split("\r?\n")) {
            if (s.startsWith("#")) continue;
            try {
                URI uri = new URI(s.trim());
                File file = new File(uri);
                list.add(file);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return list;
    }

    @Override
    public void progressOccurred(ProgressEvent event) {
        this.window.call(this.uploadProgressCallback, event.getSource().toString(), event.getProgress(), event.getTotal(), Float.valueOf(event.getPercent()));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Status {
        NONE,
        SELECTING,
        UPLOADING;

    }
}

