/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.registry;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.internal.ui.TeamUIMessages;

public class TeamDecoratorDescription {
    private static final String TAG_TEAM_DECORATOR = "teamDecorator";
    private static final String ATT_REPOSITORY_ID = "repositoryId";
    private static final String ATT_DECORATOR_ID = "decoratorId";
    private static final String ATT_DECORATED_DIRECTION_ID = "decoratedDirection";
    private static final String OUTGOING_FLAG = "OUTGOING";
    private static final String INCOMING_FLAG = "INCOMING";
    private String repositoryId;
    private String decoratorId;
    private int decoratedDirection;

    public TeamDecoratorDescription(IExtension extension) throws CoreException {
        this.readExtension(extension);
    }

    protected void readExtension(IExtension extension) throws CoreException {
        String id = extension.getUniqueIdentifier();
        IConfigurationElement[] elements = extension.getConfigurationElements();
        int count = elements.length;
        int i = 0;
        while (i < count) {
            IConfigurationElement element = elements[i];
            String name = element.getName();
            if (name.equalsIgnoreCase(TAG_TEAM_DECORATOR)) {
                this.repositoryId = element.getAttribute(ATT_REPOSITORY_ID);
                this.decoratorId = element.getAttribute(ATT_DECORATOR_ID);
                String flags = element.getAttribute(ATT_DECORATED_DIRECTION_ID);
                if (flags == null) {
                    this.decoratedDirection = 768;
                } else {
                    if (flags.contains(INCOMING_FLAG)) {
                        this.decoratedDirection |= 0x200;
                    }
                    if (flags.contains(OUTGOING_FLAG)) {
                        this.decoratedDirection |= 0x100;
                    }
                    if (this.decoratedDirection == 0) {
                        this.decoratedDirection = 768;
                    }
                }
            }
            ++i;
        }
        if (this.repositoryId == null) {
            this.fail(NLS.bind((String)TeamUIMessages.TeamContentProviderDescriptor_1, (Object[])new String[]{ATT_REPOSITORY_ID, TAG_TEAM_DECORATOR, id == null ? "" : id}));
        }
        if (this.repositoryId == null) {
            this.fail(NLS.bind((String)TeamUIMessages.TeamContentProviderDescriptor_1, (Object[])new String[]{ATT_DECORATOR_ID, TAG_TEAM_DECORATOR, id == null ? "" : id}));
        }
    }

    protected void fail(String reason) throws CoreException {
        throw new CoreException((IStatus)new Status(4, "org.eclipse.team.ui", 0, reason, null));
    }

    public String getDecoratorId() {
        return this.decoratorId;
    }

    public String getRepositoryId() {
        return this.repositoryId;
    }

    public int getDecoratedDirectionFlags() {
        return this.decoratedDirection;
    }
}

