/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.scanner;

import org.eclipse.cdt.core.dom.ast.IASTComment;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.internal.core.parser.scanner.ASTPreprocessorNode;
import org.eclipse.cdt.internal.core.parser.scanner.ILocationResolver;

class ASTComment
extends ASTPreprocessorNode
implements IASTComment {
    private final boolean fIsBlockComment;
    private String fFilePath;

    public ASTComment(IASTTranslationUnit parent, String filePath, int offset, int endOffset, boolean isBlockComment) {
        super(parent, IASTTranslationUnit.PREPROCESSOR_STATEMENT, offset, endOffset);
        this.fIsBlockComment = isBlockComment;
        this.fFilePath = filePath;
    }

    @Override
    public int getOffset() {
        ILocationResolver lr;
        if (this.fFilePath != null && (lr = (ILocationResolver)this.getTranslationUnit().getAdapter(ILocationResolver.class)) != null) {
            this.setOffset(lr.getSequenceNumberForFileOffset(this.fFilePath, super.getOffset()));
            this.fFilePath = null;
        }
        return super.getOffset();
    }

    @Override
    public char[] getComment() {
        return this.getRawSignatureChars();
    }

    @Override
    public boolean isBlockComment() {
        return this.fIsBlockComment;
    }

    @Override
    public void setComment(char[] comment) {
        assert (false);
    }
}

