/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.unitofwork;

import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.tests.unitofwork.UnitOfWorkEventTest;

public class CommitUnitOfWorkAgainTest
extends UnitOfWorkEventTest {
    @Override
    public void setup() {
        super.setup();
        this.setDescription("Test after uow.commit(), uow must be released and not in active");
    }

    public void test() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        Employee anEmployee = (Employee)uow.readObject(Employee.class);
        anEmployee.setLastName("TOPLink");
        uow.commit();
        try {
            anEmployee.setLastName("EclipseLink");
            uow.commit();
            throw new TestErrorException("UOW is not throwing an exception when it is committed for a second time.");
        }
        catch (ValidationException exception) {
            if (exception.getErrorCode() != 7096) {
                throw new TestErrorException("UOW is throwing exception " + exception.getErrorCode() + " instead of CANNOT_COMMIT_UOW_AGAIN when it is committed for a second time.");
            }
            return;
        }
    }
}

