/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.identitymaps.cacheinvalidation;

import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.LargeProject;
import org.eclipse.persistence.testing.models.employee.domain.SmallProject;

public class InvalidateAllTest
extends AutoVerifyTestCase {
    private Session m_session;
    private Vector m_largeProjects;
    private Vector m_smallProjects;

    public void reset() {
        this.m_session.getIdentityMapAccessor().initializeIdentityMaps();
        this.rollbackTransaction();
    }

    protected void setup() {
        this.m_session = this.getSession();
        this.beginTransaction();
        this.m_session.getIdentityMapAccessor().initializeIdentityMaps();
        this.m_largeProjects = this.m_session.readAllObjects(LargeProject.class);
        this.m_smallProjects = this.m_session.readAllObjects(SmallProject.class);
    }

    public void test() {
        this.m_session.getIdentityMapAccessor().invalidateAll();
    }

    protected void verify() {
        Enumeration e = this.m_largeProjects.elements();
        while (e.hasMoreElements()) {
            if (!this.m_session.getIdentityMapAccessor().isValid(e.nextElement())) continue;
            throw new TestErrorException("A large project was not invalidated.");
        }
        e = this.m_smallProjects.elements();
        while (e.hasMoreElements()) {
            if (!this.m_session.getIdentityMapAccessor().isValid(e.nextElement())) continue;
            throw new TestErrorException("A small project was not invalidated");
        }
    }
}

