/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.unitofwork;

import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.ownership.ObjectA;

public class UnitOfWorkCommitToDatabaseTest
extends AutoVerifyTestCase {
    public static final String TEST_NAME = "UnitOfWorkCommitToDatabaseTest";
    public static final String OBJECT_NAME = "CommitDB";
    public Exception storedException;

    public UnitOfWorkCommitToDatabaseTest() {
        this.setDescription("UnitOfWorkCommitToDatabaseTest checks the commitToDatabase() method");
    }

    protected void setup() {
        this.getAbstractSession().beginTransaction();
        this.storedException = null;
    }

    public void reset() {
        this.getAbstractSession().rollbackTransaction();
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    protected void test() {
        try {
            ObjectA testObject = ObjectA.example3();
            testObject.setName(OBJECT_NAME);
            UnitOfWorkImpl uow = (UnitOfWorkImpl)this.getSession().acquireUnitOfWork();
            uow.registerObject((Object)testObject);
            uow.commitRootUnitOfWork();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.setStoredException((Exception)((Object)new TestErrorException("Error calling commitToDatabase() : UnitOfWorkCommitToDatabaseTest")));
            return;
        }
    }

    protected void verify() throws Exception {
        try {
            ExpressionBuilder eb = new ExpressionBuilder();
            Expression expression = eb.get("name").equal((Object)OBJECT_NAME);
            ReadObjectQuery query = new ReadObjectQuery(ObjectA.class);
            query.dontCheckCache();
            query.setSelectionCriteria(expression);
            this.getSession().getIdentityMapAccessor().initializeIdentityMap(ObjectA.class);
            ObjectA checkObject = (ObjectA)this.getSession().executeQuery((DatabaseQuery)query);
            if (checkObject == null) {
                this.setStoredException((Exception)((Object)new TestErrorException("Object not committed to database : UnitOfWorkCommitToDatabaseTest")));
            }
        }
        catch (Exception e) {
            this.setStoredException((Exception)((Object)new TestErrorException("Error reading test object : UnitOfWorkCommitToDatabaseTest")));
            e.printStackTrace();
        }
        if (this.storedException != null) {
            throw this.storedException;
        }
    }

    protected void setStoredException(Exception e) {
        if (this.storedException == null) {
            this.storedException = e;
        }
    }
}

