/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.junit.helper;

import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.persistence.internal.helper.ConcurrencySemaphore;
import org.junit.Assert;

public class ConcurrencySemaphoreThread
implements Runnable {
    private static final ThreadLocal<Boolean> SEMAPHORE_THREAD_LOCAL_VAR = new ThreadLocal();
    private static final int SEMAPHORE_MAX_NUMBER_THREADS = 12;
    private static final Semaphore SEMAPHORE_LIMIT_MAX_NUMBER_OF_THREADS_IN_TEST = new Semaphore(12);
    private ConcurrencySemaphore testSemaphore = new ConcurrencySemaphore(SEMAPHORE_THREAD_LOCAL_VAR, 12, SEMAPHORE_LIMIT_MAX_NUMBER_OF_THREADS_IN_TEST, (Object)this, "object_builder_semaphore_acquired_01");
    private static AtomicInteger currentNoOfThreads = new AtomicInteger(0);

    @Override
    public void run() {
        boolean semaphoreWasAcquired = false;
        try {
            semaphoreWasAcquired = this.testSemaphore.acquireSemaphoreIfAppropriate(true);
            Assert.assertTrue((currentNoOfThreads.incrementAndGet() <= 12 ? 1 : 0) != 0);
            Thread.sleep(300L);
        }
        catch (InterruptedException ex) {
            Assert.fail((String)"Semaphore Test thread was interrupted.  Test failed to run properly");
        }
        finally {
            currentNoOfThreads.decrementAndGet();
            this.testSemaphore.releaseSemaphoreAllowOtherThreadsToStartDoingObjectBuilding(semaphoreWasAcquired);
        }
    }
}

