/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.identitymaps;

import org.eclipse.persistence.internal.identitymaps.IdentityMap;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class ClearLastAccessedIdentityMapTest
extends TestCase {
    protected boolean mapNotRefreshed = false;

    public ClearLastAccessedIdentityMapTest() {
        this.setDescription("Ensure that after initializeIdentityMap is called, the old identity map is not returned because of the caching of lastIdentityMapAccessed.");
    }

    public void setup() {
        this.mapNotRefreshed = false;
    }

    public void test() {
        IdentityMap originalMap = this.getAbstractSession().getIdentityMapAccessorInstance().getIdentityMap(Employee.class);
        this.getAbstractSession().getIdentityMapAccessorInstance().initializeIdentityMap(Employee.class);
        IdentityMap newMap = this.getAbstractSession().getIdentityMapAccessorInstance().getIdentityMap(Employee.class);
        if (originalMap == newMap) {
            this.mapNotRefreshed = true;
        }
    }

    public void verify() {
        if (this.mapNotRefreshed) {
            throw new TestErrorException("InitializeIdentityMap(Class) did not properly refresh the identity map cache.");
        }
    }
}

