/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.query.runtime;

import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import oracle.kv.Consistency;
import oracle.kv.Depth;
import oracle.kv.Direction;
import oracle.kv.Durability;
import oracle.kv.StoreIteratorException;
import oracle.kv.impl.api.KVStoreImpl;
import oracle.kv.impl.api.Request;
import oracle.kv.impl.api.StoreIteratorParams;
import oracle.kv.impl.api.ops.InternalOperation;
import oracle.kv.impl.api.ops.Result;
import oracle.kv.impl.api.ops.TableQuery;
import oracle.kv.impl.api.parallelscan.BaseParallelScanIteratorImpl;
import oracle.kv.impl.api.parallelscan.PartitionScanIterator;
import oracle.kv.impl.api.parallelscan.ShardScanIterator;
import oracle.kv.impl.api.query.PreparedStatementImpl;
import oracle.kv.impl.api.table.BinaryValueImpl;
import oracle.kv.impl.api.table.BooleanValueImpl;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.api.table.NullValueImpl;
import oracle.kv.impl.api.table.NumberValueImpl;
import oracle.kv.impl.api.table.PrimaryKeyImpl;
import oracle.kv.impl.api.table.RecordDefImpl;
import oracle.kv.impl.api.table.RecordValueImpl;
import oracle.kv.impl.api.table.TableImpl;
import oracle.kv.impl.api.table.TimestampValueImpl;
import oracle.kv.impl.api.table.TupleValue;
import oracle.kv.impl.async.AsyncTableIterator;
import oracle.kv.impl.async.IterationHandleNotifier;
import oracle.kv.impl.async.ResultHandler;
import oracle.kv.impl.query.QueryException;
import oracle.kv.impl.query.QueryStateException;
import oracle.kv.impl.query.compiler.Expr;
import oracle.kv.impl.query.compiler.FunctionLib;
import oracle.kv.impl.query.compiler.QueryFormatter;
import oracle.kv.impl.query.compiler.SortSpec;
import oracle.kv.impl.query.runtime.BaseTableIter;
import oracle.kv.impl.query.runtime.PlanIter;
import oracle.kv.impl.query.runtime.PlanIterState;
import oracle.kv.impl.query.runtime.ResumeInfo;
import oracle.kv.impl.query.runtime.RuntimeControlBlock;
import oracle.kv.impl.topo.PartitionId;
import oracle.kv.impl.topo.RepGroupId;
import oracle.kv.impl.util.SerialVersion;
import oracle.kv.impl.util.SerializationUtil;
import oracle.kv.impl.util.SizeOf;
import oracle.kv.query.ExecuteOptions;
import oracle.kv.stats.DetailedMetrics;
import oracle.kv.table.FieldValue;

public class ReceiveIter
extends PlanIter {
    private static final long theFixedMemoryConsumption = SizeOf.OBJECT_REF_OVERHEAD + SizeOf.HASHSET_OVERHEAD + 8;
    private final PlanIter theInputIter;
    private volatile transient CachedBinaryPlan theSerializedInputIter = null;
    private final FieldDefImpl theInputType;
    private final boolean theMayReturnNULL;
    private final int[] theSortFieldPositions;
    private final SortSpec[] theSortSpecs;
    private final int[] thePrimKeyPositions;
    private final int[] theTupleRegs;
    private final PreparedStatementImpl.DistributionKind theDistributionKind;
    private final RecordValueImpl thePrimaryKey;
    private PartitionId thePartitionId;
    private final long theTableId;
    private final String theTableName;
    private final String theNamespace;
    private final PlanIter[] thePushedExternals;
    private final int theNumRegs;
    private final int theNumIters;
    private final boolean theIsUpdate;
    private volatile transient IterationHandleNotifier theAsyncIterHandleNotifier;

    public ReceiveIter(Expr e, int resultReg, PlanIter input, FieldDefImpl inputType, boolean mayReturnNULL, int[] sortFieldPositions, SortSpec[] sortSpecs, int[] primKeyPositions, PreparedStatementImpl.DistributionKind distrKind, PrimaryKeyImpl primKey, PlanIter[] pushedExternals, int numRegs, int numIters, boolean isUpdate) {
        super(e, resultReg);
        this.theInputIter = input;
        this.theInputType = inputType;
        this.theMayReturnNULL = mayReturnNULL;
        this.theSortFieldPositions = sortFieldPositions;
        this.theSortSpecs = sortSpecs;
        this.thePrimKeyPositions = primKeyPositions;
        this.theDistributionKind = distrKind;
        this.thePushedExternals = pushedExternals;
        this.theTupleRegs = (int[])(input.producesTuples() && e.getQCB().getRootExpr() != e ? input.getTupleRegs() : null);
        this.theTableId = e.getQCB().getTargetTableId();
        if (primKey != null) {
            this.thePrimaryKey = primKey;
            this.theTableName = primKey.getTable().getFullName();
            this.theNamespace = primKey.getTable().getInternalNamespace();
            if (this.theDistributionKind == PreparedStatementImpl.DistributionKind.SINGLE_PARTITION && (this.thePushedExternals == null || this.thePushedExternals.length == 0)) {
                this.thePartitionId = primKey.getPartitionId(e.getQCB().getStore());
            }
        } else {
            this.thePrimaryKey = null;
            this.theTableName = null;
            this.theNamespace = null;
        }
        this.theNumRegs = numRegs;
        this.theNumIters = numIters;
        this.theIsUpdate = isUpdate;
    }

    public ReceiveIter(DataInput in, short serialVersion) throws IOException {
        super(in, serialVersion);
        this.theNumRegs = ReceiveIter.readPositiveInt(in);
        this.theNumIters = ReceiveIter.readPositiveInt(in);
        this.theInputType = (FieldDefImpl)ReceiveIter.deserializeFieldDef(in, serialVersion);
        this.theMayReturnNULL = in.readBoolean();
        this.theSortFieldPositions = ReceiveIter.deserializeIntArray(in, serialVersion);
        this.theSortSpecs = ReceiveIter.deserializeSortSpecs(in, serialVersion);
        this.thePrimKeyPositions = ReceiveIter.deserializeIntArray(in, serialVersion);
        this.theTupleRegs = ReceiveIter.deserializeIntArray(in, serialVersion);
        short ordinal = in.readShort();
        this.theDistributionKind = PreparedStatementImpl.DistributionKind.values()[ordinal];
        this.theTableId = in.readLong();
        this.theTableName = SerializationUtil.readString(in, serialVersion);
        if (this.theTableName != null) {
            this.theNamespace = SerializationUtil.readString(in, serialVersion);
            this.thePrimaryKey = ReceiveIter.deserializeKey(in, serialVersion);
        } else {
            this.thePrimaryKey = null;
            this.theNamespace = null;
        }
        this.thePushedExternals = ReceiveIter.deserializeIters(in, serialVersion);
        this.theIsUpdate = in.readBoolean();
        if (this.theDistributionKind == PreparedStatementImpl.DistributionKind.SINGLE_PARTITION && (this.thePushedExternals == null || this.thePushedExternals.length == 0)) {
            this.thePartitionId = new PartitionId(in.readInt());
        }
        byte[] bytes = SerializationUtil.readNonNullByteArray(in);
        this.setSerializedIter(bytes, serialVersion);
        this.theInputIter = null;
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        super.writeFastExternal(out, serialVersion);
        out.writeInt(this.theNumRegs);
        out.writeInt(this.theNumIters);
        ReceiveIter.serializeFieldDef(this.theInputType, out, serialVersion);
        out.writeBoolean(this.theMayReturnNULL);
        ReceiveIter.serializeIntArray(this.theSortFieldPositions, out, serialVersion);
        ReceiveIter.serializeSortSpecs(this.theSortSpecs, out, serialVersion);
        ReceiveIter.serializeIntArray(this.thePrimKeyPositions, out, serialVersion);
        ReceiveIter.serializeIntArray(this.theTupleRegs, out, serialVersion);
        out.writeShort(this.theDistributionKind.ordinal());
        out.writeLong(this.theTableId);
        SerializationUtil.writeString(out, serialVersion, this.theTableName);
        if (this.theTableName != null) {
            SerializationUtil.writeString(out, serialVersion, this.theNamespace);
            ReceiveIter.serializeKey(this.thePrimaryKey, out, serialVersion);
        }
        ReceiveIter.serializeIters(this.thePushedExternals, out, serialVersion);
        out.writeBoolean(this.theIsUpdate);
        if (this.theDistributionKind == PreparedStatementImpl.DistributionKind.SINGLE_PARTITION && (this.thePushedExternals == null || this.thePushedExternals.length == 0)) {
            out.writeInt(this.thePartitionId.getPartitionId());
        }
        byte[] bytes = this.ensureSerializedIter(serialVersion);
        SerializationUtil.writeNonNullByteArray(out, bytes);
    }

    @Override
    public PlanIter.PlanIterKind getKind() {
        return PlanIter.PlanIterKind.RECV;
    }

    public int getNumRegisters() {
        return this.theNumRegs;
    }

    public int getNumIterators() {
        return this.theNumIters;
    }

    @Override
    public int[] getTupleRegs() {
        return this.theInputIter.getTupleRegs();
    }

    private boolean doesSort() {
        return this.theSortFieldPositions != null;
    }

    @Override
    public void setIterationHandleNotifier(IterationHandleNotifier iterHandleNotifier) {
        this.theAsyncIterHandleNotifier = iterHandleNotifier;
    }

    public byte[] ensureSerializedIter(short serialVersion) {
        CachedBinaryPlan cachedPlan = this.theSerializedInputIter;
        if (cachedPlan != null && cachedPlan.getPlan() != null && cachedPlan.getSerialVersion() == serialVersion) {
            return cachedPlan.thePlan;
        }
        ReceiveIter receiveIter = this;
        synchronized (receiveIter) {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                DataOutputStream dataOut = new DataOutputStream(baos);
                PlanIter.serializeIter(this.theInputIter, dataOut, serialVersion);
                byte[] ba = baos.toByteArray();
                this.theSerializedInputIter = cachedPlan = CachedBinaryPlan.create(ba, serialVersion);
                return ba;
            }
            catch (IOException ioe) {
                throw new QueryException(ioe);
            }
        }
    }

    public synchronized void setSerializedIter(byte[] bytes, short serialVersion) {
        assert (this.theSerializedInputIter == null);
        this.theSerializedInputIter = CachedBinaryPlan.create(bytes, serialVersion);
    }

    private void ensureIterator(RuntimeControlBlock rcb, ReceiveIterState state) {
        if (state.theRemoteResultsIter != null) {
            return;
        }
        switch (this.theDistributionKind) {
            case SINGLE_PARTITION: {
                state.theRemoteResultsIter = this.runOnOnePartition(rcb);
                break;
            }
            case ALL_PARTITIONS: {
                state.theRemoteResultsIter = this.runOnAllPartitions(rcb);
                break;
            }
            case ALL_SHARDS: {
                state.theRemoteResultsIter = this.runOnAllShards(rcb);
                break;
            }
            default: {
                throw new QueryStateException("Unknown distribution kind: " + (Object)((Object)this.theDistributionKind));
            }
        }
        rcb.setTableIterator(state.theRemoteResultsIter);
    }

    private AsyncTableIterator<FieldValueImpl> runOnAllPartitions(final RuntimeControlBlock rcb) {
        if (rcb.getMaxReadKB() > 0 || rcb.getUseBatchSizeAsLimit()) {
            return new SequentialPartitionsIterator(rcb, null);
        }
        ExecuteOptions options = rcb.getExecuteOptions();
        Direction dir = this.theSortFieldPositions != null ? Direction.FORWARD : Direction.UNORDERED;
        StoreIteratorParams params = new StoreIteratorParams(dir, rcb.getBatchSize(), null, null, Depth.PARENT_AND_DESCENDANTS, rcb.getConsistency(), rcb.getTimeout(), rcb.getTimeUnit(), rcb.getPartitionSet());
        return new PartitionScanIterator<FieldValueImpl>(rcb.getStore(), options, params, this.theAsyncIterHandleNotifier){

            @Override
            protected QueryPartitionStream createStream(RepGroupId groupId, int partitionId) {
                return new QueryPartitionStream(groupId, partitionId);
            }

            @Override
            protected TableQuery generateGetterOp(byte[] resumeKey) {
                throw new QueryStateException("Unexpected call");
            }

            @Override
            protected void convertResult(Result result, List<FieldValueImpl> elementList) {
                List<FieldValueImpl> queryResults = result.getQueryResults();
                for (FieldValueImpl res : queryResults) {
                    elementList.add(res);
                }
            }

            @Override
            protected int compare(FieldValueImpl one, FieldValueImpl two) {
                throw new QueryStateException("Unexpected call");
            }

            class QueryPartitionStream
            extends PartitionScanIterator.PartitionStream {
                private ResumeInfo theResumeInfo;

                QueryPartitionStream(RepGroupId groupId, int partitionId) {
                    super(groupId, partitionId, null);
                    this.theResumeInfo = new ResumeInfo(rcb);
                }

                @Override
                protected Request makeReadRequest() {
                    TableQuery op = new TableQuery(PreparedStatementImpl.DistributionKind.ALL_PARTITIONS, ReceiveIter.this.theInputType, ReceiveIter.this.theMayReturnNULL, ReceiveIter.this, rcb.getExternalVars(), ReceiveIter.this.theNumIters, ReceiveIter.this.theNumRegs, ReceiveIter.this.theTableId, rcb.getMathContext(), rcb.getTraceLevel(), rcb.getBatchSize(), 0, 0, this.theResumeInfo, 1);
                    if (ReceiveIter.this.theIsUpdate) {
                        return storeImpl.makeWriteRequest((InternalOperation)op, new PartitionId(this.partitionId), rcb.getDurability(), rcb.getTimeout(), rcb.getTimeUnit(), null);
                    }
                    return storeImpl.makeReadRequest((InternalOperation)op, new PartitionId(this.partitionId), storeIteratorParams.getConsistency(), storeIteratorParams.getTimeout(), storeIteratorParams.getTimeoutUnit(), null);
                }

                @Override
                protected void setResumeKey(Result result) {
                    Result.QueryResult res = (Result.QueryResult)result;
                    this.theResumeInfo.refresh(res.getResumeInfo());
                    if (rcb.getTraceLevel() >= 1) {
                        rcb.trace("Received " + res.getNumRecords() + " results from group : " + this.groupId + " partition " + this.partitionId);
                    }
                    if (rcb.getTraceLevel() >= 4) {
                        rcb.trace(this.theResumeInfo.toString());
                    }
                }

                @Override
                protected int compareInternal(BaseParallelScanIteratorImpl.Stream o) {
                    int cmp;
                    QueryPartitionStream other = (QueryPartitionStream)o;
                    FieldValueImpl v1 = this.currentResultSet.getQueryResults().get(this.currentResultPos);
                    FieldValueImpl v2 = other.currentResultSet.getQueryResults().get(other.currentResultPos);
                    if (ReceiveIter.this.theInputType.isRecord()) {
                        RecordValueImpl rec1 = (RecordValueImpl)v1;
                        RecordValueImpl rec2 = (RecordValueImpl)v2;
                        cmp = ReceiveIter.compareRecords(rec1, rec2, ReceiveIter.this.theSortFieldPositions, ReceiveIter.this.theSortSpecs);
                    } else {
                        cmp = ReceiveIter.compareAtomics(v1, v2, 0, ReceiveIter.this.theSortSpecs);
                    }
                    if (cmp == 0) {
                        return this.partitionId < other.partitionId ? -1 : 1;
                    }
                    return cmp;
                }
            }
        };
    }

    private AsyncTableIterator<FieldValueImpl> runOnOnePartition(RuntimeControlBlock rcb) {
        ReceiveIterState state = (ReceiveIterState)rcb.getState(this.theStatePos);
        PartitionId pid = state.thePartitionId;
        PartitionId[] partitions = new PartitionId[]{pid};
        return new SequentialPartitionsIterator(rcb, partitions);
    }

    private AsyncTableIterator<FieldValueImpl> runOnAllShards(final RuntimeControlBlock rcb) {
        if (rcb.getMaxReadKB() > 0 || rcb.getUseBatchSizeAsLimit()) {
            return new SequentialShardsIterator(rcb);
        }
        Direction dir = this.theSortFieldPositions != null ? Direction.FORWARD : Direction.UNORDERED;
        return new ShardScanIterator<FieldValueImpl>(rcb.getStore(), rcb.getExecuteOptions(), dir, rcb.getShardSet(), this.theAsyncIterHandleNotifier){

            @Override
            protected QueryShardStream createStream(RepGroupId groupId) {
                return new QueryShardStream(groupId);
            }

            @Override
            protected TableQuery createOp(byte[] resumeSecondaryKey, byte[] resumePrimaryKey) {
                throw new QueryStateException("Unexpected call");
            }

            @Override
            protected void convertResult(Result result, List<FieldValueImpl> elementList) {
                List<FieldValueImpl> queryResults = result.getQueryResults();
                for (FieldValueImpl res : queryResults) {
                    elementList.add(res);
                }
            }

            @Override
            protected int compare(FieldValueImpl one, FieldValueImpl two) {
                throw new QueryStateException("Unexpected call");
            }

            class QueryShardStream
            extends ShardScanIterator.ShardStream {
                private ResumeInfo theResumeInfo;

                QueryShardStream(RepGroupId groupId) {
                    super(groupId, null, null);
                    this.theResumeInfo = new ResumeInfo(rcb);
                }

                @Override
                protected Request makeReadRequest() {
                    TableQuery op = new TableQuery(PreparedStatementImpl.DistributionKind.ALL_SHARDS, ReceiveIter.this.theInputType, ReceiveIter.this.theMayReturnNULL, ReceiveIter.this, rcb.getExternalVars(), ReceiveIter.this.theNumIters, ReceiveIter.this.theNumRegs, ReceiveIter.this.theTableId, rcb.getMathContext(), rcb.getTraceLevel(), rcb.getBatchSize(), 0, 0, this.theResumeInfo, 1);
                    if (ReceiveIter.this.theIsUpdate) {
                        return storeImpl.makeWriteRequest((InternalOperation)op, this.groupId, rcb.getDurability(), requestTimeoutMs, TimeUnit.MILLISECONDS, rcb.getLogContext());
                    }
                    return storeImpl.makeReadRequest((InternalOperation)op, this.groupId, consistency, requestTimeoutMs, TimeUnit.MILLISECONDS, rcb.getLogContext());
                }

                @Override
                protected void setResumeKey(Result result) {
                    Result.QueryResult res = (Result.QueryResult)result;
                    this.theResumeInfo.refresh(res.getResumeInfo());
                    if (rcb.getTraceLevel() >= 1) {
                        rcb.trace("Received " + res.getNumRecords() + " results from group : " + this.groupId + " shard " + this.groupId);
                    }
                    if (rcb.getTraceLevel() >= 4) {
                        rcb.trace(this.theResumeInfo.toString());
                    }
                }

                @Override
                protected int compareInternal(BaseParallelScanIteratorImpl.Stream o) {
                    int cmp;
                    QueryShardStream other = (QueryShardStream)o;
                    FieldValueImpl v1 = this.currentResultSet.getQueryResults().get(this.currentResultPos);
                    FieldValueImpl v2 = other.currentResultSet.getQueryResults().get(other.currentResultPos);
                    if (ReceiveIter.this.theInputType.isRecord()) {
                        RecordValueImpl rec1 = (RecordValueImpl)v1;
                        RecordValueImpl rec2 = (RecordValueImpl)v2;
                        cmp = ReceiveIter.compareRecords(rec1, rec2, ReceiveIter.this.theSortFieldPositions, ReceiveIter.this.theSortSpecs);
                    } else {
                        cmp = ReceiveIter.compareAtomics(v1, v2, 0, ReceiveIter.this.theSortSpecs);
                    }
                    if (cmp == 0) {
                        return this.getGroupId().compareTo(other.getGroupId());
                    }
                    return cmp;
                }
            }
        };
    }

    @Override
    public void open(RuntimeControlBlock rcb) {
        boolean alwaysFalse = false;
        PartitionId pid = PartitionId.NULL_ID;
        if (this.theDistributionKind == PreparedStatementImpl.DistributionKind.SINGLE_PARTITION) {
            if (this.thePushedExternals != null && this.thePushedExternals.length > 0) {
                TableImpl table;
                PrimaryKeyImpl primaryKey;
                if (this.thePrimaryKey instanceof PrimaryKeyImpl) {
                    primaryKey = (PrimaryKeyImpl)this.thePrimaryKey.clone();
                    table = primaryKey.getTable();
                } else {
                    table = rcb.getMetadataHelper().getTable(this.theNamespace, this.theTableName);
                    primaryKey = table.createPrimaryKey(this.thePrimaryKey);
                }
                int size = this.thePushedExternals.length;
                for (int i = 0; i < size; ++i) {
                    PlanIter iter = this.thePushedExternals[i];
                    if (iter == null) continue;
                    iter.open(rcb);
                    iter.next(rcb);
                    FieldValueImpl val = rcb.getRegVal(iter.getResultReg());
                    iter.close(rcb);
                    FieldValueImpl newVal = BaseTableIter.castValueToIndexKey(table, null, i, val, FunctionLib.FuncCode.OP_EQ);
                    if (newVal != val) {
                        if (newVal == BooleanValueImpl.falseValue) {
                            alwaysFalse = true;
                            break;
                        }
                        val = newVal;
                    }
                    String colName = table.getPrimaryKeyColumnName(i);
                    primaryKey.put(colName, (FieldValue)val);
                }
                pid = primaryKey.getPartitionId(rcb.getStore());
            } else {
                pid = this.thePartitionId;
            }
        }
        ReceiveIterState state = new ReceiveIterState(pid, this.thePrimKeyPositions != null);
        rcb.setState(this.theStatePos, state);
        rcb.incMemoryConsumption(state.theMemoryConsumption);
        if (this.theTupleRegs != null) {
            TupleValue tuple = new TupleValue((RecordDefImpl)this.theInputType, rcb.getRegisters(), this.theTupleRegs);
            rcb.setRegVal(this.theResultReg, tuple);
        }
        if (alwaysFalse) {
            state.done();
        }
    }

    @Override
    public boolean next(RuntimeControlBlock rcb) {
        return this.nextInternal(rcb, false);
    }

    @Override
    public boolean nextLocal(RuntimeControlBlock rcb) {
        return this.nextInternal(rcb, true);
    }

    private boolean nextInternal(RuntimeControlBlock rcb, boolean localOnly) {
        try {
            FieldValueImpl res;
            block15: {
                BinaryValueImpl binPrimKey;
                boolean added;
                ReceiveIterState state = (ReceiveIterState)rcb.getState(this.theStatePos);
                if (state.isDone()) {
                    return false;
                }
                this.ensureIterator(rcb, state);
                do {
                    if (localOnly) {
                        res = state.theRemoteResultsIter.nextLocal();
                        if (res == null) {
                            if (state.theRemoteResultsIter.isClosed() && !state.isClosed()) {
                                state.done();
                            }
                            return false;
                        }
                    } else {
                        boolean more = state.theRemoteResultsIter.hasNext();
                        if (!more) {
                            state.done();
                            return false;
                        }
                        res = (FieldValueImpl)state.theRemoteResultsIter.next();
                    }
                    if (this.thePrimKeyPositions == null) break block15;
                } while (!(added = state.thePrimKeysSet.add(binPrimKey = this.createBinaryPrimKey(res))));
                long sz = binPrimKey.sizeof() + 24L;
                state.theMemoryConsumption += sz;
                rcb.incMemoryConsumption(sz);
            }
            if (this.theTupleRegs != null) {
                TupleValue tuple = (TupleValue)rcb.getRegVal(this.theResultReg);
                tuple.toTuple((RecordValueImpl)res, this.doesSort());
            } else if (this.doesSort() && res.isRecord()) {
                ((RecordValueImpl)res).convertEmptyToNull();
                rcb.setRegVal(this.theResultReg, res);
            } else {
                rcb.setRegVal(this.theResultReg, res.isEMPTY() ? NullValueImpl.getInstance() : res);
            }
            return true;
        }
        catch (StoreIteratorException sie) {
            Throwable cause = sie.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw new IllegalStateException("Unexpected exception: " + cause, cause);
        }
    }

    @Override
    public void reset(RuntimeControlBlock rcb) {
        ReceiveIterState state = (ReceiveIterState)rcb.getState(this.theStatePos);
        rcb.decMemoryConsumption(state.theMemoryConsumption - theFixedMemoryConsumption);
        state.reset(this);
    }

    @Override
    public void close(RuntimeControlBlock rcb) {
        ReceiveIterState state = (ReceiveIterState)rcb.getState(this.theStatePos);
        if (state == null) {
            return;
        }
        state.close();
    }

    @Override
    public Throwable getCloseException(RuntimeControlBlock rcb) {
        ReceiveIterState state = (ReceiveIterState)rcb.getState(this.theStatePos);
        if (state == null) {
            return null;
        }
        if (state.theRemoteResultsIter != null) {
            return state.theRemoteResultsIter.getCloseException();
        }
        return state.theRemoteResultsIterCloseException;
    }

    private BinaryValueImpl createBinaryPrimKey(FieldValueImpl result) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(baos);
        try {
            if (!result.isRecord()) {
                assert (this.thePrimKeyPositions.length == 1);
                this.writeValue(out, result, 0);
            } else {
                for (int i = 0; i < this.thePrimKeyPositions.length; ++i) {
                    FieldValueImpl fval = ((RecordValueImpl)result).get(this.thePrimKeyPositions[i]);
                    this.writeValue(out, fval, i);
                }
            }
        }
        catch (IOException e) {
            throw new QueryStateException("Failed to create binary prim key due to IOException:\n" + e.getMessage());
        }
        byte[] bytes = baos.toByteArray();
        return FieldDefImpl.binaryDef.createBinary(bytes);
    }

    private void writeValue(DataOutput out, FieldValueImpl val, int i) throws IOException {
        switch (val.getType()) {
            case INTEGER: {
                SerializationUtil.writePackedInt(out, val.getInt());
                break;
            }
            case LONG: {
                SerializationUtil.writePackedLong(out, val.getLong());
                break;
            }
            case DOUBLE: {
                out.writeDouble(val.getDouble());
                break;
            }
            case FLOAT: {
                out.writeFloat(val.getFloat());
                break;
            }
            case STRING: {
                SerializationUtil.writeString(out, SerialVersion.CURRENT, val.getString());
                break;
            }
            case ENUM: {
                out.writeShort(val.asEnum().getIndex());
                break;
            }
            case TIMESTAMP: {
                TimestampValueImpl ts = (TimestampValueImpl)val;
                SerializationUtil.writeNonNullByteArray(out, ts.getBytes());
                break;
            }
            case NUMBER: {
                NumberValueImpl num = (NumberValueImpl)val;
                SerializationUtil.writeNonNullByteArray(out, num.getBytes());
                break;
            }
            default: {
                throw new QueryStateException("Unexpected type for primary key column : " + val.getType() + ", at result column " + i);
            }
        }
    }

    @Override
    protected void displayContent(StringBuilder sb, QueryFormatter formatter) {
        int i;
        if (this.theSortFieldPositions != null) {
            formatter.indent(sb);
            sb.append("Sort Field Positions : ");
            for (i = 0; i < this.theSortFieldPositions.length; ++i) {
                sb.append(this.theSortFieldPositions[i]);
                if (i >= this.theSortFieldPositions.length - 1) continue;
                sb.append(", ");
            }
            sb.append(",\n");
        }
        if (this.thePrimKeyPositions != null) {
            formatter.indent(sb);
            sb.append("Primary Key Positions : ");
            for (i = 0; i < this.thePrimKeyPositions.length; ++i) {
                sb.append(this.thePrimKeyPositions[i]);
                if (i >= this.thePrimKeyPositions.length - 1) continue;
                sb.append(", ");
            }
            sb.append(",\n");
        }
        formatter.indent(sb);
        sb.append("DistributionKind : ").append((Object)this.theDistributionKind);
        sb.append(",\n");
        if (this.thePushedExternals != null) {
            sb.append("\n");
            formatter.indent(sb);
            sb.append("EXTERNAL KEY EXPRS: ").append(this.thePushedExternals.length);
            for (PlanIter iter : this.thePushedExternals) {
                sb.append("\n");
                if (iter != null) {
                    iter.display(sb, formatter);
                    continue;
                }
                formatter.indent(sb);
                sb.append("null");
            }
            sb.append(",\n\n");
        }
        formatter.indent(sb);
        sb.append("Number of Registers :").append(this.theNumRegs);
        sb.append(",\n");
        formatter.indent(sb);
        sb.append("Number of Iterators :").append(this.theNumIters);
        sb.append(",\n");
        this.theInputIter.display(sb, formatter);
    }

    static int compareRecords(RecordValueImpl rec1, RecordValueImpl rec2, int[] sortFieldPositions, SortSpec[] sortSpecs) {
        for (int i = 0; i < sortFieldPositions.length; ++i) {
            FieldValueImpl v2;
            int pos = sortFieldPositions[i];
            FieldValueImpl v1 = rec1.get(pos);
            int comp = ReceiveIter.compareAtomics(v1, v2 = rec2.get(pos), i, sortSpecs);
            if (comp == 0) continue;
            return comp;
        }
        return 0;
    }

    static int compareAtomics(FieldValueImpl v1, FieldValueImpl v2, int sortPos, SortSpec[] sortSpecs) {
        int comp = v1.isNull() ? (v2.isNull() ? 0 : (sortSpecs[sortPos].theNullsFirst ? -1 : 1)) : (v2.isNull() ? (sortSpecs[sortPos].theNullsFirst ? 1 : -1) : (v1.isEMPTY() ? (v2.isEMPTY() ? 0 : (v2.isJsonNull() ? (sortSpecs[sortPos].theNullsFirst ? 1 : -1) : (sortSpecs[sortPos].theNullsFirst ? -1 : 1))) : (v2.isEMPTY() ? (v1.isJsonNull() ? (sortSpecs[sortPos].theNullsFirst ? -1 : 1) : (sortSpecs[sortPos].theNullsFirst ? 1 : -1)) : (v1.isJsonNull() ? (v1.isJsonNull() ? 0 : (sortSpecs[sortPos].theNullsFirst ? -1 : 1)) : (v2.isJsonNull() ? (sortSpecs[sortPos].theNullsFirst ? 1 : -1) : v1.compareTo(v2))))));
        return sortSpecs[sortPos].theIsDesc ? -comp : comp;
    }

    private class AbstractScanIterator
    implements AsyncTableIterator<FieldValueImpl> {
        private final RuntimeControlBlock theRCB;
        private PartitionId thePid;
        private RepGroupId theGroupId;
        private int theMaxReadNum;
        private int theMaxReadKB;
        private int theEmptyReadFactor;
        private Iterator<FieldValueImpl> theResultsIter;
        private boolean theMoreRemoteResults;
        private Throwable theAsyncCloseException;
        private boolean theIsClosed;
        private boolean theAsyncRequestExecuting;

        public AbstractScanIterator(RuntimeControlBlock rcb, PartitionId pid, RepGroupId gid, int maxReadNum, int maxReadKB, int emptyReadFactor) {
            this.theRCB = rcb;
            this.thePid = pid;
            this.theGroupId = gid;
            this.theMaxReadNum = maxReadNum;
            this.theMaxReadKB = maxReadKB;
            this.theMoreRemoteResults = true;
            this.theResultsIter = null;
            this.theEmptyReadFactor = emptyReadFactor;
        }

        void initForNextPartition(PartitionId pid, int maxReadNum, int maxReadKB, int emptyReadFactor) {
            this.initForNextScan(pid, null, maxReadNum, maxReadKB, emptyReadFactor);
        }

        void initForNextShard(RepGroupId gid, int maxReadNum, int maxReadKB, int emptyReadFactor) {
            this.initForNextScan(null, gid, maxReadNum, maxReadKB, emptyReadFactor);
        }

        private void initForNextScan(PartitionId pid, RepGroupId gid, int maxReadNum, int maxReadKB, int emptyReadFactor) {
            this.thePid = pid;
            this.theGroupId = gid;
            this.theRCB.getResumeInfo().reset();
            this.theMaxReadNum = maxReadNum;
            this.theMaxReadKB = maxReadKB;
            this.theMoreRemoteResults = true;
            this.theResultsIter = null;
            this.theEmptyReadFactor = emptyReadFactor;
        }

        Request createRequest() {
            TableQuery op = new TableQuery(ReceiveIter.this.theDistributionKind, ReceiveIter.this.theInputType, ReceiveIter.this.theMayReturnNULL, ReceiveIter.this, this.theRCB.getExternalVars(), ReceiveIter.this.theNumIters, ReceiveIter.this.theNumRegs, ReceiveIter.this.theTableId, this.theRCB.getMathContext(), this.theRCB.getTraceLevel(), this.theMaxReadNum, this.theMaxReadKB, this.theRCB.getMaxReadKB(), this.theRCB.getResumeInfo(), this.theEmptyReadFactor);
            Consistency consistency = this.theRCB.getConsistency();
            Durability durability = this.theRCB.getDurability();
            long timeout = this.theRCB.getTimeout();
            TimeUnit timeUnit = this.theRCB.getTimeUnit();
            KVStoreImpl store = this.theRCB.getStore();
            if (this.thePid != null) {
                if (ReceiveIter.this.theIsUpdate) {
                    return store.makeWriteRequest((InternalOperation)op, this.thePid, durability, timeout, timeUnit, null);
                }
                return store.makeReadRequest((InternalOperation)op, this.thePid, consistency, timeout, timeUnit, null);
            }
            if (ReceiveIter.this.theIsUpdate) {
                return store.makeWriteRequest((InternalOperation)op, this.theGroupId, durability, timeout, timeUnit, null);
            }
            return store.makeReadRequest((InternalOperation)op, this.theGroupId, consistency, timeout, timeUnit, null);
        }

        @Override
        public boolean hasNext() {
            if (this.theResultsIter != null && this.theResultsIter.hasNext()) {
                return true;
            }
            this.theResultsIter = null;
            if (!this.theMoreRemoteResults || this.theRCB.getReachedLimit()) {
                return false;
            }
            Request req = this.createRequest();
            KVStoreImpl store = this.theRCB.getStore();
            Result.QueryResult result = (Result.QueryResult)store.executeRequest(req);
            return this.processResults(result);
        }

        private boolean processResults(Result.QueryResult result) {
            List<FieldValueImpl> results = result.getQueryResults();
            this.theMoreRemoteResults = result.hasMoreElements();
            this.theRCB.getResumeInfo().refresh(result.getResumeInfo());
            this.theRCB.tallyReadKB(result.getReadKB());
            this.theRCB.tallyWriteKB(result.getWriteKB());
            if (this.theRCB.getUseBatchSizeAsLimit()) {
                this.theRCB.tallyResultSize(results.size());
            }
            if (results.isEmpty()) {
                assert (result.getExceededSizeLimit() || !this.theMoreRemoteResults);
                if (result.getExceededSizeLimit()) {
                    this.theRCB.setReachedLimit(true);
                }
                return false;
            }
            this.theResultsIter = results.iterator();
            if (this.theMoreRemoteResults) {
                boolean reachSizeLimit;
                boolean bl = reachSizeLimit = result.getExceededSizeLimit() || this.theMaxReadKB > 0 && this.theMaxReadKB == result.getReadKB();
                if (reachSizeLimit || this.theRCB.getUseBatchSizeAsLimit()) {
                    this.theRCB.setReachedLimit(true);
                } else if (this.theMaxReadKB > 0) {
                    this.theMaxReadKB -= result.getReadKB();
                }
            }
            return true;
        }

        @Override
        public FieldValueImpl nextLocal() {
            if (Thread.holdsLock(this)) {
                throw new IllegalStateException("nextLocal called with lock held");
            }
            if (this.theResultsIter != null && this.theResultsIter.hasNext()) {
                return this.theResultsIter.next();
            }
            if (this.theAsyncCloseException instanceof RuntimeException) {
                throw (RuntimeException)this.theAsyncCloseException;
            }
            if (this.theAsyncCloseException instanceof Error) {
                throw (Error)this.theAsyncCloseException;
            }
            if (this.theAsyncCloseException != null) {
                throw new IllegalStateException("Unexpected exception from async iteration: " + this.theAsyncCloseException, this.theAsyncCloseException);
            }
            if (this.isClosed()) {
                return null;
            }
            if (this.theAsyncRequestExecuting) {
                return null;
            }
            Request request = this.createRequest();
            this.theAsyncRequestExecuting = true;
            this.theRCB.getStore().executeRequest(request, new ResultHandler<Result>(){

                @Override
                public void onResult(Result r, Throwable e) {
                    AbstractScanIterator.this.theAsyncRequestExecuting = false;
                    AbstractScanIterator.this.handleExecuteResult(r, e);
                }
            });
            return null;
        }

        private void handleExecuteResult(Result r, Throwable e) {
            assert (!Thread.holdsLock(this));
            if (r != null) {
                this.processResults((Result.QueryResult)r);
            } else {
                this.theAsyncCloseException = e;
                this.close();
            }
            ReceiveIter.this.theAsyncIterHandleNotifier.notifyNext();
        }

        @Override
        public FieldValueImpl next() {
            return this.theResultsIter.next();
        }

        @Override
        public void close() {
            this.theResultsIter = null;
            this.theIsClosed = true;
        }

        @Override
        public boolean isClosed() {
            if (this.theIsClosed) {
                return true;
            }
            if (this.theResultsIter != null && this.theResultsIter.hasNext()) {
                return false;
            }
            if (!this.theMoreRemoteResults) {
                this.close();
                return true;
            }
            return false;
        }

        @Override
        public synchronized Throwable getCloseException() {
            return this.theAsyncCloseException;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<DetailedMetrics> getPartitionMetrics() {
            return Collections.emptyList();
        }

        @Override
        public List<DetailedMetrics> getShardMetrics() {
            return Collections.emptyList();
        }
    }

    private class SequentialShardsIterator
    implements AsyncTableIterator<FieldValueImpl> {
        private final RuntimeControlBlock theRCB;
        private final RepGroupId[] theShards;
        private AbstractScanIterator theShardIter;

        SequentialShardsIterator(RuntimeControlBlock rcb) {
            this.theRCB = rcb;
            Set<RepGroupId> gpIds = this.theRCB.getStore().getTopology().getRepGroupIds();
            this.theShards = gpIds.toArray(new RepGroupId[gpIds.size()]);
            int shardIdx = this.theRCB.getShardIdx();
            if (shardIdx < 0 || shardIdx >= this.theShards.length) {
                throw new IllegalArgumentException("Invalid shard id in continuation key: " + shardIdx);
            }
            int emptyReadFactor = this.theShards.length == 1 ? 1 : 0;
            this.theShardIter = new AbstractScanIterator(this.theRCB, null, this.theShards[shardIdx], this.theRCB.getBatchSize(), this.theRCB.getMaxReadKB(), emptyReadFactor);
        }

        @Override
        public boolean hasNext() {
            if (this.theShardIter == null) {
                return false;
            }
            while (!this.theShardIter.hasNext()) {
                int maxReadNum;
                if (this.theRCB.getReachedLimit()) {
                    this.theRCB.createContinuationKey();
                    return false;
                }
                int shardIdx = this.theRCB.incShardIdx();
                if (shardIdx == this.theShards.length) {
                    this.theShardIter.close();
                    this.theShardIter = null;
                    this.theRCB.setContinuationKey(null);
                    return false;
                }
                int maxReadKB = 0;
                if (this.theRCB.getMaxReadKB() > 0 && (maxReadKB = this.theRCB.getMaxReadKB() - this.theRCB.getReadKB()) <= 0) {
                    this.theRCB.createContinuationKey();
                    return false;
                }
                if (this.theRCB.getUseBatchSizeAsLimit()) {
                    maxReadNum = this.theRCB.getBatchSize() - this.theRCB.getResultSize();
                    if (maxReadNum <= 0) {
                        this.theRCB.createContinuationKey();
                        return false;
                    }
                } else {
                    maxReadNum = this.theRCB.getBatchSize();
                }
                int emptyReadFactor = this.theRCB.getReadKB() == 0 && shardIdx == this.theShards.length - 1 ? 1 : 0;
                this.theShardIter.initForNextShard(this.theShards[shardIdx], maxReadNum, maxReadKB, emptyReadFactor);
            }
            return true;
        }

        @Override
        public FieldValueImpl next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.theShardIter.next();
        }

        @Override
        public FieldValueImpl nextLocal() {
            if (this.theShardIter == null) {
                return null;
            }
            return this.theShardIter.nextLocal();
        }

        @Override
        public void close() {
            if (this.theShardIter != null) {
                this.theShardIter = null;
            }
        }

        @Override
        public boolean isClosed() {
            return this.theShardIter == null || this.theShardIter.isClosed();
        }

        @Override
        public Throwable getCloseException() {
            return this.theShardIter != null ? this.theShardIter.getCloseException() : null;
        }

        @Override
        public List<DetailedMetrics> getPartitionMetrics() {
            return Collections.emptyList();
        }

        @Override
        public List<DetailedMetrics> getShardMetrics() {
            return Collections.emptyList();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class SequentialPartitionsIterator
    implements AsyncTableIterator<FieldValueImpl> {
        private final RuntimeControlBlock theRCB;
        private final PartitionId[] thePartitions;
        private AbstractScanIterator thePartitionIter;

        SequentialPartitionsIterator(RuntimeControlBlock rcb, PartitionId[] partitions) {
            this.theRCB = rcb;
            if (partitions != null) {
                this.thePartitions = partitions;
            } else {
                Set pids = rcb.getStore().getTopology().getPartitionMap().getAllIds();
                this.thePartitions = pids.toArray(new PartitionId[pids.size()]);
            }
            int pidIdx = rcb.getPidIdx();
            if (pidIdx < 0 || pidIdx >= this.thePartitions.length) {
                throw new IllegalArgumentException("Invalid partition id in continuation key: " + pidIdx);
            }
            int emptyReadFactor = this.thePartitions.length == 1 ? 1 : 0;
            this.thePartitionIter = new AbstractScanIterator(this.theRCB, this.thePartitions[pidIdx], null, this.theRCB.getBatchSize(), this.theRCB.getMaxReadKB(), emptyReadFactor);
        }

        @Override
        public boolean hasNext() {
            if (this.thePartitionIter == null) {
                return false;
            }
            while (!this.thePartitionIter.hasNext()) {
                int maxReadNum;
                if (this.theRCB.getReachedLimit()) {
                    this.theRCB.createContinuationKey();
                    return false;
                }
                int pidIdx = this.theRCB.incPidIdx();
                if (pidIdx == this.thePartitions.length) {
                    this.thePartitionIter.close();
                    this.thePartitionIter = null;
                    this.theRCB.setContinuationKey(null);
                    return false;
                }
                int maxReadKB = 0;
                if (this.theRCB.getMaxReadKB() > 0 && (maxReadKB = this.theRCB.getMaxReadKB() - this.theRCB.getReadKB()) <= 0) {
                    this.theRCB.createContinuationKey();
                    return false;
                }
                if (this.theRCB.getUseBatchSizeAsLimit()) {
                    maxReadNum = this.theRCB.getBatchSize() - this.theRCB.getResultSize();
                    if (maxReadNum <= 0) {
                        this.theRCB.createContinuationKey();
                        return false;
                    }
                } else {
                    maxReadNum = this.theRCB.getBatchSize();
                }
                int emptyReadFactor = this.theRCB.getReadKB() == 0 && pidIdx == this.thePartitions.length - 1 ? 1 : 0;
                this.thePartitionIter.initForNextPartition(this.thePartitions[pidIdx], maxReadNum, maxReadKB, emptyReadFactor);
            }
            return true;
        }

        @Override
        public FieldValueImpl nextLocal() {
            if (this.thePartitionIter == null) {
                return null;
            }
            return this.thePartitionIter.nextLocal();
        }

        @Override
        public FieldValueImpl next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.thePartitionIter.next();
        }

        @Override
        public void close() {
            if (this.thePartitionIter != null) {
                this.thePartitionIter.close();
                this.thePartitionIter = null;
            }
        }

        @Override
        public boolean isClosed() {
            return this.thePartitionIter == null || this.thePartitionIter.isClosed();
        }

        @Override
        public Throwable getCloseException() {
            return this.thePartitionIter != null ? this.thePartitionIter.getCloseException() : null;
        }

        @Override
        public List<DetailedMetrics> getPartitionMetrics() {
            return Collections.emptyList();
        }

        @Override
        public List<DetailedMetrics> getShardMetrics() {
            return Collections.emptyList();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class CachedBinaryPlan {
        private byte[] thePlan = null;
        private short theSerialVersion = (short)-1;

        private CachedBinaryPlan(byte[] plan, short serialVersion) {
            this.thePlan = plan;
            this.theSerialVersion = serialVersion;
        }

        public static CachedBinaryPlan create(byte[] plan, short serialVersion) {
            return new CachedBinaryPlan(plan, serialVersion);
        }

        byte[] getPlan() {
            return this.thePlan;
        }

        short getSerialVersion() {
            return this.theSerialVersion;
        }
    }

    private static class ReceiveIterState
    extends PlanIterState {
        final PartitionId thePartitionId;
        AsyncTableIterator<FieldValueImpl> theRemoteResultsIter;
        Throwable theRemoteResultsIterCloseException;
        HashSet<BinaryValueImpl> thePrimKeysSet;
        long theMemoryConsumption = ReceiveIter.access$000();

        ReceiveIterState(PartitionId pid, boolean eliminateIndexDups) {
            this.thePartitionId = pid;
            if (eliminateIndexDups) {
                this.thePrimKeysSet = new HashSet(1000);
            }
        }

        @Override
        public void done() {
            super.done();
            this.clear();
        }

        @Override
        public void reset(PlanIter iter) {
            super.reset(iter);
            this.clear();
            this.theMemoryConsumption = theFixedMemoryConsumption;
        }

        @Override
        public void close() {
            super.close();
            if (this.theRemoteResultsIter != null) {
                this.theRemoteResultsIterCloseException = this.theRemoteResultsIter.getCloseException();
            }
            this.clear();
        }

        void clear() {
            if (this.theRemoteResultsIter != null) {
                this.theRemoteResultsIter.close();
                this.theRemoteResultsIter = null;
            }
            if (this.thePrimKeysSet != null) {
                this.thePrimKeysSet.clear();
            }
        }
    }
}

