/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.ops;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import oracle.kv.KeyRange;
import oracle.kv.impl.api.ops.InternalOperation;
import oracle.kv.impl.api.ops.MultiTableOperation;
import oracle.kv.impl.api.table.TargetTables;
import oracle.kv.impl.util.SerializationUtil;

public class MultiDeleteTable
extends MultiTableOperation {
    private final byte[] resumeKey;
    private final boolean majorPathComplete;
    private final int batchSize;
    private final int maxWriteKB;
    private transient byte[] lastDeleted;

    public MultiDeleteTable(byte[] parentKey, TargetTables targetTables, KeyRange subRange) {
        this(parentKey, targetTables, subRange, null, 0);
    }

    public MultiDeleteTable(byte[] parentKey, TargetTables targetTables, KeyRange subRange, byte[] resumeKey, int maxWriteKB) {
        super(InternalOperation.OpCode.MULTI_DELETE_TABLE, parentKey, targetTables, subRange);
        this.resumeKey = resumeKey;
        this.maxWriteKB = maxWriteKB;
        this.majorPathComplete = true;
        this.batchSize = 0;
    }

    protected MultiDeleteTable(DataInput in, short serialVersion) throws IOException {
        super(InternalOperation.OpCode.MULTI_DELETE_TABLE, in, serialVersion);
        this.majorPathComplete = true;
        this.batchSize = 0;
        if (serialVersion >= 16) {
            this.resumeKey = SerializationUtil.readByteArray(in);
            this.maxWriteKB = in.readInt();
        } else {
            this.resumeKey = null;
            this.maxWriteKB = 0;
        }
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        super.writeFastExternal(out, serialVersion);
        if (serialVersion >= 16) {
            SerializationUtil.writeByteArray(out, this.resumeKey);
            out.writeInt(this.maxWriteKB);
        }
    }

    public MultiDeleteTable(byte[] parentKey, long targetTableId, boolean majorPathComplete, int batchSize, byte[] resumeKey) {
        super(InternalOperation.OpCode.MULTI_DELETE_TABLE, parentKey, new TargetTables(targetTableId), null);
        this.majorPathComplete = majorPathComplete;
        this.batchSize = batchSize;
        this.resumeKey = resumeKey;
        this.maxWriteKB = 0;
    }

    byte[] getResumeKey() {
        return this.resumeKey;
    }

    boolean getMajorPathComplete() {
        return this.majorPathComplete;
    }

    int getBatchSize() {
        return this.batchSize;
    }

    public byte[] getLastDeleted() {
        return this.lastDeleted;
    }

    void setLastDeleted(byte[] lastDeleted) {
        this.lastDeleted = lastDeleted;
    }

    int getMaxWriteKB() {
        return this.maxWriteKB;
    }
}

