/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.debug.ui.model;

import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.tcf.internal.debug.ui.model.TCFChildren;
import org.eclipse.tcf.internal.debug.ui.model.TCFNode;
import org.eclipse.tcf.internal.debug.ui.model.TCFNodeExecContext;
import org.eclipse.tcf.internal.debug.ui.model.TCFNodeExpression;

public class TCFChildrenLogExpressions
extends TCFChildren {
    private final HashSet<String> scripts = new HashSet();

    TCFChildrenLogExpressions(TCFNodeExecContext node) {
        super(node, 16);
    }

    void onSuspended() {
        for (TCFNode n : this.getNodes()) {
            ((TCFNodeExpression)n).onSuspended(false);
        }
        this.scripts.clear();
        this.reset();
    }

    void onRegisterValueChanged() {
        for (TCFNode n : this.getNodes()) {
            ((TCFNodeExpression)n).onRegisterValueChanged();
        }
    }

    void onMemoryChanged() {
        for (TCFNode n : this.getNodes()) {
            ((TCFNodeExpression)n).onMemoryChanged();
        }
    }

    void onMemoryMapChanged() {
        for (TCFNode n : this.getNodes()) {
            ((TCFNodeExpression)n).onMemoryMapChanged();
        }
    }

    public TCFNodeExpression findScript(String script) {
        for (TCFNode n : this.getNodes()) {
            TCFNodeExpression e = (TCFNodeExpression)n;
            if (!script.equals(e.getScript())) continue;
            return e;
        }
        return null;
    }

    public void addScript(String script) {
        if (this.scripts.add(script)) {
            this.reset();
        }
    }

    protected boolean startDataRetrieval() {
        HashMap<String, TCFNode> data = new HashMap<String, TCFNode>();
        for (String script : this.scripts) {
            TCFNodeExpression expression_node = this.findScript(script);
            if (expression_node == null) {
                expression_node = new TCFNodeExpression(this.node, script, null, null, null, null, -1, false);
                this.add(expression_node);
            }
            data.put(expression_node.id, expression_node);
        }
        this.set(null, null, data);
        return true;
    }
}

