/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.utilities;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.pivot.Feature;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.Stereotype;

public interface FeatureFilter {
    public static final @NonNull FeatureFilter SELECT_EXTENSION = new ExtensionFeatureFilter();
    public static final @NonNull FeatureFilter SELECT_NON_STATIC = new NonStaticFeatureFilter();
    public static final @NonNull FeatureFilter SELECT_STATIC = new StaticFeatureFilter();

    public boolean accept(@NonNull Feature var1);

    public static final class ExtensionFeatureFilter
    implements FeatureFilter {
        @Override
        public boolean accept(@NonNull Feature asFeature) {
            return asFeature instanceof Property && ((Property)asFeature).getType() instanceof Stereotype;
        }
    }

    public static final class NonStaticFeatureFilter
    implements FeatureFilter {
        @Override
        public boolean accept(@NonNull Feature asFeature) {
            return !asFeature.isIsStatic();
        }
    }

    public static final class StaticFeatureFilter
    implements FeatureFilter {
        @Override
        public boolean accept(@NonNull Feature asFeature) {
            return asFeature.isIsStatic();
        }
    }
}

