/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.pde.ui.target.provider;

import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.m2e.pde.target.BNDInstructions;
import org.eclipse.m2e.pde.target.MavenTargetBundle;
import org.eclipse.m2e.pde.target.MavenTargetLocation;
import org.eclipse.swt.graphics.Image;

public class DependencyNodeLabelProvider
implements ILabelProvider {
    private ResourceManager resourceManager = new LocalResourceManager(JFaceResources.getResources());
    private ImageDescriptor jarDescriptor = ImageDescriptor.createFromURLSupplier((boolean)true, () -> DependencyNodeLabelProvider.class.getResource("/icons/jar_obj.gif"));
    private ImageDescriptor inheritedDescriptor = ImageDescriptor.createFromURLSupplier((boolean)true, () -> DependencyNodeLabelProvider.class.getResource("/icons/show_inherited_dependencies.gif"));
    private ImageDescriptor inheritedJarDescriptor = ImageDescriptor.createFromURLSupplier((boolean)true, () -> DependencyNodeLabelProvider.class.getResource("/icons/jar_dep.png"));
    private ImageDescriptor inheritedJarDefaultDescriptor = ImageDescriptor.createFromURLSupplier((boolean)true, () -> DependencyNodeLabelProvider.class.getResource("/icons/jar_dep_default.png"));
    private ImageDescriptor errorDescriptor = ImageDescriptor.createFromURLSupplier((boolean)true, () -> DependencyNodeLabelProvider.class.getResource("/icons/error_st_obj.gif"));
    private ImageDescriptor disabledDescriptor = ImageDescriptor.createFromURLSupplier((boolean)true, () -> DependencyNodeLabelProvider.class.getResource("/icons/clear.gif"));

    public String getText(Object element) {
        if (element instanceof DependencyNode) {
            String scope;
            DependencyNode node = (DependencyNode)element;
            Artifact artifact = node.getArtifact();
            MavenTargetLocation location = this.getTargetLocation(node);
            String baseLabel = artifact.getGroupId() + ":" + artifact.getArtifactId() + " (" + artifact.getVersion() + ")";
            Dependency dependency = node.getDependency();
            if (dependency != null && (scope = dependency.getScope()) != null && !scope.isBlank()) {
                baseLabel = baseLabel + " [" + scope + "]";
            }
            if (location != null) {
                if (location.isExcluded(artifact)) {
                    return "(excluded) " + baseLabel;
                }
                if (location.isIgnored(artifact)) {
                    return "(ignored) " + baseLabel;
                }
                if (location.isFailed(artifact)) {
                    return "(failed) " + baseLabel;
                }
            }
            return baseLabel;
        }
        return String.valueOf(element);
    }

    private MavenTargetLocation getTargetLocation(DependencyNode node) {
        Object object = node.getData().get("dependencynode.parent");
        if (object instanceof DependencyNode) {
            DependencyNode dependency = (DependencyNode)object;
            return this.getTargetLocation(dependency);
        }
        if (object instanceof MavenTargetLocation) {
            MavenTargetLocation location = (MavenTargetLocation)object;
            return location;
        }
        return null;
    }

    public Image getImage(Object element) {
        if (element instanceof DependencyNode) {
            DependencyNode node = (DependencyNode)element;
            MavenTargetLocation location = this.getTargetLocation(node);
            if (location != null) {
                if (location.isExcluded(node.getArtifact())) {
                    return (Image)this.resourceManager.create((DeviceResourceDescriptor)this.disabledDescriptor);
                }
                if (location.isIgnored(node.getArtifact())) {
                    return (Image)this.resourceManager.create((DeviceResourceDescriptor)this.jarDescriptor);
                }
                if (location.isFailed(node.getArtifact())) {
                    return (Image)this.resourceManager.create((DeviceResourceDescriptor)this.errorDescriptor);
                }
                MavenTargetBundle targetBundle = location.getMavenTargetBundle(node.getArtifact());
                if (targetBundle != null && targetBundle.isWrapped()) {
                    BNDInstructions instructions = location.getInstructions(node.getArtifact());
                    if (instructions.isEmpty()) {
                        return (Image)this.resourceManager.create((DeviceResourceDescriptor)this.inheritedJarDefaultDescriptor);
                    }
                    return (Image)this.resourceManager.create((DeviceResourceDescriptor)this.inheritedJarDescriptor);
                }
            }
            return (Image)this.resourceManager.create((DeviceResourceDescriptor)this.inheritedDescriptor);
        }
        return null;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
        this.resourceManager.dispose();
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

