/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.emf.ui.internal.common.resourcelocator.dialogs;

import java.util.ArrayList;
import org.eclipse.e4.tools.emf.ui.internal.common.component.tabs.empty.E;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;

public class DynamicWizard
extends Wizard {
    protected ArrayList<IWizardPage> pages = new ArrayList();
    private String message;

    public DynamicWizard() {
        this.setForcePreviousAndNextButtons(true);
    }

    public boolean performFinish() {
        return true;
    }

    public boolean canFinish() {
        IWizardPage cur = this.getContainer().getCurrentPage();
        IWizardPage nextPage = this.getNextPage(cur);
        for (IWizardPage page : this.pages) {
            if (page.isPageComplete()) continue;
            return false;
        }
        return nextPage == null;
    }

    public void addPage(IWizardPage page) {
        page.setWizard((IWizard)this);
        this.pages.add(page);
        if (super.getPageCount() == 0) {
            super.addPage(page);
            this.updateMessage();
        }
    }

    private void updateMessage() {
        IWizardPage page;
        if (E.notEmpty(this.message) && this.pages.size() > 0 && (page = this.pages.get(0)) instanceof WizardPage) {
            WizardPage wizPage = (WizardPage)page;
            wizPage.setMessage(this.message);
        }
    }

    public IWizardPage getPreviousPage(IWizardPage page) {
        IWizardPage cur = this.getContainer().getCurrentPage();
        int index = this.pages.indexOf(cur);
        if (index > 0) {
            return this.pages.get(index - 1);
        }
        return null;
    }

    public IWizardPage getNextPage(IWizardPage page) {
        int index = this.pages.indexOf(page);
        if (index < this.pages.size() - 1) {
            return this.pages.get(index + 1);
        }
        return null;
    }

    public void clearDynamicPages() {
        while (this.pages.size() > 1) {
            this.pages.remove(this.pages.size() - 1);
        }
    }

    public void setMessage(String message) {
        this.message = message;
        this.updateMessage();
    }
}

