/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.internal.swt.table.action;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.emfforms.spi.swt.table.action.Action;
import org.eclipse.emfforms.spi.swt.table.action.ActionConfiguration;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;

public class KeyBindingManager {
    private final Collection<ActionKeyBinding> keyBindings = new LinkedList<ActionKeyBinding>();
    private final Map<Viewer, KeyListener> viewerBindings = new LinkedHashMap<Viewer, KeyListener>();

    public void bindAction(Action action, KeyStroke keyStroke) {
        this.keyBindings.add(new ActionKeyBinding(action, keyStroke));
    }

    public void applyActionConfiguration(ActionConfiguration configuration) {
        for (Action action : configuration.getActions()) {
            if (!configuration.hasKeyStrokesFor(action)) continue;
            for (KeyStroke keyStroke : configuration.getKeyStrokesFor(action)) {
                this.bindAction(action, keyStroke);
            }
        }
    }

    public void bindToViewer(Viewer viewer) {
        if (this.viewerBindings.containsKey(viewer)) {
            throw new IllegalArgumentException("Already bound to the given viewer");
        }
        KeyAdapter listener = new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                for (ActionKeyBinding binding : KeyBindingManager.this.keyBindings) {
                    binding.keyPressed(e);
                }
            }
        };
        viewer.getControl().addKeyListener((KeyListener)listener);
        this.viewerBindings.put(viewer, (KeyListener)listener);
    }

    public void unbindFromViewer(Viewer viewer) {
        if (!this.viewerBindings.containsKey(viewer)) {
            return;
        }
        KeyListener listener = this.viewerBindings.get(viewer);
        viewer.getControl().removeKeyListener(listener);
        this.viewerBindings.remove(viewer);
    }

    private class ActionKeyBinding {
        private final KeyStroke keyStroke;
        private final Action action;

        ActionKeyBinding(Action action, KeyStroke keyStroke) {
            this.action = action;
            this.keyStroke = keyStroke;
        }

        public void keyPressed(KeyEvent e) {
            KeyStroke current = KeyStroke.getInstance((int)e.stateMask, (int)e.keyCode);
            if (this.keyStroke.equals((Object)current)) {
                this.invokeAction();
            }
        }

        private void invokeAction() {
            if (this.action.canExecute()) {
                this.action.execute();
            }
        }
    }
}

