/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.launching.ext;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimaps;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;
import org.eclipse.jdt.launching.environments.IExecutionEnvironmentsManager;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.target.ITargetLocation;
import org.eclipse.pde.core.target.TargetBundle;
import org.eclipse.pde.internal.core.target.IUBundleContainer;
import org.eclipse.pde.internal.launching.PDEMessages;
import org.eclipse.pde.internal.launching.launcher.VMHelper;
import org.eclipse.pde.launching.EclipseApplicationLaunchConfiguration;
import org.eclipse.rcptt.internal.launching.aut.LaunchInfoCache;
import org.eclipse.rcptt.internal.launching.ext.JDTUtils;
import org.eclipse.rcptt.internal.launching.ext.OSArchitecture;
import org.eclipse.rcptt.internal.launching.ext.Q7ExtLaunchMonitor;
import org.eclipse.rcptt.internal.launching.ext.Q7ExtLaunchingPlugin;
import org.eclipse.rcptt.internal.launching.ext.Q7TargetPlatformManager;
import org.eclipse.rcptt.internal.launching.ext.UpdateVMArgs;
import org.eclipse.rcptt.launching.events.AutEventManager;
import org.eclipse.rcptt.launching.ext.BundleStart;
import org.eclipse.rcptt.launching.ext.DependencyResolver;
import org.eclipse.rcptt.launching.ext.OriginalOrderProperties;
import org.eclipse.rcptt.launching.ext.Q7LaunchDelegateUtils;
import org.eclipse.rcptt.launching.ext.StartLevelSupport;
import org.eclipse.rcptt.launching.ext.VmInstallMetaData;
import org.eclipse.rcptt.launching.internal.target.Q7Target;
import org.eclipse.rcptt.launching.target.ITargetPlatformHelper;
import org.eclipse.rcptt.tesla.core.TeslaLimits;
import org.eclipse.rcptt.util.FileUtil;
import org.eclipse.rcptt.util.Versions;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;

public class Q7ExternalLaunchDelegate
extends EclipseApplicationLaunchConfiguration {
    private static final String Q7_LAUNCHING_AUT = "RCPTT: Launching AUT: ";
    private static final String SECURE_STORAGE_FILE_NAME = "secure_storage";
    private ILaunch launch;
    private static final String KEY_BUNDLES_TO_LAUNCH = "bundlesToLaunch";

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        this.launch = launch;
        SubMonitor subm = SubMonitor.convert((IProgressMonitor)monitor, (int)2000);
        Q7ExtLaunchMonitor waiter = new Q7ExtLaunchMonitor(launch);
        try {
            try {
                super.launch(configuration, mode, launch, (IProgressMonitor)subm.split(1000));
                waiter.wait((IProgressMonitor)subm.split(1000), TeslaLimits.getAUTStartupTimeout() / 1000);
            }
            catch (CoreException e) {
                if (!e.getStatus().matches(8)) {
                    Q7ExtLaunchingPlugin.getDefault().log("RCPTT: Failed to Launch AUT: " + configuration.getName() + " cause " + e.getMessage(), e);
                }
                waiter.handle((Exception)((Object)e));
                throw e;
            }
            catch (OperationCanceledException e) {
                throw new CoreException(Status.CANCEL_STATUS);
            }
            catch (RuntimeException e) {
                Q7ExtLaunchingPlugin.getDefault().log("RCPTT: Failed to Launch AUT: " + configuration.getName() + " cause " + e.getMessage(), e);
                waiter.handle(e);
                throw e;
            }
        }
        finally {
            waiter.dispose();
        }
        monitor.done();
    }

    protected void manageLaunch(ILaunch launch) {
    }

    protected boolean saveBeforeLaunch(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        if (Q7ExternalLaunchDelegate.isHeadless(configuration)) {
            return true;
        }
        return super.saveBeforeLaunch(configuration, mode, monitor);
    }

    protected IProject[] getBuildOrder(ILaunchConfiguration configuration, String mode) throws CoreException {
        return new IProject[0];
    }

    public boolean finalLaunchCheck(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        if (Q7ExternalLaunchDelegate.isHeadless(configuration)) {
            return true;
        }
        return super.finalLaunchCheck(configuration, mode, monitor);
    }

    public boolean preLaunchCheck(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        ILaunchConfigurationWorkingCopy workingCopy;
        if (monitor.isCanceled()) {
            return false;
        }
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (!Q7ExternalLaunchDelegate.isHeadless(configuration) && !super.preLaunchCheck(configuration, mode, (IProgressMonitor)sm.split(1))) {
            monitor.done();
            return false;
        }
        this.waitForClearBundlePool((IProgressMonitor)sm.split(1));
        LaunchInfoCache.CachedInfo info = LaunchInfoCache.getInfo((ILaunchConfiguration)configuration);
        if (info.target != null) {
            monitor.done();
            return true;
        }
        ITargetPlatformHelper target = Q7TargetPlatformManager.findTarget(configuration, (IProgressMonitor)sm.split(1));
        if (target == null) {
            if (sm.isCanceled()) {
                return false;
            }
            target = Q7TargetPlatformManager.getTarget(configuration, (IProgressMonitor)sm.split(1));
            if (target == null) {
                throw new CoreException(Status.error((String)("RCPTT has been updated since AUT " + configuration.getName() + " was created. Edit the AUT to restore compatibility.")));
            }
            ILaunchConfigurationWorkingCopy wc = configuration.getWorkingCopy();
            Q7TargetPlatformManager.setHelper(wc, target);
            wc.doSave();
        }
        if (monitor.isCanceled()) {
            return false;
        }
        MultiStatus error = new MultiStatus("org.eclipse.rcptt.launching.ext", 0, "Target platform initialization failed  for " + configuration.getName() + " edit the AUT to retry", null);
        error.add(target.resolve((IProgressMonitor)sm.split(97)));
        if (!error.isOK() && !error.matches(8)) {
            Q7ExtLaunchingPlugin.log((IStatus)error);
        }
        if (error.matches(12)) {
            if (monitor.isCanceled()) {
                return false;
            }
            throw new CoreException((IStatus)error);
        }
        info.target = target;
        boolean jvmFound = false;
        OSArchitecture configArch = null;
        StringBuilder detectMsg = new StringBuilder();
        OSArchitecture architecture = configArch == null ? ((ITargetPlatformHelper)info.target).detectArchitecture(detectMsg) : configArch;
        Q7ExtLaunchingPlugin.getDefault().info(Q7_LAUNCHING_AUT + configuration.getName() + ": Detected AUT architecture is " + architecture.name() + ". " + detectMsg.toString());
        IVMInstall install = Q7ExternalLaunchDelegate.getVMInstall(configuration, target);
        OSArchitecture jvmArch = JDTUtils.detect(install);
        Q7ExtLaunchingPlugin.getDefault().info(Q7_LAUNCHING_AUT + configuration.getName() + ": Selected JVM is " + install.getInstallLocation().toString() + " detected architecture is " + jvmArch.name());
        if (jvmArch.equals((Object)architecture)) {
            jvmFound = true;
        }
        if (!jvmFound && architecture != OSArchitecture.Unknown && target.detectArchitecture(new StringBuilder()) == OSArchitecture.Unknown) {
            Q7ExtLaunchingPlugin.getDefault().info("Cannot determine AUT architecture, sticking to architecture of selected JVM, which is " + jvmArch.name());
            jvmFound = true;
        }
        Q7ExtLaunchingPlugin.getDefault().info(Q7_LAUNCHING_AUT + configuration.getName() + ": JVM and AUT architectures are compatible: " + jvmFound + ".");
        if (!jvmFound && (jvmFound = Q7ExternalLaunchDelegate.updateJVM(workingCopy = configuration.getWorkingCopy(), architecture, (ITargetPlatformHelper)info.target))) {
            workingCopy.doSave();
            Q7ExtLaunchingPlugin.getDefault().info(Q7_LAUNCHING_AUT + configuration.getName() + "JVM configuration is updated to compatible one: " + String.valueOf(Q7ExternalLaunchDelegate.getVMInstall(configuration, target).getInstallLocation()));
        }
        if (!jvmFound) {
            String errorMessage = String.format("Select a compatible Runtime JRE. Architecture: %s, incompatible with: ", new Object[]{architecture, target.getIncompatibleExecutionEnvironments()});
            Q7ExtLaunchingPlugin.getDefault().log(errorMessage, null);
            this.removeTargetPlatform(configuration);
            throw new CoreException((IStatus)new Status(4, "org.eclipse.rcptt.launching.ext", errorMessage, null));
        }
        monitor.done();
        return true;
    }

    public static IVMInstall getVMInstall(ILaunchConfiguration configuration, ITargetPlatformHelper target) throws CoreException {
        return VMHelper.getVMInstall((ILaunchConfiguration)configuration, target.getModels().map(m -> m.model()).collect(Collectors.toSet()));
    }

    private void removeTargetPlatform(ILaunchConfiguration configuration) throws CoreException {
        Q7TargetPlatformManager.delete(configuration);
        LaunchInfoCache.remove((ILaunchConfiguration)configuration);
    }

    private static boolean isHeadless(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("q7.headless.launch", false);
    }

    private void waitForClearBundlePool(IProgressMonitor monitor) {
        try {
            Job.getJobManager().join((Object)"q7.clean.bundle.pool.job", (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)1));
        }
        catch (Exception e1) {
            Q7ExtLaunchingPlugin.getDefault().log("Failed to wait for bundle pool clear job", e1);
        }
    }

    public static boolean updateJVM(ILaunchConfigurationWorkingCopy workingCopy, OSArchitecture architecture, ITargetPlatformHelper target) throws CoreException {
        VmInstallMetaData jvm = VmInstallMetaData.all().filter(m -> Q7ExternalLaunchDelegate.isCompatible(m, architecture, target.getIncompatibleExecutionEnvironments())).findFirst().orElse(null);
        if (jvm == null) {
            return false;
        }
        IVMInstall jvmInstall = jvm.install;
        workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_JRE_CONTAINER_PATH, String.format("org.eclipse.jdt.launching.JRE_CONTAINER/%s/%s", jvmInstall.getVMInstallType().getId(), jvmInstall.getName()));
        return true;
    }

    private static boolean isCompatible(VmInstallMetaData m, OSArchitecture architecture, Set<String> incompatibleExecutionEnvironments) {
        return m.arch.equals((Object)architecture) && Collections.disjoint(incompatibleExecutionEnvironments, m.compatibleEnvironments);
    }

    private static String getSubstitutedString(String text) throws CoreException {
        if (text == null) {
            return "";
        }
        IStringVariableManager mgr = VariablesPlugin.getDefault().getStringVariableManager();
        return mgr.performStringSubstitution(text);
    }

    private String[] constructClasspath(ILaunchConfiguration configuration) throws CoreException {
        LaunchInfoCache.CachedInfo info = LaunchInfoCache.getInfo((ILaunchConfiguration)configuration);
        ITargetPlatformHelper target = (ITargetPlatformHelper)info.target;
        String jarPath = target.getEquinoxStartupPath("org.eclipse.equinox.launcher");
        if (jarPath == null) {
            return null;
        }
        ArrayList<String> entries = new ArrayList<String>();
        entries.add(jarPath);
        String bootstrap = configuration.getAttribute("bootstrap", "");
        StringTokenizer tok = new StringTokenizer(Q7ExternalLaunchDelegate.getSubstitutedString(bootstrap), ",");
        while (tok.hasMoreTokens()) {
            entries.add(tok.nextToken().trim());
        }
        return entries.toArray(new String[entries.size()]);
    }

    public String[] getClasspath(ILaunchConfiguration configuration) throws CoreException {
        String[] classpath = this.constructClasspath(configuration);
        if (classpath == null) {
            String message = PDEMessages.WorkbenchLauncherConfigurationDelegate_noStartup;
            throw new CoreException(Q7ExtLaunchingPlugin.status(message));
        }
        return classpath;
    }

    public String[] getProgramArguments(ILaunchConfiguration configuration) throws CoreException {
        LaunchInfoCache.CachedInfo info = LaunchInfoCache.getInfo((ILaunchConfiguration)configuration);
        ITargetPlatformHelper target = (ITargetPlatformHelper)info.target;
        if (info.programArgs != null) {
            return info.programArgs;
        }
        ArrayList<String> programArgs = new ArrayList<String>();
        programArgs.addAll(Arrays.asList(super.getProgramArguments(configuration)));
        try {
            File config = new File(this.getConfigDir(configuration), "config.ini");
            Properties props = new Properties();
            Throwable throwable = null;
            Object var8_10 = null;
            try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(config));){
                props.load(in);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            File location = target.getQ7Target().getInstallLocation();
            if (location != null) {
                props.setProperty("osgi.install.area", location.getAbsolutePath());
            }
            props.setProperty("osgi.bundles", Q7LaunchDelegateUtils.computeOSGiBundles(Q7ExternalLaunchDelegate.getBundlesToLaunch((LaunchInfoCache.CachedInfo)info).latestVersionsOnly));
            props.remove("osgi.framework");
            OriginalOrderProperties properties = target.getConfigIniProperties();
            properties.setBeginAdd(true);
            properties.putAll((Map<?, ?>)props);
            Throwable throwable3 = null;
            Object var10_14 = null;
            try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(config));){
                properties.store(out, "Configuration File");
            }
            catch (Throwable throwable4) {
                if (throwable3 == null) {
                    throwable3 = throwable4;
                } else if (throwable3 != throwable4) {
                    throwable3.addSuppressed(throwable4);
                }
                throw throwable3;
            }
            new File(config.getParent(), ".p2").mkdirs();
        }
        catch (IOException e) {
            throw new CoreException(Q7ExtLaunchingPlugin.status(e));
        }
        if (configuration.getAttribute("override-secure-storage", true)) {
            programArgs.add("-eclipse.keyring");
            programArgs.add(this.getConfigDir(configuration).toString() + "/secure_storage");
        }
        IVMInstall install = Q7ExternalLaunchDelegate.getVMInstall(configuration, target);
        programArgs.add("-vm");
        programArgs.add(install.getInstallLocation().toString());
        this.removeKey(programArgs, "-arch");
        this.removeKey(programArgs, "-dev");
        info.programArgs = programArgs.toArray(new String[programArgs.size()]);
        Q7ExtLaunchingPlugin.getDefault().info(Q7_LAUNCHING_AUT + configuration.getName() + ": AUT command line arguments is set to: " + Arrays.toString(info.programArgs));
        return info.programArgs;
    }

    private void removeKey(ArrayList<String> programArgs, String key) {
        int archIndex = programArgs.indexOf(key);
        while (archIndex >= 0) {
            programArgs.remove(archIndex);
            programArgs.remove(archIndex);
            archIndex = programArgs.indexOf(key);
        }
    }

    public String[] getVMArguments(ILaunchConfiguration config) throws CoreException {
        LaunchInfoCache.CachedInfo info = LaunchInfoCache.getInfo((ILaunchConfiguration)config);
        if (info.vmArgs != null) {
            return info.vmArgs;
        }
        ArrayList<String> args = new ArrayList<String>(Arrays.asList(super.getVMArguments(config)));
        ITargetPlatformHelper target = (ITargetPlatformHelper)info.target;
        Q7ExternalLaunchDelegate.massageVmArguments(config, args, target, this.launch.getAttribute("org.eclipse.rcptt.launching.ATTR_AUT_LAUNCH_ID"));
        info.vmArgs = args.toArray(new String[args.size()]);
        Q7ExtLaunchingPlugin.getDefault().info(Q7_LAUNCHING_AUT + config.getName() + ": AUT JVM arguments is set to : " + Arrays.toString(info.vmArgs));
        return info.vmArgs;
    }

    public static void massageVmArguments(ILaunchConfiguration config, List<String> args, ITargetPlatformHelper target, String autId) throws CoreException {
        Iterables.removeIf(args, (Predicate)new Predicate<String>(){

            public boolean apply(String input) {
                return input.contains("-Declipse.pde.launch=true");
            }
        });
        args.add("-Dq7id=" + autId);
        args.add("-Dq7EclPort=" + AutEventManager.INSTANCE.getPort());
        IPluginModelBase hook = target.getWeavingHook();
        if (hook == null) {
            throw new CoreException(Q7ExtLaunchingPlugin.status("No org.eclipse.equinox.weaving.hook plugin"));
        }
        OriginalOrderProperties properties = target.getConfigIniProperties();
        ArrayList<String> argsCopy = new ArrayList<String>(args);
        args.clear();
        args.addAll(UpdateVMArgs.addHook(argsCopy, hook, properties.getProperty("osgi.framework.extensions")));
        args.addAll(Q7ExternalLaunchDelegate.vmSecurityArguments(config, target));
        ArrayList<String> copy = new ArrayList<String>(args);
        args.clear();
        args.addAll(UpdateVMArgs.updateAttr(copy));
        args.add("-Declipse.vmargs=" + Joiner.on((String)"\n").join(args) + "\n");
    }

    public static List<String> vmSecurityArguments(ILaunchConfiguration configuration, ITargetPlatformHelper target) throws CoreException {
        ArrayList<String> result = new ArrayList<String>();
        Set<String> envs = Q7ExternalLaunchDelegate.getMatchingEnvironments(configuration, target);
        if (envs.contains("JavaSE-11")) {
            result.addAll(Arrays.asList("--add-opens", "java.base/java.lang=ALL-UNNAMED", "--add-modules=ALL-SYSTEM"));
            if (!envs.contains("JavaSE-17")) {
                result.add("--illegal-access=permit");
            }
        }
        if (envs.contains("JavaSE-12") && !envs.contains("JavaSE-17")) {
            result.add("-Djava.security.manager=allow");
        }
        return result;
    }

    private static Set<String> getMatchingEnvironments(ILaunchConfiguration configuration, ITargetPlatformHelper target) throws CoreException {
        IVMInstall install = Q7ExternalLaunchDelegate.getVMInstall(configuration, target);
        if (install == null) {
            return Collections.emptySet();
        }
        IExecutionEnvironmentsManager manager = JavaRuntime.getExecutionEnvironmentsManager();
        return Arrays.stream(manager.getExecutionEnvironments()).filter(env -> Arrays.stream(env.getCompatibleVMs()).anyMatch(install::equals)).map(IExecutionEnvironment::getId).collect(Collectors.toSet());
    }

    protected void preLaunchCheck(ILaunchConfiguration configuration, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        SubMonitor subm = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        super.preLaunchCheck(configuration, launch, (IProgressMonitor)subm.split(50));
        LaunchInfoCache.CachedInfo info = LaunchInfoCache.getInfo((ILaunchConfiguration)configuration);
        ITargetPlatformHelper target = (ITargetPlatformHelper)info.target;
        BundlesToLaunch bundlesToLaunch = Q7ExternalLaunchDelegate.collectBundles(target, (IProgressMonitor)subm.split(50));
        Q7ExternalLaunchDelegate.setBundlesToLaunch(info, bundlesToLaunch);
        Q7ExternalLaunchDelegate.removeUnresolved(bundlesToLaunch);
        Q7LaunchDelegateUtils.setDelegateFields(this, bundlesToLaunch.fModels, Maps.transformValues((Map)bundlesToLaunch.fAllBundles.asMap(), ArrayList::new));
        this.copyConfiguratonFiles(configuration, info);
        monitor.done();
    }

    public static void removeUnresolved(BundlesToLaunch launch) {
        DependencyResolver resolver = new DependencyResolver(launch.fAllBundles);
        Collection<IPluginModelBase> toDelete = resolver.checkPlugins(launch.fModels.keySet());
        toDelete.forEach(plugin -> {
            bundlesToLaunch.fAllBundles.remove((Object)plugin.getBundleDescription().getName(), plugin);
            bundlesToLaunch.fModels.remove(plugin);
        });
        String message = "Following bundles were unresolved:\n" + toDelete.stream().map(p -> p.getBundleDescription().getName() + "_" + p.getPluginBase().getVersion()).collect(Collectors.joining("\n"));
        Q7ExtLaunchingPlugin.log(Status.info((String)message));
    }

    public static boolean isQ7BundleContainer(ITargetLocation container) {
        if (!(container instanceof IUBundleContainer)) {
            return false;
        }
        for (URI uri : ((IUBundleContainer)container).getRepositories()) {
            if (uri.getScheme().equals("platform") && uri.getPath().startsWith("/plugin/org.eclipse.rcptt")) continue;
            return false;
        }
        return true;
    }

    public static boolean isAutConfigSimpleconfiguratorSet(Q7Target target) {
        return target.getInstall().configIniBundles().containsKey("org.eclipse.equinox.simpleconfigurator");
    }

    public static BundlesToLaunch collectBundles(ITargetPlatformHelper targetDefinition, IProgressMonitor monitor) {
        BundlesToLaunchCollector collector = new BundlesToLaunchCollector();
        SubMonitor subm = SubMonitor.convert((IProgressMonitor)monitor, (String)"Collecting bundles", (int)targetDefinition.size());
        try {
            for (ITargetPlatformHelper.Model m : targetDefinition.getModels()::iterator) {
                subm.split(1);
                collector.addPluginBundle(m.model(), m.startLevel());
            }
            BundlesToLaunch bundlesToLaunch = new BundlesToLaunch(collector.plugins, collector.latestVersions);
            return bundlesToLaunch;
        }
        finally {
            IProgressMonitor.done((IProgressMonitor)monitor);
        }
    }

    public static void setBundlesToLaunch(LaunchInfoCache.CachedInfo info, BundlesToLaunch bundles) {
        info.data.put(KEY_BUNDLES_TO_LAUNCH, bundles);
    }

    public static BundlesToLaunch getBundlesToLaunch(LaunchInfoCache.CachedInfo info) {
        return (BundlesToLaunch)info.data.get(KEY_BUNDLES_TO_LAUNCH);
    }

    private static Version version(IPluginModelBase plugin) {
        try {
            return new Version(plugin.getPluginBase().getVersion());
        }
        catch (IllegalArgumentException e) {
            return Version.emptyVersion;
        }
    }

    private void copyConfiguratonFiles(ILaunchConfiguration configuration, LaunchInfoCache.CachedInfo info) throws CoreException {
        File[] listFiles;
        File configFolder;
        String targetPlatformPath = ((ITargetPlatformHelper)info.target).getUserArea();
        if (targetPlatformPath == null) {
            targetPlatformPath = ((ITargetPlatformHelper)info.target).getTargetPlatformProfilePath();
        }
        if (!(configFolder = new File(targetPlatformPath, "configuration")).exists()) {
            return;
        }
        HashSet<String> filter = new HashSet<String>(Arrays.asList(new String(".p2;org.eclipse.core.runtime;org.eclipse.equinox.app;org.eclipse.equinox.simpleconfigurator;org.eclipse.equinox.source;org.eclipse.osgi;org.eclipse.ui.intro.universal;org.eclipse.update;config.ini;.settings;org.eclipse.help.base").split(";")));
        File target = this.getConfigDir(configuration);
        File[] fileArray = listFiles = configFolder.listFiles();
        int n = listFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (!filter.contains(file.getName())) {
                if (file.isDirectory()) {
                    FileUtil.copyFiles((File)file, (File)new File(target, file.getName()));
                } else {
                    FileUtil.copyFiles((File)file, (File)target);
                }
            }
            ++n2;
        }
    }

    public static class BundlesToLaunch {
        public final Map<IPluginModelBase, BundleStart> resolvedBundles;
        public final Map<IPluginModelBase, BundleStart> latestVersionsOnly;
        public final Map<IPluginModelBase, String> fModels;
        public final ListMultimap<String, IPluginModelBase> fAllBundles;

        public BundlesToLaunch(Map<IPluginModelBase, BundleStart> plugins, final Map<String, IPluginModelBase> latestVersions) {
            this.resolvedBundles = plugins;
            this.latestVersionsOnly = Maps.filterKeys(this.resolvedBundles, (Predicate)new Predicate<IPluginModelBase>(){

                public boolean apply(IPluginModelBase input) {
                    return latestVersions.get(Q7LaunchDelegateUtils.id(input)) == input;
                }
            });
            ListMultimap multiMap = Multimaps.newListMultimap(new HashMap(), ArrayList::new);
            for (IPluginModelBase plugin : plugins.keySet()) {
                multiMap.put((Object)Q7LaunchDelegateUtils.id(plugin), (Object)plugin);
            }
            this.fAllBundles = multiMap;
            this.fModels = new HashMap<IPluginModelBase, String>(Maps.transformValues(this.resolvedBundles, (Function)new Function<BundleStart, String>(){

                public String apply(BundleStart input) {
                    return input.toModelString();
                }
            }));
        }
    }

    public static class BundlesToLaunchCollector {
        private final Map<IPluginModelBase, BundleStart> plugins = new HashMap<IPluginModelBase, BundleStart>();
        private final Map<String, IPluginModelBase> latestVersions = new HashMap<String, IPluginModelBase>();
        private final Set<UniquePluginModel> uniqueModels = new HashSet<UniquePluginModel>();

        public void addInstallationBundle(IPluginModelBase base, BundleStart hint) throws BundleException, IOException {
            this.put(base, StartLevelSupport.getStartInfo(StartLevelSupport.loadManifest(base.getInstallLocation()), hint));
        }

        public void addPluginBundle(IPluginModelBase bundle, BundleStart startlevel) {
            this.put(bundle, startlevel);
        }

        public BundlesToLaunch getResult() {
            return new BundlesToLaunch(this.plugins, this.latestVersions);
        }

        private void put(IPluginModelBase plugin, BundleStart start) {
            boolean newer;
            String id = Q7LaunchDelegateUtils.id(plugin);
            if (!this.uniqueModels.add(new UniquePluginModel(plugin))) {
                return;
            }
            IPluginModelBase existing = this.latestVersions.get(id);
            boolean bl = newer = existing == null || Versions.isGreater((Version)Q7ExternalLaunchDelegate.version(plugin), (Version)Q7ExternalLaunchDelegate.version(existing));
            if (BundlesToLaunchCollector.isSingleton(plugin)) {
                if (!newer) {
                    return;
                }
                this.plugins.remove(existing);
            }
            this.plugins.put(plugin, start);
            if (newer) {
                this.latestVersions.put(id, plugin);
            }
        }

        private static boolean isSingleton(IPluginModelBase plugin) {
            String id = Q7LaunchDelegateUtils.id(plugin);
            return plugin.getBundleDescription().isSingleton() || id.equals("org.eclipse.equinox.weaving.aspectj") || id.equals("org.aspectj.runtime") || id.equals("org.eclipse.equinox.weaving.hook");
        }
    }

    public static class UniquePluginModel {
        private String name;
        private Version version;

        public UniquePluginModel(IPluginModelBase model) {
            this.version = model.getBundleDescription().getVersion();
            this.name = model.getBundleDescription().getName();
        }

        public UniquePluginModel(TargetBundle bundle) {
            this.version = Version.parseVersion((String)bundle.getBundleInfo().getVersion());
            this.name = bundle.getBundleInfo().getSymbolicName();
        }

        public int hashCode() {
            int prime = 31;
            int hashCode = 1;
            hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
            hashCode = 31 * hashCode + (this.version == null ? 0 : this.version.hashCode());
            return 0;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (object == this) {
                return true;
            }
            if (!(object instanceof UniquePluginModel)) {
                return false;
            }
            UniquePluginModel uniquePluginModel = (UniquePluginModel)object;
            return uniquePluginModel.name.equals(this.name) && uniquePluginModel.version.equals((Object)this.version);
        }
    }
}

