/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.workbench.texteditor;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.rcptt.tesla.core.ui.Marker;
import org.eclipse.rcptt.tesla.core.ui.UiFactory;
import org.eclipse.rcptt.tesla.internal.core.TeslaCore;
import org.eclipse.rcptt.tesla.jface.text.JFaceTextManager;
import org.eclipse.rcptt.tesla.recording.aspects.jface.text.JFaceTextEventManager;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.rulers.AbstractContributedRulerColumn;

public class TextEditorAnnotationFinder {
    public Map<String, EList<Marker>> findAnnotations(TextViewer viewer) {
        HashMap<String, EList<Marker>> markersAtEditor = new HashMap<String, EList<Marker>>();
        FoundResults rulers = this.findRulerColumn(viewer);
        if (rulers != null && rulers.getRulerColumn() instanceof AbstractContributedRulerColumn) {
            AbstractContributedRulerColumn contributedRuler = (AbstractContributedRulerColumn)rulers.getRulerColumn();
            this.detectAnnotations(markersAtEditor, contributedRuler);
        }
        return markersAtEditor;
    }

    private FoundResults findRulerColumn(TextViewer viewer) {
        List rulers = JFaceTextEventManager.getRulers();
        for (IVerticalRuler ruler : rulers) {
            if (!(ruler instanceof CompositeRuler)) continue;
            Iterator iterator = ((CompositeRuler)ruler).getDecoratorIterator();
            while (iterator.hasNext()) {
                Object next = iterator.next();
                if (!(next instanceof AbstractContributedRulerColumn)) continue;
                AbstractContributedRulerColumn column = (AbstractContributedRulerColumn)next;
                Composite rulerParent = column.getControl().getParent().getParent();
                Control viewerParent = viewer.getControl();
                if (!viewerParent.equals(rulerParent)) continue;
                return new FoundResults(ruler, (IVerticalRulerColumn)column);
            }
        }
        return null;
    }

    private void detectAnnotations(Map<String, EList<Marker>> markersAtEditor, AbstractContributedRulerColumn contributedRuler) {
        ITextEditor editor = contributedRuler.getEditor();
        IAnnotationModel model = editor.getDocumentProvider().getAnnotationModel((Object)editor.getEditorInput());
        if (model == null) {
            return;
        }
        Iterator iterator = model.getAnnotationIterator();
        while (iterator.hasNext()) {
            Annotation annotation = (Annotation)iterator.next();
            Position position = model.getPosition(annotation);
            if (position == null) continue;
            try {
                int line = this.getLine(position, contributedRuler) + 1;
                Marker marker = UiFactory.eINSTANCE.createMarker();
                marker.setLine(line);
                marker.setType(annotation.getType());
                marker.setText(annotation.getText());
                marker.setColumn(contributedRuler.getClass().toString());
                this.putAnnotation(markersAtEditor, marker, line);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    private int getLine(Position position, AbstractContributedRulerColumn contributedRuler) throws BadLocationException {
        ITextEditor editor = contributedRuler.getEditor();
        IDocument document = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
        return document.getLineOfOffset(position.getOffset());
    }

    private void putAnnotation(Map<String, EList<Marker>> markersAtEditor, Marker marker, int line) {
        String key = "" + line;
        if (markersAtEditor.containsKey(key)) {
            EList<Marker> markers = markersAtEditor.get(key);
            boolean contains = false;
            for (Marker m : markers) {
                if (!EcoreUtil.equals((EObject)m, (EObject)marker)) continue;
                contains = true;
            }
            if (!contains) {
                markers.add((Object)marker);
            }
        } else {
            BasicEList markers = new BasicEList();
            markers.add((Object)marker);
            markersAtEditor.put(key, (EList<Marker>)markers);
        }
    }

    protected int getVisibleCaretOffset(StyledText control, int line, int offset) {
        TextViewer viewer = JFaceTextManager.getViewer((StyledText)control);
        IDocument document = viewer.getDocument();
        try {
            int lineOffset = document.getLineOffset(line - 1);
            int len = document.getLineLength(line - 1);
            document.get(lineOffset, len);
            int tabs = control.getTabs();
            int column = 0;
            int i = lineOffset;
            while (i <= lineOffset + len) {
                if (column == offset - 1) {
                    column = i - lineOffset;
                    break;
                }
                column = '\t' == document.getChar(i) ? (column += tabs - (tabs == 0 ? 0 : column % tabs)) : ++column;
                ++i;
            }
            return viewer.modelOffset2WidgetOffset(lineOffset + column);
        }
        catch (BadLocationException e) {
            return -1;
        }
        catch (Exception e) {
            TeslaCore.log((Throwable)e);
            return -1;
        }
    }

    final class FoundResults {
        private final IVerticalRuler ruler;
        private final IVerticalRulerColumn rulerColumn;

        public FoundResults(IVerticalRuler ruler, IVerticalRulerColumn rulerColumn) {
            this.ruler = ruler;
            this.rulerColumn = rulerColumn;
        }

        public IVerticalRuler getRuler() {
            return this.ruler;
        }

        public IVerticalRulerColumn getRulerColumn() {
            return this.rulerColumn;
        }
    }
}

