/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.core.IModelProviderEvent;
import org.eclipse.pde.core.IModelProviderListener;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.internal.core.ExternalFeatureModelManager;
import org.eclipse.pde.internal.core.FeatureModelDelta;
import org.eclipse.pde.internal.core.FeatureTable;
import org.eclipse.pde.internal.core.IFeatureModelDelta;
import org.eclipse.pde.internal.core.IFeatureModelListener;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PDECoreMessages;
import org.eclipse.pde.internal.core.TargetPlatformHelper;
import org.eclipse.pde.internal.core.WorkspaceFeatureModelManager;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.core.target.P2TargetUtils;
import org.eclipse.pde.internal.core.util.VersionUtil;
import org.osgi.framework.Version;

public class FeatureModelManager {
    private FeatureTable fActiveModels;
    private FeatureTable fInactiveModels;
    private ExternalFeatureModelManager fExternalManager;
    private boolean fReloadExternalNeeded = false;
    private final WorkspaceFeatureModelManager fWorkspaceManager = new WorkspaceFeatureModelManager();
    private IModelProviderListener fProviderListener;
    private final List<IFeatureModelListener> fListeners = new ArrayList<IFeatureModelListener>();
    private static final Comparator<IFeatureModel> FEATURE_VERSION = Comparator.comparing(f -> Version.parseVersion((String)f.getFeature().getVersion()));

    public synchronized void shutdown() {
        if (this.fWorkspaceManager != null) {
            this.fWorkspaceManager.removeModelProviderListener(this.fProviderListener);
        }
        if (this.fExternalManager != null) {
            this.fExternalManager.removeModelProviderListener(this.fProviderListener);
        }
    }

    public boolean isInitialized() {
        return this.fActiveModels != null && !this.fReloadExternalNeeded;
    }

    private synchronized void init() {
        IFeatureModel[] models;
        if (this.fActiveModels != null) {
            if (this.fReloadExternalNeeded) {
                this.fReloadExternalNeeded = false;
                this.fExternalManager.initialize();
            }
            return;
        }
        this.fActiveModels = new FeatureTable();
        this.fInactiveModels = new FeatureTable();
        this.fProviderListener = this::handleModelsChanged;
        this.fWorkspaceManager.addModelProviderListener(this.fProviderListener);
        IFeatureModel[] iFeatureModelArray = models = this.fWorkspaceManager.getFeatureModels();
        int n = models.length;
        int n2 = 0;
        while (n2 < n) {
            IFeatureModel model = iFeatureModelArray[n2];
            this.fActiveModels.add(model);
            ++n2;
        }
        this.fExternalManager = new ExternalFeatureModelManager();
        this.fExternalManager.addModelProviderListener(this.fProviderListener);
        this.fReloadExternalNeeded = false;
        ITargetDefinition unresolvedRepoBasedtarget = null;
        try {
            unresolvedRepoBasedtarget = TargetPlatformHelper.getUnresolvedRepositoryBasedWorkspaceTarget();
        }
        catch (CoreException e) {
            PDECore.log(e);
        }
        if (unresolvedRepoBasedtarget != null && !P2TargetUtils.isProfileValid(unresolvedRepoBasedtarget)) {
            WorkspaceJob initializeExternalManager = new WorkspaceJob(PDECoreMessages.FeatureModelManager_initializingFeatureTargetPlatform){

                public IStatus runInWorkspace(IProgressMonitor monitor) {
                    FeatureModelManager.this.fExternalManager.initialize();
                    return Status.OK_STATUS;
                }
            };
            initializeExternalManager.schedule();
        } else {
            this.fExternalManager.initialize();
        }
    }

    public IFeatureModel[] getModels() {
        this.init();
        return this.fActiveModels.getAllValidFeatures();
    }

    public IFeatureModel[] getWorkspaceModels() {
        this.init();
        return this.fWorkspaceManager.getFeatureModels();
    }

    public IFeatureModel[] getExternalModels() {
        this.init();
        return this.fExternalManager.getModels();
    }

    public IFeatureModel getFeatureModel(IProject project) {
        this.init();
        return (IFeatureModel)this.fWorkspaceManager.getModel(project);
    }

    public IFeatureModel findFeatureModel(String id, String version) {
        this.init();
        if (VersionUtil.isEmptyVersion(version)) {
            return this.findFeatureModel(id);
        }
        List<IFeatureModel> models = this.fActiveModels.get(id, version);
        for (IFeatureModel model : models) {
            if (!model.isValid()) continue;
            return model;
        }
        return null;
    }

    public IFeatureModel findFeatureModelRelaxed(String id, String version) {
        IFeatureModel model = this.findFeatureModel(id, version);
        if (model != null) {
            return model;
        }
        try {
            Version pvi = Version.parseVersion((String)version);
            return this.findFeatureModel(id, pvi.getMajor() + "." + pvi.getMinor() + "." + pvi.getMicro() + ".qualifier");
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public List<IFeatureModel> findFeatureModels(String id) {
        this.init();
        return this.fActiveModels.getAllValidFeatures(id);
    }

    public IFeatureModel findFeatureModel(String id) {
        List<IFeatureModel> models = this.findFeatureModels(id);
        return models.stream().max(FEATURE_VERSION).orElse(null);
    }

    private void handleModelsChanged(IModelProviderEvent e) {
        Object[] entries;
        this.init();
        IFeatureModelDelta delta = this.processEvent(e);
        Object[] objectArray = entries = this.fListeners.toArray();
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            Object entry = objectArray[n2];
            ((IFeatureModelListener)entry).modelsChanged(delta);
            ++n2;
        }
    }

    private synchronized IFeatureModelDelta processEvent(IModelProviderEvent e) {
        IModel[] changed;
        FeatureTable.Idver idver;
        String version;
        String id;
        FeatureTable.Idver idver2;
        IFeatureModel model;
        IModel element;
        int n;
        int n2;
        IModel[] iModelArray;
        FeatureModelDelta delta = new FeatureModelDelta();
        HashSet<FeatureTable.Idver> affectedIdVers = null;
        if ((e.getEventTypes() & 2) != 0) {
            IModel[] removed;
            iModelArray = removed = e.getRemovedModels();
            n2 = removed.length;
            n = 0;
            while (n < n2) {
                element = iModelArray[n];
                if (element instanceof IFeatureModel) {
                    model = (IFeatureModel)element;
                    idver2 = this.fActiveModels.remove(model);
                    if (idver2 != null) {
                        if (affectedIdVers == null) {
                            affectedIdVers = new HashSet<FeatureTable.Idver>();
                        }
                        affectedIdVers.add(idver2);
                        delta.add(model, 2);
                    } else {
                        this.fInactiveModels.remove(model);
                    }
                }
                ++n;
            }
        }
        if ((e.getEventTypes() & 1) != 0) {
            IModel[] added = e.getAddedModels();
            iModelArray = added;
            n2 = added.length;
            n = 0;
            while (n < n2) {
                element = iModelArray[n];
                if (element instanceof IFeatureModel) {
                    model = (IFeatureModel)element;
                    if (model.getUnderlyingResource() != null) {
                        idver2 = this.fActiveModels.add(model);
                        delta.add(model, 1);
                        if (affectedIdVers == null) {
                            affectedIdVers = new HashSet();
                        }
                        affectedIdVers.add(idver2);
                    } else if (model.isValid() && this.fInactiveModels.get(id = model.getFeature().getId(), version = model.getFeature().getVersion()).isEmpty()) {
                        List<IFeatureModel> activeModels = this.fActiveModels.get(id, version);
                        for (IFeatureModel activeModel : activeModels) {
                            if (activeModel.getUnderlyingResource() != null) continue;
                        }
                        idver = this.fInactiveModels.add(model);
                        if (affectedIdVers == null) {
                            affectedIdVers = new HashSet();
                        }
                        affectedIdVers.add(idver);
                    }
                }
                ++n;
            }
        }
        if ((e.getEventTypes() & 4) != 0) {
            changed = e.getChangedModels();
            iModelArray = changed;
            n2 = changed.length;
            n = 0;
            while (n < n2) {
                element = iModelArray[n];
                if (element instanceof IFeatureModel) {
                    model = (IFeatureModel)element;
                    id = model.getFeature().getId();
                    version = model.getFeature().getVersion();
                    FeatureTable.Idver oldIdver = this.fActiveModels.get(model);
                    if (!(oldIdver == null || Objects.equals(oldIdver.id(), id) && Objects.equals(oldIdver.version(), version))) {
                        idver = this.fActiveModels.add(model);
                        if (affectedIdVers == null) {
                            affectedIdVers = new HashSet();
                        }
                        affectedIdVers.add(oldIdver);
                        affectedIdVers.add(idver);
                    }
                }
                ++n;
            }
        }
        this.adjustExternalVisibility(delta, affectedIdVers);
        if ((e.getEventTypes() & 4) != 0) {
            changed = e.getChangedModels();
            iModelArray = changed;
            n2 = changed.length;
            n = 0;
            while (n < n2) {
                element = iModelArray[n];
                if (element instanceof IFeatureModel && !delta.contains(model = (IFeatureModel)element, 3)) {
                    delta.add(model, 4);
                }
                ++n;
            }
        }
        return delta;
    }

    private void adjustExternalVisibility(FeatureModelDelta delta, Set<FeatureTable.Idver> affectedIdVers) {
        if (affectedIdVers != null) {
            for (FeatureTable.Idver idver : affectedIdVers) {
                List<IFeatureModel> models;
                List<IFeatureModel> affectedModels = this.fActiveModels.get(idver);
                if (affectedModels.size() > 1) {
                    for (IFeatureModel model : affectedModels) {
                        if (model.getUnderlyingResource() != null) continue;
                        this.fActiveModels.remove(model);
                        this.fInactiveModels.add(model);
                        delta.add(model, 2);
                    }
                }
                if (!affectedModels.isEmpty() || (models = this.fInactiveModels.get(idver)).isEmpty()) continue;
                IFeatureModel firstModel = models.get(0);
                this.fInactiveModels.remove(firstModel);
                this.fActiveModels.add(firstModel);
                delta.add(firstModel, 1);
            }
        }
    }

    public void addFeatureModelListener(IFeatureModelListener listener) {
        if (!this.fListeners.contains(listener)) {
            this.fListeners.add(listener);
        }
    }

    public void removeFeatureModelListener(IFeatureModelListener listener) {
        if (this.fListeners.contains(listener)) {
            this.fListeners.remove(listener);
        }
    }

    public void targetReloaded() {
        this.fReloadExternalNeeded = true;
    }

    public IFeatureModel getDeltaPackFeature() {
        IFeatureModel model = this.findFeatureModel("org.eclipse.equinox.executable");
        if (model == null) {
            model = this.findFeatureModel("org.eclipse.platform.launchers");
        }
        return model;
    }

    public void removeFromWorkspaceFeature(IFeatureModel iFeatureModel) {
        if (this.fWorkspaceManager != null) {
            this.fWorkspaceManager.removeModel(iFeatureModel);
        }
    }
}

