/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.search;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import org.apache.log4j.Logger;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ListDialog;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.ui.editor.IURIEditorOpener;
import org.eclipse.xtext.ui.label.GlobalDescriptionLabelProvider;
import org.eclipse.xtext.ui.search.IXtextEObjectSearch;
import org.eclipse.xtext.ui.search.XtextEObjectSearchDialog;

public class OpenXtextElementHandler
extends AbstractHandler {
    @Inject
    private IURIEditorOpener uriEditorOpener;
    @Inject
    private IXtextEObjectSearch searchEngine;
    @Inject
    private GlobalDescriptionLabelProvider globalDescriptionLabelProvider;
    @Inject(optional=true)
    @Named(value="xtext.enable.styledLables")
    private boolean enableStyledLabels = true;
    private static final Logger LOG = Logger.getLogger(OpenXtextElementHandler.class);

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Shell activeShell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        ListDialog searchDialog = this.createSearchDialog(event, activeShell, this.searchEngine);
        int result = searchDialog.open();
        if (result == 0) {
            try {
                Object selection;
                Object[] selections = searchDialog.getResult();
                if (selections != null && selections.length > 0 && (selection = selections[0]) instanceof IEObjectDescription) {
                    IEObjectDescription selectedObjectDescription = (IEObjectDescription)selection;
                    this.uriEditorOpener.open(selectedObjectDescription.getEObjectURI(), true);
                }
            }
            catch (Exception e) {
                LOG.error((Object)"Error opening editor", (Throwable)e);
                throw new ExecutionException("Error opening editor", (Throwable)e);
            }
        }
        return null;
    }

    protected ListDialog createSearchDialog(ExecutionEvent event, Shell activeShell, IXtextEObjectSearch searchEngine) {
        return new XtextEObjectSearchDialog(activeShell, searchEngine, this.globalDescriptionLabelProvider, this.isEnableStyledLabels());
    }

    public void setEnableStyledLabels(boolean enableStyledLabels) {
        this.enableStyledLabels = enableStyledLabels;
    }

    public boolean isEnableStyledLabels() {
        return this.enableStyledLabels;
    }
}

