/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.types.constraints;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ElementTypeRelationshipKind implements Enumerator
{
    EXACT_TYPE(0, "exactType", "exactType"),
    SPECIALIZATION_TYPE(1, "specializationType", "specializationType"),
    SUBTYPE(2, "subtype", "subtype"),
    SUPERTYPE(3, "supertype", "supertype");

    public static final int EXACT_TYPE_VALUE = 0;
    public static final int SPECIALIZATION_TYPE_VALUE = 1;
    public static final int SUBTYPE_VALUE = 2;
    public static final int SUPERTYPE_VALUE = 3;
    private static final ElementTypeRelationshipKind[] VALUES_ARRAY;
    public static final List<ElementTypeRelationshipKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ElementTypeRelationshipKind[]{EXACT_TYPE, SPECIALIZATION_TYPE, SUBTYPE, SUPERTYPE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ElementTypeRelationshipKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ElementTypeRelationshipKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ElementTypeRelationshipKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ElementTypeRelationshipKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ElementTypeRelationshipKind get(int value) {
        switch (value) {
            case 0: {
                return EXACT_TYPE;
            }
            case 1: {
                return SPECIALIZATION_TYPE;
            }
            case 2: {
                return SUBTYPE;
            }
            case 3: {
                return SUPERTYPE;
            }
        }
        return null;
    }

    private ElementTypeRelationshipKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

