/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.nattable.menu;

import java.util.List;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.commands.MCommand;
import org.eclipse.e4.ui.model.application.ui.basic.impl.PartImpl;
import org.eclipse.e4.ui.model.application.ui.menu.MHandledMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuElement;
import org.eclipse.e4.ui.model.application.ui.menu.impl.MenuFactoryImpl;
import org.eclipse.e4.ui.model.application.ui.menu.impl.MenuImpl;
import org.eclipse.e4.ui.model.application.ui.menu.impl.PopupMenuImpl;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.infra.core.architecture.ArchitectureDescriptionLanguage;
import org.eclipse.papyrus.infra.ui.util.WorkbenchPartHelper;
import org.eclipse.papyrus.toolsmiths.nattable.messages.Messages;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.internal.PartSite;
import org.eclipse.ui.internal.menus.SlaveMenuService;
import org.eclipse.ui.menus.ExtensionContributionFactory;
import org.eclipse.ui.menus.IContributionRoot;
import org.eclipse.ui.menus.IMenuService;
import org.eclipse.ui.services.IServiceLocator;

public class ContributionToNewChildMenu
extends ExtensionContributionFactory {
    private static final String COMMAND_ID = "org.eclipse.papyrus.toolsmiths.nattable.registerTableConfigurationInAF";
    private static final String COMMAND_ICON_URI = "platform:/plugin/org.eclipse.papyrus.toolsmiths.nattable/icons/PapyrusTable.gif";
    private static final String ARCHITECTURE_FILE_EXTENSION = "architecture";

    public void createContributionItems(IServiceLocator serviceLocator, IContributionRoot additions) {
        if (!this.mustContributeToMenu(serviceLocator)) {
            return;
        }
        MApplication application = this.getApplication();
        if (application == null) {
            return;
        }
        MCommand mmCommand = application.getCommand(COMMAND_ID);
        if (mmCommand == null) {
            return;
        }
        MenuImpl menuImp = this.getMenuToContribute(serviceLocator);
        if (menuImp == null) {
            return;
        }
        MHandledMenuItem item = MenuFactoryImpl.eINSTANCE.createHandledMenuItem();
        item.setLabel(Messages.ContributionToNewChildMenu_RegisterExitingTableConfigurationMenuItem);
        item.setCommand(mmCommand);
        item.setIconURI(COMMAND_ICON_URI);
        if (menuImp != null) {
            menuImp.getChildren().add(item);
        }
    }

    private boolean mustContributeToMenu(IServiceLocator serviceLocator) {
        ArchitectureDescriptionLanguage language;
        Object first;
        ISelectionService serv = (ISelectionService)serviceLocator.getService(ISelectionService.class);
        return serv != null && serv.getSelection() instanceof IStructuredSelection && (first = ((IStructuredSelection)serv.getSelection()).getFirstElement()) instanceof ArchitectureDescriptionLanguage && ARCHITECTURE_FILE_EXTENSION.equals((language = (ArchitectureDescriptionLanguage)first).eResource().getURI().fileExtension());
    }

    private MenuImpl getMenuToContribute(IServiceLocator serviceLocator) {
        IMenuService manager = (IMenuService)serviceLocator.getService(IMenuService.class);
        if (manager instanceof SlaveMenuService) {
            PartImpl model = (PartImpl)((SlaveMenuService)manager).getModel();
            List menus = model.getMenus();
            for (MMenu m : menus) {
                if (!(m instanceof PopupMenuImpl)) continue;
                for (MMenuElement current : m.getChildren()) {
                    if (current.getLabel() == null || !(current instanceof MenuImpl) || !current.getLabel().equals("&New Child")) continue;
                    return (MenuImpl)current;
                }
            }
        }
        return null;
    }

    private MApplication getApplication() {
        PartSite ps;
        IWorkbenchPartSite site;
        IWorkbenchPart activePart = WorkbenchPartHelper.getCurrentActiveWorkbenchPart();
        if (activePart != null && (site = activePart.getSite()) instanceof PartSite && (ps = (PartSite)activePart.getSite()) != null) {
            IEclipseContext iec = ps.getContext();
            return (MApplication)iec.get(MApplication.class);
        }
        return null;
    }
}

