/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.project;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.m2m.internal.qvt.oml.QvtPlugin;
import org.eclipse.m2m.internal.qvt.oml.project.QVTOProjectPlugin;
import org.eclipse.m2m.internal.qvt.oml.project.builder.QVTOBuilderConfig;
import org.eclipse.m2m.internal.qvt.oml.project.model.IQvtProject;
import org.eclipse.m2m.internal.qvt.oml.project.model.QvtProject;

public class QvtProjectUtil {
    private QvtProjectUtil() {
    }

    public static IQvtProject getQvtProject(IProject project) {
        if (QvtProjectUtil.isQvtProject(project)) {
            return new QvtProject(project);
        }
        return null;
    }

    public static boolean isQvtProject(IProject project) {
        try {
            return project.isAccessible() && project.hasNature("org.eclipse.m2m.qvt.oml.project.QVTONature");
        }
        catch (CoreException e) {
            QvtPlugin.getDefault().log((Object)e.getStatus());
            return false;
        }
    }

    public static boolean isNamespaceFolder(IFolder folder) {
        if (folder.exists() && QvtProjectUtil.isQvtProject(folder.getProject())) {
            try {
                QVTOBuilderConfig builderConfig = QVTOBuilderConfig.getConfig(folder.getProject());
                return builderConfig.isInSourceContainer((IResource)folder);
            }
            catch (CoreException e) {
                QVTOProjectPlugin.log(e.getStatus());
            }
        }
        return false;
    }

    public static IContainer getDefaultNamespaceContainer(IProject project) {
        if (!QvtProjectUtil.isQvtProject(project)) {
            return null;
        }
        try {
            IContainer container = QVTOBuilderConfig.getConfig(project).getSourceContainer();
            return container.exists() ? container : null;
        }
        catch (CoreException e) {
            QVTOProjectPlugin.log(e.getStatus());
            return null;
        }
    }
}

