/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.common.ui.dialogs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.m2m.internal.qvt.oml.common.ui.dialogs.AbstractClassifierProvider;
import org.eclipse.m2m.internal.qvt.oml.common.ui.dialogs.IClassifierProvider;
import org.eclipse.m2m.internal.qvt.oml.emf.util.EmfUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComplexClassifierProvider
extends AbstractClassifierProvider
implements IClassifierProvider {
    public ComplexClassifierProvider(List<EPackage> rootPackages) {
        super(rootPackages);
    }

    @Override
    protected String normalizeQuery(String query) {
        StringBuffer result = new StringBuffer();
        String[] parts = query.split("::");
        int i = 0;
        while (i < parts.length) {
            result.append(parts[i].trim());
            if (i != parts.length - 1) {
                result.append("::");
            }
            ++i;
        }
        if (query.startsWith("::")) {
            result.insert(0, "::");
        }
        if (query.endsWith("::")) {
            result.append("::");
        }
        return result.toString();
    }

    @Override
    protected boolean isMatching(EClassifier classifier, String query) {
        int index = query.lastIndexOf("::");
        if (index == -1) {
            return this.isMatchingClassifier(classifier, query);
        }
        String packageQuery = query.substring(0, index);
        String classifierQuery = query.substring(index + "::".length());
        return this.isMatchingClassifier(classifier, classifierQuery) && this.isMatchingPackage(classifier.getEPackage(), packageQuery);
    }

    protected boolean isMatchingPackage(EPackage ePackage, String packageQuery) {
        return this.matches(EmfUtil.getFullName((EPackage)ePackage, (String)"::"), packageQuery, false);
    }

    protected boolean isMatchingClassifier(EClassifier classifier, String classifierQuery) {
        return this.matches(classifier.getName(), classifierQuery, true);
    }

    protected boolean matches(String str, String pattern, boolean prefix) {
        String string = str == null ? "" : str;
        ArrayList<String> parts = new ArrayList<String>((Collection)Arrays.asList(pattern.split("\\*")));
        if (pattern.startsWith("*")) {
            parts.add(0, "");
        }
        if (pattern.endsWith("*")) {
            parts.add("");
        }
        int offset = 0;
        boolean firstPart = true;
        Iterator iter = parts.iterator();
        while (iter.hasNext()) {
            String part = (String)iter.next();
            boolean found = false;
            while (!found) {
                int index = 0;
                while (index < part.length()) {
                    if (offset + index >= string.length()) {
                        return false;
                    }
                    char pc = Character.toLowerCase(part.charAt(index));
                    char sc = Character.toLowerCase(string.charAt(offset + index));
                    if (pc != '?' && pc != sc) {
                        if (firstPart) {
                            return false;
                        }
                        ++offset;
                        break;
                    }
                    ++index;
                }
                boolean bl = found = index == part.length();
            }
            offset += part.length();
            if (part.length() == 0 && !iter.hasNext()) {
                offset = string.length();
            }
            firstPart = false;
        }
        return prefix || offset == string.length();
    }
}

