/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.telemetry.tracing.tck.cdi;

import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Scope;
import jakarta.inject.Inject;
import org.eclipse.microprofile.telemetry.tracing.tck.ConfigAsset;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.Test;

public class SpanBeanTest
extends Arquillian {
    @Inject
    private Span injectedSpan;
    @Inject
    private Tracer tracer;

    @Deployment
    public static WebArchive createDeployment() {
        ConfigAsset config = new ConfigAsset().add("otel.sdk.disabled", "false");
        return (WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addAsResource((Asset)EmptyAsset.INSTANCE, "META-INF/beans.xml")).addAsResource((Asset)config, "META-INF/microprofile-config.properties");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void spanBeanChange() {
        Span originalSpan = Span.current();
        Assert.assertEquals((String)originalSpan.getSpanContext().getSpanId(), (String)this.injectedSpan.getSpanContext().getSpanId());
        Span span1 = this.tracer.spanBuilder("span1").startSpan();
        Assert.assertNotEquals((Object)originalSpan.getSpanContext().getSpanId(), (Object)span1.getSpanContext().getSpanId());
        Assert.assertEquals((String)originalSpan.getSpanContext().getSpanId(), (String)this.injectedSpan.getSpanContext().getSpanId());
        try (Scope s = span1.makeCurrent();){
            Assert.assertEquals((String)span1.getSpanContext().getSpanId(), (String)this.injectedSpan.getSpanContext().getSpanId());
            Span span2 = this.tracer.spanBuilder("span2").startSpan();
            Assert.assertEquals((String)span1.getSpanContext().getSpanId(), (String)this.injectedSpan.getSpanContext().getSpanId());
            try (Scope s2 = span2.makeCurrent();){
                Assert.assertEquals((String)span2.getSpanContext().getSpanId(), (String)this.injectedSpan.getSpanContext().getSpanId());
            }
            finally {
                span2.end();
            }
            Assert.assertEquals((String)span1.getSpanContext().getSpanId(), (String)this.injectedSpan.getSpanContext().getSpanId());
        }
        finally {
            span1.end();
        }
        Assert.assertEquals((String)originalSpan.getSpanContext().getSpanId(), (String)this.injectedSpan.getSpanContext().getSpanId());
    }
}

