/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.ludus.backend.datastructures.weights;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.lsat.common.ludus.backend.datastructures.weights.DoubleWeightFunction;

public class DoubleWeightFunctionInt<E>
implements DoubleWeightFunction<Integer, E>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<E, Integer> weight1Map = new HashMap<E, Integer>();
    private final Map<E, Integer> weight2Map = new HashMap<E, Integer>();
    private Integer min1Value = Integer.MAX_VALUE;
    private Integer min2Value;
    private Integer max1Value = Integer.MIN_VALUE;
    private Integer max2Value;
    private Integer maxAbsValue = 0;

    public DoubleWeightFunctionInt() {
        this.min2Value = Integer.MAX_VALUE;
        this.max2Value = Integer.MIN_VALUE;
    }

    public void addWeight(E edge, Integer weight1, Integer weight2) {
        this.weight1Map.put(edge, weight1);
        this.weight2Map.put(edge, weight2);
        this.min1Value = Math.min(this.min1Value, weight1);
        this.max1Value = Math.max(this.max1Value, weight1);
        this.min2Value = Math.min(this.min2Value, weight2);
        this.max2Value = Math.max(this.max2Value, weight2);
        this.maxAbsValue = Math.max(this.maxAbsValue, Math.abs(weight1));
        this.maxAbsValue = Math.max(this.maxAbsValue, Math.abs(weight2));
    }

    @Override
    public Integer getWeight1(E edge) {
        return this.weight1Map.get(edge);
    }

    @Override
    public Integer getWeight2(E edge) {
        return this.weight2Map.get(edge);
    }

    public Integer getMin1Value() {
        return this.min1Value;
    }

    public Integer getMax1Value() {
        return this.max1Value;
    }

    public Integer getMin2Value() {
        return this.min1Value;
    }

    public Integer getMax2Value() {
        return this.max1Value;
    }

    @Override
    public Integer getMaxAbsValue() {
        return this.maxAbsValue;
    }
}

