/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.activity.diagram.design;

import activity.PeripheralAction;
import java.util.Collection;
import machine.IResource;
import machine.Machine;
import machine.Peripheral;
import machine.Resource;
import machine.provider.MachineItemProviderAdapterFactory;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.lsat.activity.diagram.design.AddPeripheralActionPage;
import org.eclipse.lsat.common.emf.ui.model.ModelWorkbenchContentProvider;
import org.eclipse.lsat.common.emf.ui.wizards.ElementTreeSelectionWizardPage;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;

public class AddPeripheralActionWizard
extends Wizard {
    private final ElementTreeSelectionWizardPage peripheralSelectionPage;
    private final AddPeripheralActionPage peripheralActionPage;
    private PeripheralAction peripheralAction;

    public AddPeripheralActionWizard(Collection<EObject> roots, IResource resource, EObject initialSelection, String initialActionName) {
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        adapterFactory.addAdapterFactory((AdapterFactory)new MachineItemProviderAdapterFactory());
        adapterFactory.addAdapterFactory((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
        this.peripheralSelectionPage = this.createPeripheralSelectionPage(roots, initialSelection, (AdapterFactory)adapterFactory);
        this.peripheralActionPage = new AddPeripheralActionPage(resource, initialActionName, (AdapterFactory)adapterFactory);
    }

    private ElementTreeSelectionWizardPage createPeripheralSelectionPage(Collection<EObject> roots, EObject initialSelection, AdapterFactory adapterFactory) {
        ElementTreeSelectionWizardPage peripheralSelectionPage = new ElementTreeSelectionWizardPage("PeripheralSelectionPage", (IBaseLabelProvider)new AdapterFactoryLabelProvider(adapterFactory), (ITreeContentProvider)new ModelWorkbenchContentProvider(new AdapterFactory[0]));
        peripheralSelectionPage.setTitle("Select peripheral");
        peripheralSelectionPage.setMessage("Select peripheral to add action");
        peripheralSelectionPage.setInput(roots);
        peripheralSelectionPage.setAllowMultiple(false);
        final Resource targetResource = initialSelection instanceof IResource ? ((IResource)initialSelection).getResource() : null;
        peripheralSelectionPage.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return element instanceof Machine || targetResource == element || targetResource == null && element instanceof Resource || element instanceof Peripheral;
            }
        });
        peripheralSelectionPage.setValidator(new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                if (selection.length <= 0) {
                    return new Status(4, "org.eclipse.lsat.activity.diagram.design", 0, "Please select a peripheral!", null);
                }
                Object[] objectArray = selection;
                int n = selection.length;
                int n2 = 0;
                while (n2 < n) {
                    Object selected = objectArray[n2];
                    if (!(selected instanceof Peripheral)) {
                        return new Status(4, "org.eclipse.lsat.activity.diagram.design", 0, "Only peripheral selection is allowed!", null);
                    }
                    ++n2;
                }
                return new Status(0, "org.eclipse.lsat.activity.diagram.design", 0, "OK", null);
            }
        });
        peripheralSelectionPage.setInitialSelections(new Object[]{initialSelection});
        return peripheralSelectionPage;
    }

    public void addPages() {
        this.addPage((IWizardPage)this.peripheralSelectionPage);
        this.addPage((IWizardPage)this.peripheralActionPage);
    }

    public IWizardPage getStartingPage() {
        if (this.peripheralSelectionPage.isPageComplete()) {
            return this.getNextPage((IWizardPage)this.peripheralSelectionPage);
        }
        return super.getStartingPage();
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (this.peripheralSelectionPage == page) {
            this.peripheralActionPage.setPeripheral((Peripheral)this.peripheralSelectionPage.getResult()[0]);
        }
        return super.getNextPage(page);
    }

    public boolean performFinish() {
        this.peripheralAction = this.peripheralActionPage.createPeripheralAction();
        return true;
    }

    public PeripheralAction getPeripheralAction() {
        return this.peripheralAction;
    }
}

