/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.descriptor;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Optional;
import java.util.function.Function;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.extension.ExecutableInvoker;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestInstances;
import org.junit.jupiter.engine.config.JupiterConfiguration;
import org.junit.jupiter.engine.descriptor.AbstractExtensionContext;
import org.junit.jupiter.engine.descriptor.ClassBasedTestDescriptor;
import org.junit.platform.engine.EngineExecutionListener;
import org.junit.platform.engine.support.hierarchical.Node;
import org.junit.platform.engine.support.hierarchical.ThrowableCollector;

final class ClassExtensionContext
extends AbstractExtensionContext<ClassBasedTestDescriptor> {
    private final TestInstance.Lifecycle lifecycle;
    private final ThrowableCollector throwableCollector;
    private TestInstances testInstances;

    ClassExtensionContext(ExtensionContext parent, EngineExecutionListener engineExecutionListener, ClassBasedTestDescriptor testDescriptor, JupiterConfiguration configuration, ThrowableCollector throwableCollector, Function<ExtensionContext, ExecutableInvoker> executableInvokerFactory) {
        this(parent, engineExecutionListener, testDescriptor, TestInstance.Lifecycle.PER_METHOD, configuration, throwableCollector, executableInvokerFactory);
    }

    ClassExtensionContext(ExtensionContext parent, EngineExecutionListener engineExecutionListener, ClassBasedTestDescriptor testDescriptor, TestInstance.Lifecycle lifecycle, JupiterConfiguration configuration, ThrowableCollector throwableCollector, Function<ExtensionContext, ExecutableInvoker> executableInvokerFactory) {
        super(parent, engineExecutionListener, testDescriptor, configuration, executableInvokerFactory);
        this.lifecycle = lifecycle;
        this.throwableCollector = throwableCollector;
    }

    public Optional<AnnotatedElement> getElement() {
        return Optional.of(((ClassBasedTestDescriptor)((Object)this.getTestDescriptor())).getTestClass());
    }

    public Optional<Class<?>> getTestClass() {
        return Optional.of(((ClassBasedTestDescriptor)((Object)this.getTestDescriptor())).getTestClass());
    }

    public Optional<TestInstance.Lifecycle> getTestInstanceLifecycle() {
        return Optional.of(this.lifecycle);
    }

    public Optional<Object> getTestInstance() {
        return this.getTestInstances().map(TestInstances::getInnermostInstance);
    }

    public Optional<TestInstances> getTestInstances() {
        return Optional.ofNullable(this.testInstances);
    }

    void setTestInstances(TestInstances testInstances) {
        this.testInstances = testInstances;
    }

    public Optional<Method> getTestMethod() {
        return Optional.empty();
    }

    public Optional<Throwable> getExecutionException() {
        return Optional.ofNullable(this.throwableCollector.getThrowable());
    }

    @Override
    protected Node.ExecutionMode getPlatformExecutionMode() {
        return ((ClassBasedTestDescriptor)((Object)this.getTestDescriptor())).getExecutionMode();
    }
}

