/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.internal.preference;

import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.sirius.common.ui.tools.api.util.SWTUtil;
import org.eclipse.sirius.viewpoint.provider.Messages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Scale;

public class ScaleWithLegendFieldEditor
extends FieldEditor {
    protected Scale scale;
    private int incrementValue;
    private int maxValue;
    private int minValue;
    private int oldValue;
    private int pageIncrementValue;

    protected ScaleWithLegendFieldEditor() {
    }

    public ScaleWithLegendFieldEditor(String name, String labelText, Composite parent) {
        super(name, labelText, parent);
        this.setDefaultValues();
    }

    public ScaleWithLegendFieldEditor(String name, String labelText, Composite parent, int min, int max, int increment, int pageIncrement) {
        super(name, labelText, parent);
        this.setValues(min, max, increment, pageIncrement);
    }

    protected void adjustForNumColumns(int numColumns) {
        ((GridData)this.scale.getLayoutData()).horizontalSpan = numColumns - 1;
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        Composite composite = SWTUtil.createCompositeHorizontalFill((Composite)parent, (int)3, (boolean)false);
        SWTUtil.createLabel((Composite)composite, (String)Messages.ExportAsImage_nominalLevelLabel, (int)16384);
        this.scale = this.getScaleControl(composite);
        GridData gd = new GridData(768);
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.scale.setLayoutData((Object)new GridData(4, 4, true, true));
        SWTUtil.createLabel((Composite)composite, (String)Messages.ExportAsImage_maxLevelLabel, (int)131072);
        this.updateScale();
    }

    protected void doLoad() {
        if (this.scale != null) {
            int value = this.getPreferenceStore().getInt(this.getPreferenceName());
            this.scale.setSelection(value);
            this.oldValue = value;
        }
    }

    protected void doLoadDefault() {
        if (this.scale != null) {
            int value = this.getPreferenceStore().getDefaultInt(this.getPreferenceName());
            this.scale.setSelection(value);
        }
        this.valueChanged();
    }

    protected void doStore() {
        this.getPreferenceStore().setValue(this.getPreferenceName(), this.scale.getSelection());
    }

    public int getIncrement() {
        return this.incrementValue;
    }

    public int getMaximum() {
        return this.maxValue;
    }

    public int getMinimum() {
        return this.minValue;
    }

    public int getNumberOfControls() {
        return 1;
    }

    public int getPageIncrement() {
        return this.pageIncrementValue;
    }

    public Scale getScaleControl() {
        return this.scale;
    }

    protected Scale getScaleControl(Composite parent) {
        if (this.scale == null) {
            this.scale = new Scale(parent, 256);
            this.scale.setFont(parent.getFont());
            this.scale.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    ScaleWithLegendFieldEditor.this.valueChanged();
                }
            });
            this.scale.addDisposeListener(event -> {
                Scale scale = this.scale = null;
            });
        } else {
            this.checkParent((Control)this.scale, parent);
        }
        return this.scale;
    }

    private void setDefaultValues() {
        this.setValues(0, 10, 1, 1);
    }

    public void setFocus() {
        if (this.scale != null && !this.scale.isDisposed()) {
            this.scale.setFocus();
        }
    }

    public void setIncrement(int increment) {
        this.incrementValue = increment;
        this.updateScale();
    }

    public void setMaximum(int max) {
        this.maxValue = max;
        this.updateScale();
    }

    public void setMinimum(int min) {
        this.minValue = min;
        this.updateScale();
    }

    public void setPageIncrement(int pageIncrement) {
        this.pageIncrementValue = pageIncrement;
        this.updateScale();
    }

    private void setValues(int min, int max, int increment, int pageIncrement) {
        this.incrementValue = increment;
        this.maxValue = max;
        this.minValue = min;
        this.pageIncrementValue = pageIncrement;
        this.updateScale();
    }

    private void updateScale() {
        if (this.scale != null && !this.scale.isDisposed()) {
            this.scale.setMinimum(this.getMinimum());
            this.scale.setMaximum(this.getMaximum());
            this.scale.setIncrement(this.getIncrement());
            this.scale.setPageIncrement(this.getPageIncrement());
        }
    }

    protected void valueChanged() {
        this.setPresentsDefaultValue(false);
        int newValue = this.scale.getSelection();
        if (newValue != this.oldValue) {
            this.fireStateChanged("field_editor_is_valid", false, true);
            this.fireValueChanged("field_editor_value", new Integer(this.oldValue), new Integer(newValue));
            this.oldValue = newValue;
        }
    }
}

