/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.core.refactoring;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.ltk.core.refactoring.GroupCategory;

public class GroupCategorySet {
    public static final GroupCategorySet NONE = new GroupCategorySet(){

        @Override
        public boolean contains(GroupCategory category) {
            return false;
        }

        @Override
        public List<GroupCategory> asList() {
            return Collections.emptyList();
        }
    };
    private List<GroupCategory> fContent;

    public static GroupCategorySet union(GroupCategorySet one, GroupCategorySet two) {
        Assert.isNotNull((Object)one);
        Assert.isNotNull((Object)two);
        if (one == two) {
            return one;
        }
        if (one == NONE) {
            return two;
        }
        if (two == NONE) {
            return one;
        }
        HashSet<GroupCategory> combined = new HashSet<GroupCategory>(one.asList());
        combined.addAll(two.asList());
        return new GroupCategorySet(combined);
    }

    private GroupCategorySet() {
        this.fContent = Collections.emptyList();
    }

    private GroupCategorySet(Set<GroupCategory> categories) {
        this.fContent = new ArrayList<GroupCategory>(categories);
    }

    public GroupCategorySet(GroupCategory category) {
        Assert.isNotNull((Object)category);
        this.fContent = new ArrayList<GroupCategory>(1);
        this.fContent.add(category);
    }

    public GroupCategorySet(GroupCategory[] categories) {
        Assert.isNotNull((Object)categories);
        this.fContent = new ArrayList<GroupCategory>(categories.length);
        GroupCategory[] groupCategoryArray = categories;
        int n = categories.length;
        int n2 = 0;
        while (n2 < n) {
            GroupCategory categorie = groupCategoryArray[n2];
            if (!this.fContent.contains(categorie)) {
                this.fContent.add(categorie);
            }
            ++n2;
        }
    }

    public boolean contains(GroupCategory category) {
        return this.fContent.contains(category);
    }

    public boolean containsOneCategory(List<GroupCategory> categories) {
        for (GroupCategory category : categories) {
            if (!this.contains(category)) continue;
            return true;
        }
        return false;
    }

    public List<GroupCategory> asList() {
        return Collections.unmodifiableList(this.fContent);
    }
}

