/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.core.impl;

import org.eclipse.trace4cps.core.IInterval;

public final class Interval
implements IInterval {
    private final Number lb;
    private final Number ub;
    private final boolean openLb;
    private final boolean openUb;

    public Interval(Number lb, Number ub) {
        this(lb, false, ub, true);
    }

    public Interval(Number lb, boolean openLb, Number ub, boolean openUb) {
        this.lb = lb;
        this.openLb = openLb;
        this.ub = ub;
        this.openUb = openUb;
    }

    public static Interval trivial() {
        return new Interval(0.0, false, Double.POSITIVE_INFINITY, true);
    }

    public boolean isTrivial() {
        return this.lb.doubleValue() == 0.0 && !this.openLb && this.ub.doubleValue() == Double.POSITIVE_INFINITY;
    }

    public boolean strictlySmallerThan(Number ts) {
        if (this.ub.doubleValue() < 0.0) {
            return false;
        }
        if (this.openUb) {
            return ts.doubleValue() >= this.ub.doubleValue();
        }
        return ts.doubleValue() > this.ub.doubleValue();
    }

    public boolean strictlyLargerThan(Number ts) {
        if (this.openLb) {
            return ts.doubleValue() <= this.lb.doubleValue();
        }
        return ts.doubleValue() < this.lb.doubleValue();
    }

    @Override
    public boolean contains(Number ts) {
        if (ts.doubleValue() < this.lb.doubleValue() || ts.doubleValue() <= this.lb.doubleValue() && this.openLb) {
            return false;
        }
        if (this.openUb) {
            return ts.doubleValue() < this.ub.doubleValue();
        }
        return ts.doubleValue() <= this.ub.doubleValue();
    }

    @Override
    public Number lb() {
        return this.lb;
    }

    @Override
    public Number ub() {
        return this.ub;
    }

    @Override
    public boolean isOpenLb() {
        return this.openLb;
    }

    @Override
    public boolean isOpenUb() {
        return this.openUb;
    }

    @Override
    public boolean isEmpty() {
        return this.lb.doubleValue() > this.ub.doubleValue() || this.lb.doubleValue() == this.ub.doubleValue() && (this.openLb || this.openUb);
    }

    public String toString() {
        String l = this.openLb ? "(" : "[";
        String r = this.openUb ? ")" : "]";
        return l + String.valueOf(this.lb) + "," + String.valueOf(this.ub) + r;
    }

    public static Interval intersect(Interval i1, Interval i2) {
        boolean openUb;
        Number ub;
        boolean openLb;
        Number lb;
        if (i1.lb.doubleValue() < i2.lb.doubleValue()) {
            lb = i2.lb;
            openLb = i2.openLb;
        } else if (i1.lb.doubleValue() == i2.lb.doubleValue()) {
            lb = i1.lb;
            openLb = i1.openLb || i2.openLb;
        } else {
            lb = i1.lb;
            openLb = i1.openLb;
        }
        if (i1.ub.doubleValue() < i2.ub.doubleValue()) {
            ub = i1.ub;
            openUb = i1.openUb;
        } else if (i1.ub.doubleValue() == i2.ub.doubleValue()) {
            ub = i1.ub;
            openUb = i1.openUb || i2.openUb;
        } else {
            ub = i2.ub;
            openUb = i2.openUb;
        }
        return new Interval(lb, openLb, ub, openUb);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.lb == null ? 0 : this.lb.hashCode());
        result = 31 * result + (this.openLb ? 1231 : 1237);
        result = 31 * result + (this.openUb ? 1231 : 1237);
        result = 31 * result + (this.ub == null ? 0 : this.ub.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Interval other = (Interval)obj;
        if (this.lb == null ? other.lb != null : !this.lb.equals(other.lb)) {
            return false;
        }
        if (this.openLb != other.openLb) {
            return false;
        }
        if (this.openUb != other.openUb) {
            return false;
        }
        return !(this.ub == null ? other.ub != null : !this.ub.equals(other.ub));
    }
}

