/**
 */
package org.eclipse.lsat.common.graph.directed.impl;

import org.eclipse.lsat.common.graph.directed.Aspect;
import org.eclipse.lsat.common.graph.directed.DirectedGraph;
import org.eclipse.lsat.common.graph.directed.DirectedGraphPackage;
import org.eclipse.lsat.common.graph.directed.Edge;
import org.eclipse.lsat.common.graph.directed.Node;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;

import org.eclipse.emf.ecore.util.EObjectWithInverseResolvingEList;
import org.eclipse.emf.ecore.util.EcoreEMap;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Node</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.lsat.common.graph.directed.impl.NodeImpl#getName <em>Name</em>}</li>
 *   <li>{@link org.eclipse.lsat.common.graph.directed.impl.NodeImpl#getOutgoingEdges <em>Outgoing Edges</em>}</li>
 *   <li>{@link org.eclipse.lsat.common.graph.directed.impl.NodeImpl#getIncomingEdges <em>Incoming Edges</em>}</li>
 *   <li>{@link org.eclipse.lsat.common.graph.directed.impl.NodeImpl#getGraph <em>Graph</em>}</li>
 *   <li>{@link org.eclipse.lsat.common.graph.directed.impl.NodeImpl#getAspects <em>Aspects</em>}</li>
 *   <li>{@link org.eclipse.lsat.common.graph.directed.impl.NodeImpl#getProperties <em>Properties</em>}</li>
 * </ul>
 *
 * @generated
 */
public class NodeImpl extends MinimalEObjectImpl.Container implements Node {
	/**
     * The default value of the '{@link #getName() <em>Name</em>}' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #getName()
     * @generated
     * @ordered
     */
	protected static final String NAME_EDEFAULT = null;

	/**
     * The cached value of the '{@link #getName() <em>Name</em>}' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #getName()
     * @generated
     * @ordered
     */
	protected String name = NAME_EDEFAULT;

	/**
     * The cached value of the '{@link #getOutgoingEdges() <em>Outgoing Edges</em>}' reference list.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #getOutgoingEdges()
     * @generated
     * @ordered
     */
	protected EList<Edge> outgoingEdges;

	/**
     * The cached value of the '{@link #getIncomingEdges() <em>Incoming Edges</em>}' reference list.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #getIncomingEdges()
     * @generated
     * @ordered
     */
	protected EList<Edge> incomingEdges;

	/**
     * The cached value of the '{@link #getAspects() <em>Aspects</em>}' reference list.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #getAspects()
     * @generated
     * @ordered
     */
	protected EList<Aspect<?, ?>> aspects;

	/**
     * The cached value of the '{@link #getProperties() <em>Properties</em>}' map.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getProperties()
     * @generated
     * @ordered
     */
    protected EMap<String, String> properties;

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected NodeImpl() {
        super();
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	protected EClass eStaticClass() {
        return DirectedGraphPackage.Literals.NODE;
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public String getName() {
        return name;
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public void setName(String newName) {
        String oldName = name;
        name = newName;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, DirectedGraphPackage.NODE__NAME, oldName, name));
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public EList<Edge> getOutgoingEdges() {
        if (outgoingEdges == null)
        {
            outgoingEdges = new EObjectWithInverseResolvingEList<Edge>(Edge.class, this, DirectedGraphPackage.NODE__OUTGOING_EDGES, DirectedGraphPackage.EDGE__SOURCE_NODE);
        }
        return outgoingEdges;
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public EList<Edge> getIncomingEdges() {
        if (incomingEdges == null)
        {
            incomingEdges = new EObjectWithInverseResolvingEList<Edge>(Edge.class, this, DirectedGraphPackage.NODE__INCOMING_EDGES, DirectedGraphPackage.EDGE__TARGET_NODE);
        }
        return incomingEdges;
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public DirectedGraph<?, ?> getGraph() {
        if (eContainerFeatureID() != DirectedGraphPackage.NODE__GRAPH) return null;
        return (DirectedGraph<?, ?>)eInternalContainer();
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public NotificationChain basicSetGraph(DirectedGraph<?, ?> newGraph, NotificationChain msgs) {
        msgs = eBasicSetContainer((InternalEObject)newGraph, DirectedGraphPackage.NODE__GRAPH, msgs);
        return msgs;
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public void setGraph(DirectedGraph<?, ?> newGraph) {
        if (newGraph != eInternalContainer() || (eContainerFeatureID() != DirectedGraphPackage.NODE__GRAPH && newGraph != null))
        {
            if (EcoreUtil.isAncestor(this, newGraph))
                throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
            NotificationChain msgs = null;
            if (eInternalContainer() != null)
                msgs = eBasicRemoveFromContainer(msgs);
            if (newGraph != null)
                msgs = ((InternalEObject)newGraph).eInverseAdd(this, DirectedGraphPackage.DIRECTED_GRAPH__NODES, DirectedGraph.class, msgs);
            msgs = basicSetGraph(newGraph, msgs);
            if (msgs != null) msgs.dispatch();
        }
        else if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, DirectedGraphPackage.NODE__GRAPH, newGraph, newGraph));
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public EList<Aspect<?, ?>> getAspects() {
        if (aspects == null)
        {
            aspects = new EObjectWithInverseResolvingEList.ManyInverse<Aspect<?, ?>>(Aspect.class, this, DirectedGraphPackage.NODE__ASPECTS, DirectedGraphPackage.ASPECT__NODES);
        }
        return aspects;
    }

	/**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public EMap<String, String> getProperties()
    {
        if (properties == null)
        {
            properties = new EcoreEMap<String,String>(DirectedGraphPackage.Literals.PROPERTY_MAP_ENTRY, PropertyMapEntryImpl.class, this, DirectedGraphPackage.NODE__PROPERTIES);
        }
        return properties;
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@SuppressWarnings("unchecked")
	@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID)
        {
            case DirectedGraphPackage.NODE__OUTGOING_EDGES:
                return ((InternalEList<InternalEObject>)(InternalEList<?>)getOutgoingEdges()).basicAdd(otherEnd, msgs);
            case DirectedGraphPackage.NODE__INCOMING_EDGES:
                return ((InternalEList<InternalEObject>)(InternalEList<?>)getIncomingEdges()).basicAdd(otherEnd, msgs);
            case DirectedGraphPackage.NODE__GRAPH:
                if (eInternalContainer() != null)
                    msgs = eBasicRemoveFromContainer(msgs);
                return basicSetGraph((DirectedGraph<?, ?>)otherEnd, msgs);
            case DirectedGraphPackage.NODE__ASPECTS:
                return ((InternalEList<InternalEObject>)(InternalEList<?>)getAspects()).basicAdd(otherEnd, msgs);
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID)
        {
            case DirectedGraphPackage.NODE__OUTGOING_EDGES:
                return ((InternalEList<?>)getOutgoingEdges()).basicRemove(otherEnd, msgs);
            case DirectedGraphPackage.NODE__INCOMING_EDGES:
                return ((InternalEList<?>)getIncomingEdges()).basicRemove(otherEnd, msgs);
            case DirectedGraphPackage.NODE__GRAPH:
                return basicSetGraph(null, msgs);
            case DirectedGraphPackage.NODE__ASPECTS:
                return ((InternalEList<?>)getAspects()).basicRemove(otherEnd, msgs);
            case DirectedGraphPackage.NODE__PROPERTIES:
                return ((InternalEList<?>)getProperties()).basicRemove(otherEnd, msgs);
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
        switch (eContainerFeatureID())
        {
            case DirectedGraphPackage.NODE__GRAPH:
                return eInternalContainer().eInverseRemove(this, DirectedGraphPackage.DIRECTED_GRAPH__NODES, DirectedGraph.class, msgs);
        }
        return super.eBasicRemoveFromContainerFeature(msgs);
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID)
        {
            case DirectedGraphPackage.NODE__NAME:
                return getName();
            case DirectedGraphPackage.NODE__OUTGOING_EDGES:
                return getOutgoingEdges();
            case DirectedGraphPackage.NODE__INCOMING_EDGES:
                return getIncomingEdges();
            case DirectedGraphPackage.NODE__GRAPH:
                return getGraph();
            case DirectedGraphPackage.NODE__ASPECTS:
                return getAspects();
            case DirectedGraphPackage.NODE__PROPERTIES:
                if (coreType) return getProperties();
                else return getProperties().map();
        }
        return super.eGet(featureID, resolve, coreType);
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
        switch (featureID)
        {
            case DirectedGraphPackage.NODE__NAME:
                setName((String)newValue);
                return;
            case DirectedGraphPackage.NODE__OUTGOING_EDGES:
                getOutgoingEdges().clear();
                getOutgoingEdges().addAll((Collection<? extends Edge>)newValue);
                return;
            case DirectedGraphPackage.NODE__INCOMING_EDGES:
                getIncomingEdges().clear();
                getIncomingEdges().addAll((Collection<? extends Edge>)newValue);
                return;
            case DirectedGraphPackage.NODE__GRAPH:
                setGraph((DirectedGraph<?, ?>)newValue);
                return;
            case DirectedGraphPackage.NODE__ASPECTS:
                getAspects().clear();
                getAspects().addAll((Collection<? extends Aspect<?, ?>>)newValue);
                return;
            case DirectedGraphPackage.NODE__PROPERTIES:
                ((EStructuralFeature.Setting)getProperties()).set(newValue);
                return;
        }
        super.eSet(featureID, newValue);
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public void eUnset(int featureID) {
        switch (featureID)
        {
            case DirectedGraphPackage.NODE__NAME:
                setName(NAME_EDEFAULT);
                return;
            case DirectedGraphPackage.NODE__OUTGOING_EDGES:
                getOutgoingEdges().clear();
                return;
            case DirectedGraphPackage.NODE__INCOMING_EDGES:
                getIncomingEdges().clear();
                return;
            case DirectedGraphPackage.NODE__GRAPH:
                setGraph((DirectedGraph<?, ?>)null);
                return;
            case DirectedGraphPackage.NODE__ASPECTS:
                getAspects().clear();
                return;
            case DirectedGraphPackage.NODE__PROPERTIES:
                getProperties().clear();
                return;
        }
        super.eUnset(featureID);
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public boolean eIsSet(int featureID) {
        switch (featureID)
        {
            case DirectedGraphPackage.NODE__NAME:
                return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT.equals(name);
            case DirectedGraphPackage.NODE__OUTGOING_EDGES:
                return outgoingEdges != null && !outgoingEdges.isEmpty();
            case DirectedGraphPackage.NODE__INCOMING_EDGES:
                return incomingEdges != null && !incomingEdges.isEmpty();
            case DirectedGraphPackage.NODE__GRAPH:
                return getGraph() != null;
            case DirectedGraphPackage.NODE__ASPECTS:
                return aspects != null && !aspects.isEmpty();
            case DirectedGraphPackage.NODE__PROPERTIES:
                return properties != null && !properties.isEmpty();
        }
        return super.eIsSet(featureID);
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public String toString() {
        if (eIsProxy()) return super.toString();

        StringBuilder result = new StringBuilder(super.toString());
        result.append(" (name: ");
        result.append(name);
        result.append(')');
        return result.toString();
    }

} //NodeImpl
