/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.simulator.options;

import java.util.Arrays;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.escet.cif.simulator.output.svgviz.RuntimeCifSvgDecls;
import org.eclipse.escet.cif.simulator.runtime.model.RuntimeEventKind;
import org.eclipse.escet.cif.simulator.runtime.model.RuntimeSpec;
import org.eclipse.escet.cif.simulator.runtime.model.RuntimeState;
import org.eclipse.escet.common.app.framework.options.Options;
import org.eclipse.escet.common.app.framework.options.StringOption;
import org.eclipse.escet.common.app.framework.output.OutputProvider;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.java.exceptions.InvalidOptionException;

public class NonUrgentEventsOption
extends StringOption {
    private static final Pattern FILTER_PATTERN = Pattern.compile("[a-zA-Z_*][a-zA-Z0-9_*]*(\\.[a-zA-Z_*][a-zA-Z0-9_*]*)*");

    public NonUrgentEventsOption() {
        super("Non-urgent events", "Option to specify the non-urgent events. Specify comma separated absolute names of events, or \"tau\". The \"*\" character can be used as wildcard in event names, and indicates zero or more characters. Use \"svg\" to specify that all SVG interactive events should also be non-urgent events. [DEFAULT=\"\"]", null, "non-urgent-events", "EVTS", "", false, true, "Option to specify the non-urgent events. Specify comma separated absolute names of events, or \"tau\". The \"*\" character can be used as wildcard in event names, and indicates zero or more characters. Use \"svg\" to specify that all SVG interactive events should also be non-urgent events.", "Event names:");
    }

    private static String[] getFilters() {
        String value = (String)Options.get(NonUrgentEventsOption.class);
        String[] filters = StringUtils.split((String)value, (String)",");
        int i = 0;
        while (i < filters.length) {
            filters[i] = filters[i].trim();
            if (!FILTER_PATTERN.matcher(filters[i]).matches()) {
                String msg = Strings.fmt((String)"Non-urgent event filter \"%s\" has invalid syntax.", (Object[])new Object[]{filters[i]});
                throw new InvalidOptionException(msg);
            }
            ++i;
        }
        return filters;
    }

    public static <S extends RuntimeState> boolean[] getUrgentEvents(RuntimeSpec<?> spec) {
        String[] filters = NonUrgentEventsOption.getFilters();
        boolean[] rslt = new boolean[spec.events.size()];
        Arrays.fill(rslt, true);
        if (filters.length == 0) {
            return rslt;
        }
        String[] names = new String[spec.events.size()];
        int i = 0;
        while (i < names.length) {
            names[i] = spec.events.get((int)i).name.replace("$", "");
            ++i;
        }
        String[] stringArray = filters;
        int n = filters.length;
        int n2 = 0;
        while (n2 < n) {
            String filter = stringArray[n2];
            boolean match = false;
            boolean effect = false;
            if (filter.equals("svg")) {
                boolean[] interactive = NonUrgentEventsOption.getSvgInteractiveEvents(spec);
                int i2 = 0;
                while (i2 < spec.events.size()) {
                    if (interactive[i2]) {
                        if (rslt[i2]) {
                            effect = true;
                        }
                        rslt[i2] = false;
                        match = true;
                    }
                    ++i2;
                }
            } else {
                String regEx = filter.replace(".", "\\.");
                regEx = regEx.replace("*", ".*");
                Pattern pattern = Pattern.compile(regEx);
                int i3 = 0;
                while (i3 < names.length) {
                    if (spec.events.get((int)i3).kind != RuntimeEventKind.ENVIRONMENT && pattern.matcher(names[i3]).matches()) {
                        if (rslt[i3]) {
                            effect = true;
                        }
                        rslt[i3] = false;
                        match = true;
                    }
                    ++i3;
                }
            }
            if (!match) {
                msg = Strings.fmt((String)"Non-urgent event filter \"%s\" does not match any of the events in the specification.", (Object[])new Object[]{filter});
                if (filter.equals("svg")) {
                    msg = (String)msg + " The specification does not contain any SVG interactive events.";
                }
                OutputProvider.warn((String)msg);
            } else if (!effect) {
                msg = Strings.fmt((String)"Non-urgent event filter \"%s\" does not have any effect. The matched events were already made non-urgent events by an earlier filter.", (Object[])new Object[]{filter});
                OutputProvider.warn((String)msg);
            }
            ++n2;
        }
        return rslt;
    }

    private static boolean[] getSvgInteractiveEvents(RuntimeSpec<?> spec) {
        boolean[] interactive = new boolean[spec.events.size()];
        for (RuntimeCifSvgDecls decls : spec.getCifSvgDecls()) {
            boolean[] declsInteractive = decls.getInteractiveEvents();
            int i = 0;
            while (i < interactive.length) {
                int n = i;
                interactive[n] = interactive[n] | declsInteractive[i];
                ++i;
            }
        }
        return interactive;
    }
}

