/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.common;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.escet.cif.common.CifScopeUtils;
import org.eclipse.escet.cif.common.RangeCompat;
import org.eclipse.escet.cif.metamodel.cif.Component;
import org.eclipse.escet.cif.metamodel.cif.ComponentDef;
import org.eclipse.escet.cif.metamodel.cif.ComponentInst;
import org.eclipse.escet.cif.metamodel.cif.declarations.AlgVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.Constant;
import org.eclipse.escet.cif.metamodel.cif.declarations.ContVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.Declaration;
import org.eclipse.escet.cif.metamodel.cif.declarations.DiscVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.EnumDecl;
import org.eclipse.escet.cif.metamodel.cif.declarations.EnumLiteral;
import org.eclipse.escet.cif.metamodel.cif.declarations.InputVariable;
import org.eclipse.escet.cif.metamodel.cif.expressions.AlgVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.CompInstWrapExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.CompParamExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.CompParamWrapExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ComponentExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ConstantExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ContVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.DiscVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.EnumLiteralExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.EventExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.expressions.FunctionExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.InputVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.LocationExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.SelfExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.StdLibFunction;
import org.eclipse.escet.cif.metamodel.cif.functions.Function;
import org.eclipse.escet.cif.metamodel.cif.functions.FunctionParameter;
import org.eclipse.escet.cif.metamodel.cif.types.BoolType;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.cif.types.CompInstWrapType;
import org.eclipse.escet.cif.metamodel.cif.types.CompParamWrapType;
import org.eclipse.escet.cif.metamodel.cif.types.ComponentDefType;
import org.eclipse.escet.cif.metamodel.cif.types.ComponentType;
import org.eclipse.escet.cif.metamodel.cif.types.DictType;
import org.eclipse.escet.cif.metamodel.cif.types.DistType;
import org.eclipse.escet.cif.metamodel.cif.types.EnumType;
import org.eclipse.escet.cif.metamodel.cif.types.Field;
import org.eclipse.escet.cif.metamodel.cif.types.FuncType;
import org.eclipse.escet.cif.metamodel.cif.types.IntType;
import org.eclipse.escet.cif.metamodel.cif.types.ListType;
import org.eclipse.escet.cif.metamodel.cif.types.RealType;
import org.eclipse.escet.cif.metamodel.cif.types.SetType;
import org.eclipse.escet.cif.metamodel.cif.types.StringType;
import org.eclipse.escet.cif.metamodel.cif.types.TupleType;
import org.eclipse.escet.cif.metamodel.cif.types.TypeRef;
import org.eclipse.escet.cif.metamodel.cif.types.VoidType;
import org.eclipse.escet.cif.metamodel.java.CifConstructors;
import org.eclipse.escet.common.emf.EMFHelper;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.position.common.PositionUtils;
import org.eclipse.escet.common.position.metamodel.position.Position;

public class CifTypeUtils {
    private CifTypeUtils() {
    }

    public static boolean checkTypeCompat(CifType type1, CifType type2, RangeCompat rangeCompat) {
        return CifTypeUtils.checkTypeCompat(type1, type2, rangeCompat, rangeCompat);
    }

    public static boolean checkTypeCompat(CifType type1, CifType type2, RangeCompat rangeCompatInt, RangeCompat rangeCompatList) {
        if (type1 instanceof BoolType && type2 instanceof BoolType) {
            return true;
        }
        if (type1 instanceof IntType && type2 instanceof IntType) {
            IntType itype1 = (IntType)type1;
            IntType itype2 = (IntType)type2;
            int lower1 = CifTypeUtils.getLowerBound(itype1);
            int lower2 = CifTypeUtils.getLowerBound(itype2);
            int upper1 = CifTypeUtils.getUpperBound(itype1);
            int upper2 = CifTypeUtils.getUpperBound(itype2);
            switch (rangeCompatInt) {
                case IGNORE: {
                    return true;
                }
                case CONTAINED: {
                    return lower1 <= lower2 && upper1 >= upper2;
                }
                case EQUAL: {
                    return lower1 == lower2 && upper1 == upper2;
                }
                case OVERLAP: {
                    return upper1 >= lower2 && lower1 <= upper2;
                }
            }
            String msg = "Unknown rangeCompatInt: " + String.valueOf((Object)rangeCompatInt);
            throw new RuntimeException(msg);
        }
        if (type1 instanceof TypeRef) {
            return CifTypeUtils.checkTypeCompat(((TypeRef)type1).getType().getType(), type2, rangeCompatInt, rangeCompatList);
        }
        if (type2 instanceof TypeRef) {
            return CifTypeUtils.checkTypeCompat(type1, ((TypeRef)type2).getType().getType(), rangeCompatInt, rangeCompatList);
        }
        if (type1 instanceof EnumType && type2 instanceof EnumType) {
            EnumDecl enum1 = ((EnumType)type1).getEnum();
            EnumDecl enum2 = ((EnumType)type2).getEnum();
            return CifTypeUtils.areEnumsCompatible(enum1, enum2);
        }
        if (type1 instanceof RealType && type2 instanceof RealType) {
            return true;
        }
        if (type1 instanceof StringType && type2 instanceof StringType) {
            return true;
        }
        if (type1 instanceof ListType && type2 instanceof ListType) {
            ListType ltype1 = (ListType)type1;
            ListType ltype2 = (ListType)type2;
            int lower1 = CifTypeUtils.getLowerBound(ltype1);
            int lower2 = CifTypeUtils.getLowerBound(ltype2);
            int upper1 = CifTypeUtils.getUpperBound(ltype1);
            int upper2 = CifTypeUtils.getUpperBound(ltype2);
            switch (rangeCompatList) {
                case IGNORE: {
                    break;
                }
                case CONTAINED: {
                    if (lower1 <= lower2 && upper1 >= upper2) break;
                    return false;
                }
                case EQUAL: {
                    if (lower1 == lower2 && upper1 == upper2) break;
                    return false;
                }
                case OVERLAP: {
                    if (upper1 >= lower2 && lower1 <= upper2) break;
                    return false;
                }
                default: {
                    String msg = "Unknown rangeCompatList: " + String.valueOf((Object)rangeCompatList);
                    throw new RuntimeException(msg);
                }
            }
            return CifTypeUtils.checkTypeCompat(ltype1.getElementType(), ltype2.getElementType(), rangeCompatInt, rangeCompatList);
        }
        if (type1 instanceof SetType && type2 instanceof SetType) {
            SetType stype1 = (SetType)type1;
            SetType stype2 = (SetType)type2;
            return CifTypeUtils.checkTypeCompat(stype1.getElementType(), stype2.getElementType(), rangeCompatInt, rangeCompatList);
        }
        if (type1 instanceof FuncType && type2 instanceof FuncType) {
            int cnt2;
            CifType rtype2;
            CifType rtype1;
            FuncType ftype1 = (FuncType)type1;
            FuncType ftype2 = (FuncType)type2;
            RangeCompat returnCompatInt = rangeCompatInt;
            RangeCompat returnCompatList = rangeCompatList;
            if (returnCompatInt == RangeCompat.OVERLAP) {
                returnCompatInt = RangeCompat.CONTAINED;
            }
            if (returnCompatList == RangeCompat.OVERLAP) {
                returnCompatList = RangeCompat.CONTAINED;
            }
            if (!CifTypeUtils.checkTypeCompat(rtype1 = ftype1.getReturnType(), rtype2 = ftype2.getReturnType(), returnCompatInt, returnCompatList)) {
                return false;
            }
            int cnt1 = ftype1.getParamTypes().size();
            if (cnt1 != (cnt2 = ftype2.getParamTypes().size())) {
                return false;
            }
            int i = 0;
            while (i < ftype1.getParamTypes().size()) {
                CifType ptype2;
                CifType ptype1 = (CifType)ftype1.getParamTypes().get(i);
                if (!CifTypeUtils.checkTypeCompat(ptype1, ptype2 = (CifType)ftype2.getParamTypes().get(i), rangeCompatInt, rangeCompatList)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        if (type1 instanceof DictType && type2 instanceof DictType) {
            DictType dtype1 = (DictType)type1;
            DictType dtype2 = (DictType)type2;
            return CifTypeUtils.checkTypeCompat(dtype1.getKeyType(), dtype2.getKeyType(), rangeCompatInt, rangeCompatList) && CifTypeUtils.checkTypeCompat(dtype1.getValueType(), dtype2.getValueType(), rangeCompatInt, rangeCompatList);
        }
        if (type1 instanceof TupleType && type2 instanceof TupleType) {
            int cnt2;
            TupleType ttype1 = (TupleType)type1;
            TupleType ttype2 = (TupleType)type2;
            int cnt1 = ttype1.getFields().size();
            if (cnt1 != (cnt2 = ttype2.getFields().size())) {
                return false;
            }
            int i = 0;
            while (i < ttype1.getFields().size()) {
                CifType ftype2;
                CifType ftype1 = ((Field)ttype1.getFields().get(i)).getType();
                if (!CifTypeUtils.checkTypeCompat(ftype1, ftype2 = ((Field)ttype2.getFields().get(i)).getType(), rangeCompatInt, rangeCompatList)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        if (type1 instanceof DistType && type2 instanceof DistType) {
            DistType dtype1 = (DistType)type1;
            DistType dtype2 = (DistType)type2;
            return CifTypeUtils.checkTypeCompat(dtype1.getSampleType(), dtype2.getSampleType(), rangeCompatInt, rangeCompatList);
        }
        if (type1 instanceof CompParamWrapType) {
            return CifTypeUtils.checkTypeCompat(((CompParamWrapType)type1).getReference(), type2, rangeCompatInt, rangeCompatList);
        }
        if (type2 instanceof CompParamWrapType) {
            return CifTypeUtils.checkTypeCompat(type1, ((CompParamWrapType)type2).getReference(), rangeCompatInt, rangeCompatList);
        }
        if (type1 instanceof CompInstWrapType) {
            return CifTypeUtils.checkTypeCompat(((CompInstWrapType)type1).getReference(), type2, rangeCompatInt, rangeCompatList);
        }
        if (type2 instanceof CompInstWrapType) {
            return CifTypeUtils.checkTypeCompat(type1, ((CompInstWrapType)type2).getReference(), rangeCompatInt, rangeCompatList);
        }
        if (type1 instanceof ComponentDefType && type2 instanceof ComponentType) {
            ComponentDef cdef1 = ((ComponentDefType)type1).getDefinition();
            Component comp2 = ((ComponentType)type2).getComponent();
            if (!(comp2 instanceof ComponentInst)) {
                return false;
            }
            ComponentInst inst = (ComponentInst)comp2;
            ComponentDef cdef2 = CifTypeUtils.getCompDefFromCompInst(inst);
            return cdef1 == cdef2;
        }
        if (type1 instanceof ComponentDefType && type2 instanceof ComponentDefType) {
            ComponentDef cdef2;
            ComponentDef cdef1 = ((ComponentDefType)type1).getDefinition();
            return cdef1 == (cdef2 = ((ComponentDefType)type2).getDefinition());
        }
        return type1 instanceof VoidType && type2 instanceof VoidType;
    }

    public static boolean areEnumsCompatible(EnumDecl enum1, EnumDecl enum2) {
        if (enum1.getLiterals().size() != enum2.getLiterals().size()) {
            return false;
        }
        List<String> lits1 = CifTypeUtils.getLiteralNames(enum1);
        List<String> lits2 = CifTypeUtils.getLiteralNames(enum2);
        return lits1.equals(lits2);
    }

    public static List<String> getLiteralNames(EnumDecl enumDecl) {
        List lits = Lists.listc((int)enumDecl.getLiterals().size());
        for (EnumLiteral lit : enumDecl.getLiterals()) {
            lits.add(lit.getName());
        }
        return lits;
    }

    public static int hashType(CifType type) {
        return CifTypeUtils.hashType(type, true, true);
    }

    public static int hashType(CifType type, boolean ignoreRanges) {
        return CifTypeUtils.hashType(type, ignoreRanges, ignoreRanges);
    }

    public static int hashType(CifType type, boolean ignoreRangesInt, boolean ignoreRangesList) {
        if (type instanceof BoolType) {
            return 1;
        }
        if (type instanceof RealType) {
            return 64;
        }
        if (type instanceof StringType) {
            return 512;
        }
        if (type instanceof VoidType) {
            return 4096;
        }
        if (type instanceof IntType) {
            int rslt = 8;
            if (!ignoreRangesInt) {
                IntType itype = (IntType)type;
                rslt ^= CifTypeUtils.getLowerBound(itype) + 13;
                rslt ^= CifTypeUtils.getUpperBound(itype) + 27;
            }
            return rslt;
        }
        if (type instanceof ListType) {
            ListType ltype = (ListType)type;
            int rslt = 32768 + CifTypeUtils.hashType(ltype.getElementType(), ignoreRangesInt, ignoreRangesList);
            if (!ignoreRangesList) {
                rslt ^= CifTypeUtils.getLowerBound(ltype) + 13;
                rslt ^= CifTypeUtils.getUpperBound(ltype) + 27;
            }
            return rslt;
        }
        if (type instanceof SetType) {
            return 262144 + CifTypeUtils.hashType(((SetType)type).getElementType(), ignoreRangesInt, ignoreRangesList);
        }
        if (type instanceof DictType) {
            return 0x200000 + CifTypeUtils.hashType(((DictType)type).getKeyType(), ignoreRangesInt, ignoreRangesList) + CifTypeUtils.hashType(((DictType)type).getValueType(), ignoreRangesInt, ignoreRangesList);
        }
        if (type instanceof TupleType) {
            int rslt = 0x1000000;
            for (Field field : ((TupleType)type).getFields()) {
                rslt += CifTypeUtils.hashType(field.getType(), ignoreRangesInt, ignoreRangesList);
            }
            return rslt;
        }
        if (type instanceof DistType) {
            return 0x8000000 + CifTypeUtils.hashType(((DistType)type).getSampleType(), ignoreRangesInt, ignoreRangesList);
        }
        if (type instanceof FuncType) {
            FuncType ftype = (FuncType)type;
            int rslt = 1 << 30 + CifTypeUtils.hashType(ftype.getReturnType(), ignoreRangesInt, ignoreRangesList);
            for (CifType ptype : ftype.getParamTypes()) {
                rslt += CifTypeUtils.hashType(ptype, ignoreRangesInt, ignoreRangesList);
            }
            return rslt;
        }
        if (type instanceof TypeRef) {
            return CifTypeUtils.hashType(((TypeRef)type).getType().getType(), ignoreRangesInt, ignoreRangesList);
        }
        if (type instanceof EnumType) {
            return CifTypeUtils.getLiteralNames(((EnumType)type).getEnum()).hashCode();
        }
        if (type instanceof CompParamWrapType) {
            return CifTypeUtils.hashType(((CompParamWrapType)type).getReference(), ignoreRangesInt, ignoreRangesList);
        }
        if (type instanceof CompInstWrapType) {
            return CifTypeUtils.hashType(((CompInstWrapType)type).getReference(), ignoreRangesInt, ignoreRangesList);
        }
        throw new RuntimeException("Unexpected type: " + String.valueOf(type));
    }

    public static boolean supportsValueEquality(CifType type) {
        if (type instanceof BoolType) {
            return true;
        }
        if (type instanceof IntType) {
            return true;
        }
        if (type instanceof TypeRef) {
            return CifTypeUtils.supportsValueEquality(((TypeRef)type).getType().getType());
        }
        if (type instanceof EnumType) {
            return true;
        }
        if (type instanceof RealType) {
            return true;
        }
        if (type instanceof StringType) {
            return true;
        }
        if (type instanceof ListType) {
            return CifTypeUtils.supportsValueEquality(((ListType)type).getElementType());
        }
        if (type instanceof SetType) {
            return CifTypeUtils.supportsValueEquality(((SetType)type).getElementType());
        }
        if (type instanceof FuncType) {
            return false;
        }
        if (type instanceof DictType) {
            DictType dtype = (DictType)type;
            return CifTypeUtils.supportsValueEquality(dtype.getKeyType()) && CifTypeUtils.supportsValueEquality(dtype.getValueType());
        }
        if (type instanceof TupleType) {
            TupleType ttype = (TupleType)type;
            for (Field field : ttype.getFields()) {
                if (CifTypeUtils.supportsValueEquality(field.getType())) continue;
                return false;
            }
            return true;
        }
        if (type instanceof DistType) {
            return false;
        }
        if (type instanceof ComponentDefType) {
            return false;
        }
        if (type instanceof ComponentType) {
            return false;
        }
        if (type instanceof CompInstWrapType) {
            CompInstWrapType wrapper = (CompInstWrapType)type;
            return CifTypeUtils.supportsValueEquality(wrapper.getReference());
        }
        if (type instanceof CompParamWrapType) {
            CompParamWrapType wrapper = (CompParamWrapType)type;
            return CifTypeUtils.supportsValueEquality(wrapper.getReference());
        }
        if (type instanceof VoidType) {
            return false;
        }
        throw new RuntimeException("Unknown type: " + String.valueOf(type));
    }

    public static boolean hasComponentLikeType(CifType type) {
        if (type instanceof BoolType) {
            return false;
        }
        if (type instanceof IntType) {
            return false;
        }
        if (type instanceof TypeRef) {
            return CifTypeUtils.hasComponentLikeType(((TypeRef)type).getType().getType());
        }
        if (type instanceof EnumType) {
            return false;
        }
        if (type instanceof RealType) {
            return false;
        }
        if (type instanceof StringType) {
            return false;
        }
        if (type instanceof ListType) {
            return CifTypeUtils.hasComponentLikeType(((ListType)type).getElementType());
        }
        if (type instanceof SetType) {
            return CifTypeUtils.hasComponentLikeType(((SetType)type).getElementType());
        }
        if (type instanceof FuncType) {
            FuncType ftype = (FuncType)type;
            if (CifTypeUtils.hasComponentLikeType(ftype.getReturnType())) {
                return true;
            }
            for (CifType paramType : ftype.getParamTypes()) {
                if (!CifTypeUtils.hasComponentLikeType(paramType)) continue;
                return true;
            }
            return false;
        }
        if (type instanceof DictType) {
            DictType dtype = (DictType)type;
            return CifTypeUtils.hasComponentLikeType(dtype.getKeyType()) || CifTypeUtils.hasComponentLikeType(dtype.getValueType());
        }
        if (type instanceof TupleType) {
            TupleType ttype = (TupleType)type;
            for (Field field : ttype.getFields()) {
                if (!CifTypeUtils.hasComponentLikeType(field.getType())) continue;
                return true;
            }
            return false;
        }
        if (type instanceof DistType) {
            return false;
        }
        if (type instanceof ComponentDefType) {
            return true;
        }
        if (type instanceof ComponentType) {
            return true;
        }
        if (type instanceof CompInstWrapType) {
            CompInstWrapType wrapper = (CompInstWrapType)type;
            return CifTypeUtils.hasComponentLikeType(wrapper.getReference());
        }
        if (type instanceof CompParamWrapType) {
            CompParamWrapType wrapper = (CompParamWrapType)type;
            return CifTypeUtils.hasComponentLikeType(wrapper.getReference());
        }
        if (type instanceof VoidType) {
            return false;
        }
        throw new RuntimeException("Unknown type: " + String.valueOf(type));
    }

    public static boolean hasFunctionType(CifType type) {
        if (type instanceof BoolType) {
            return false;
        }
        if (type instanceof IntType) {
            return false;
        }
        if (type instanceof TypeRef) {
            return CifTypeUtils.hasFunctionType(((TypeRef)type).getType().getType());
        }
        if (type instanceof EnumType) {
            return false;
        }
        if (type instanceof RealType) {
            return false;
        }
        if (type instanceof StringType) {
            return false;
        }
        if (type instanceof ListType) {
            return CifTypeUtils.hasFunctionType(((ListType)type).getElementType());
        }
        if (type instanceof SetType) {
            return CifTypeUtils.hasFunctionType(((SetType)type).getElementType());
        }
        if (type instanceof FuncType) {
            return true;
        }
        if (type instanceof DictType) {
            DictType dtype = (DictType)type;
            return CifTypeUtils.hasFunctionType(dtype.getKeyType()) || CifTypeUtils.hasFunctionType(dtype.getValueType());
        }
        if (type instanceof TupleType) {
            TupleType ttype = (TupleType)type;
            for (Field field : ttype.getFields()) {
                if (!CifTypeUtils.hasFunctionType(field.getType())) continue;
                return true;
            }
            return false;
        }
        if (type instanceof DistType) {
            return false;
        }
        if (type instanceof ComponentDefType) {
            return false;
        }
        if (type instanceof ComponentType) {
            return false;
        }
        if (type instanceof CompInstWrapType) {
            CompInstWrapType wrapper = (CompInstWrapType)type;
            return CifTypeUtils.hasFunctionType(wrapper.getReference());
        }
        if (type instanceof CompParamWrapType) {
            CompParamWrapType wrapper = (CompParamWrapType)type;
            return CifTypeUtils.hasFunctionType(wrapper.getReference());
        }
        if (type instanceof VoidType) {
            return false;
        }
        throw new RuntimeException("Unknown type: " + String.valueOf(type));
    }

    public static boolean hasDistType(CifType type) {
        if (type instanceof BoolType) {
            return false;
        }
        if (type instanceof IntType) {
            return false;
        }
        if (type instanceof TypeRef) {
            return CifTypeUtils.hasDistType(((TypeRef)type).getType().getType());
        }
        if (type instanceof EnumType) {
            return false;
        }
        if (type instanceof RealType) {
            return false;
        }
        if (type instanceof StringType) {
            return false;
        }
        if (type instanceof ListType) {
            return CifTypeUtils.hasDistType(((ListType)type).getElementType());
        }
        if (type instanceof SetType) {
            return CifTypeUtils.hasDistType(((SetType)type).getElementType());
        }
        if (type instanceof FuncType) {
            FuncType ftype = (FuncType)type;
            if (CifTypeUtils.hasDistType(ftype.getReturnType())) {
                return true;
            }
            for (CifType paramType : ftype.getParamTypes()) {
                if (!CifTypeUtils.hasDistType(paramType)) continue;
                return true;
            }
            return false;
        }
        if (type instanceof DictType) {
            DictType dtype = (DictType)type;
            return CifTypeUtils.hasDistType(dtype.getKeyType()) || CifTypeUtils.hasDistType(dtype.getValueType());
        }
        if (type instanceof TupleType) {
            TupleType ttype = (TupleType)type;
            for (Field field : ttype.getFields()) {
                if (!CifTypeUtils.hasDistType(field.getType())) continue;
                return true;
            }
            return false;
        }
        if (type instanceof DistType) {
            return true;
        }
        if (type instanceof ComponentDefType) {
            return false;
        }
        if (type instanceof ComponentType) {
            return false;
        }
        if (type instanceof CompInstWrapType) {
            CompInstWrapType wrapper = (CompInstWrapType)type;
            return CifTypeUtils.hasDistType(wrapper.getReference());
        }
        if (type instanceof CompParamWrapType) {
            CompParamWrapType wrapper = (CompParamWrapType)type;
            return CifTypeUtils.hasDistType(wrapper.getReference());
        }
        if (type instanceof VoidType) {
            return false;
        }
        throw new RuntimeException("Unknown type: " + String.valueOf(type));
    }

    public static boolean hasType(CifType type, Predicate<CifType> condition) {
        if (condition.test(type)) {
            return true;
        }
        if (type instanceof BoolType) {
            return false;
        }
        if (type instanceof IntType) {
            return false;
        }
        if (type instanceof EnumType) {
            return false;
        }
        if (type instanceof RealType) {
            return false;
        }
        if (type instanceof StringType) {
            return false;
        }
        if (type instanceof ComponentDefType) {
            return false;
        }
        if (type instanceof ComponentType) {
            return false;
        }
        if (type instanceof VoidType) {
            return false;
        }
        if (type instanceof TypeRef) {
            TypeRef typeRef = (TypeRef)type;
            return CifTypeUtils.hasType(typeRef.getType().getType(), condition);
        }
        if (type instanceof ListType) {
            ListType listType = (ListType)type;
            return CifTypeUtils.hasType(listType.getElementType(), condition);
        }
        if (type instanceof SetType) {
            SetType setType = (SetType)type;
            return CifTypeUtils.hasType(setType.getElementType(), condition);
        }
        if (type instanceof DictType) {
            DictType dictType = (DictType)type;
            return CifTypeUtils.hasType(dictType.getKeyType(), condition) || CifTypeUtils.hasType(dictType.getValueType(), condition);
        }
        if (type instanceof TupleType) {
            TupleType tupleType = (TupleType)type;
            for (Field field : tupleType.getFields()) {
                if (!CifTypeUtils.hasType(field.getType(), condition)) continue;
                return true;
            }
            return false;
        }
        if (type instanceof FuncType) {
            FuncType funcType = (FuncType)type;
            if (CifTypeUtils.hasType(funcType.getReturnType(), condition)) {
                return true;
            }
            for (CifType paramType : funcType.getParamTypes()) {
                if (!CifTypeUtils.hasType(paramType, condition)) continue;
                return true;
            }
            return false;
        }
        if (type instanceof DistType) {
            DistType distType = (DistType)type;
            return CifTypeUtils.hasType(distType.getSampleType(), condition);
        }
        if (type instanceof CompInstWrapType) {
            CompInstWrapType wrapType = (CompInstWrapType)type;
            return CifTypeUtils.hasType(wrapType.getReference(), condition);
        }
        if (type instanceof CompParamWrapType) {
            CompParamWrapType wrapType = (CompParamWrapType)type;
            return CifTypeUtils.hasType(wrapType.getReference(), condition);
        }
        throw new RuntimeException("Unknown type: " + String.valueOf(type));
    }

    public static boolean hasEnumType(CifType type) {
        if (type instanceof BoolType) {
            return false;
        }
        if (type instanceof IntType) {
            return false;
        }
        if (type instanceof TypeRef) {
            return CifTypeUtils.hasEnumType(((TypeRef)type).getType().getType());
        }
        if (type instanceof EnumType) {
            return true;
        }
        if (type instanceof RealType) {
            return false;
        }
        if (type instanceof StringType) {
            return false;
        }
        if (type instanceof ListType) {
            return CifTypeUtils.hasEnumType(((ListType)type).getElementType());
        }
        if (type instanceof SetType) {
            return CifTypeUtils.hasEnumType(((SetType)type).getElementType());
        }
        if (type instanceof FuncType) {
            FuncType ftype = (FuncType)type;
            if (CifTypeUtils.hasEnumType(ftype.getReturnType())) {
                return true;
            }
            for (CifType paramType : ftype.getParamTypes()) {
                if (!CifTypeUtils.hasEnumType(paramType)) continue;
                return true;
            }
            return false;
        }
        if (type instanceof DictType) {
            DictType dtype = (DictType)type;
            return CifTypeUtils.hasEnumType(dtype.getKeyType()) || CifTypeUtils.hasEnumType(dtype.getValueType());
        }
        if (type instanceof TupleType) {
            TupleType ttype = (TupleType)type;
            for (Field field : ttype.getFields()) {
                if (!CifTypeUtils.hasEnumType(field.getType())) continue;
                return true;
            }
            return false;
        }
        if (type instanceof DistType) {
            return false;
        }
        if (type instanceof ComponentDefType) {
            return false;
        }
        if (type instanceof ComponentType) {
            return false;
        }
        if (type instanceof CompInstWrapType) {
            CompInstWrapType wrapper = (CompInstWrapType)type;
            return CifTypeUtils.hasEnumType(wrapper.getReference());
        }
        if (type instanceof CompParamWrapType) {
            CompParamWrapType wrapper = (CompParamWrapType)type;
            return CifTypeUtils.hasEnumType(wrapper.getReference());
        }
        if (type instanceof VoidType) {
            return false;
        }
        throw new RuntimeException("Unknown type: " + String.valueOf(type));
    }

    public static CifType mergeTypes(CifType type1, CifType type2, Position position) {
        CifType origType1 = type1;
        type1 = CifTypeUtils.normalizeType(type1);
        type2 = CifTypeUtils.normalizeType(type2);
        if (type1 instanceof BoolType && type2 instanceof BoolType) {
            return CifConstructors.newBoolType((Position)PositionUtils.copyPosition((Position)position));
        }
        if (type1 instanceof IntType && type2 instanceof IntType) {
            IntType itype1 = (IntType)type1;
            IntType itype2 = (IntType)type2;
            IntType itype = CifConstructors.newIntType();
            itype.setPosition(PositionUtils.copyPosition((Position)position));
            if (!CifTypeUtils.isRangeless(itype1) && !CifTypeUtils.isRangeless(itype2)) {
                itype.setLower(Integer.valueOf(Math.min(itype1.getLower(), itype2.getLower())));
                itype.setUpper(Integer.valueOf(Math.max(itype1.getUpper(), itype2.getUpper())));
            }
            return itype;
        }
        if (type1 instanceof EnumType && type2 instanceof EnumType) {
            EnumDecl enum1 = ((EnumType)type1).getEnum();
            EnumDecl enum2 = ((EnumType)type2).getEnum();
            Assert.check((boolean)CifTypeUtils.areEnumsCompatible(enum1, enum2));
            return CifTypeUtils.changePositions((CifType)EMFHelper.deepclone((EObject)origType1), position);
        }
        if (type1 instanceof RealType && type2 instanceof RealType) {
            return CifConstructors.newRealType((Position)PositionUtils.copyPosition((Position)position));
        }
        if (type1 instanceof StringType && type2 instanceof StringType) {
            return CifConstructors.newStringType((Position)PositionUtils.copyPosition((Position)position));
        }
        if (type1 instanceof ListType && type2 instanceof ListType) {
            ListType ltype1 = (ListType)type1;
            ListType ltype2 = (ListType)type2;
            ListType ltype = CifConstructors.newListType();
            ltype.setPosition(PositionUtils.copyPosition((Position)position));
            if (!CifTypeUtils.isRangeless(ltype1) && !CifTypeUtils.isRangeless(ltype2)) {
                ltype.setLower(Integer.valueOf(Math.min(ltype1.getLower(), ltype2.getLower())));
                ltype.setUpper(Integer.valueOf(Math.max(ltype1.getUpper(), ltype2.getUpper())));
            }
            CifType etype = CifTypeUtils.mergeTypes(ltype1.getElementType(), ltype2.getElementType(), position);
            ltype.setElementType(etype);
            return ltype;
        }
        if (type1 instanceof SetType && type2 instanceof SetType) {
            CifType etype = CifTypeUtils.mergeTypes(((SetType)type1).getElementType(), ((SetType)type2).getElementType(), position);
            SetType stype = CifConstructors.newSetType();
            stype.setPosition(PositionUtils.copyPosition((Position)position));
            stype.setElementType(etype);
            return stype;
        }
        if (type1 instanceof FuncType && type2 instanceof FuncType) {
            int cnt2;
            FuncType ftype1 = (FuncType)type1;
            FuncType ftype2 = (FuncType)type2;
            CifType rtype = CifTypeUtils.mergeTypes(ftype1.getReturnType(), ftype2.getReturnType(), position);
            int cnt1 = ftype1.getParamTypes().size();
            Assert.check((cnt1 == (cnt2 = ftype2.getParamTypes().size()) ? 1 : 0) != 0);
            List ptypes = Lists.listc((int)cnt1);
            int i = 0;
            while (i < cnt1) {
                ptypes.add(CifTypeUtils.mergeTypes((CifType)ftype1.getParamTypes().get(i), (CifType)ftype2.getParamTypes().get(i), position));
                ++i;
            }
            FuncType ftype = CifConstructors.newFuncType();
            ftype.setPosition(PositionUtils.copyPosition((Position)position));
            ftype.setReturnType(rtype);
            ftype.getParamTypes().addAll((Collection)ptypes);
            return ftype;
        }
        if (type1 instanceof DictType && type2 instanceof DictType) {
            DictType dtype1 = (DictType)type1;
            DictType dtype2 = (DictType)type2;
            CifType ktype = CifTypeUtils.mergeTypes(dtype1.getKeyType(), dtype2.getKeyType(), position);
            CifType vtype = CifTypeUtils.mergeTypes(dtype1.getValueType(), dtype2.getValueType(), position);
            DictType dtype = CifConstructors.newDictType();
            dtype.setPosition(PositionUtils.copyPosition((Position)position));
            dtype.setKeyType(ktype);
            dtype.setValueType(vtype);
            return dtype;
        }
        if (type1 instanceof TupleType && type2 instanceof TupleType) {
            int cnt2;
            TupleType ttype1 = (TupleType)type1;
            TupleType ttype2 = (TupleType)type2;
            int cnt1 = ttype1.getFields().size();
            Assert.check((cnt1 == (cnt2 = ttype2.getFields().size()) ? 1 : 0) != 0);
            List fields = Lists.listc((int)cnt1);
            int i = 0;
            while (i < cnt1) {
                Field field1 = (Field)ttype1.getFields().get(i);
                Field field2 = (Field)ttype2.getFields().get(i);
                CifType ftype = CifTypeUtils.mergeTypes(field1.getType(), field2.getType(), position);
                Field field = CifConstructors.newField();
                field.setPosition(PositionUtils.copyPosition((Position)position));
                field.setType(ftype);
                fields.add(field);
                ++i;
            }
            TupleType ttype = CifConstructors.newTupleType();
            ttype.setPosition(PositionUtils.copyPosition((Position)position));
            ttype.getFields().addAll((Collection)fields);
            return ttype;
        }
        if (type1 instanceof DistType && type2 instanceof DistType) {
            CifType stype = CifTypeUtils.mergeTypes(((DistType)type1).getSampleType(), ((DistType)type2).getSampleType(), position);
            DistType dtype = CifConstructors.newDistType();
            dtype.setPosition(PositionUtils.copyPosition((Position)position));
            dtype.setSampleType(stype);
            return dtype;
        }
        if (type1 instanceof VoidType && type2 instanceof VoidType) {
            return CifConstructors.newVoidType((Position)PositionUtils.copyPosition((Position)position));
        }
        String msg = "Unknown/unexpected types: " + String.valueOf(type1) + ", " + String.valueOf(type2);
        throw new RuntimeException(msg);
    }

    public static int getLowerBound(IntType type) {
        Integer rslt = type.getLower();
        return rslt == null ? Integer.MIN_VALUE : rslt;
    }

    public static int getLowerBound(ListType type) {
        Integer rslt = type.getLower();
        return rslt == null ? 0 : rslt;
    }

    public static int getUpperBound(IntType type) {
        Integer rslt = type.getUpper();
        return rslt == null ? Integer.MAX_VALUE : rslt;
    }

    public static int getUpperBound(ListType type) {
        Integer rslt = type.getUpper();
        return rslt == null ? Integer.MAX_VALUE : rslt;
    }

    public static boolean isRangeless(IntType type) {
        return type.getLower() == null;
    }

    public static boolean isRangeless(ListType type) {
        return type.getLower() == null;
    }

    public static boolean isArrayType(ListType type) {
        return type.getLower() != null && type.getUpper() != null && type.getLower().equals(type.getUpper());
    }

    public static boolean containsRangedType(CifType type) {
        if (type instanceof BoolType) {
            return false;
        }
        if (type instanceof IntType) {
            return !CifTypeUtils.isRangeless((IntType)type);
        }
        if (type instanceof TypeRef) {
            return CifTypeUtils.containsRangedType(((TypeRef)type).getType().getType());
        }
        if (type instanceof EnumType) {
            return false;
        }
        if (type instanceof RealType) {
            return false;
        }
        if (type instanceof StringType) {
            return false;
        }
        if (type instanceof ListType) {
            return !CifTypeUtils.isRangeless((ListType)type) || CifTypeUtils.containsRangedType(((ListType)type).getElementType());
        }
        if (type instanceof SetType) {
            return CifTypeUtils.containsRangedType(((SetType)type).getElementType());
        }
        if (type instanceof FuncType) {
            FuncType ftype = (FuncType)type;
            if (CifTypeUtils.containsRangedType(ftype.getReturnType())) {
                return true;
            }
            for (CifType paramType : ftype.getParamTypes()) {
                if (!CifTypeUtils.containsRangedType(paramType)) continue;
                return true;
            }
            return false;
        }
        if (type instanceof DictType) {
            DictType dtype = (DictType)type;
            return CifTypeUtils.containsRangedType(dtype.getKeyType()) || CifTypeUtils.containsRangedType(dtype.getValueType());
        }
        if (type instanceof TupleType) {
            TupleType ttype = (TupleType)type;
            for (Field field : ttype.getFields()) {
                if (!CifTypeUtils.containsRangedType(field.getType())) continue;
                return true;
            }
            return false;
        }
        if (type instanceof DistType) {
            return false;
        }
        if (type instanceof ComponentDefType) {
            return false;
        }
        if (type instanceof ComponentType) {
            return false;
        }
        if (type instanceof CompInstWrapType) {
            CompInstWrapType wrapper = (CompInstWrapType)type;
            return CifTypeUtils.containsRangedType(wrapper.getReference());
        }
        if (type instanceof CompParamWrapType) {
            CompParamWrapType wrapper = (CompParamWrapType)type;
            return CifTypeUtils.containsRangedType(wrapper.getReference());
        }
        if (type instanceof VoidType) {
            return false;
        }
        throw new RuntimeException("Unknown type: " + String.valueOf(type));
    }

    public static CifType normalizeType(CifType type) {
        if (type instanceof TypeRef) {
            return CifTypeUtils.normalizeType(((TypeRef)type).getType().getType());
        }
        if (type instanceof CompParamWrapType) {
            return CifTypeUtils.normalizeType(((CompParamWrapType)type).getReference());
        }
        if (type instanceof CompInstWrapType) {
            return CifTypeUtils.normalizeType(((CompInstWrapType)type).getReference());
        }
        return type;
    }

    public static CifType normalizeTypeRecursive(CifType type) {
        if (type instanceof BoolType) {
            return type;
        }
        if (type instanceof IntType) {
            return type;
        }
        if (type instanceof EnumType) {
            return type;
        }
        if (type instanceof RealType) {
            return type;
        }
        if (type instanceof StringType) {
            return type;
        }
        if (type instanceof ListType) {
            ListType ltype = (ListType)type;
            CifType netype = CifTypeUtils.normalizeTypeRecursive(ltype.getElementType());
            ListType rslt = CifConstructors.newListType();
            rslt.setLower(ltype.getLower());
            rslt.setUpper(ltype.getUpper());
            rslt.setElementType((CifType)EMFHelper.deepclone((EObject)netype));
            return rslt;
        }
        if (type instanceof SetType) {
            SetType stype = (SetType)type;
            CifType netype = CifTypeUtils.normalizeTypeRecursive(stype.getElementType());
            SetType rslt = CifConstructors.newSetType();
            rslt.setElementType((CifType)EMFHelper.deepclone((EObject)netype));
            return rslt;
        }
        if (type instanceof FuncType) {
            FuncType ftype = (FuncType)type;
            CifType nrtype = CifTypeUtils.normalizeTypeRecursive(ftype.getReturnType());
            List nptypes = Lists.listc((int)ftype.getParamTypes().size());
            for (CifType ptype : ftype.getParamTypes()) {
                nptypes.add((CifType)EMFHelper.deepclone((EObject)CifTypeUtils.normalizeTypeRecursive(ptype)));
            }
            FuncType rslt = CifConstructors.newFuncType();
            rslt.setReturnType((CifType)EMFHelper.deepclone((EObject)nrtype));
            rslt.getParamTypes().addAll((Collection)nptypes);
            return rslt;
        }
        if (type instanceof DictType) {
            DictType dtype = (DictType)type;
            CifType nktype = CifTypeUtils.normalizeTypeRecursive(dtype.getKeyType());
            CifType nvtype = CifTypeUtils.normalizeTypeRecursive(dtype.getValueType());
            DictType rslt = CifConstructors.newDictType();
            rslt.setKeyType((CifType)EMFHelper.deepclone((EObject)nktype));
            rslt.setValueType((CifType)EMFHelper.deepclone((EObject)nvtype));
            return rslt;
        }
        if (type instanceof TupleType) {
            TupleType ttype = (TupleType)type;
            List nfields = Lists.listc((int)ttype.getFields().size());
            for (Field field : ttype.getFields()) {
                Field nfield = CifConstructors.newField();
                nfield.setName(field.getName());
                CifType ftype = CifTypeUtils.normalizeTypeRecursive(field.getType());
                nfield.setType((CifType)EMFHelper.deepclone((EObject)ftype));
                nfields.add(nfield);
            }
            TupleType rslt = CifConstructors.newTupleType();
            rslt.getFields().addAll((Collection)nfields);
            return rslt;
        }
        if (type instanceof DistType) {
            DistType dtype = (DistType)type;
            CifType nstype = CifTypeUtils.normalizeTypeRecursive(dtype.getSampleType());
            DistType rslt = CifConstructors.newDistType();
            rslt.setSampleType((CifType)EMFHelper.deepclone((EObject)nstype));
            return rslt;
        }
        if (type instanceof ComponentType) {
            return type;
        }
        if (type instanceof ComponentDefType) {
            return type;
        }
        if (type instanceof TypeRef) {
            return CifTypeUtils.normalizeTypeRecursive(((TypeRef)type).getType().getType());
        }
        if (type instanceof CompInstWrapType) {
            CompInstWrapType wrapper = (CompInstWrapType)type;
            return CifTypeUtils.normalizeTypeRecursive(wrapper.getReference());
        }
        if (type instanceof CompParamWrapType) {
            CompParamWrapType wrapper = (CompParamWrapType)type;
            return CifTypeUtils.normalizeTypeRecursive(wrapper.getReference());
        }
        if (type instanceof VoidType) {
            return type;
        }
        throw new RuntimeException("Unknown type: " + String.valueOf(type));
    }

    public static CifType unwrapType(CifType type) {
        if (type instanceof CompParamWrapType) {
            return CifTypeUtils.unwrapType(((CompParamWrapType)type).getReference());
        }
        if (type instanceof CompInstWrapType) {
            return CifTypeUtils.unwrapType(((CompInstWrapType)type).getReference());
        }
        return type;
    }

    public static Expression unwrapExpression(Expression expr) {
        if (expr instanceof CompParamWrapExpression) {
            return CifTypeUtils.unwrapExpression(((CompParamWrapExpression)expr).getReference());
        }
        if (expr instanceof CompInstWrapExpression) {
            return CifTypeUtils.unwrapExpression(((CompInstWrapExpression)expr).getReference());
        }
        return expr;
    }

    public static ComponentDef getCompDefFromCompInst(ComponentInst inst) {
        CifType type = inst.getDefinition();
        type = CifTypeUtils.unwrapType(type);
        Assert.check((boolean)(type instanceof ComponentDefType));
        return ((ComponentDefType)type).getDefinition();
    }

    public static boolean isAutRefExpr(Expression expr) {
        if (expr instanceof SelfExpression) {
            return true;
        }
        if ((expr = CifTypeUtils.unwrapExpression(expr)) instanceof ComponentExpression) {
            Component comp = ((ComponentExpression)expr).getComponent();
            return CifScopeUtils.isAutomaton(comp);
        }
        if (expr instanceof CompParamExpression) {
            CompParamExpression compParamExpr = (CompParamExpression)expr;
            CifType t = CifTypeUtils.normalizeType(compParamExpr.getType());
            Assert.check((boolean)(t instanceof ComponentDefType));
            ComponentDef cdef = ((ComponentDefType)t).getDefinition();
            return CifScopeUtils.isAutomaton((Component)cdef.getBody());
        }
        return false;
    }

    public static boolean isRefExpr(Expression expr) {
        return expr instanceof ConstantExpression || expr instanceof DiscVariableExpression || expr instanceof AlgVariableExpression || expr instanceof ContVariableExpression || expr instanceof LocationExpression || expr instanceof EventExpression || expr instanceof EnumLiteralExpression || expr instanceof FunctionExpression || expr instanceof InputVariableExpression || expr instanceof ComponentExpression || expr instanceof CompParamExpression || expr instanceof CompParamWrapExpression || expr instanceof CompInstWrapExpression || expr instanceof SelfExpression;
    }

    public static boolean isRefType(CifType type) {
        return type instanceof TypeRef || type instanceof EnumType || type instanceof ComponentType || type instanceof ComponentDefType || type instanceof CompParamWrapType || type instanceof CompInstWrapType;
    }

    public static boolean isContainerType(CifType type) {
        return (type = CifTypeUtils.normalizeType(type)) instanceof DictType || type instanceof ListType || type instanceof SetType || type instanceof TupleType;
    }

    public static boolean isDistFunction(StdLibFunction func) {
        switch (func) {
            case MINIMUM: 
            case MAXIMUM: 
            case POWER: 
            case SIGN: 
            case CBRT: 
            case CEIL: 
            case DELETE: 
            case EMPTY: 
            case EXP: 
            case FLOOR: 
            case LN: 
            case LOG: 
            case POP: 
            case ROUND: 
            case SIZE: 
            case SQRT: 
            case ACOSH: 
            case ACOS: 
            case ASINH: 
            case ASIN: 
            case ATANH: 
            case ATAN: 
            case COSH: 
            case COS: 
            case SINH: 
            case SIN: 
            case TANH: 
            case TAN: 
            case ABS: 
            case FORMAT: 
            case SCALE: {
                return false;
            }
            case BERNOULLI: 
            case BETA: 
            case BINOMIAL: 
            case CONSTANT: 
            case ERLANG: 
            case EXPONENTIAL: 
            case GAMMA: 
            case GEOMETRIC: 
            case LOG_NORMAL: 
            case NORMAL: 
            case POISSON: 
            case RANDOM: 
            case TRIANGLE: 
            case UNIFORM: 
            case WEIBULL: {
                return true;
            }
        }
        throw new RuntimeException("Unknown stdlib func: " + String.valueOf(func));
    }

    public static Boolean areStructurallySameType(CifType type1, CifType type2) {
        if (!type1.getClass().equals(type2.getClass())) {
            return false;
        }
        if (type1 instanceof BoolType && type2 instanceof BoolType) {
            return true;
        }
        if (type1 instanceof IntType) {
            IntType itype1 = (IntType)type1;
            if (type2 instanceof IntType) {
                IntType itype2 = (IntType)type2;
                if (Objects.equals(itype1.getLower(), itype2.getLower()) && Objects.equals(itype1.getUpper(), itype2.getUpper())) {
                    return true;
                }
                return false;
            }
        }
        if (type1 instanceof TypeRef) {
            TypeRef typeRef1 = (TypeRef)type1;
            if (type2 instanceof TypeRef) {
                TypeRef typeRef2 = (TypeRef)type2;
                if (typeRef1.getType() == typeRef2.getType()) {
                    return true;
                }
                return false;
            }
        }
        if (type1 instanceof EnumType) {
            EnumType etype1 = (EnumType)type1;
            if (type2 instanceof EnumType) {
                EnumType etype2 = (EnumType)type2;
                if (etype1.getEnum() == etype2.getEnum()) {
                    return true;
                }
                return false;
            }
        }
        if (type1 instanceof ListType) {
            ListType ltype1 = (ListType)type1;
            if (type2 instanceof ListType) {
                ListType ltype2 = (ListType)type2;
                if (Objects.equals(ltype1.getLower(), ltype2.getLower()) && Objects.equals(ltype1.getUpper(), ltype2.getUpper()) && CifTypeUtils.areStructurallySameType(ltype1.getElementType(), ltype2.getElementType()).booleanValue()) {
                    return true;
                }
                return false;
            }
        }
        if (type1 instanceof StringType && type2 instanceof StringType) {
            return true;
        }
        if (type1 instanceof RealType && type2 instanceof RealType) {
            return true;
        }
        if (type1 instanceof SetType) {
            SetType stype1 = (SetType)type1;
            if (type2 instanceof SetType) {
                SetType stype2 = (SetType)type2;
                return CifTypeUtils.areStructurallySameType(stype1.getElementType(), stype2.getElementType());
            }
        }
        if (type1 instanceof FuncType) {
            FuncType ftype1 = (FuncType)type1;
            if (type2 instanceof FuncType) {
                FuncType ftype2 = (FuncType)type2;
                if (ftype1.getParamTypes().size() != ftype1.getParamTypes().size()) {
                    return false;
                }
                int i = 0;
                while (i < ftype1.getParamTypes().size()) {
                    if (!CifTypeUtils.areStructurallySameType((CifType)ftype1.getParamTypes().get(i), (CifType)ftype2.getParamTypes().get(i)).booleanValue()) {
                        return false;
                    }
                    ++i;
                }
                return CifTypeUtils.areStructurallySameType(ftype1.getReturnType(), ftype2.getReturnType());
            }
        }
        if (type1 instanceof VoidType && type2 instanceof VoidType) {
            return true;
        }
        if (type1 instanceof DictType) {
            DictType dtype1 = (DictType)type1;
            if (type2 instanceof DictType) {
                DictType dtype2 = (DictType)type2;
                if (CifTypeUtils.areStructurallySameType(dtype1.getKeyType(), dtype2.getKeyType()).booleanValue() && CifTypeUtils.areStructurallySameType(dtype1.getValueType(), dtype2.getValueType()).booleanValue()) {
                    return true;
                }
                return false;
            }
        }
        if (type1 instanceof TupleType) {
            TupleType ttype1 = (TupleType)type1;
            if (type2 instanceof TupleType) {
                TupleType ttype2 = (TupleType)type2;
                if (ttype1.getFields().size() != ttype2.getFields().size()) {
                    return false;
                }
                int i = 0;
                while (i < ttype1.getFields().size()) {
                    Field field1 = (Field)ttype1.getFields().get(i);
                    Field field2 = (Field)ttype2.getFields().get(i);
                    if (!Objects.equals(field1.getName(), field2.getName())) {
                        return false;
                    }
                    if (!CifTypeUtils.areStructurallySameType(field1.getType(), field2.getType()).booleanValue()) {
                        return false;
                    }
                    ++i;
                }
            }
        }
        if (type1 instanceof DistType) {
            DistType dtype1 = (DistType)type1;
            if (type2 instanceof DistType) {
                DistType dtype2 = (DistType)type2;
                return CifTypeUtils.areStructurallySameType(dtype1.getSampleType(), dtype2.getSampleType());
            }
        }
        if (type1 instanceof ComponentDefType) {
            ComponentDefType cdtype1 = (ComponentDefType)type1;
            if (type2 instanceof ComponentDefType) {
                ComponentDefType cdtype2 = (ComponentDefType)type2;
                if (cdtype1.getDefinition() == cdtype2.getDefinition()) {
                    return true;
                }
                return false;
            }
        }
        if (type1 instanceof ComponentType) {
            ComponentType ctype1 = (ComponentType)type1;
            if (type2 instanceof ComponentType) {
                ComponentType ctype2 = (ComponentType)type2;
                if (ctype1.getComponent() == ctype2.getComponent()) {
                    return true;
                }
                return false;
            }
        }
        if (type1 instanceof CompInstWrapType) {
            CompInstWrapType ciwtype1 = (CompInstWrapType)type1;
            if (type2 instanceof CompInstWrapType) {
                CompInstWrapType ciwtype2 = (CompInstWrapType)type2;
                if (ciwtype1.getInstantiation() == ciwtype2.getInstantiation() && CifTypeUtils.areStructurallySameType(ciwtype1.getReference(), ciwtype2.getReference()).booleanValue()) {
                    return true;
                }
                return false;
            }
        }
        if (type1 instanceof CompParamWrapType) {
            CompParamWrapType cpwType1 = (CompParamWrapType)type1;
            if (type2 instanceof CompParamWrapType) {
                CompParamWrapType cpwType2 = (CompParamWrapType)type2;
                if (cpwType1.getParameter() == cpwType2.getParameter() && CifTypeUtils.areStructurallySameType(cpwType1.getReference(), cpwType2.getReference()).booleanValue()) {
                    return true;
                }
                return false;
            }
        }
        throw new RuntimeException("Unexpected types: " + String.valueOf(type1) + ", " + String.valueOf(type2));
    }

    public static CifType makeTupleType(List<CifType> fieldTypes, Position position) {
        Assert.check((!fieldTypes.isEmpty() ? 1 : 0) != 0);
        if (fieldTypes.size() == 1) {
            return CifTypeUtils.changePositions((CifType)EMFHelper.deepclone((EObject)((CifType)Lists.first(fieldTypes))), position);
        }
        TupleType tupleType = CifConstructors.newTupleType();
        tupleType.setPosition(PositionUtils.copyPosition((Position)position));
        for (CifType fieldType : fieldTypes) {
            Field field = CifConstructors.newField();
            field.setPosition(PositionUtils.copyPosition((Position)position));
            field.setType(CifTypeUtils.changePositions((CifType)EMFHelper.deepclone((EObject)fieldType), position));
            tupleType.getFields().add((Object)field);
        }
        return tupleType;
    }

    public static CifType makeTupleTypeFromValues(List<Expression> values, Position position) {
        Assert.check((!values.isEmpty() ? 1 : 0) != 0);
        if (values.size() == 1) {
            return CifTypeUtils.changePositions((CifType)EMFHelper.deepclone((EObject)((Expression)Lists.first(values)).getType()), position);
        }
        TupleType tupleType = CifConstructors.newTupleType();
        tupleType.setPosition(PositionUtils.copyPosition((Position)position));
        for (Expression value : values) {
            Field field = CifConstructors.newField();
            field.setPosition(PositionUtils.copyPosition((Position)position));
            field.setType(CifTypeUtils.changePositions((CifType)EMFHelper.deepclone((EObject)value.getType()), position));
            tupleType.getFields().add((Object)field);
        }
        return tupleType;
    }

    public static FuncType makeFunctionType(Function func, Position position) {
        FuncType type = CifConstructors.newFuncType();
        type.setPosition(PositionUtils.copyPosition((Position)position));
        for (FunctionParameter param : func.getParameters()) {
            CifType paramType = param.getParameter().getType();
            type.getParamTypes().add((Object)CifTypeUtils.changePositions((CifType)EMFHelper.deepclone((EObject)paramType), position));
        }
        type.setReturnType(CifTypeUtils.makeTupleType((List<CifType>)func.getReturnTypes(), position));
        return type;
    }

    public static <T extends CifType> T changePositions(T type, Position position) {
        if (position == null) {
            return type;
        }
        if (type instanceof BoolType) {
            BoolType bt = (BoolType)type;
            bt.setPosition(PositionUtils.copyPosition((Position)position));
        } else if (type instanceof RealType) {
            RealType rt = (RealType)type;
            rt.setPosition(PositionUtils.copyPosition((Position)position));
        } else if (type instanceof StringType) {
            StringType st = (StringType)type;
            st.setPosition(PositionUtils.copyPosition((Position)position));
        } else if (type instanceof VoidType) {
            VoidType vt = (VoidType)type;
            vt.setPosition(PositionUtils.copyPosition((Position)position));
        } else if (type instanceof IntType) {
            IntType it = (IntType)type;
            it.setPosition(PositionUtils.copyPosition((Position)position));
        } else if (type instanceof ListType) {
            ListType lt = (ListType)type;
            lt.setPosition(PositionUtils.copyPosition((Position)position));
            CifTypeUtils.changePositions(lt.getElementType(), position);
        } else if (type instanceof SetType) {
            SetType st = (SetType)type;
            st.setPosition(PositionUtils.copyPosition((Position)position));
            CifTypeUtils.changePositions(st.getElementType(), position);
        } else if (type instanceof DictType) {
            DictType dt = (DictType)type;
            dt.setPosition(PositionUtils.copyPosition((Position)position));
            CifTypeUtils.changePositions(dt.getKeyType(), position);
            CifTypeUtils.changePositions(dt.getValueType(), position);
        } else if (type instanceof TupleType) {
            TupleType tt = (TupleType)type;
            tt.setPosition(PositionUtils.copyPosition((Position)position));
            for (Field field : tt.getFields()) {
                field.setPosition(PositionUtils.copyPosition((Position)position));
                CifTypeUtils.changePositions(field.getType(), position);
            }
        } else if (type instanceof DistType) {
            DistType dt = (DistType)type;
            dt.setPosition(PositionUtils.copyPosition((Position)position));
            CifTypeUtils.changePositions(dt.getSampleType(), position);
        } else if (type instanceof FuncType) {
            FuncType ft = (FuncType)type;
            ft.setPosition(PositionUtils.copyPosition((Position)position));
            CifTypeUtils.changePositions(ft.getReturnType(), position);
            for (CifType pt : ft.getParamTypes()) {
                CifTypeUtils.changePositions(pt, position);
            }
        } else if (type instanceof TypeRef) {
            TypeRef tr = (TypeRef)type;
            tr.setPosition(PositionUtils.copyPosition((Position)position));
        } else if (type instanceof EnumType) {
            EnumType et = (EnumType)type;
            et.setPosition(PositionUtils.copyPosition((Position)position));
        } else if (type instanceof ComponentType) {
            ComponentType ct = (ComponentType)type;
            ct.setPosition(PositionUtils.copyPosition((Position)position));
        } else if (type instanceof ComponentDefType) {
            ComponentDefType cdt = (ComponentDefType)type;
            cdt.setPosition(PositionUtils.copyPosition((Position)position));
        } else if (type instanceof CompParamWrapType) {
            CompParamWrapType cpwt = (CompParamWrapType)type;
            cpwt.setPosition(PositionUtils.copyPosition((Position)position));
            CifTypeUtils.changePositions(cpwt.getReference(), position);
        } else if (type instanceof CompInstWrapType) {
            CompInstWrapType ciwt = (CompInstWrapType)type;
            ciwt.setPosition(PositionUtils.copyPosition((Position)position));
            CifTypeUtils.changePositions(ciwt.getReference(), position);
        } else {
            throw new RuntimeException("Unexpected type: " + String.valueOf(type));
        }
        return type;
    }

    public static CifType getVariableType(Declaration decl) {
        if (decl instanceof AlgVariable) {
            AlgVariable algVar = (AlgVariable)decl;
            return algVar.getType();
        }
        if (decl instanceof Constant) {
            Constant constant = (Constant)decl;
            return constant.getType();
        }
        if (decl instanceof ContVariable) {
            return CifConstructors.newRealType();
        }
        if (decl instanceof DiscVariable) {
            DiscVariable discVar = (DiscVariable)decl;
            return discVar.getType();
        }
        if (decl instanceof InputVariable) {
            InputVariable inputVar = (InputVariable)decl;
            return inputVar.getType();
        }
        throw new RuntimeException("Unknown variable: " + String.valueOf(decl));
    }
}

