/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.setext.typechecker;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.java.TextPosition;
import org.eclipse.escet.common.typechecker.SemanticException;
import org.eclipse.escet.common.typechecker.TypeChecker;
import org.eclipse.escet.setext.parser.ast.Decl;
import org.eclipse.escet.setext.parser.ast.HooksDecl;
import org.eclipse.escet.setext.parser.ast.SeTextObject;
import org.eclipse.escet.setext.parser.ast.Specification;
import org.eclipse.escet.setext.parser.ast.Symbol;
import org.eclipse.escet.setext.parser.ast.parser.ImportDecl;
import org.eclipse.escet.setext.parser.ast.parser.JavaType;
import org.eclipse.escet.setext.parser.ast.parser.NonTerminal;
import org.eclipse.escet.setext.parser.ast.parser.ParserRule;
import org.eclipse.escet.setext.parser.ast.parser.ParserRulePart;
import org.eclipse.escet.setext.parser.ast.parser.StartSymbol;
import org.eclipse.escet.setext.parser.ast.regex.RegEx;
import org.eclipse.escet.setext.parser.ast.regex.RegExAlts;
import org.eclipse.escet.setext.parser.ast.regex.RegExChar;
import org.eclipse.escet.setext.parser.ast.regex.RegExCharClass;
import org.eclipse.escet.setext.parser.ast.regex.RegExCharSeq;
import org.eclipse.escet.setext.parser.ast.regex.RegExChars;
import org.eclipse.escet.setext.parser.ast.regex.RegExDot;
import org.eclipse.escet.setext.parser.ast.regex.RegExOpt;
import org.eclipse.escet.setext.parser.ast.regex.RegExPlus;
import org.eclipse.escet.setext.parser.ast.regex.RegExSeq;
import org.eclipse.escet.setext.parser.ast.regex.RegExShortcut;
import org.eclipse.escet.setext.parser.ast.regex.RegExStar;
import org.eclipse.escet.setext.parser.ast.scanner.KeywordsIdentifier;
import org.eclipse.escet.setext.parser.ast.scanner.KeywordsTerminal;
import org.eclipse.escet.setext.parser.ast.scanner.ScannerDecl;
import org.eclipse.escet.setext.parser.ast.scanner.ShortcutDecl;
import org.eclipse.escet.setext.parser.ast.scanner.Terminal;
import org.eclipse.escet.setext.parser.ast.scanner.TerminalsDecl;
import org.eclipse.escet.setext.typechecker.Message;
import org.eclipse.escet.setext.typechecker.SymbolTable;

public class SeTextTypeChecker
extends TypeChecker<Specification, Specification> {
    private static final String TOKEN_CLASS_NAME = "org.eclipse.escet.setext.runtime.Token";
    public static boolean skipEmptyTermCheck = false;
    private SymbolTable symtable = new SymbolTable(this);
    private Specification spec = null;

    public void addProblem(Message message, TextPosition position, String ... args) {
        this.addProblem(message.format(args), message.getSeverity(), position);
    }

    protected Specification transRoot(Specification spec) {
        this.spec = spec;
        this.tcheckTerminalShortcuts();
        spec.states = Sets.set();
        spec.states.add("");
        spec.terminals = Lists.list();
        spec.nonterminals = Lists.list();
        this.tcheckTerminals();
        this.checkUnusedShortcuts();
        this.checkScannerStates();
        this.tcheckImports();
        this.tcheckNonTerminals();
        spec.mainSymbols = Lists.list();
        spec.startSymbols = Lists.list();
        this.tcheckStartSymbols();
        this.removeUnusedGeneratedNonTerminals();
        this.checkUnusedSymbols();
        this.checkUnreachableNonTerminals();
        this.checkMainSymbols();
        this.tcheckHooksClass();
        this.tcheckScannerClass();
        this.checkUnusedImports();
        this.checkDuplicateGenClasses();
        return spec;
    }

    private void tcheckTerminalShortcuts() {
        for (Decl decl : this.spec.decls) {
            if (!(decl instanceof ShortcutDecl)) continue;
            ShortcutDecl shortcut = (ShortcutDecl)decl;
            this.tcheckRegEx(shortcut.regEx, true);
            this.symtable.add(shortcut.name, (SeTextObject)shortcut);
        }
    }

    private void tcheckTerminals() {
        int priority = 0;
        for (Decl decl : this.spec.decls) {
            if (!(decl instanceof TerminalsDecl)) continue;
            TerminalsDecl terminals = (TerminalsDecl)decl;
            for (Symbol terminal : terminals.terminals) {
                if (terminal instanceof Terminal) {
                    this.tcheckTerminal((Terminal)terminal, priority);
                    continue;
                }
                if (terminal instanceof KeywordsTerminal) {
                    this.tcheckKeywordsTerminal((KeywordsTerminal)terminal, priority);
                    continue;
                }
                throw new RuntimeException("Unknown terminal.");
            }
            ++priority;
        }
    }

    private void tcheckTerminal(Terminal terminal, int priority) {
        String src;
        terminal.priority = priority;
        this.tcheckRegEx(terminal.regEx, false);
        if (terminal.regEx.acceptsEmptyString() && !skipEmptyTermCheck) {
            TextPosition pos = terminal.name == null ? terminal.regEx.position : terminal.position;
            String name = terminal.name == null ? "" : " \"" + terminal.name + "\"";
            this.addProblem(Message.TERM_ACCEPTS_EMPTY_STR, pos, name);
        }
        if (!this.spec.states.contains(src = terminal.getStateName())) {
            this.spec.states.add(src);
        }
        if (terminal.name != null) {
            this.symtable.add(terminal.name, (SeTextObject)terminal);
        }
        this.spec.terminals.add(terminal);
        this.tcheckTerminalDescription(terminal);
    }

    private void tcheckKeywordsTerminal(KeywordsTerminal kwterminal, int priority) {
        String src;
        String string = src = kwterminal.state == null ? "" : kwterminal.state.id;
        if (!this.spec.states.contains(src)) {
            this.spec.states.add(src);
        }
        List keywordTerminals = Lists.list();
        for (KeywordsIdentifier keyword : kwterminal.keywords) {
            Object name = keyword.keyword.id.toUpperCase(Locale.US);
            name = (String)name + "KW";
            RegEx regEx = this.keywordToRegEx(keyword.keyword.id, keyword.keyword.position);
            Terminal terminal = new Terminal((String)name, regEx, keyword.func, null, keyword.description, keyword.position);
            this.symtable.add((String)name, (SeTextObject)terminal);
            this.spec.terminals.add(terminal);
            keywordTerminals.add(terminal);
            this.tcheckTerminalDescription(terminal);
        }
        JavaType javaType = new JavaType(TOKEN_CLASS_NAME, null, kwterminal.position);
        List rules = Lists.list();
        for (Terminal keywordTerminal : keywordTerminals) {
            ParserRulePart part = new ParserRulePart(keywordTerminal.name, true, keywordTerminal.position);
            part.symbol = keywordTerminal;
            rules.add(new ParserRule(Lists.list((Object)part)));
        }
        NonTerminal nt = new NonTerminal(javaType, kwterminal.name, rules, true, kwterminal.position);
        this.symtable.add(nt.name, (SeTextObject)nt);
        this.spec.nonterminals.add(nt);
    }

    private void tcheckTerminalDescription(Terminal terminal) {
        boolean available;
        boolean needed = terminal.name != null && !terminal.isEof() && !terminal.regEx.isDescriptionText();
        boolean bl = available = terminal.description != null;
        if (needed && !available) {
            this.addProblem(Message.TERM_DESCR_MISSING, terminal.position, terminal.name);
        } else if (!needed && available) {
            if (terminal.name == null) {
                this.addProblem(Message.TERM_DESCR_UNNECESSARY, terminal.description.position, "nameless terminals");
            } else {
                if (terminal.isEof()) {
                    throw new RuntimeException("Terminal description for eof.");
                }
                String description = terminal.regEx.getDescriptionText();
                Assert.notNull((Object)description);
                this.addProblem(Message.TERM_DESCR_OVERRIDE, terminal.description.position, terminal.name, description);
            }
        }
    }

    private RegEx keywordToRegEx(String keyword, TextPosition position) {
        int[] codePoints = Strings.getCodePoints((String)keyword);
        List chars = Lists.listc((int)codePoints.length);
        int idx = 0;
        while (idx < codePoints.length) {
            int codePoint = codePoints[idx];
            Assert.check((position.startLine == position.endLine ? 1 : 0) != 0);
            TextPosition charPos = new TextPosition(position.location, position.source, position.startLine, position.startColumn + idx, position.endLine, position.endColumn, position.startOffset + idx, position.endOffset);
            chars.add(new RegExChar(codePoint, charPos));
            ++idx;
        }
        if (chars.size() == 1) {
            return (RegEx)Lists.first((List)chars);
        }
        return new RegExSeq(chars);
    }

    private void tcheckRegEx(RegEx regEx, boolean isShortcut) {
        if (regEx instanceof RegExAlts) {
            for (RegEx alt : ((RegExAlts)regEx).alts) {
                this.tcheckRegEx(alt, isShortcut);
            }
        } else if (regEx instanceof RegExCharClass) {
            RegExCharClass cls = (RegExCharClass)regEx;
            boolean anyChildEmpty = false;
            for (RegExChars c : cls.chars) {
                this.tcheckRegEx((RegEx)c, isShortcut);
                if (!c.getCodePoints().isEmpty()) continue;
                anyChildEmpty = true;
            }
            if (!anyChildEmpty && cls.getCodePoints().isEmpty()) {
                this.addProblem(Message.CHAR_CLS_EMPTY, cls.position, new String[0]);
            }
        } else if (regEx instanceof RegExChar) {
            boolean isASCII;
            RegExChar ch = (RegExChar)regEx;
            if (ch.isEof()) {
                return;
            }
            int codePoint = ch.character;
            boolean bl = isASCII = codePoint >= 0 && codePoint <= 127;
            if (!isASCII) {
                this.addProblem(Message.UNSUPPORTED_NON_ASCII_CHAR, regEx.position, Strings.codePointToStr((int)codePoint), String.valueOf(codePoint));
                throw new SemanticException();
            }
        } else if (regEx instanceof RegExCharSeq) {
            RegExCharSeq seq = (RegExCharSeq)regEx;
            this.tcheckRegEx((RegEx)seq.start, isShortcut);
            this.tcheckRegEx((RegEx)seq.end, isShortcut);
            int start = seq.start.character;
            int end = seq.end.character;
            if (start > end) {
                this.addProblem(Message.CHAR_SEQ_INVALID, regEx.position, Strings.codePointToStr((int)start) + "-" + Strings.codePointToStr((int)end));
            }
            if (start == end) {
                this.addProblem(Message.CHAR_SEQ_SINGLE, regEx.position, Strings.codePointToStr((int)start) + "-" + Strings.codePointToStr((int)end));
            }
        } else if (!(regEx instanceof RegExDot)) {
            if (regEx instanceof RegExOpt) {
                this.tcheckRegEx(((RegExOpt)regEx).child, isShortcut);
            } else if (regEx instanceof RegExPlus) {
                this.tcheckRegEx(((RegExPlus)regEx).child, isShortcut);
            } else if (regEx instanceof RegExSeq) {
                for (RegEx re : ((RegExSeq)regEx).sequence) {
                    this.tcheckRegEx(re, isShortcut);
                }
            } else if (regEx instanceof RegExShortcut) {
                RegExShortcut shortcut = (RegExShortcut)regEx;
                if (!this.symtable.contains(shortcut.name)) {
                    this.addProblem(isShortcut ? Message.SHORTCUT_UNDEFINED_ORDER : Message.SHORTCUT_UNDEFINED, regEx.position, shortcut.name);
                    throw new SemanticException();
                }
                SeTextObject obj = this.symtable.get(shortcut.name);
                if (!(obj instanceof ShortcutDecl)) {
                    this.addProblem(Message.SHORTCUT_INVALID_REF, regEx.position, shortcut.name);
                    throw new SemanticException();
                }
                shortcut.shortcut = (ShortcutDecl)obj;
                shortcut.shortcut.used = true;
            } else if (regEx instanceof RegExStar) {
                this.tcheckRegEx(((RegExStar)regEx).child, isShortcut);
            } else {
                throw new RuntimeException("Unknown reg ex: " + String.valueOf(regEx));
            }
        }
    }

    private void checkUnusedShortcuts() {
        for (Decl decl : this.spec.decls) {
            if (!(decl instanceof ShortcutDecl)) continue;
            ShortcutDecl shortcut = (ShortcutDecl)decl;
            if (shortcut.used) continue;
            this.addProblem(Message.SHORTCUT_UNUSED, decl.position, shortcut.name);
        }
    }

    private void checkScannerStates() {
        String state;
        for (Terminal terminal : this.spec.terminals) {
            String dst;
            if (terminal.newState == null || this.spec.states.contains(dst = terminal.newState.id)) continue;
            this.addProblem(Message.STATE_DOES_NOT_EXIST, terminal.newState.position, dst);
        }
        for (Terminal terminal : this.spec.terminals) {
            String dst;
            Object src;
            if (terminal.newState == null || !((String)(src = terminal.getStateName())).equals(dst = terminal.newState.id)) continue;
            this.addProblem(Message.STATE_SAME_AS_SOURCE, terminal.newState.position, dst);
        }
        Map eofMap = Maps.map();
        for (Terminal terminal : this.spec.terminals) {
            RegExChar c;
            if (!(terminal.regEx instanceof RegExChar) || !(c = (RegExChar)terminal.regEx).isEof()) continue;
            state = terminal.getStateName();
            if (eofMap.containsKey(state)) {
                this.addProblem(Message.STATE_DUPL_EOF, terminal.position, state);
                this.addProblem(Message.STATE_DUPL_EOF, (TextPosition)eofMap.get(state), state);
                continue;
            }
            eofMap.put(state, terminal.position);
        }
        if (eofMap.isEmpty()) {
            this.addProblem(Message.NO_STATE_EOF, this.spec.position, new String[0]);
        } else if (!eofMap.containsKey("")) {
            this.addProblem(Message.DEFAULT_STATE_NO_EOF, this.spec.position, new String[0]);
        }
        Set reachableStates = Sets.set((Object)"");
        for (Terminal terminal : this.spec.terminals) {
            String newState;
            state = terminal.getStateName();
            String string = newState = terminal.newState == null ? state : terminal.newState.id;
            if (state.equals(newState)) continue;
            reachableStates.add(newState);
        }
        for (String state2 : this.spec.states) {
            if (reachableStates.contains(state2)) continue;
            for (Decl decl : this.spec.decls) {
                String sname;
                if (!(decl instanceof TerminalsDecl)) continue;
                TerminalsDecl tdecl = (TerminalsDecl)decl;
                String string = sname = tdecl.state == null ? "" : tdecl.state.id;
                if (!sname.equals(state2)) continue;
                this.addProblem(Message.STATE_UNREACHABLE, tdecl.position, state2);
            }
        }
    }

    private void tcheckImports() {
        for (Decl decl : this.spec.decls) {
            if (!(decl instanceof ImportDecl)) continue;
            ImportDecl imp = (ImportDecl)decl;
            if (imp.name == null) {
                imp.name = imp.javaType.className;
                int idx = imp.name.lastIndexOf(46);
                if (idx != -1) {
                    imp.name = imp.name.substring(idx + 1);
                }
            }
            this.symtable.add(imp.name, (SeTextObject)imp);
        }
    }

    private void tcheckNonTerminals() {
        for (Decl decl : this.spec.decls) {
            if (!(decl instanceof NonTerminal)) continue;
            NonTerminal nonterm = (NonTerminal)decl;
            this.symtable.add(nonterm.name, (SeTextObject)nonterm);
            this.spec.nonterminals.add(nonterm);
        }
        for (NonTerminal nonterm : this.spec.nonterminals) {
            this.tcheckNonTerminal(nonterm);
        }
    }

    private void tcheckNonTerminal(NonTerminal nonterm) {
        if (nonterm.generated) {
            return;
        }
        this.tcheckJavaType(nonterm.returnType);
        for (ParserRule rule : nonterm.rules) {
            for (ParserRulePart part : rule.symbols) {
                this.tcheckParserRulePart(part);
            }
        }
    }

    private void tcheckParserRulePart(ParserRulePart part) {
        if (!this.symtable.contains(part.name)) {
            this.addProblem(Message.SYMBOL_UNDEFINED, part.position, part.name);
            return;
        }
        SeTextObject obj = this.symtable.get(part.name);
        if (!(obj instanceof Symbol)) {
            this.addProblem(Message.SYMBOL_INVALID_REF, part.position, part.name);
            return;
        }
        Symbol sym = (Symbol)obj;
        Assert.check((!(sym instanceof KeywordsTerminal) ? 1 : 0) != 0);
        part.symbol = sym;
        if (part.callBackArg && part.symbol instanceof NonTerminal) {
            this.addProblem(Message.CALLBACK_BY_DEF, part.position, part.name);
        }
        if (part.symbol instanceof NonTerminal) {
            part.callBackArg = true;
        }
    }

    private void tcheckJavaType(JavaType javaType) {
        String prefix;
        String className = javaType.className;
        int idx = className.indexOf(46);
        String string = prefix = idx == -1 ? className : Strings.slice((String)className, null, (Integer)idx);
        if (this.symtable.contains(prefix)) {
            SeTextObject obj = this.symtable.get(prefix);
            if (!(obj instanceof ImportDecl)) {
                this.addProblem(Message.IMPORT_INVALID_REF, javaType.position, prefix);
                throw new SemanticException();
            }
            ImportDecl imp = (ImportDecl)obj;
            imp.used = true;
            if (imp.javaType.genericTypeParams != null && idx != -1) {
                this.addProblem(Message.REL_REF_ON_COMPLETE_TYPE, javaType.position, javaType.className, prefix);
            }
            if (imp.javaType.genericTypeParams != null && javaType.genericTypeParams != null) {
                this.addProblem(Message.DUPL_GENERIC_TYPE_PARAMS, javaType.position, prefix);
            }
            if (imp.javaType.genericTypeParams != null && javaType.genericTypeParams == null) {
                javaType.genericTypeParams = imp.javaType.genericTypeParams;
            }
            javaType.className = imp.javaType.className + Strings.slice((String)javaType.className, (Integer)prefix.length(), null);
        }
        if (javaType.genericTypeParams != null) {
            for (JavaType param : javaType.genericTypeParams) {
                this.tcheckJavaType(param);
            }
        }
    }

    private void tcheckStartSymbols() {
        int cnt = 0;
        Map startNonTerms = Maps.map();
        for (Decl decl : this.spec.decls) {
            NonTerminal symbol;
            if (!(decl instanceof StartSymbol)) continue;
            ++cnt;
            StartSymbol start = (StartSymbol)decl;
            if (!this.symtable.contains(start.name.id)) {
                this.addProblem(Message.NONTERM_UNDEFINED, start.name.position, start.name.id);
                throw new SemanticException();
            }
            SeTextObject obj = this.symtable.get(start.name.id);
            if (!(obj instanceof NonTerminal)) {
                this.addProblem(Message.NONTERM_INVALID_REF, start.name.position, start.name.id);
                throw new SemanticException();
            }
            start.symbol = symbol = (NonTerminal)obj;
            this.tcheckJavaType(start.javaType);
            if (start.main) {
                this.spec.mainSymbols.add(start);
            } else {
                this.spec.startSymbols.add(start);
            }
            if (start.javaType.genericTypeParams != null) {
                this.addProblem(Message.PARSER_CLASS_GENERIC, start.javaType.position, start.javaType.toString(), start.getStartType(), start.name.id);
            }
            if (startNonTerms.containsKey(symbol)) {
                this.addProblem(Message.START_DUPL, start.position, symbol.name);
                this.addProblem(Message.START_DUPL, (TextPosition)startNonTerms.get(symbol), symbol.name);
                continue;
            }
            startNonTerms.put(symbol, start.position);
        }
        if (cnt == 0) {
            for (NonTerminal nonterm : this.spec.nonterminals) {
                if (nonterm.generated) continue;
                this.addProblem(Message.NO_START_SYMBOL, this.spec.position, new String[0]);
                break;
            }
        }
    }

    private void checkUnusedImports() {
        for (Decl decl : this.spec.decls) {
            if (!(decl instanceof ImportDecl)) continue;
            ImportDecl imp = (ImportDecl)decl;
            if (imp.used) continue;
            this.addProblem(Message.IMPORT_UNUSED, decl.position, imp.name);
        }
    }

    private void removeUnusedGeneratedNonTerminals() {
        Set usedNonTerminals = Sets.set();
        for (NonTerminal nonterm : this.spec.nonterminals) {
            for (ParserRule rule : nonterm.rules) {
                for (ParserRulePart part : rule.symbols) {
                    if (!(part.symbol instanceof NonTerminal)) continue;
                    usedNonTerminals.add((NonTerminal)part.symbol);
                }
            }
        }
        for (StartSymbol start : this.spec.mainSymbols) {
            usedNonTerminals.add(start.symbol);
        }
        for (StartSymbol start : this.spec.startSymbols) {
            usedNonTerminals.add(start.symbol);
        }
        Set unusedNonTerminals = Sets.list2set((List)this.spec.nonterminals);
        unusedNonTerminals.removeAll(usedNonTerminals);
        Iterator iter = this.spec.nonterminals.iterator();
        while (iter.hasNext()) {
            NonTerminal nonterm = (NonTerminal)iter.next();
            if (!nonterm.generated || !unusedNonTerminals.contains(nonterm)) continue;
            iter.remove();
        }
    }

    private void checkUnusedSymbols() {
        Set usedTerminals = Sets.set();
        Set usedNonTerminals = Sets.set();
        for (NonTerminal nonterm : this.spec.nonterminals) {
            for (ParserRule rule : nonterm.rules) {
                for (ParserRulePart part : rule.symbols) {
                    Symbol symbol = part.symbol;
                    if (symbol == null) continue;
                    if (symbol instanceof Terminal) {
                        usedTerminals.add((Terminal)symbol);
                        continue;
                    }
                    Assert.check((boolean)(symbol instanceof NonTerminal));
                    usedNonTerminals.add((NonTerminal)symbol);
                }
            }
        }
        for (StartSymbol start : this.spec.mainSymbols) {
            usedNonTerminals.add(start.symbol);
        }
        for (StartSymbol start : this.spec.startSymbols) {
            usedNonTerminals.add(start.symbol);
        }
        Set unusedTerminals = Sets.list2set((List)this.spec.terminals);
        Set unusedNonTerminals = Sets.list2set((List)this.spec.nonterminals);
        unusedTerminals.removeAll(usedTerminals);
        unusedNonTerminals.removeAll(usedNonTerminals);
        if (!this.spec.nonterminals.isEmpty()) {
            for (Terminal terminal : unusedTerminals) {
                if (terminal.name == null) continue;
                this.addProblem(Message.TERM_UNUSED, terminal.position, terminal.name);
            }
        }
        for (NonTerminal nonterminal : unusedNonTerminals) {
            Assert.notNull((Object)nonterminal.name);
            this.addProblem(Message.NONTERM_UNUSED, nonterminal.position, nonterminal.name);
        }
    }

    private void checkUnreachableNonTerminals() {
        Set unreachables = Sets.list2set((List)this.spec.nonterminals);
        for (StartSymbol start : this.spec.getStartSymbols()) {
            Set<NonTerminal> reachables = SeTextTypeChecker.getReachableNonTerms(start.symbol);
            unreachables.removeAll(reachables);
        }
        for (NonTerminal unreachable : unreachables) {
            this.addProblem(Message.NONTERM_UNREACHABLE, unreachable.position, unreachable.name);
        }
    }

    private void checkMainSymbols() {
        for (StartSymbol main : this.spec.mainSymbols) {
            Set<NonTerminal> reachables = SeTextTypeChecker.getReachableNonTerms(main.symbol);
            Set unreachables = Sets.list2set((List)this.spec.nonterminals);
            unreachables.removeAll(reachables);
            if (unreachables.isEmpty()) continue;
            List names = Lists.list();
            for (NonTerminal unreachable : unreachables) {
                names.add(unreachable.name);
            }
            Collections.sort(names, Strings.SORTER);
            this.addProblem(Message.MAIN_UNREACHABLES, main.position, main.name.id, String.join((CharSequence)", ", names));
        }
    }

    public static Set<NonTerminal> getReachableNonTerms(NonTerminal start) {
        Set rslt = Sets.set((Object)start);
        Stack<NonTerminal> unprocesseds = new Stack<NonTerminal>();
        unprocesseds.add(start);
        while (!unprocesseds.isEmpty()) {
            NonTerminal todo = (NonTerminal)unprocesseds.pop();
            rslt.add(todo);
            Set candidates = Sets.set();
            for (ParserRule rule : todo.rules) {
                for (ParserRulePart part : rule.symbols) {
                    if (!(part.symbol instanceof NonTerminal)) continue;
                    candidates.add((NonTerminal)part.symbol);
                }
            }
            for (NonTerminal candidate : candidates) {
                if (rslt.contains(candidate) || unprocesseds.contains(candidate)) continue;
                unprocesseds.add(candidate);
            }
        }
        return rslt;
    }

    private void tcheckHooksClass() {
        List hooksDecls = Lists.filter((List)this.spec.decls, HooksDecl.class);
        if (hooksDecls.size() > 1) {
            for (HooksDecl hooksDecl : hooksDecls) {
                this.addProblem(Message.HOOKS_DECL_DUPL, hooksDecl.position, new String[0]);
            }
            throw new SemanticException();
        }
        boolean needed = false;
        for (Terminal terminal : this.spec.terminals) {
            if (terminal.func == null) continue;
            needed = true;
            break;
        }
        if (!needed) {
            for (NonTerminal nonterminal : this.spec.nonterminals) {
                if (nonterminal.generated) continue;
                needed = true;
                break;
            }
        }
        if (needed && hooksDecls.isEmpty()) {
            this.addProblem(Message.HOOKS_DECL_MISSING, this.spec.position, new String[0]);
            throw new SemanticException();
        }
        if (hooksDecls.isEmpty()) {
            return;
        }
        JavaType hooksClass = ((HooksDecl)Lists.first((List)hooksDecls)).hooksClass;
        this.tcheckJavaType(hooksClass);
        if (hooksClass.genericTypeParams != null) {
            this.addProblem(Message.HOOKS_DECL_GENERIC, hooksClass.position, new String[0]);
        }
        this.spec.hooksClass = hooksClass;
    }

    private void tcheckScannerClass() {
        boolean needed;
        List scannerDecls = Lists.filter((List)this.spec.decls, ScannerDecl.class);
        if (scannerDecls.size() > 1) {
            for (ScannerDecl scannerDecl : scannerDecls) {
                this.addProblem(Message.SCANNER_DECL_DUPL, scannerDecl.position, new String[0]);
            }
            throw new SemanticException();
        }
        boolean bl = needed = !this.spec.terminals.isEmpty();
        if (needed && scannerDecls.isEmpty()) {
            this.addProblem(Message.SCANNER_DECL_MISSING, this.spec.position, new String[0]);
            throw new SemanticException();
        }
        if (scannerDecls.isEmpty()) {
            return;
        }
        JavaType scannerClass = ((ScannerDecl)Lists.first((List)scannerDecls)).scannerClass;
        this.tcheckJavaType(scannerClass);
        if (scannerClass.genericTypeParams != null) {
            this.addProblem(Message.SCANNER_DECL_GENERIC, scannerClass.position, new String[0]);
        }
        this.spec.scannerClass = scannerClass;
    }

    private void checkDuplicateGenClasses() {
        Map classNames = Maps.map();
        for (StartSymbol start : this.spec.getStartSymbols()) {
            String className = start.javaType.className;
            if (classNames.containsKey(className)) {
                this.addProblem(Message.GEN_CLASS_DUPL, start.javaType.position, className);
                this.addProblem(Message.GEN_CLASS_DUPL, (TextPosition)classNames.get(className), className);
                continue;
            }
            classNames.put(className, start.javaType.position);
        }
        if (this.spec.scannerClass != null) {
            String className = this.spec.scannerClass.className;
            if (classNames.containsKey(className)) {
                this.addProblem(Message.GEN_CLASS_DUPL, this.spec.scannerClass.position, className);
                this.addProblem(Message.GEN_CLASS_DUPL, (TextPosition)classNames.get(className), className);
            } else {
                classNames.put(className, this.spec.scannerClass.position);
            }
        }
    }
}

