/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.launchConfigurations;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.ui.ILaunchGroup;
import org.eclipse.jface.resource.ImageDescriptor;

public class LaunchGroupExtension
implements ILaunchGroup {
    private IConfigurationElement fConfig;
    private ImageDescriptor fImageDescriptor;
    private ImageDescriptor fBannerImageDescriptor;

    public LaunchGroupExtension(IConfigurationElement element) {
        this.setConfigurationElement(element);
    }

    private void setConfigurationElement(IConfigurationElement element) {
        this.fConfig = element;
    }

    protected IConfigurationElement getConfigurationElement() {
        return this.fConfig;
    }

    @Override
    public ImageDescriptor getImageDescriptor() {
        if (this.fImageDescriptor == null) {
            this.fImageDescriptor = this.createImageDescriptor("image");
        }
        return this.fImageDescriptor;
    }

    @Override
    public ImageDescriptor getBannerImageDescriptor() {
        if (this.fBannerImageDescriptor == null) {
            this.fBannerImageDescriptor = this.createImageDescriptor("bannerImage");
        }
        return this.fBannerImageDescriptor;
    }

    @Override
    public String getLabel() {
        return this.getConfigurationElement().getAttribute("label");
    }

    @Override
    public String getIdentifier() {
        return this.getConfigurationElement().getAttribute("id");
    }

    @Override
    public String getCategory() {
        return this.getConfigurationElement().getAttribute("category");
    }

    @Override
    public String getMode() {
        return this.getConfigurationElement().getAttribute("mode");
    }

    protected ImageDescriptor createImageDescriptor(String attribute) {
        return DebugUIPlugin.getImageDescriptor(this.getConfigurationElement(), attribute);
    }

    @Override
    public boolean isPublic() {
        String string = this.getConfigurationElement().getAttribute("public");
        if (string == null) {
            return true;
        }
        return string.equals("true");
    }
}

