/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.cif2yed;

import java.awt.geom.Rectangle2D;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.escet.cif.cif2cif.RemoveAnnotations;
import org.eclipse.escet.cif.cif2yed.CifToYedColors;
import org.eclipse.escet.cif.cif2yed.CifToYedDiagram;
import org.eclipse.escet.cif.cif2yed.CifToYedRelationsDiagramPreChecker;
import org.eclipse.escet.cif.cif2yed.options.RelationKind;
import org.eclipse.escet.cif.cif2yed.options.RelationKindsOption;
import org.eclipse.escet.cif.common.CifEquationUtils;
import org.eclipse.escet.cif.common.CifScopeUtils;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.common.CifTypeUtils;
import org.eclipse.escet.cif.metamodel.cif.AlgParameter;
import org.eclipse.escet.cif.metamodel.cif.ComplexComponent;
import org.eclipse.escet.cif.metamodel.cif.Component;
import org.eclipse.escet.cif.metamodel.cif.ComponentDef;
import org.eclipse.escet.cif.metamodel.cif.ComponentInst;
import org.eclipse.escet.cif.metamodel.cif.Equation;
import org.eclipse.escet.cif.metamodel.cif.EventParameter;
import org.eclipse.escet.cif.metamodel.cif.Group;
import org.eclipse.escet.cif.metamodel.cif.LocationParameter;
import org.eclipse.escet.cif.metamodel.cif.Parameter;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.SupKind;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.automata.Edge;
import org.eclipse.escet.cif.metamodel.cif.automata.EdgeEvent;
import org.eclipse.escet.cif.metamodel.cif.automata.EdgeReceive;
import org.eclipse.escet.cif.metamodel.cif.automata.EdgeSend;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.metamodel.cif.declarations.AlgVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.ContVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.Declaration;
import org.eclipse.escet.cif.metamodel.cif.declarations.DiscVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.Event;
import org.eclipse.escet.cif.metamodel.cif.declarations.InputVariable;
import org.eclipse.escet.cif.metamodel.cif.expressions.AlgVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.CompInstWrapExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.CompParamWrapExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ContVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.DiscVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.expressions.InputVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.LocationExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.TauExpression;
import org.eclipse.escet.cif.metamodel.cif.functions.Function;
import org.eclipse.escet.cif.metamodel.java.CifWalker;
import org.eclipse.escet.cif.prettyprinter.CifPrettyPrinter;
import org.eclipse.escet.common.app.framework.output.OutputProvider;
import org.eclipse.escet.common.emf.EMFHelper;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Pair;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.java.Termination;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CifToYedRelationsDiagram
extends CifToYedDiagram {
    private EnumSet<RelationKind> relations;
    private Set<String> instIds;
    private Set<String> compIds;
    private Set<String> boxIds;
    private Set<Pair<String, String>> paramRefIds;
    private Set<Pair<Element, String>> dataRefIds;
    private Map<Pair<String, String>, Element> dataEdgeElems;
    private long nextFreeEvtRefId;
    private long nextFreeDataRefId;
    private Map<ComponentDef, String> compDefMap;

    @Override
    protected void addSpec(Specification spec, String absSpecPath, Element root, Termination termination) {
        spec = (Specification)EMFHelper.deepclone((EObject)spec);
        new RemoveAnnotations().transform(spec);
        CifToYedRelationsDiagramPreChecker checker = new CifToYedRelationsDiagramPreChecker(termination);
        checker.reportPreconditionViolations(spec, absSpecPath, "CIF to yEd transformer");
        this.relations = RelationKindsOption.getKinds();
        this.rootGraph = null;
        this.instIds = Sets.set();
        this.compIds = Sets.set();
        this.boxIds = Sets.set();
        this.paramRefIds = Sets.set();
        this.dataRefIds = Sets.set();
        this.dataEdgeElems = Maps.map();
        this.nextFreeEvtRefId = 0L;
        this.nextFreeDataRefId = 0L;
        this.compDefMap = Maps.map();
        if (this.relations.isEmpty()) {
            OutputProvider.warn((String)"Relation diagram will not include any relations, as no relations have been specified.");
        }
        this.addComponent((Component)spec, false, false, false, root, "cif");
        this.removeInstInternalEdges(root);
        Set edgeSrcTgtIds = Sets.set();
        this.collectEdgeSrcTgtIds(root, edgeSrcTgtIds);
        this.removeInstInternalNodes(root, edgeSrcTgtIds);
        this.removeEmptyComps(root);
    }

    private void addComponent(Component comp, boolean notBody, boolean defBody, boolean instBody, Element parent, String id) {
        int i;
        Object title;
        boolean wrapper;
        boolean isBody = comp.eContainer() instanceof ComponentDef;
        int cntBody = 0;
        if (notBody) {
            ++cntBody;
        }
        if (defBody) {
            ++cntBody;
        }
        if (instBody) {
            ++cntBody;
        }
        Assert.check((cntBody == (isBody ? 1 : 0) ? 1 : 0) != 0);
        boolean asBody = defBody || instBody;
        boolean bl = wrapper = isBody && !asBody || !isBody && comp instanceof ComponentInst;
        if (!asBody && !(comp instanceof Specification)) {
            CifToYedColors bgColor;
            Object kindText;
            Element nodeElem = this.doc.createElement("node");
            parent.appendChild(nodeElem);
            nodeElem.setAttribute("id", id);
            parent = nodeElem;
            this.compIds.add(id);
            ComponentDef cdef = null;
            if (comp instanceof ComponentInst) {
                ComponentInst inst = (ComponentInst)comp;
                cdef = CifTypeUtils.getCompDefFromCompInst((ComponentInst)inst);
            } else if (isBody) {
                cdef = (ComponentDef)comp.eContainer();
            }
            Component body = comp;
            if (cdef != null) {
                body = cdef.getBody();
            }
            boolean isAut = body instanceof Automaton;
            boolean isGroup = body instanceof Group;
            if (isAut) {
                kindText = "automaton";
                SupKind kind = ((Automaton)body).getKind();
                if (kind != SupKind.NONE) {
                    kindText = CifTextUtils.kindToStr((SupKind)kind) + " " + (String)kindText;
                }
            } else if (isGroup) {
                kindText = "group";
            } else {
                throw new RuntimeException("Unknown body: " + String.valueOf(body));
            }
            String name = comp.getName();
            if (cdef == null) {
                title = (String)kindText + " " + name;
                bgColor = CifToYedColors.COMP_HEADER_COLOR;
            } else if (comp instanceof ComponentInst) {
                ComponentInst inst = (ComponentInst)comp;
                CifPrettyPrinter pprinter = new CifPrettyPrinter(null);
                String cdefRefTxt = pprinter.pprint(inst.getDefinition());
                title = Strings.fmt((String)"%s: %s()", (Object[])new Object[]{name, cdefRefTxt});
                bgColor = CifToYedColors.INST_HEADER_COLOR;
            } else {
                title = Strings.fmt((String)"%s def %s()", (Object[])new Object[]{kindText, name});
                bgColor = CifToYedColors.DEF_HEADER_COLOR;
            }
            nodeElem.setAttribute("yfiles.foldertype", "folder");
            Element dnDataElem = this.doc.createElement("data");
            nodeElem.appendChild(dnDataElem);
            dnDataElem.setAttribute("key", "dn");
            dnDataElem.setTextContent((String)title);
            Element ngDataElem = this.doc.createElement("data");
            nodeElem.appendChild(ngDataElem);
            ngDataElem.setAttribute("key", "ng");
            Element pabnElem = this.doc.createElement("y:ProxyAutoBoundsNode");
            ngDataElem.appendChild(pabnElem);
            Element realElem = this.doc.createElement("y:Realizers");
            pabnElem.appendChild(realElem);
            realElem.setAttribute("active", "1");
            Iterator iterator = Lists.list((Object[])new Boolean[]{false, true}).iterator();
            while (iterator.hasNext()) {
                boolean closed = (Boolean)iterator.next();
                Element gnElem = this.doc.createElement("y:GroupNode");
                realElem.appendChild(gnElem);
                if (closed) {
                    Element geoElem = this.doc.createElement("y:Geometry");
                    gnElem.appendChild(geoElem);
                    Rectangle2D size = this.guessTextSize((String)title, 5);
                    double width = size.getWidth() + 40.0;
                    double height = size.getHeight();
                    geoElem.setAttribute("width", Strings.str((Object)width));
                    geoElem.setAttribute("height", Strings.str((Object)height));
                }
                Object label = title;
                label = Strings.spaces((int)5) + (String)label;
                label = this.highlight((String)label);
                Element nlElem = this.doc.createElement("y:NodeLabel");
                gnElem.appendChild(nlElem);
                nlElem.setAttribute("alignment", "left");
                nlElem.setAttribute("autoSizePolicy", "node_width");
                nlElem.setAttribute("backgroundColor", bgColor.color);
                nlElem.setAttribute("modelName", "internal");
                nlElem.setAttribute("modelPosition", "t");
                nlElem.setAttribute("fontStyle", isGroup ? "italic" : "plain");
                nlElem.setTextContent((String)label);
                Element fillElem = this.doc.createElement("y:Fill");
                gnElem.appendChild(fillElem);
                CifToYedColors fc = closed ? CifToYedColors.COMP_BG_CLOSED_COLOR : CifToYedColors.COMP_BG_OPENED_COLOR;
                fillElem.setAttribute("color", fc.color);
                Element shapeElem = this.doc.createElement("y:Shape");
                gnElem.appendChild(shapeElem);
                shapeElem.setAttribute("type", "rectangle");
                Element stateElem = this.doc.createElement("y:State");
                gnElem.appendChild(stateElem);
                stateElem.setAttribute("closed", Strings.str((Object)closed));
            }
        }
        if (!asBody) {
            Element graphElem = this.doc.createElement("graph");
            parent.appendChild(graphElem);
            graphElem.setAttribute("id", id + ":");
            graphElem.setAttribute("edgedefault", "undirected");
            parent = graphElem;
        }
        if (comp instanceof Specification) {
            this.rootGraph = parent;
        }
        if (!wrapper) {
            String childId;
            boolean BOX_DEFS = false;
            boolean BOX_COMPS = true;
            String[] boxNames = new String[]{"Component definitions", "Components"};
            Element[] boxes = new Element[boxNames.length];
            i = 0;
            while (i < boxes.length) {
                Element nodeElem = this.doc.createElement("node");
                parent.appendChild(nodeElem);
                Assert.check((!id.endsWith(":") ? 1 : 0) != 0);
                Element graphElem = this.doc.createElement("graph");
                nodeElem.appendChild(graphElem);
                graphElem.setAttribute("edgedefault", "undirected");
                boxes[i] = graphElem;
                nodeElem.setAttribute("id", id);
                graphElem.setAttribute("id", id + ":");
                title = boxNames[i];
                nodeElem.setAttribute("yfiles.foldertype", "folder");
                Element dnDataElem = this.doc.createElement("data");
                nodeElem.appendChild(dnDataElem);
                dnDataElem.setAttribute("key", "dn");
                dnDataElem.setTextContent((String)title);
                Element ngDataElem = this.doc.createElement("data");
                nodeElem.appendChild(ngDataElem);
                ngDataElem.setAttribute("key", "ng");
                Element pabnElem = this.doc.createElement("y:ProxyAutoBoundsNode");
                ngDataElem.appendChild(pabnElem);
                Element realElem = this.doc.createElement("y:Realizers");
                pabnElem.appendChild(realElem);
                realElem.setAttribute("active", "1");
                Iterator iterator = Lists.list((Object[])new Boolean[]{false, true}).iterator();
                while (iterator.hasNext()) {
                    boolean closed = (Boolean)iterator.next();
                    Element gnElem = this.doc.createElement("y:GroupNode");
                    realElem.appendChild(gnElem);
                    if (closed) {
                        Element geoElem = this.doc.createElement("y:Geometry");
                        gnElem.appendChild(geoElem);
                        Rectangle2D size = this.guessTextSize((String)title, 5);
                        double width = size.getWidth() + 40.0;
                        double height = size.getHeight();
                        geoElem.setAttribute("width", Strings.str((Object)width));
                        geoElem.setAttribute("height", Strings.str((Object)height));
                    }
                    Object label = title;
                    label = Strings.spaces((int)5) + (String)label;
                    Element nlElem = this.doc.createElement("y:NodeLabel");
                    gnElem.appendChild(nlElem);
                    nlElem.setAttribute("alignment", "left");
                    nlElem.setAttribute("autoSizePolicy", "node_width");
                    nlElem.setAttribute("backgroundColor", CifToYedColors.WRAP_BOX_HEADER_COLOR.color);
                    nlElem.setAttribute("modelName", "internal");
                    nlElem.setAttribute("modelPosition", "t");
                    nlElem.setTextContent((String)label);
                    Element fillElem = this.doc.createElement("y:Fill");
                    gnElem.appendChild(fillElem);
                    CifToYedColors fc = closed ? CifToYedColors.COMP_BG_CLOSED_COLOR : CifToYedColors.COMP_BG_OPENED_COLOR;
                    fillElem.setAttribute("color", fc.color);
                    Element shapeElem = this.doc.createElement("y:Shape");
                    gnElem.appendChild(shapeElem);
                    shapeElem.setAttribute("type", "rectangle");
                    Element stateElem = this.doc.createElement("y:State");
                    gnElem.appendChild(stateElem);
                    stateElem.setAttribute("closed", Strings.str((Object)closed));
                }
                ++i;
            }
            if (!instBody && comp instanceof Group) {
                for (ComponentDef child : ((Group)comp).getDefinitions()) {
                    childId = id + ":" + child.getBody().getName();
                    this.addComponent((Component)child.getBody(), true, false, false, boxes[0], childId);
                }
            }
            if (comp instanceof Group) {
                for (Component child : ((Group)comp).getComponents()) {
                    childId = id + ":" + child.getName();
                    this.addComponent(child, false, false, false, boxes[1], childId);
                }
            }
            if (!wrapper && comp instanceof ComplexComponent) {
                for (Declaration decl : ((ComplexComponent)comp).getDeclarations()) {
                    if ((!this.relations.contains((Object)RelationKind.EVENT) || !(decl instanceof Event)) && (!this.relations.contains((Object)RelationKind.DATA) || !(decl instanceof AlgVariable) && !(decl instanceof ContVariable) && !(decl instanceof DiscVariable) && !(decl instanceof InputVariable))) continue;
                    String declId = id + ":" + decl.getName();
                    this.addDecl((PositionObject)decl, boxes[1], declId);
                }
            }
            if (this.relations.contains((Object)RelationKind.DATA) && !wrapper && comp instanceof Automaton) {
                Automaton aut = (Automaton)comp;
                for (Location loc : aut.getLocations()) {
                    if (loc.getName() == null) continue;
                    String declId = id + ":" + loc.getName();
                    this.addDecl((PositionObject)loc, boxes[1], declId);
                }
            }
            if (this.relations.contains((Object)RelationKind.EVENT) && !wrapper && comp instanceof Automaton) {
                Automaton aut = (Automaton)comp;
                List<Expression> syncs = this.getSyncAlphabet(aut);
                List<Expression> sends = this.getSendAlphabet(aut);
                List<Expression> recvs = this.getRecvAlphabet(aut);
                Set<String> syncIds = this.getEventRefIds(syncs);
                Set<String> sendIds = this.getEventRefIds(sends);
                Set<String> recvIds = this.getEventRefIds(recvs);
                for (String syncId : syncIds) {
                    this.addEventRef(syncId, boxes[1], "");
                }
                for (String sendId : sendIds) {
                    this.addEventRef(sendId, boxes[1], "!");
                }
                for (String recvId : recvIds) {
                    this.addEventRef(recvId, boxes[1], "?");
                }
            }
            if (this.relations.contains((Object)RelationKind.DATA) && !wrapper) {
                Assert.check((boolean)(comp instanceof ComplexComponent));
                CompRefExprCollector collector = new CompRefExprCollector();
                collector.collectRefExprs((ComplexComponent)comp);
                for (Expression ref : collector.refs) {
                    this.addDeclRef(this.getObjRefId(ref), boxes[1]);
                }
            }
            i = 0;
            while (i < boxes.length) {
                Element graphElem = boxes[i];
                Element nodeElem = (Element)graphElem.getParentNode();
                String boxId = id + "::box" + Strings.str((Object)i);
                this.boxIds.add(boxId);
                nodeElem.setAttribute("id", boxId);
                graphElem.setAttribute("id", boxId + ":");
                ++i;
            }
        }
        if (comp instanceof ComponentInst) {
            this.instIds.add(id);
        }
        if (wrapper) {
            ComponentDef cdef;
            ComponentInst inst;
            if (comp instanceof ComponentInst) {
                inst = (ComponentInst)comp;
                cdef = CifTypeUtils.getCompDefFromCompInst((ComponentInst)inst);
            } else {
                inst = null;
                cdef = (ComponentDef)comp.eContainer();
            }
            boolean isInst = inst != null;
            String prev = this.compDefMap.put(cdef, id);
            Assert.check((prev == null ? 1 : 0) != 0);
            i = 0;
            while (i < cdef.getParameters().size()) {
                boolean collect;
                String paramId;
                Parameter param = (Parameter)cdef.getParameters().get(i);
                Expression arg = null;
                if (inst != null) {
                    arg = (Expression)inst.getArguments().get(i);
                }
                if (this.relations.contains((Object)RelationKind.DATA) && param instanceof AlgParameter) {
                    AlgParameter algParam = (AlgParameter)param;
                    AlgVariable var = algParam.getVariable();
                    paramId = id + ":" + var.getName();
                    collect = true;
                } else if (this.relations.contains((Object)RelationKind.EVENT) && param instanceof EventParameter) {
                    EventParameter eventParam = (EventParameter)param;
                    Event event = eventParam.getEvent();
                    paramId = id + ":" + event.getName();
                    collect = false;
                } else if (this.relations.contains((Object)RelationKind.DATA) && param instanceof LocationParameter) {
                    LocationParameter locParam = (LocationParameter)param;
                    Location loc = locParam.getLocation();
                    paramId = id + ":" + loc.getName();
                    collect = false;
                } else {
                    paramId = null;
                    collect = false;
                }
                if (paramId != null) {
                    this.addParam(param, parent, paramId);
                    if (arg != null) {
                        if (collect) {
                            ArgRefExprCollector collector = new ArgRefExprCollector();
                            collector.collectRefExprs(arg);
                            for (Expression argRef : collector.refs) {
                                this.addParamRelation(param, paramId, argRef);
                            }
                        } else {
                            this.addParamRelation(param, paramId, arg);
                        }
                    }
                }
                ++i;
            }
            this.addComponent((Component)cdef.getBody(), false, !isInst, isInst, parent, id);
            this.compDefMap.remove(cdef);
        }
    }

    private void addDecl(PositionObject decl, Element parent, String id) {
        String prefix;
        if (decl instanceof Location && ((Location)decl).getName() == null) {
            return;
        }
        Element nodeElem = this.doc.createElement("node");
        parent.appendChild(nodeElem);
        nodeElem.setAttribute("id", id);
        if (decl instanceof Event) {
            Assert.check((boolean)this.relations.contains((Object)RelationKind.EVENT));
            prefix = "event";
        } else if (decl instanceof AlgVariable) {
            Assert.check((boolean)this.relations.contains((Object)RelationKind.DATA));
            prefix = "alg";
        } else if (decl instanceof ContVariable) {
            Assert.check((boolean)this.relations.contains((Object)RelationKind.DATA));
            prefix = "cont";
        } else if (decl instanceof DiscVariable) {
            Assert.check((boolean)this.relations.contains((Object)RelationKind.DATA));
            prefix = "disc";
        } else if (decl instanceof InputVariable) {
            Assert.check((boolean)this.relations.contains((Object)RelationKind.DATA));
            prefix = "input";
        } else if (decl instanceof Location) {
            Assert.check((boolean)this.relations.contains((Object)RelationKind.DATA));
            prefix = "location";
        } else {
            throw new RuntimeException("Unexpected decl: " + String.valueOf(decl));
        }
        Object label = prefix + " " + CifTextUtils.getName((PositionObject)decl);
        if (decl instanceof Event && ((Event)decl).getType() != null) {
            label = (String)label + " !?~";
        }
        Element dnDataElem = this.doc.createElement("data");
        nodeElem.appendChild(dnDataElem);
        dnDataElem.setAttribute("key", "dn");
        dnDataElem.setTextContent((String)label);
        Element ngDataElem = this.doc.createElement("data");
        nodeElem.appendChild(ngDataElem);
        ngDataElem.setAttribute("key", "ng");
        Element snElem = this.doc.createElement("y:ShapeNode");
        ngDataElem.appendChild(snElem);
        Element geoElem = this.doc.createElement("y:Geometry");
        snElem.appendChild(geoElem);
        geoElem.setAttribute("width", Strings.str((Object)this.guessTextWidth((String)label, 5)));
        label = this.highlight((String)label);
        Element nlElem = this.doc.createElement("y:NodeLabel");
        snElem.appendChild(nlElem);
        nlElem.setAttribute("alignment", "center");
        nlElem.setTextContent((String)label);
        Element bsElem = this.doc.createElement("y:BorderStyle");
        snElem.appendChild(bsElem);
        bsElem.setAttribute("width", "2.0");
        Element fillElem = this.doc.createElement("y:Fill");
        snElem.appendChild(fillElem);
        if (decl instanceof Event) {
            fillElem.setAttribute("color", CifToYedColors.EVENT_DECL_COLOR.color);
        } else {
            fillElem.setAttribute("color", CifToYedColors.DATA_DECL_COLOR.color);
        }
        Element shapeElem = this.doc.createElement("y:Shape");
        snElem.appendChild(shapeElem);
        shapeElem.setAttribute("type", "rectangle");
        if (!(decl instanceof Event)) {
            if (decl instanceof AlgVariable || decl instanceof ContVariable || decl instanceof DiscVariable || decl instanceof InputVariable) {
                DeclRefExprCollector collector = new DeclRefExprCollector();
                collector.collectRefExprs((Declaration)decl);
                for (Expression ref : collector.refs) {
                    this.addDeclRef(this.getObjRefId(ref), id);
                }
            } else if (decl instanceof Location) {
                DeclRefExprCollector collector = new DeclRefExprCollector();
                collector.collectRefExprs((Location)decl);
                for (Expression ref : collector.refs) {
                    this.addDeclRef(this.getObjRefId(ref), id);
                }
            } else {
                throw new RuntimeException("Unexpected decl: " + String.valueOf(decl));
            }
        }
    }

    private void addParam(Parameter param, Element parent, String id) {
        EventParameter eventParam;
        String name;
        String prefix;
        Element nodeElem = this.doc.createElement("node");
        parent.appendChild(nodeElem);
        nodeElem.setAttribute("id", id);
        if (param instanceof EventParameter) {
            Assert.check((boolean)this.relations.contains((Object)RelationKind.EVENT));
            Event event = ((EventParameter)param).getEvent();
            prefix = "event";
            name = event.getName();
        } else if (param instanceof LocationParameter) {
            Assert.check((boolean)this.relations.contains((Object)RelationKind.DATA));
            Location loc = ((LocationParameter)param).getLocation();
            prefix = "location";
            name = loc.getName();
        } else if (param instanceof AlgParameter) {
            Assert.check((boolean)this.relations.contains((Object)RelationKind.DATA));
            AlgVariable var = ((AlgParameter)param).getVariable();
            prefix = "alg";
            name = var.getName();
        } else {
            throw new RuntimeException("Unexpected param: " + String.valueOf(param));
        }
        Object label = prefix + " " + name;
        if (param instanceof EventParameter && (eventParam = (EventParameter)param).getEvent().getType() != null) {
            label = (String)label + " ";
            if (eventParam.isSendFlag()) {
                label = (String)label + "!";
            }
            if (eventParam.isRecvFlag()) {
                label = (String)label + "?";
            }
            if (eventParam.isSyncFlag()) {
                label = (String)label + "~";
            }
            if (!(eventParam.isSendFlag() || eventParam.isRecvFlag() || eventParam.isSyncFlag())) {
                label = (String)label + "!?~";
            }
        }
        Element dnDataElem = this.doc.createElement("data");
        nodeElem.appendChild(dnDataElem);
        dnDataElem.setAttribute("key", "dn");
        dnDataElem.setTextContent((String)label);
        Element nodeNgDataElem = this.doc.createElement("data");
        nodeElem.appendChild(nodeNgDataElem);
        nodeNgDataElem.setAttribute("key", "ng");
        Element nodeSnElem = this.doc.createElement("y:ShapeNode");
        nodeNgDataElem.appendChild(nodeSnElem);
        Element nodeGeoElem = this.doc.createElement("y:Geometry");
        nodeSnElem.appendChild(nodeGeoElem);
        nodeGeoElem.setAttribute("width", Strings.str((Object)this.guessTextWidth((String)label, 5)));
        label = this.highlight((String)label);
        Element nodeNlElem = this.doc.createElement("y:NodeLabel");
        nodeSnElem.appendChild(nodeNlElem);
        nodeNlElem.setAttribute("alignment", "center");
        nodeNlElem.setTextContent((String)label);
        Element nodeBsElem = this.doc.createElement("y:BorderStyle");
        nodeSnElem.appendChild(nodeBsElem);
        nodeBsElem.setAttribute("type", "dashed");
        Element nodeFillElem = this.doc.createElement("y:Fill");
        nodeSnElem.appendChild(nodeFillElem);
        if (param instanceof EventParameter) {
            nodeFillElem.setAttribute("color", CifToYedColors.EVENT_PARAM_COLOR.color);
        } else {
            nodeFillElem.setAttribute("color", CifToYedColors.DATA_PARAM_COLOR.color);
        }
        Element nodeShapeElem = this.doc.createElement("y:Shape");
        nodeSnElem.appendChild(nodeShapeElem);
        nodeShapeElem.setAttribute("type", "octagon");
    }

    private void addParamRelation(Parameter param, String id, Expression ref) {
        String targetArrowStyle;
        String sourceArrowStyle;
        String targetId;
        String sourceId;
        boolean directed;
        if (param instanceof EventParameter) {
            EventParameter eventParam = (EventParameter)param;
            if (eventParam.isSendFlag() && !eventParam.isRecvFlag()) {
                directed = true;
                sourceId = id;
                targetId = this.getEventRefId(ref);
                sourceArrowStyle = "none";
                targetArrowStyle = "arrow";
            } else if (!eventParam.isSendFlag() && eventParam.isRecvFlag()) {
                directed = true;
                sourceId = this.getEventRefId(ref);
                targetId = id;
                sourceArrowStyle = "none";
                targetArrowStyle = "arrow";
            } else {
                directed = false;
                sourceId = this.getEventRefId(ref);
                targetId = id;
                sourceArrowStyle = eventParam.isSendFlag() ? "arrow" : "none";
                targetArrowStyle = eventParam.isRecvFlag() ? "arrow" : "none";
            }
        } else {
            directed = true;
            sourceId = this.getObjRefId(ref);
            targetId = id;
            sourceArrowStyle = "none";
            targetArrowStyle = "arrow";
        }
        Assert.notNull((Object)sourceId);
        Assert.notNull((Object)targetId);
        Pair srcTgtIds = Pair.pair((Object)sourceId, (Object)targetId);
        if (this.paramRefIds.contains(srcTgtIds)) {
            return;
        }
        this.paramRefIds.add((Pair<String, String>)srcTgtIds);
        Element edgeElem = this.doc.createElement("edge");
        this.rootGraph.appendChild(edgeElem);
        edgeElem.setAttribute("source", sourceId);
        edgeElem.setAttribute("target", targetId);
        edgeElem.setAttribute("directed", Strings.str((Object)directed));
        Element edgeEgDataElem = this.doc.createElement("data");
        edgeElem.appendChild(edgeEgDataElem);
        edgeEgDataElem.setAttribute("key", "eg");
        Element edgePleElem = this.doc.createElement("y:PolyLineEdge");
        edgeEgDataElem.appendChild(edgePleElem);
        Element edgeArrElem = this.doc.createElement("y:Arrows");
        edgePleElem.appendChild(edgeArrElem);
        edgeArrElem.setAttribute("source", sourceArrowStyle);
        edgeArrElem.setAttribute("target", targetArrowStyle);
        Element edgeBsElem = this.doc.createElement("y:BendStyle");
        edgePleElem.appendChild(edgeBsElem);
        edgeBsElem.setAttribute("smoothed", "true");
    }

    private void addEventRef(String eventRefId, Element parent, String direction) {
        String targetArrowStyle;
        String sourceArrowStyle;
        Object targetId;
        Object sourceId;
        Assert.check((boolean)this.relations.contains((Object)RelationKind.EVENT));
        Element nodeElem = this.doc.createElement("node");
        parent.appendChild(nodeElem);
        Object nodeId = parent.getAttribute("id");
        Assert.check((boolean)((String)nodeId).endsWith(":"));
        nodeId = (String)nodeId + ":evtref" + Strings.str((Object)this.nextFreeEvtRefId);
        nodeElem.setAttribute("id", (String)nodeId);
        ++this.nextFreeEvtRefId;
        int idx = eventRefId.lastIndexOf(58);
        String eventName = eventRefId.substring(idx + 1);
        Object label = eventName;
        if (!direction.isEmpty()) {
            label = (String)label + " " + direction;
        }
        Element dnDataElem = this.doc.createElement("data");
        nodeElem.appendChild(dnDataElem);
        dnDataElem.setAttribute("key", "dn");
        dnDataElem.setTextContent((String)label);
        Element nodeNgDataElem = this.doc.createElement("data");
        nodeElem.appendChild(nodeNgDataElem);
        nodeNgDataElem.setAttribute("key", "ng");
        Element nodeSnElem = this.doc.createElement("y:ShapeNode");
        nodeNgDataElem.appendChild(nodeSnElem);
        label = direction;
        label = this.highlight((String)label);
        Element nodeGeoElem = this.doc.createElement("y:Geometry");
        nodeSnElem.appendChild(nodeGeoElem);
        nodeGeoElem.setAttribute("width", "30");
        nodeGeoElem.setAttribute("height", "30");
        if (!((String)label).isEmpty()) {
            Element nodeNlElem = this.doc.createElement("y:NodeLabel");
            nodeSnElem.appendChild(nodeNlElem);
            nodeNlElem.setAttribute("alignment", "center");
            nodeNlElem.setAttribute("fontSize", "20");
            nodeNlElem.setTextContent((String)label);
        }
        Element nodeFillElem = this.doc.createElement("y:Fill");
        nodeSnElem.appendChild(nodeFillElem);
        nodeFillElem.setAttribute("color", CifToYedColors.EVENT_REF_COLOR.color);
        Element nodeShapeElem = this.doc.createElement("y:Shape");
        nodeSnElem.appendChild(nodeShapeElem);
        nodeShapeElem.setAttribute("type", "ellipse");
        if (direction.equals("!")) {
            sourceId = nodeId;
            targetId = eventRefId;
            sourceArrowStyle = "none";
            targetArrowStyle = "arrow";
        } else if (direction.equals("?")) {
            sourceId = eventRefId;
            targetId = nodeId;
            sourceArrowStyle = "none";
            targetArrowStyle = "arrow";
        } else {
            Assert.check((boolean)direction.isEmpty());
            sourceId = eventRefId;
            targetId = nodeId;
            sourceArrowStyle = "none";
            targetArrowStyle = "none";
        }
        Element edgeElem = this.doc.createElement("edge");
        this.rootGraph.appendChild(edgeElem);
        edgeElem.setAttribute("source", (String)sourceId);
        edgeElem.setAttribute("target", (String)targetId);
        edgeElem.setAttribute("directed", Strings.str((Object)(!direction.isEmpty() ? 1 : 0)));
        Element edgeEgDataElem = this.doc.createElement("data");
        edgeElem.appendChild(edgeEgDataElem);
        edgeEgDataElem.setAttribute("key", "eg");
        Element edgePleElem = this.doc.createElement("y:PolyLineEdge");
        edgeEgDataElem.appendChild(edgePleElem);
        Element edgeArrElem = this.doc.createElement("y:Arrows");
        edgePleElem.appendChild(edgeArrElem);
        edgeArrElem.setAttribute("source", sourceArrowStyle);
        edgeArrElem.setAttribute("target", targetArrowStyle);
        Element edgeBsElem = this.doc.createElement("y:BendStyle");
        edgePleElem.appendChild(edgeBsElem);
        edgeBsElem.setAttribute("smoothed", "true");
    }

    private void addDeclRef(String refId, Element parent) {
        Assert.check((boolean)this.relations.contains((Object)RelationKind.DATA));
        Pair info = Pair.pair((Object)parent, (Object)refId);
        boolean present = this.dataRefIds.contains(info);
        if (present) {
            return;
        }
        this.dataRefIds.add((Pair<Element, String>)info);
        Element nodeElem = this.doc.createElement("node");
        parent.appendChild(nodeElem);
        Object nodeId = parent.getAttribute("id");
        Assert.check((boolean)((String)nodeId).endsWith(":"));
        nodeId = (String)nodeId + ":dataref" + this.nextFreeDataRefId;
        nodeElem.setAttribute("id", (String)nodeId);
        ++this.nextFreeDataRefId;
        int idx = refId.lastIndexOf(58);
        String declName = refId.substring(idx + 1);
        Element dnDataElem = this.doc.createElement("data");
        nodeElem.appendChild(dnDataElem);
        dnDataElem.setAttribute("key", "dn");
        dnDataElem.setTextContent(declName);
        Element nodeNgDataElem = this.doc.createElement("data");
        nodeElem.appendChild(nodeNgDataElem);
        nodeNgDataElem.setAttribute("key", "ng");
        Element nodeSnElem = this.doc.createElement("y:ShapeNode");
        nodeNgDataElem.appendChild(nodeSnElem);
        Element nodeGeoElem = this.doc.createElement("y:Geometry");
        nodeSnElem.appendChild(nodeGeoElem);
        nodeGeoElem.setAttribute("width", "30");
        nodeGeoElem.setAttribute("height", "30");
        Element nodeFillElem = this.doc.createElement("y:Fill");
        nodeSnElem.appendChild(nodeFillElem);
        nodeFillElem.setAttribute("color", CifToYedColors.DATA_REF_COLOR.color);
        Element nodeShapeElem = this.doc.createElement("y:Shape");
        nodeSnElem.appendChild(nodeShapeElem);
        nodeShapeElem.setAttribute("type", "ellipse");
        this.addDeclRef(refId, (String)nodeId);
    }

    private void addDeclRef(String srcId, String tgtId) {
        boolean reverse;
        Assert.check((boolean)this.relations.contains((Object)RelationKind.DATA));
        Pair srcTgtIds = Pair.pair((Object)srcId, (Object)tgtId);
        Pair tgtSrcIds = Pair.pair((Object)tgtId, (Object)srcId);
        Element edgeElem = this.dataEdgeElems.get(srcTgtIds);
        Element edgeElemRev = this.dataEdgeElems.get(tgtSrcIds);
        boolean selfLoop = srcTgtIds.equals((Object)tgtSrcIds);
        if (selfLoop) {
            Assert.check((edgeElem == edgeElemRev ? 1 : 0) != 0);
        } else {
            Assert.check((edgeElem == null || edgeElemRev == null ? 1 : 0) != 0);
        }
        boolean bl = reverse = !selfLoop && edgeElemRev != null;
        if (reverse) {
            edgeElem = edgeElemRev;
        }
        if (edgeElem == null) {
            edgeElem = this.doc.createElement("edge");
            this.rootGraph.appendChild(edgeElem);
            edgeElem.setAttribute("source", srcId);
            edgeElem.setAttribute("target", tgtId);
            edgeElem.setAttribute("directed", "true");
            this.dataEdgeElems.put((Pair<String, String>)srcTgtIds, edgeElem);
            Element edgeEgDataElem = this.doc.createElement("data");
            edgeElem.appendChild(edgeEgDataElem);
            edgeEgDataElem.setAttribute("key", "eg");
            Element edgePleElem = this.doc.createElement("y:PolyLineEdge");
            edgeEgDataElem.appendChild(edgePleElem);
            Element edgeArrElem = this.doc.createElement("y:Arrows");
            edgePleElem.appendChild(edgeArrElem);
            edgeArrElem.setAttribute("source", "none");
            edgeArrElem.setAttribute("target", "none");
            Element edgeBsElem = this.doc.createElement("y:BendStyle");
            edgePleElem.appendChild(edgeBsElem);
            edgeBsElem.setAttribute("smoothed", "true");
        }
        if (reverse) {
            edgeElem.setAttribute("directed", "false");
        }
        Element dataElem = this.getChildElem(edgeElem, "data");
        Assert.notNull((Object)dataElem);
        Element pleElem = this.getChildElem(dataElem, "y:PolyLineEdge");
        Assert.notNull((Object)pleElem);
        Element arrElem = this.getChildElem(pleElem, "y:Arrows");
        Assert.notNull((Object)arrElem);
        arrElem.setAttribute(reverse ? "source" : "target", "arrow");
    }

    private Set<String> getEventRefIds(List<Expression> eventRefs) {
        Set ids = Sets.set();
        for (Expression eventRef : eventRefs) {
            String id = this.getEventRefId(eventRef);
            if (id == null) continue;
            ids.add(id);
        }
        return ids;
    }

    private String getEventRefId(Expression eventRef) {
        if (eventRef instanceof TauExpression) {
            return null;
        }
        return this.getObjRefId(eventRef);
    }

    private String getObjRefId(Expression ref) {
        if (ref instanceof CompInstWrapExpression) {
            CompInstWrapExpression wrap = (CompInstWrapExpression)ref;
            ComponentInst inst = wrap.getInstantiation();
            String instId = this.getAbsObjRefId((PositionObject)inst);
            ComponentDef cdef = CifTypeUtils.getCompDefFromCompInst((ComponentInst)inst);
            return this.getViaRefObjId(wrap.getReference(), cdef, instId);
        }
        if (ref instanceof CompParamWrapExpression) {
            throw new RuntimeException("Unsupported: shouldn't get here.");
        }
        PositionObject obj = CifScopeUtils.getRefObjFromRef((Expression)ref);
        return this.getAbsObjRefId(obj);
    }

    private String getAbsObjRefId(PositionObject obj) {
        PositionObject objScope = CifScopeUtils.getScope((PositionObject)obj);
        PositionObject objRoot = CifScopeUtils.getScopeRoot((PositionObject)objScope);
        if (objRoot instanceof Specification) {
            String name = CifTextUtils.getAbsName((PositionObject)obj, (boolean)false);
            return "cif:" + name.replace('.', ':');
        }
        Assert.check((boolean)(objRoot instanceof ComponentDef));
        ComponentDef cdef = (ComponentDef)objRoot;
        String compId = this.compDefMap.get(cdef);
        Assert.notNull((Object)compId);
        return compId + ":" + this.getRelObjId(objRoot, obj);
    }

    private String getRelObjId(PositionObject root, PositionObject obj) {
        Assert.check((root != obj ? 1 : 0) != 0);
        Object rslt = CifTextUtils.getName((PositionObject)obj);
        PositionObject scope = CifScopeUtils.getScope((PositionObject)obj);
        while (scope != root) {
            rslt = CifTextUtils.getName((PositionObject)scope) + ":" + (String)rslt;
            scope = CifScopeUtils.getScope((PositionObject)scope);
        }
        return rslt;
    }

    private String getViaRefObjId(Expression ref, ComponentDef cdef, String instId) {
        if (ref instanceof CompInstWrapExpression) {
            CompInstWrapExpression wrap = (CompInstWrapExpression)ref;
            ComponentInst inst = wrap.getInstantiation();
            String childInstId = instId + ":" + this.getRelObjId((PositionObject)cdef, (PositionObject)inst);
            ComponentDef childCdef = CifTypeUtils.getCompDefFromCompInst((ComponentInst)inst);
            return this.getViaRefObjId(wrap.getReference(), childCdef, childInstId);
        }
        if (ref instanceof CompParamWrapExpression) {
            throw new RuntimeException("via something -> via param -> ref");
        }
        PositionObject obj = CifScopeUtils.getRefObjFromRef((Expression)ref);
        return instId + ":" + this.getRelObjId((PositionObject)cdef, obj);
    }

    private List<Expression> getSyncAlphabet(Automaton aut) {
        if (aut.getAlphabet() != null) {
            return aut.getAlphabet().getEvents();
        }
        List alphabet = Lists.list();
        for (Location loc : aut.getLocations()) {
            for (Edge edge : loc.getEdges()) {
                for (EdgeEvent edgeEvent : edge.getEvents()) {
                    if (edgeEvent instanceof EdgeSend || edgeEvent instanceof EdgeReceive) continue;
                    alphabet.add(edgeEvent.getEvent());
                }
            }
        }
        return alphabet;
    }

    private List<Expression> getSendAlphabet(Automaton aut) {
        List alphabet = Lists.list();
        for (Location loc : aut.getLocations()) {
            for (Edge edge : loc.getEdges()) {
                for (EdgeEvent edgeEvent : edge.getEvents()) {
                    if (!(edgeEvent instanceof EdgeSend)) continue;
                    alphabet.add(edgeEvent.getEvent());
                }
            }
        }
        return alphabet;
    }

    private List<Expression> getRecvAlphabet(Automaton aut) {
        List alphabet = Lists.list();
        for (Location loc : aut.getLocations()) {
            for (Edge edge : loc.getEdges()) {
                for (EdgeEvent edgeEvent : edge.getEvents()) {
                    if (!(edgeEvent instanceof EdgeReceive)) continue;
                    alphabet.add(edgeEvent.getEvent());
                }
            }
        }
        return alphabet;
    }

    private void removeInstInternalEdges(Element elem) {
        if (elem.getTagName().equals("edge")) {
            String srcId = elem.getAttribute("source");
            String tgtId = elem.getAttribute("target");
            Assert.check((!srcId.isEmpty() ? 1 : 0) != 0);
            Assert.check((!tgtId.isEmpty() ? 1 : 0) != 0);
            List<String> commonPrefix = this.getCommonPrefix(srcId, tgtId);
            int i = commonPrefix.size();
            while (i > 0) {
                List<String> prefix = commonPrefix.subList(0, i);
                String instId = String.join((CharSequence)":", prefix);
                if (this.instIds.contains(instId)) {
                    elem.getParentNode().removeChild(elem);
                    return;
                }
                --i;
            }
        }
        NodeList children = elem.getChildNodes();
        int i = children.getLength() - 1;
        while (i >= 0) {
            Node child = children.item(i);
            if (child instanceof Element) {
                this.removeInstInternalEdges((Element)child);
            }
            --i;
        }
    }

    private List<String> getCommonPrefix(String id1, String id2) {
        String[] parts1 = StringUtils.split((String)id1, (String)":");
        String[] parts2 = StringUtils.split((String)id2, (String)":");
        List rslt = Lists.listc((int)Math.max(parts1.length, parts2.length));
        int i = 0;
        while (i < Math.min(parts1.length, parts2.length)) {
            if (!parts1[i].equals(parts2[i])) break;
            rslt.add(parts1[i]);
            ++i;
        }
        return rslt;
    }

    private void collectEdgeSrcTgtIds(Element elem, Set<String> ids) {
        if (elem.getTagName().equals("edge")) {
            String srcId = elem.getAttribute("source");
            String tgtId = elem.getAttribute("target");
            Assert.check((!srcId.isEmpty() ? 1 : 0) != 0);
            Assert.check((!tgtId.isEmpty() ? 1 : 0) != 0);
            ids.add(srcId);
            ids.add(tgtId);
        }
        NodeList children = elem.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child instanceof Element) {
                this.collectEdgeSrcTgtIds((Element)child, ids);
            }
            ++i;
        }
    }

    private void removeInstInternalNodes(Element elem, Set<String> nodeIds) {
        if (elem.getTagName().equals("node")) {
            String id = elem.getAttribute("id");
            Assert.check((!id.isEmpty() ? 1 : 0) != 0);
            if (!nodeIds.contains(id) && this.getChildElem(elem, "graph") == null) {
                Object[] parts = StringUtils.split((String)id, (String)":");
                int i = parts.length - 1;
                while (i > 0) {
                    CharSequence[] prefix = (String[])ArrayUtils.subarray((Object[])parts, (int)0, (int)i);
                    String instId = String.join((CharSequence)":", prefix);
                    if (this.instIds.contains(instId)) {
                        elem.getParentNode().removeChild(elem);
                        return;
                    }
                    --i;
                }
            }
        }
        NodeList children = elem.getChildNodes();
        int i = children.getLength() - 1;
        while (i >= 0) {
            Node child = children.item(i);
            if (child instanceof Element) {
                this.removeInstInternalNodes((Element)child, nodeIds);
            }
            --i;
        }
    }

    private Element getChildElem(Element elem, String name) {
        NodeList children = elem.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Element childElem;
            Node child = children.item(i);
            if (child instanceof Element && (childElem = (Element)child).getTagName().equals(name)) {
                return childElem;
            }
            ++i;
        }
        return null;
    }

    private void removeEmptyComps(Element elem) {
        NodeList children = elem.getChildNodes();
        int i = children.getLength() - 1;
        while (i >= 0) {
            Node child = children.item(i);
            if (child instanceof Element) {
                this.removeEmptyComps((Element)child);
            }
            --i;
        }
        Assert.check((elem.getParentNode() != null ? 1 : 0) != 0);
        boolean isRoot = elem.getParentNode() instanceof Document;
        if (isRoot || elem.getTagName().equals("node")) {
            Element childElem;
            Node child;
            Element graphElem;
            String id = elem.getAttribute("id");
            if (!isRoot) {
                Assert.check((!id.isEmpty() ? 1 : 0) != 0);
            }
            if (isRoot || this.compIds.contains(id)) {
                graphElem = this.getChildElem(elem, "graph");
                if (graphElem == null) {
                    throw new RuntimeException("no graph");
                }
                List boxElems = Lists.list();
                children = graphElem.getChildNodes();
                int i2 = 0;
                while (i2 < children.getLength()) {
                    String boxId;
                    child = children.item(i2);
                    if (child instanceof Element && (childElem = (Element)child).getTagName().equals("node") && this.boxIds.contains(boxId = childElem.getAttribute("id"))) {
                        boxElems.add(childElem);
                    }
                    ++i2;
                }
                if (boxElems.size() == 1) {
                    Element boxElem = (Element)boxElems.get(0);
                    Element boxGraphElem = this.getChildElem(boxElem, "graph");
                    children = boxGraphElem.getChildNodes();
                    int i3 = children.getLength() - 1;
                    while (i3 >= 0) {
                        Element childElem2;
                        Node child2 = children.item(i3);
                        if (child2 instanceof Element && (childElem2 = (Element)child2).getTagName().equals("node")) {
                            graphElem.appendChild(childElem2);
                        }
                        --i3;
                    }
                    boxElem.getParentNode().removeChild(boxElem);
                }
            }
            if (this.compIds.contains(id) || this.boxIds.contains(id)) {
                graphElem = this.getChildElem(elem, "graph");
                if (graphElem == null) {
                    throw new RuntimeException("no graph");
                }
                int nodeCnt = 0;
                children = graphElem.getChildNodes();
                int i4 = 0;
                while (i4 < children.getLength()) {
                    child = children.item(i4);
                    if (child instanceof Element && (childElem = (Element)child).getTagName().equals("node")) {
                        ++nodeCnt;
                    }
                    ++i4;
                }
                if (nodeCnt == 0) {
                    elem.getParentNode().removeChild(elem);
                }
            }
        }
    }

    private static class ArgRefExprCollector
    extends BaseRefExprCollector {
        private ArgRefExprCollector() {
        }

        public void collectRefExprs(Expression expr) {
            this.walkExpression(expr);
        }
    }

    private static abstract class BaseRefExprCollector
    extends CifWalker {
        public List<Expression> refs = Lists.listc((int)1);

        private BaseRefExprCollector() {
        }

        protected void walkAlgVariableExpression(AlgVariableExpression ref) {
            this.addRef((Expression)ref);
        }

        protected void walkContVariableExpression(ContVariableExpression ref) {
            this.addRef((Expression)ref);
        }

        protected void walkDiscVariableExpression(DiscVariableExpression ref) {
            this.addRef((Expression)ref);
        }

        protected void walkInputVariableExpression(InputVariableExpression ref) {
            this.addRef((Expression)ref);
        }

        protected void walkLocationExpression(LocationExpression ref) {
            this.addRef((Expression)ref);
        }

        private void addRef(Expression ref) {
            EObject parent = ref.eContainer();
            if (parent instanceof CompParamWrapExpression) {
                this.addRef((Expression)((CompParamWrapExpression)parent));
            } else if (parent instanceof CompInstWrapExpression) {
                this.addRef((Expression)((CompInstWrapExpression)parent));
            } else {
                this.refs.add(ref);
            }
        }
    }

    private static class CompRefExprCollector
    extends BaseRefExprCollector {
        private boolean rootEncountered;

        private CompRefExprCollector() {
        }

        public void collectRefExprs(ComplexComponent comp) {
            this.rootEncountered = false;
            this.walkComplexComponent(comp);
        }

        protected void walkAlgVariable(AlgVariable var) {
        }

        protected void walkContVariable(ContVariable var) {
        }

        protected void walkDiscVariable(DiscVariable var) {
        }

        protected void walkInputVariable(InputVariable var) {
        }

        protected void walkLocation(Location loc) {
            if (loc.getName() == null) {
                super.walkLocation(loc);
            }
        }

        protected void walkEquation(Equation equation) {
        }

        protected void walkComponentDef(ComponentDef cdef) {
        }

        protected void walkComponent(Component comp) {
        }

        protected void walkComplexComponent(ComplexComponent comp) {
            if (!this.rootEncountered) {
                super.walkComplexComponent(comp);
                return;
            }
        }

        protected void walkGroup(Group grp) {
            if (!this.rootEncountered) {
                this.rootEncountered = true;
                super.walkGroup(grp);
                return;
            }
        }

        protected void walkAutomaton(Automaton aut) {
            if (!this.rootEncountered) {
                this.rootEncountered = true;
                super.walkAutomaton(aut);
                return;
            }
        }

        protected void walkComponentInst(ComponentInst inst) {
        }

        protected void walkFunction(Function obj) {
        }
    }

    private static class DeclRefExprCollector
    extends BaseRefExprCollector {
        private boolean skipEquations;

        private DeclRefExprCollector() {
        }

        public void collectRefExprs(Declaration decl) {
            this.skipEquations = false;
            this.walkDeclaration(decl);
            if (decl instanceof AlgVariable || decl instanceof ContVariable) {
                List eqns = CifEquationUtils.getEquations((PositionObject)decl);
                for (Equation eqn : eqns) {
                    this.walkEquation(eqn);
                }
            }
        }

        public void collectRefExprs(Location loc) {
            this.skipEquations = true;
            this.walkLocation(loc);
        }

        public void walkEquation(Equation equation) {
            if (!this.skipEquations) {
                super.walkEquation(equation);
            }
        }
    }
}

