/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.plot;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import org.jfree.chart.ChartMouseEvent;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.annotations.XYAnnotation;
import org.jfree.chart.annotations.XYMeasurementAnnotation;
import org.jfree.chart.entity.XYItemEntity;
import org.jfree.chart.geom.Point2DNumber;
import org.jfree.chart.panel.CrosshairOverlay;
import org.jfree.chart.plot.Crosshair;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.util.Args;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.XYDataset;

public class XYMeasureWithAnnotations
extends CrosshairOverlay
implements ChartMouseListener {
    private static final long serialVersionUID = -7754581177397547320L;
    private final MeasurementAxis measurementAxis;
    private final Crosshair movingCrosshair;
    private final Crosshair markedCrosshair;
    private transient Point2DNumber markedPoint;
    private Predicate<MouseEvent> markPredicate = InputEvent::isAltDown;
    private BiFunction<Number, Number, String> annotationLabelProvider = (first, second) -> String.format("Difference: %f", Math.abs(second.doubleValue() - first.doubleValue()));

    public static XYMeasureWithAnnotations addToChartPanel(ChartPanel chartPanel, MeasurementAxis axis) {
        XYMeasureWithAnnotations instance = new XYMeasureWithAnnotations(axis);
        instance.addToChartPanel(chartPanel);
        return instance;
    }

    public XYMeasureWithAnnotations(MeasurementAxis axis) {
        Args.nullNotPermitted((Object)axis, "axis");
        this.measurementAxis = axis;
        this.movingCrosshair = new Crosshair(Double.NaN, Color.GRAY, new BasicStroke(1.0f));
        this.markedCrosshair = new Crosshair(Double.NaN, Color.BLACK, new BasicStroke(1.0f));
        this.addCrosshair(this.movingCrosshair);
        this.addCrosshair(this.markedCrosshair);
    }

    private void addCrosshair(Crosshair crosshair) {
        switch (this.measurementAxis) {
            case DOMAIN: {
                this.addDomainCrosshair(crosshair);
                break;
            }
            case RANGE: {
                this.addRangeCrosshair(crosshair);
            }
        }
    }

    public void addToChartPanel(ChartPanel chartPanel) {
        Args.nullNotPermitted(chartPanel, "chartPanel");
        chartPanel.addOverlay(this);
        chartPanel.addChartMouseListener(this);
    }

    public void removeFromChartPanel(ChartPanel chartPanel) {
        Args.nullNotPermitted(chartPanel, "chartPanel");
        chartPanel.removeChartMouseListener(this);
        chartPanel.removeOverlay(this);
    }

    public void setAnnotationLabelProvider(BiFunction<Number, Number, String> annotationLabelProvider) {
        Args.nullNotPermitted(annotationLabelProvider, "annotationLabelProvider");
        this.annotationLabelProvider = annotationLabelProvider;
    }

    public Predicate<MouseEvent> getMarkPredicate() {
        return this.markPredicate;
    }

    public void setMarkPredicate(Predicate<MouseEvent> markPredicate) {
        Args.nullNotPermitted(markPredicate, "markPredicate");
        this.markPredicate = markPredicate;
    }

    @Override
    public void chartMouseMoved(ChartMouseEvent event) {
        Point2DNumber crosshairPoint = this.getCrosshairPoint(event);
        double crosshairValue = Double.NaN;
        if (crosshairPoint != null) {
            crosshairValue = this.measurementAxis == MeasurementAxis.DOMAIN ? ((Point2D)crosshairPoint).getX() : ((Point2D)crosshairPoint).getY();
        }
        this.movingCrosshair.setValue(crosshairValue);
        event.getTrigger().consume();
    }

    @Override
    public void chartMouseClicked(ChartMouseEvent event) {
        if (this.markPredicate.test(event.getTrigger())) {
            Point2DNumber crosshairPoint = this.getCrosshairPoint(event);
            if (null != crosshairPoint && null != this.markedPoint) {
                this.addAnnotation(event.getChart().getXYPlot(), this.markedPoint, crosshairPoint, event.getTrigger());
                this.markedPoint = null;
                this.markedCrosshair.setValue(Double.NaN);
            } else {
                this.markedPoint = crosshairPoint;
                double crosshairValue = Double.NaN;
                if (crosshairPoint != null) {
                    crosshairValue = this.measurementAxis == MeasurementAxis.DOMAIN ? crosshairPoint.getX() : crosshairPoint.getY();
                }
                this.markedCrosshair.setValue(crosshairValue);
            }
            event.getTrigger().consume();
        }
    }

    protected Point2DNumber getCrosshairPoint(ChartMouseEvent event) {
        if (!(event.getEntity() instanceof XYItemEntity)) {
            return null;
        }
        XYItemEntity entity = (XYItemEntity)event.getEntity();
        XYDataset dataset = entity.getDataset();
        if (dataset instanceof IntervalXYDataset) {
            Number y;
            Number x;
            IntervalXYDataset intervalDataset = (IntervalXYDataset)dataset;
            int mouseX = event.getTrigger().getX();
            int mouseY = event.getTrigger().getY();
            Rectangle2D entityBounds = entity.getArea().getBounds2D();
            PlotOrientation plotOrientation = event.getChart().getXYPlot().getOrientation();
            if (this.measurementAxis == MeasurementAxis.DOMAIN) {
                boolean snapDomainToStart = plotOrientation == PlotOrientation.VERTICAL ? (double)mouseX < entityBounds.getCenterX() : (double)mouseY > entityBounds.getCenterY();
                x = snapDomainToStart ? (Number)intervalDataset.getStartX(entity.getSeriesIndex(), entity.getItem()) : (Number)intervalDataset.getEndX(entity.getSeriesIndex(), entity.getItem());
                y = intervalDataset.getY(entity.getSeriesIndex(), entity.getItem());
            } else {
                x = intervalDataset.getX(entity.getSeriesIndex(), entity.getItem());
                boolean snapRangeToStart = plotOrientation == PlotOrientation.VERTICAL ? (double)mouseY > entityBounds.getCenterY() : (double)mouseX < entityBounds.getCenterX();
                y = snapRangeToStart ? (Number)intervalDataset.getStartY(entity.getSeriesIndex(), entity.getItem()) : (Number)intervalDataset.getEndY(entity.getSeriesIndex(), entity.getItem());
            }
            return new Point2DNumber(x, y);
        }
        return new Point2DNumber(dataset.getX(entity.getSeriesIndex(), entity.getItem()), dataset.getY(entity.getSeriesIndex(), entity.getItem()));
    }

    protected void addAnnotation(XYPlot plot, Point2DNumber first, Point2DNumber second, MouseEvent event) {
        XYMeasurementAnnotation.Orientation orientation;
        String label;
        if (this.measurementAxis == MeasurementAxis.DOMAIN) {
            label = this.createMeasurementLabel(first.getX(), second.getX(), event);
            orientation = plot.getOrientation() == PlotOrientation.VERTICAL ? XYMeasurementAnnotation.Orientation.HORIZONTAL : XYMeasurementAnnotation.Orientation.VERTICAL;
        } else {
            label = this.createMeasurementLabel(first.getY(), second.getY(), event);
            orientation = plot.getOrientation() == PlotOrientation.VERTICAL ? XYMeasurementAnnotation.Orientation.VERTICAL : XYMeasurementAnnotation.Orientation.HORIZONTAL;
        }
        plot.addAnnotation(this.createMeasurementAnnotation(orientation, label, first, second));
    }

    protected String createMeasurementLabel(Number firstValue, Number secondValue, MouseEvent event) {
        return this.annotationLabelProvider.apply(firstValue, secondValue);
    }

    protected XYAnnotation createMeasurementAnnotation(XYMeasurementAnnotation.Orientation orientation, String label, Point2DNumber first, Point2DNumber second) {
        return new XYMeasurementAnnotation(orientation, label, first, second);
    }

    public static enum MeasurementAxis {
        DOMAIN,
        RANGE;

    }
}

