/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.rpm.ui.editor.markers;

import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.linuxtools.internal.rpm.ui.editor.SpecfileLog;
import org.eclipse.linuxtools.rpm.ui.editor.markers.SpecfileMarkerHandler;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.MarkerUtilities;

public class SpecfileTaskHandler
extends SpecfileMarkerHandler {
    public static final String SPECFILE_TASK_MARKER_ID = "org.eclipse.linuxtools.rpm.ui.editor.specfiletask";

    public SpecfileTaskHandler(IFile file, IDocument document) {
        super(file, document);
    }

    public SpecfileTaskHandler(FileEditorInput file, IDocument document) {
        this(file.getFile(), document);
    }

    public void handleTask(int lineNumber, String line, String taskType) {
        Integer charEnd;
        if (this.file == null) {
            return;
        }
        String message = line.substring(line.indexOf(taskType));
        HashMap<String, Object> map = new HashMap<String, Object>();
        MarkerUtilities.setLineNumber(map, (int)lineNumber);
        MarkerUtilities.setMessage(map, (String)message);
        map.put("message", message);
        map.put("location", this.file.getFullPath().toString());
        map.put("userEditable", false);
        Integer charStart = this.getCharOffset(lineNumber, 0);
        if (charStart != null) {
            map.put("charStart", charStart);
        }
        if ((charEnd = this.getCharOffset(lineNumber, line.length())) != null) {
            map.put("charEnd", charEnd);
        }
        try {
            MarkerUtilities.createMarker((IResource)this.file, map, (String)SPECFILE_TASK_MARKER_ID);
        }
        catch (CoreException ee) {
            SpecfileLog.logError(ee);
        }
    }

    @Override
    String getMarkerID() {
        return SPECFILE_TASK_MARKER_ID;
    }
}

