/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.binutils.utils;

import java.io.IOException;
import org.eclipse.cdt.utils.Addr2line;
import org.eclipse.cdt.utils.CPPFilt;
import org.eclipse.cdt.utils.CommandLineUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.linuxtools.binutils.utils.ISTBinutilsFactory;
import org.eclipse.linuxtools.binutils.utils.STNM;
import org.eclipse.linuxtools.binutils.utils.STNMSymbolsHandler;
import org.eclipse.linuxtools.binutils.utils.STStrings;
import org.eclipse.linuxtools.internal.Activator;
import org.eclipse.linuxtools.tools.launch.core.factory.RuntimeProcessFactory;

public class DefaultBinutilsFactory
implements ISTBinutilsFactory {
    @Override
    public Addr2line getAddr2line(String path, IProject project) throws IOException {
        IPreferenceStore prefsStore = Activator.getDefault().getPreferenceStore();
        String addr2lineCmd = prefsStore.getString("PREFKEY_ADDR2LINE_CMD");
        String addr2lineArgs = prefsStore.getString("PREFKEY_ADDR2LINE_ARGS");
        String[] args = CommandLineUtil.argumentsToArray((String)addr2lineArgs);
        String addr2line = RuntimeProcessFactory.getFactory().whichCommand(addr2lineCmd, project);
        return new Addr2line(addr2line, args, path);
    }

    @Override
    public CPPFilt getCPPFilt(IProject project) throws IOException {
        IPreferenceStore prefsStore = Activator.getDefault().getPreferenceStore();
        String cppfiltCmd = prefsStore.getString("PREFKEY_CPPFILT_CMD");
        String cppfiltArgs = prefsStore.getString("PREFKEY_CPPFILT_ARGS");
        String[] args = CommandLineUtil.argumentsToArray((String)cppfiltArgs);
        String cppfilt = RuntimeProcessFactory.getFactory().whichCommand(cppfiltCmd, project);
        return new CPPFilt(cppfilt, args);
    }

    @Override
    public STNM getNM(String path, STNMSymbolsHandler handler, IProject project) throws IOException {
        IPreferenceStore prefsStore = Activator.getDefault().getPreferenceStore();
        String nmCmd = prefsStore.getString("PREFKEY_NM_CMD");
        String nmArgs = prefsStore.getString("PREFKEY_NM_ARGS");
        String[] args = CommandLineUtil.argumentsToArray((String)nmArgs);
        String nm = RuntimeProcessFactory.getFactory().whichCommand(nmCmd, project);
        return new STNM(nm, args, path, handler, project);
    }

    @Override
    public STStrings getSTRINGS(IProject project) throws IOException {
        IPreferenceStore prefsStore = Activator.getDefault().getPreferenceStore();
        String stringsCmd = prefsStore.getString("PREFKEY_STRINGS_CMD");
        String stringsArgs = prefsStore.getString("PREFKEY_STRINGS_ARGS");
        String[] args = CommandLineUtil.argumentsToArray((String)stringsArgs);
        String strings = RuntimeProcessFactory.getFactory().whichCommand(stringsCmd, project);
        return new STStrings(strings, args);
    }

    @Override
    public boolean testAvailability() {
        return true;
    }
}

