/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.relaxng.xml.completion;

import java.util.Arrays;
import org.eclipse.lemminx.XMLAssert;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.extensions.contentmodel.BaseFileTempTest;
import org.eclipse.lemminx.services.XMLLanguageService;
import org.eclipse.lsp4j.CompletionItem;
import org.junit.jupiter.api.Test;

public class XMLCompletionBasedOnRelaxNGTest
extends BaseFileTempTest {
    @Test
    public void completionOnRoot() throws BadLocationException {
        String xml = "<?xml-model href=\"tei_all.rng\" ?>\r\n<|";
        XMLCompletionBasedOnRelaxNGTest.testCompletionFor(xml, null, XMLAssert.c("TEI", XMLAssert.te(1, 0, 1, 1, "<TEI></TEI>"), "<TEI"), XMLAssert.c("teiCorpus", XMLAssert.te(1, 0, 1, 1, "<teiCorpus></teiCorpus>"), "<teiCorpus"));
    }

    @Test
    public void completionInDocumentElement() throws BadLocationException {
        String xml = "<?xml-model href=\"tei_all.rng\" ?>\r\n<TEI xmlns=\"http://www.tei-c.org/ns/1.0\">\r\n  <|\r\n</TEI>";
        XMLCompletionBasedOnRelaxNGTest.testCompletionFor(xml, 3, XMLAssert.c("teiHeader", XMLAssert.te(2, 2, 2, 3, "<teiHeader></teiHeader>"), "<teiHeader"));
    }

    @Test
    public void completionWithTwoSameRelaxNG() throws BadLocationException {
        String xml = "<?xml-model href=\"tei_all.rng\" ?>\r\n<?xml-model href=\"tei_all.rng\" ?>\r\n<TEI xmlns=\"http://www.tei-c.org/ns/1.0\">\r\n  <|\r\n</TEI>";
        XMLCompletionBasedOnRelaxNGTest.testCompletionFor(xml, 4, XMLAssert.c("teiHeader", XMLAssert.te(3, 2, 3, 3, "<teiHeader></teiHeader>"), "<teiHeader"));
        xml = "<?xml-model href=\"tei_all.rng\" schematypens=\"http://relaxng.org/ns/structure/1.0\" ?>\r\n<?xml-model href=\"tei_all.rng\" schematypens=\"http://purl.oclc.org/dsdl/schematron\" ?>\r\n<TEI xmlns=\"http://www.tei-c.org/ns/1.0\">\r\n  <|\r\n</TEI>";
        XMLCompletionBasedOnRelaxNGTest.testCompletionFor(xml, 3, XMLAssert.c("teiHeader", XMLAssert.te(3, 2, 3, 3, "<teiHeader></teiHeader>"), "<teiHeader"));
    }

    @Test
    public void completionOnRootWithXMLNS() throws BadLocationException {
        String xml = "<?xml-model href=\"simple.rng\"?>\r\n|";
        XMLCompletionBasedOnRelaxNGTest.testCompletionFor(xml, 19, XMLAssert.c("rootelt", XMLAssert.te(1, 0, 1, 0, "<rootelt xmlns:lmx=\"https://github.com/eclipse/lemminx\" xml:lang=\"\" lmx:type=\"\"></rootelt>"), "rootelt"));
    }

    @Test
    public void completionInElementWithXMLNS() throws BadLocationException {
        String xml = "<?xml-model href=\"simple.rng\"?>\r\n<rootelt xmlns:lmx=\"https://github.com/eclipse/lemminx\" xml:lang=\"\" lmx:type=\"\">\r\n|\r\n</rootelt>";
        XMLCompletionBasedOnRelaxNGTest.testCompletionFor(xml, 6, XMLAssert.c("child", XMLAssert.te(2, 0, 2, 0, "<child xmlns:vx=\"https://github.com/redhat-developer/vscode-xml\" vx:type=\"\"></child>"), "child"));
        xml = "<?xml-model href=\"simple.rng\"?>\r\n<rootelt xmlns:lmx=\"https://github.com/eclipse/lemminx\" xml:lang=\"\" lmx:type=\"\">\r\n<|\r\n</rootelt>";
        XMLCompletionBasedOnRelaxNGTest.testCompletionFor(xml, 4, XMLAssert.c("child", XMLAssert.te(2, 0, 2, 1, "<child xmlns:vx=\"https://github.com/redhat-developer/vscode-xml\" vx:type=\"\"></child>"), "<child"));
    }

    @Test
    public void completionInElementWithXMLNSAndDefinedNS() throws BadLocationException {
        String xml = "<?xml-model href=\"simple.rng\"?>\r\n<rootelt xmlns:lmx=\"https://github.com/eclipse/lemminx\" xmlns:myvx=\"https://github.com/redhat-developer/vscode-xml\" xml:lang=\"\" lmx:type=\"\">\r\n|\r\n</rootelt>";
        XMLCompletionBasedOnRelaxNGTest.testCompletionFor(xml, 7, XMLAssert.c("child", XMLAssert.te(2, 0, 2, 0, "<child myvx:type=\"\"></child>"), "child"));
        xml = "<?xml-model href=\"simple.rng\"?>\r\n<rootelt xmlns:lmx=\"https://github.com/eclipse/lemminx\" xmlns:myvx=\"https://github.com/redhat-developer/vscode-xml\" xml:lang=\"\" lmx:type=\"\">\r\n<|\r\n</rootelt>";
        XMLCompletionBasedOnRelaxNGTest.testCompletionFor(xml, 5, XMLAssert.c("child", XMLAssert.te(2, 0, 2, 1, "<child myvx:type=\"\"></child>"), "<child"));
    }

    @Test
    public void completionOnAttributes() throws BadLocationException {
        String xml = "<?xml-model href=\"docbook.rng\"?>\r\n<book xmlns=\"http://docbook.org/ns/docbook\">\r\n\t<acknowledgements |></acknowledgements>\t\r\n</book>";
        XMLCompletionBasedOnRelaxNGTest.testCompletionFor(xml, 30, XMLAssert.c("role", XMLAssert.te(2, 19, 2, 19, "role=\"\""), "role"), XMLAssert.c("xlink:actuate", XMLAssert.te(2, 19, 2, 19, "xlink:actuate=\"\""), Arrays.asList(XMLAssert.te(1, 43, 1, 43, " xmlns:xlink=\"http://www.w3.org/1999/xlink\"")), "xlink:actuate"));
    }

    @Test
    public void completionOnAttributesWithPrefix() throws BadLocationException {
        String xml = "<?xml-model href=\"docbook.rng\"?>\r\n<book xmlns=\"http://docbook.org/ns/docbook\">\r\n\t<acknowledgements |></acknowledgements>\t\r\n</book>";
        XMLCompletionBasedOnRelaxNGTest.testCompletionFor(xml, 30, XMLAssert.c("xlink:actuate", XMLAssert.te(2, 19, 2, 19, "xlink:actuate=\"\""), Arrays.asList(XMLAssert.te(1, 43, 1, 43, " xmlns:xlink=\"http://www.w3.org/1999/xlink\"")), "xlink:actuate"));
        xml = "<?xml-model href=\"docbook.rng\"?>\r\n<book xmlns=\"http://docbook.org/ns/docbook\" >\r\n\t<acknowledgements |></acknowledgements>\t\r\n</book>";
        XMLCompletionBasedOnRelaxNGTest.testCompletionFor(xml, 30, XMLAssert.c("xlink:actuate", XMLAssert.te(2, 19, 2, 19, "xlink:actuate=\"\""), Arrays.asList(XMLAssert.te(1, 43, 1, 43, " xmlns:xlink=\"http://www.w3.org/1999/xlink\"")), "xlink:actuate"));
        xml = "<?xml-model href=\"docbook.rng\"?>\r\n<book\r\n\t<acknowledgements |></acknowledgements>\t\r\n</book>";
        XMLCompletionBasedOnRelaxNGTest.testCompletionFor(xml, 30, XMLAssert.c("xlink:actuate", XMLAssert.te(2, 19, 2, 19, "xlink:actuate=\"\""), Arrays.asList(XMLAssert.te(1, 5, 1, 5, " xmlns:xlink=\"http://www.w3.org/1999/xlink\"")), "xlink:actuate"));
    }

    private static void testCompletionFor(String value, Integer expectedCount, CompletionItem ... expectedItems) throws BadLocationException {
        XMLAssert.testCompletionFor(new XMLLanguageService(), value, null, null, "src/test/resources/relaxng/test.xml", expectedCount, true, expectedItems);
    }
}

