/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.references;

import org.eclipse.lemminx.AbstractCacheBasedTest;
import org.eclipse.lemminx.XMLAssert;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.extensions.references.XMLReferencesSettingsForTest;
import org.eclipse.lemminx.services.XMLLanguageService;
import org.eclipse.lemminx.services.extensions.save.ISaveContext;
import org.eclipse.lsp4j.LocationLink;
import org.junit.jupiter.api.Test;

public class XMLReferencesDefinitionExtensionsTest
extends AbstractCacheBasedTest {
    @Test
    public void tei() throws BadLocationException {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<TEI xmlns=\"http://www.tei-c.org/ns/1.0\">\r\n  <teiHeader>  \r\n    <fileDesc>\r\n      <titleStmt>\r\n        <title>Title</title>\r\n      </titleStmt>\r\n      <publicationStmt>\r\n        <p>Publication information</p>  \r\n      </publicationStmt>\r\n      <sourceDesc>\r\n        <p>Information about the source</p>\r\n      </sourceDesc>\r\n    </fileDesc>\r\n  </teiHeader>\r\n  <text>\r\n    <body xml:id=\"body-id\">\r\n      <p xml:id=\"p-id\" >Some text here.</p>\r\n      <anchor corresp=\"#bo|dy-id\"></anchor>\r\n    </body>\r\n  </text>\r\n</TEI>";
        XMLReferencesDefinitionExtensionsTest.testDefinitionFor(xml, "file:///test/tei.xml", XMLAssert.ll("file:///test/tei.xml", XMLAssert.r(18, 23, 18, 31), XMLAssert.r(16, 18, 16, 25)));
    }

    @Test
    public void teiTargetMulti1() throws BadLocationException {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<TEI xmlns=\"http://www.tei-c.org/ns/1.0\">\r\n\t<teiHeader></teiHeader>\r\n\t<text>\r\n\t\t<body>\r\n\t\t\t<p xml:id=\"A\" />\r\n\t\t\t<p xml:id=\"B\" />\r\n\t\t</body>\r\n\t\t<link target=\"#|A #B\" />\r\n\t</text>\r\n</TEI>";
        XMLReferencesDefinitionExtensionsTest.testDefinitionFor(xml, "file:///test/tei.xml", XMLAssert.ll("file:///test/tei.xml", XMLAssert.r(8, 16, 8, 18), XMLAssert.r(5, 14, 5, 15)));
    }

    @Test
    public void teiTargetMulti2() throws BadLocationException {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<TEI xmlns=\"http://www.tei-c.org/ns/1.0\">\r\n\t<teiHeader></teiHeader>\r\n\t<text>\r\n\t\t<body>\r\n\t\t\t<p xml:id=\"A\" />\r\n\t\t\t<p xml:id=\"B\" />\r\n\t\t</body>\r\n\t\t<link target=\"#A #|B\" />\r\n\t</text>\r\n</TEI>";
        XMLReferencesDefinitionExtensionsTest.testDefinitionFor(xml, "file:///test/tei.xml", XMLAssert.ll("file:///test/tei.xml", XMLAssert.r(8, 19, 8, 21), XMLAssert.r(6, 14, 6, 15)));
    }

    @Test
    public void docbook() throws BadLocationException {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<book>\r\n    <chapter id=\"chapter-1\">\r\n\r\n        <xref linkend=\"chap|ter-1\" />\r\n\r\n    </chapter>\r\n\r\n    <chapter id=\"chapter-2\">\r\n\r\n    </chapter>\r\n</book>";
        XMLReferencesDefinitionExtensionsTest.testDefinitionFor(xml, "file:///test/docbook.xml", XMLAssert.ll("file:///test/docbook.xml", XMLAssert.r(4, 23, 4, 32), XMLAssert.r(2, 17, 2, 26)));
    }

    @Test
    public void web() throws BadLocationException {
        String xml = "<web-app xmlns=\"http://xmlns.jcp.org/xml/ns/javaee\"\r\n  xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n  version=\"3.1\">\r\n  <servlet>\r\n    <servlet-name>comingsoon</servlet-name>\r\n    <servlet-class>mysite.server.ComingSoonServlet</servlet-class>\r\n  </servlet>\r\n  <servlet-mapping>\r\n    <servlet-name>co|mingsoon</servlet-name>\r\n    <url-pattern>/*</url-pattern>\r\n  </servlet-mapping>\r\n</web-app>\r\n";
        XMLReferencesDefinitionExtensionsTest.testDefinitionFor(xml, "file:///test/web.xml", XMLAssert.ll("file:///test/web.xml", XMLAssert.r(8, 18, 8, 28), XMLAssert.r(4, 18, 4, 28)));
    }

    @Test
    public void noDefinitionWithTEI() throws BadLocationException {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<TEI xmlns=\"http://www.tei-c.org/ns/1.0\">\r\n  <teiHeader>  \r\n    <fileDesc>\r\n      <titleStmt>\r\n        <title>Title</title>\r\n      </titleStmt>\r\n      <publicationStmt>\r\n        <p>Publication information</p>  \r\n      </publicationStmt>\r\n      <sourceDesc>\r\n        <p>Information about the source</p>\r\n      </sourceDesc>\r\n    </fileDesc>\r\n  </teiHeader>\r\n  <text>\r\n      <p xml:id=\"p-id\" >Some text here.</p>\r\n      <anchor corresp=\"#bo|dy-id\"></anchor>\r\n  </text>\r\n</TEI>";
        XMLReferencesDefinitionExtensionsTest.testDefinitionFor(xml, "file:///test/tei.xml", new LocationLink[0]);
    }

    @Test
    public void noDefinitionWithTEIAndNotHash() throws BadLocationException {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<TEI xmlns=\"http://www.tei-c.org/ns/1.0\">\r\n  <teiHeader>  \r\n    <fileDesc>\r\n      <titleStmt>\r\n        <title>Title</title>\r\n      </titleStmt>\r\n      <publicationStmt>\r\n        <p>Publication information</p>  \r\n      </publicationStmt>\r\n      <sourceDesc>\r\n        <p>Information about the source</p>\r\n      </sourceDesc>\r\n    </fileDesc>\r\n  </teiHeader>\r\n  <text>\r\n    <body xml:id=\"body-id\">\r\n      <p xml:id=\"p-id\" >Some text here.</p>\r\n      <anchor corresp=\"bo|dy-id\"></anchor>\r\n    </body>\r\n  </text>\r\n</TEI>";
        XMLReferencesDefinitionExtensionsTest.testDefinitionFor(xml, "file:///test/tei.xml", new LocationLink[0]);
    }

    @Test
    public void attrToText() throws BadLocationException {
        String xml = "<aaa ref=\"chi|ld1 child2 child3\">\r\n  <bbb>child1</bbb>\r\n  <bbb>child2</bbb>\r\n  <bbb>child3</bbb>\r\n</aaa>";
        XMLReferencesDefinitionExtensionsTest.testDefinitionFor(xml, "file:///test/attr-to-text.xml", XMLAssert.ll("file:///test/attr-to-text.xml", XMLAssert.r(0, 10, 0, 16), XMLAssert.r(1, 7, 1, 13)));
    }

    private static void testDefinitionFor(String xml, String fileURI, LocationLink ... expectedItems) throws BadLocationException {
        XMLLanguageService xmlLanguageService = new XMLLanguageService();
        xmlLanguageService.getExtensions();
        xmlLanguageService.doSave((ISaveContext)new XMLAssert.SettingsSaveContext(XMLReferencesSettingsForTest.createXMLReferencesSettings()));
        XMLAssert.testDefinitionFor(xmlLanguageService, xml, fileURI, expectedItems);
    }
}

