/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.net.modem;

import java.util.Arrays;
import java.util.Objects;
import org.eclipse.kura.configuration.Password;
import org.eclipse.kura.net.IPAddress;
import org.eclipse.kura.net.NetConfig;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class ModemConfig
implements NetConfig {
    private boolean enabled = false;
    private String dialString = "";
    private int pppNumber = 0;
    private int profileID = 0;
    private PdpType pdpType = PdpType.IP;
    private AuthType authType = AuthType.NONE;
    private String apn = "";
    private String username = "";
    private Password password = new Password("");
    private boolean persist = false;
    private int holdoff = 1;
    private int maxFail = 0;
    private int idle = 0;
    private String activeFilter = "";
    private int lcpEchoInterval = 0;
    private int lcpEchoFailure = 0;
    private IPAddress ipAddress = null;
    private int dataCompression = 0;
    private int headerCompression = 0;
    private boolean gpsEnabled = false;
    private boolean diversityEnabled = false;
    private int resetTimeout = 0;

    public ModemConfig() {
    }

    public ModemConfig(int profileID, PdpType pdpType, String apn, IPAddress ipAddress, int dataCompression, int headerCompresion) {
        this.profileID = profileID;
        this.pdpType = pdpType;
        this.apn = apn;
        this.ipAddress = ipAddress;
        this.dataCompression = dataCompression;
        this.headerCompression = headerCompresion;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getDialString() {
        return this.dialString;
    }

    public void setDialString(String dialString) {
        this.dialString = dialString;
    }

    public AuthType getAuthType() {
        return this.authType;
    }

    public void setAuthType(AuthType authType) {
        this.authType = authType;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    @Deprecated
    public String getPassword() {
        return this.password.toString();
    }

    public Password getPasswordAsPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = new Password(password);
    }

    public void setPassword(Password password) {
        this.password = password;
    }

    public boolean isPersist() {
        return this.persist;
    }

    public void setPersist(boolean persist) {
        this.persist = persist;
    }

    public int getHoldoff() {
        return this.holdoff;
    }

    public void setHoldoff(int holdoff) {
        this.holdoff = holdoff;
    }

    public int getMaxFail() {
        return this.maxFail;
    }

    public void setMaxFail(int maxFail) {
        this.maxFail = maxFail;
    }

    public int getIdle() {
        return this.idle;
    }

    public void setIdle(int idle) {
        this.idle = idle;
    }

    public String getActiveFilter() {
        return this.activeFilter;
    }

    public void setActiveFilter(String activeFilter) {
        this.activeFilter = activeFilter;
    }

    public int getLcpEchoInterval() {
        return this.lcpEchoInterval;
    }

    public void setLcpEchoInterval(int lcpEchoInterval) {
        this.lcpEchoInterval = lcpEchoInterval;
    }

    public int getLcpEchoFailure() {
        return this.lcpEchoFailure;
    }

    public void setLcpEchoFailure(int lcpEchoFailure) {
        this.lcpEchoFailure = lcpEchoFailure;
    }

    public int getPppNumber() {
        return this.pppNumber;
    }

    public void setPppNumber(int pppNumber) {
        this.pppNumber = pppNumber;
    }

    public int getProfileID() {
        return this.profileID;
    }

    public void setProfileID(int id) {
        this.profileID = id;
    }

    public PdpType getPdpType() {
        return this.pdpType;
    }

    public void setPdpType(PdpType pdpType) {
        this.pdpType = pdpType;
    }

    public String getApn() {
        return this.apn;
    }

    public void setApn(String apn) {
        this.apn = apn;
    }

    public IPAddress getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(IPAddress address) {
        this.ipAddress = address;
    }

    public int getDataCompression() {
        return this.dataCompression;
    }

    public void setDataCompression(int dataCompression) {
        this.dataCompression = dataCompression;
    }

    public int getHeaderCompression() {
        return this.headerCompression;
    }

    public void setHeaderCompression(int headerCompression) {
        this.headerCompression = headerCompression;
    }

    public boolean isDataCompression() {
        return this.dataCompression != 0;
    }

    public boolean isHeaderCompression() {
        return this.headerCompression != 0;
    }

    public boolean isGpsEnabled() {
        return this.gpsEnabled;
    }

    public int getResetTimeout() {
        return this.resetTimeout;
    }

    public void setResetTimeout(int tout) {
        this.resetTimeout = tout;
    }

    public void setGpsEnabled(boolean gpsEnabled) {
        this.gpsEnabled = gpsEnabled;
    }

    public boolean isDiversityEnabled() {
        return this.diversityEnabled;
    }

    public void setDiversityEnabled(boolean diversityEnabled) {
        this.diversityEnabled = diversityEnabled;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.activeFilter, this.apn, this.authType, this.dataCompression, this.dialString, this.diversityEnabled, this.enabled, this.gpsEnabled, this.headerCompression, this.holdoff, this.idle, this.ipAddress, this.lcpEchoFailure, this.lcpEchoInterval, this.maxFail, this.password, this.pdpType, this.persist, this.pppNumber, this.profileID, this.resetTimeout, this.username});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ModemConfig)) {
            return false;
        }
        ModemConfig other = (ModemConfig)obj;
        return Objects.equals(this.activeFilter, other.activeFilter) && Objects.equals(this.apn, other.apn) && this.authType == other.authType && this.dataCompression == other.dataCompression && Objects.equals(this.dialString, other.dialString) && this.diversityEnabled == other.diversityEnabled && this.enabled == other.enabled && this.gpsEnabled == other.gpsEnabled && this.headerCompression == other.headerCompression && this.holdoff == other.holdoff && this.idle == other.idle && Objects.equals(this.ipAddress, other.ipAddress) && this.lcpEchoFailure == other.lcpEchoFailure && this.lcpEchoInterval == other.lcpEchoInterval && this.maxFail == other.maxFail && Arrays.equals(this.password.getPassword(), other.getPasswordAsPassword().getPassword()) && this.pdpType == other.pdpType && this.persist == other.persist && this.pppNumber == other.pppNumber && this.profileID == other.profileID && this.resetTimeout == other.resetTimeout && Objects.equals(this.username, other.username);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append("ModemConfig - ");
        sb.append("Enabled: ").append(this.enabled);
        sb.append(" - PPP Number: ").append(this.pppNumber);
        sb.append(" - Dial String: ").append(this.dialString);
        sb.append(" - Profile ID: ").append(this.profileID);
        sb.append(" - PDP Type: ").append((Object)this.pdpType);
        sb.append(" - Auth Type: ").append((Object)this.authType);
        sb.append(" - APN: ").append(this.apn);
        sb.append(" - Username: ").append(this.username);
        sb.append(" - Password: ").append(this.password);
        sb.append(" - IP Address: ").append(this.ipAddress == null ? "null" : this.ipAddress.getHostAddress());
        sb.append(" - Data Compression: ").append(this.dataCompression);
        sb.append(" - Header Compression: ").append(this.headerCompression);
        return sb.toString();
    }

    @Override
    public boolean isValid() {
        boolean result = true;
        if (this.pppNumber < 0) {
            result = false;
        }
        return result;
    }

    public static enum AuthType {
        NONE,
        AUTO,
        PAP,
        CHAP;

    }

    public static enum PdpType {
        IP,
        PPP,
        IPv6,
        UNKNOWN;

    }
}

