/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.gpsd4java.backend;

import com.google.gson.JsonObject;
import de.taimos.gpsd4java.api.IObjectListener;
import de.taimos.gpsd4java.backend.AbstractResultParser;
import de.taimos.gpsd4java.backend.ResultParser;
import de.taimos.gpsd4java.backend.SocketThread;
import de.taimos.gpsd4java.types.ATTObject;
import de.taimos.gpsd4java.types.DeviceObject;
import de.taimos.gpsd4java.types.DevicesObject;
import de.taimos.gpsd4java.types.IGPSObject;
import de.taimos.gpsd4java.types.PollObject;
import de.taimos.gpsd4java.types.SKYObject;
import de.taimos.gpsd4java.types.TPVObject;
import de.taimos.gpsd4java.types.VersionObject;
import de.taimos.gpsd4java.types.WatchObject;
import de.taimos.gpsd4java.types.subframes.SUBFRAMEObject;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GPSdEndpoint {
    private static final Logger LOG = LoggerFactory.getLogger(GPSdEndpoint.class);
    private Socket socket;
    private BufferedReader in;
    private BufferedWriter out;
    private SocketThread listenThread;
    private final boolean daemon;
    private final List<IObjectListener> listeners = new ArrayList<IObjectListener>(1);
    private IGPSObject asyncResult = null;
    private final Object asyncMutex = new Object();
    private final Object asyncWaitMutex = new Object();
    private final AbstractResultParser resultParser;
    private String server;
    private int port;
    private String lastWatch;
    private AtomicLong retryInterval = new AtomicLong(1000L);

    public GPSdEndpoint(String server, int port, AbstractResultParser resultParser, boolean daemon) {
        this.server = server;
        this.port = port;
        if (server == null) {
            throw new IllegalArgumentException("server can not be null!");
        }
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException("Illegal port number: " + port);
        }
        if (resultParser == null) {
            throw new IllegalArgumentException("resultParser can not be null!");
        }
        this.resultParser = resultParser;
        this.daemon = daemon;
    }

    public GPSdEndpoint(String server, int port, AbstractResultParser resultParser) throws UnknownHostException, IOException {
        this(server, port, resultParser, true);
    }

    public GPSdEndpoint(String server, int port) {
        this(server, port, new ResultParser(), true);
    }

    public void start() {
        this.listenThread = new SocketThread(this.in, this, this.resultParser, this.daemon);
        this.listenThread.start();
    }

    public void stop() {
        try {
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (IOException e1) {
            LOG.debug("Close forced: " + e1.getMessage());
        }
        this.listeners.clear();
        if (this.listenThread != null) {
            this.listenThread.halt();
        }
        this.listenThread = null;
    }

    public WatchObject watch(boolean enable, boolean dumpData) throws IOException {
        return this.watch(enable, dumpData, null);
    }

    public WatchObject watch(boolean enable, boolean dumpData, String device) throws IOException {
        JsonObject watch = new JsonObject();
        watch.addProperty("class", "WATCH");
        watch.addProperty("enable", Boolean.valueOf(enable));
        watch.addProperty("json", Boolean.valueOf(dumpData));
        if (device != null) {
            watch.addProperty("device", device);
        }
        return this.syncCommand("?WATCH=" + watch.toString(), WatchObject.class);
    }

    public PollObject poll() throws IOException {
        return this.syncCommand("?POLL;", PollObject.class);
    }

    public VersionObject version() throws IOException {
        return this.syncCommand("?VERSION;", VersionObject.class);
    }

    public void addListener(IObjectListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(IObjectListener listener) {
        this.listeners.remove(listener);
    }

    private <T extends IGPSObject> T syncCommand(String command, Class<T> responseClass) throws IOException {
        Object object = this.asyncMutex;
        synchronized (object) {
            IGPSObject result;
            if (this.out != null) {
                this.out.write(command + "\n");
                this.out.flush();
            }
            if (responseClass == WatchObject.class) {
                this.lastWatch = command;
            }
            while ((result = this.waitForResult()) != null && !result.getClass().equals(responseClass)) {
            }
            return (T)((IGPSObject)responseClass.cast(result));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void voidCommand(String command) throws IOException {
        Object object = this.asyncMutex;
        synchronized (object) {
            this.out.write(command + "\n");
            this.out.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IGPSObject waitForResult() {
        Object object = this.asyncWaitMutex;
        synchronized (object) {
            if (this.asyncResult == null) {
                try {
                    this.asyncWaitMutex.wait(1000L);
                }
                catch (InterruptedException e) {
                    LOG.info("Interrupted while waiting for result", (Throwable)e);
                }
            }
            IGPSObject result = this.asyncResult;
            this.asyncResult = null;
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handle(IGPSObject object) {
        if (object instanceof TPVObject) {
            for (IObjectListener l : this.listeners) {
                l.handleTPV((TPVObject)object);
            }
        } else if (object instanceof SKYObject) {
            for (IObjectListener l : this.listeners) {
                l.handleSKY((SKYObject)object);
            }
        } else if (object instanceof ATTObject) {
            for (IObjectListener l : this.listeners) {
                l.handleATT((ATTObject)object);
            }
        } else if (object instanceof SUBFRAMEObject) {
            for (IObjectListener l : this.listeners) {
                l.handleSUBFRAME((SUBFRAMEObject)object);
            }
        } else if (object instanceof DevicesObject) {
            for (IObjectListener l : this.listeners) {
                l.handleDevices((DevicesObject)object);
            }
        } else if (object instanceof DeviceObject) {
            for (IObjectListener l : this.listeners) {
                l.handleDevice((DeviceObject)object);
            }
        } else {
            Object object2 = this.asyncWaitMutex;
            synchronized (object2) {
                this.asyncResult = object;
                this.asyncWaitMutex.notifyAll();
            }
        }
    }

    public void kickDevice(String path) throws IOException {
        JsonObject d = new JsonObject();
        d.addProperty("class", "DEVICE");
        d.addProperty("path", path);
        this.voidCommand("?DEVICE=" + d);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleDisconnected() throws IOException {
        Object object = this.asyncMutex;
        synchronized (object) {
            if (this.socket != null) {
                this.socket.close();
            }
            this.socket = new Socket(this.server, this.port);
            this.in = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
            this.out = new BufferedWriter(new OutputStreamWriter(this.socket.getOutputStream()));
            this.listenThread = new SocketThread(this.in, this, this.resultParser, this.daemon);
            this.listenThread.start();
            if (this.lastWatch != null) {
                this.syncCommand(this.lastWatch, WatchObject.class);
            }
        }
    }

    public void setRetryInterval(long millis) {
        this.retryInterval.set(millis);
    }

    public long getRetryInterval() {
        return this.retryInterval.get();
    }
}

