/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.keystore.request.handler;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.cloudconnection.message.KuraMessage;
import org.eclipse.kura.cloudconnection.request.RequestHandlerContext;
import org.eclipse.kura.core.keystore.request.PrivateKeyWriteRequest;
import org.eclipse.kura.core.keystore.request.handler.KeystoreServiceRequestHandler;
import org.eclipse.kura.core.keystore.util.PrivateKeyInfo;
import org.eclipse.kura.message.KuraPayload;
import org.eclipse.kura.message.KuraResponsePayload;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeystoreServiceRequestHandlerV2
extends KeystoreServiceRequestHandler {
    private static final Logger logger = LoggerFactory.getLogger(KeystoreServiceRequestHandlerV2.class);
    protected static final String PRIVATEKEY = "privatekey";
    private static final List<String> PRIVATE_KEY_RESOURCE = Arrays.asList("keystores", "entries", "privatekey");

    public KeystoreServiceRequestHandlerV2() {
        super("KEYS-V2");
    }

    @Override
    public KuraMessage doPost(RequestHandlerContext context, KuraMessage reqMessage) throws KuraException {
        List<String> resourcePath = KeystoreServiceRequestHandlerV2.extractResourcePath(reqMessage);
        if (!PRIVATE_KEY_RESOURCE.equals(resourcePath)) {
            return super.doPost(context, reqMessage);
        }
        KuraPayload reqPayload = reqMessage.getPayload();
        String body = new String(reqPayload.getBody(), StandardCharsets.UTF_8);
        PrivateKeyInfo privateKeyInfo = this.unmarshal(body, PrivateKeyInfo.class);
        this.validateAs(privateKeyInfo, PrivateKeyWriteRequest::new);
        try {
            this.storePrivateKeyEntryInternal(privateKeyInfo);
        }
        catch (Exception e) {
            logger.warn("Failed to store private key entry", (Throwable)e);
            return new KuraMessage((KuraPayload)new KuraResponsePayload(500));
        }
        return new KuraMessage((KuraPayload)new KuraResponsePayload(200));
    }
}

