/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.util.pushstream;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import org.osgi.util.pushstream.AbstractBufferBuilder;
import org.osgi.util.pushstream.PushEvent;
import org.osgi.util.pushstream.PushEventSource;
import org.osgi.util.pushstream.PushStream;
import org.osgi.util.pushstream.PushStreamBuilder;
import org.osgi.util.pushstream.PushStreamProvider;
import org.osgi.util.pushstream.PushbackPolicy;
import org.osgi.util.pushstream.PushbackPolicyOption;
import org.osgi.util.pushstream.QueuePolicy;
import org.osgi.util.pushstream.QueuePolicyOption;

class PushStreamBuilderImpl<T, U extends BlockingQueue<PushEvent<? extends T>>>
extends AbstractBufferBuilder<PushStream<T>, T, U>
implements PushStreamBuilder<T, U> {
    private final PushStreamProvider psp;
    private final PushEventSource<T> eventSource;
    private final Executor previousExecutor;
    private final ScheduledExecutorService previousScheduler;
    private boolean unbuffered;

    PushStreamBuilderImpl(PushStreamProvider psp, Executor defaultExecutor, ScheduledExecutorService defaultScheduler, PushEventSource<T> eventSource) {
        this.psp = psp;
        this.previousExecutor = defaultExecutor;
        this.previousScheduler = defaultScheduler;
        this.eventSource = eventSource;
        this.worker = defaultExecutor;
    }

    @Override
    public PushStreamBuilder<T, U> withBuffer(U queue) {
        this.unbuffered = false;
        return (PushStreamBuilder)super.withBuffer(queue);
    }

    @Override
    public PushStreamBuilder<T, U> withQueuePolicy(QueuePolicy<T, U> queuePolicy) {
        this.unbuffered = false;
        return (PushStreamBuilder)super.withQueuePolicy(queuePolicy);
    }

    @Override
    public PushStreamBuilder<T, U> withQueuePolicy(QueuePolicyOption queuePolicyOption) {
        this.unbuffered = false;
        return (PushStreamBuilder)super.withQueuePolicy(queuePolicyOption);
    }

    @Override
    public PushStreamBuilder<T, U> withPushbackPolicy(PushbackPolicy<T, U> pushbackPolicy) {
        this.unbuffered = false;
        return (PushStreamBuilder)super.withPushbackPolicy(pushbackPolicy);
    }

    @Override
    public PushStreamBuilder<T, U> withPushbackPolicy(PushbackPolicyOption pushbackPolicyOption, long time) {
        this.unbuffered = false;
        return (PushStreamBuilder)super.withPushbackPolicy(pushbackPolicyOption, time);
    }

    @Override
    public PushStreamBuilder<T, U> withParallelism(int parallelism) {
        this.unbuffered = false;
        return (PushStreamBuilder)super.withParallelism(parallelism);
    }

    @Override
    public PushStreamBuilder<T, U> withExecutor(Executor executor) {
        return (PushStreamBuilder)super.withExecutor(executor);
    }

    @Override
    public PushStreamBuilder<T, U> withScheduler(ScheduledExecutorService scheduler) {
        return (PushStreamBuilder)super.withScheduler(scheduler);
    }

    @Override
    public PushStreamBuilder<T, U> unbuffered() {
        this.unbuffered = true;
        return this;
    }

    @Override
    public PushStream<T> build() {
        ScheduledExecutorService timerToUse;
        Executor workerToUse = this.worker == null ? this.previousExecutor : this.worker;
        ScheduledExecutorService scheduledExecutorService = timerToUse = this.timer == null ? this.previousScheduler : this.timer;
        if (this.unbuffered) {
            return this.psp.createUnbufferedStream(this.eventSource, workerToUse, timerToUse);
        }
        return this.psp.createStream(this.eventSource, this.concurrency, workerToUse, timerToUse, this.buffer, this.bufferingPolicy, this.backPressure);
    }
}

