/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.doc.gen.business.core.ui.wizards;

import org.eclipse.emf.edit.ui.action.LoadResourceAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.polarsys.kitalpha.doc.gen.business.core.preference.helper.DocgenBrandingPreferencesHelper;
import org.polarsys.kitalpha.doc.gen.business.core.ui.wizards.string.Messages;

public class HTMLDocumentationBrandingWizardPage
extends WizardPage {
    private Text copyrightText;
    private Text logoPathText;
    private Text logoAltText;

    public HTMLDocumentationBrandingWizardPage() {
        super("wizardPage");
        this.setTitle(Messages.HTMLDocumentationGenerationWizardPage_title);
        this.setDescription(Messages.HTMLDocumentationBrandingWizardPage_description);
    }

    public void createControl(Composite parent) {
        Composite container = this.createContent(parent);
        this.loadPreferencesValues();
        this.dialogChanged();
        this.setControl((Control)container);
    }

    public String getCopyright() {
        return this.copyrightText != null && this.doesCopyrightChanged() ? this.copyrightText.getText() : null;
    }

    public String getLogoPath() {
        return this.logoPathText != null && this.doesLogoPathChanged() ? this.logoPathText.getText() : null;
    }

    public String getLogoAlt() {
        return this.logoAltText != null && this.doesLogoAltChanged() ? this.logoAltText.getText() : null;
    }

    public void askUserForUpdatingBrandingDataPreferences() {
        if (this.doesBrandingDataChanged()) {
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            MessageDialog dialog = new MessageDialog(shell, "Branding data", null, "Would you like to update the prefereences with the wizard data", 3, new String[]{"Yes", "No"}, 0);
            int result = dialog.open();
            if (result == 0) {
                this.updateBrandingPreferences();
            }
        }
    }

    public boolean doesCopyrightChanged() {
        return !this.copyrightText.getText().equals(DocgenBrandingPreferencesHelper.getCopyright());
    }

    public boolean doesLogoPathChanged() {
        return !this.logoPathText.getText().equals(DocgenBrandingPreferencesHelper.getLogoPath());
    }

    public boolean doesLogoAltChanged() {
        return !this.logoAltText.getText().equals(DocgenBrandingPreferencesHelper.getLogoAlternateText());
    }

    public boolean doesBrandingDataChanged() {
        return this.doesCopyrightChanged() || this.doesLogoPathChanged() || this.doesLogoAltChanged();
    }

    public void updateBrandingPreferences() {
        IPreferenceStore store = DocgenBrandingPreferencesHelper.STORE;
        if (!this.copyrightText.getText().equals(DocgenBrandingPreferencesHelper.getCopyright())) {
            store.setValue("DocdenBrandingCopyright", this.copyrightText.getText());
        }
        if (!this.logoPathText.getText().equals(DocgenBrandingPreferencesHelper.getLogoPath())) {
            store.setValue("DocdenBrandingLogo", this.logoPathText.getText());
        }
        if (!this.logoAltText.getText().equals(DocgenBrandingPreferencesHelper.getLogoAlternateText())) {
            store.setValue("DocdenBrandingLogoALT", this.logoAltText.getText());
        }
        if (this.logoPathText.getText().equals("Default") && this.logoAltText.getText().equals("[Default logo]")) {
            store.setValue("DocdenBrandingUseDefaultLogo", true);
        } else {
            store.setValue("DocdenBrandingUseDefaultLogo", false);
        }
    }

    private Composite createContent(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 3;
        layout.verticalSpacing = 10;
        Label copyrightLabel = new Label(container, 0);
        copyrightLabel.setText(Messages.HTMLDocumentationBrandingWizardPage_Copyright);
        this.copyrightText = new Text(container, 2052);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.copyrightText.setLayoutData((Object)gd);
        Label imageLabel = new Label(container, 0);
        imageLabel.setText(Messages.HTMLDocumentationBrandingWizardPage_Logo_Path);
        this.logoPathText = new Text(container, 2052);
        this.logoPathText.setLayoutData((Object)new GridData(768));
        this.logoPathText.setEnabled(false);
        this.logoPathText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                HTMLDocumentationBrandingWizardPage.this.dialogChanged();
            }
        });
        Button button = new Button(container, 8);
        button.setText(Messages.HTMLDocumentationGenerationWizardPage_browse_text);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HTMLDocumentationBrandingWizardPage.this.imageSelection();
            }
        });
        Label logoAltLabel = new Label(container, 0);
        logoAltLabel.setText(Messages.HTMLDocumentationBrandingWizardPage_Logo_ALT);
        this.logoAltText = new Text(container, 2052);
        this.logoAltText.setLayoutData((Object)gd);
        return container;
    }

    private void loadPreferencesValues() {
        this.copyrightText.setText(DocgenBrandingPreferencesHelper.getCopyright());
        this.logoPathText.setText(DocgenBrandingPreferencesHelper.getLogoPath());
        this.logoAltText.setText(DocgenBrandingPreferencesHelper.getLogoAlternateText());
    }

    private void dialogChanged() {
        String logoPqth = this.logoPathText.getText();
        if (logoPqth.equals("Default")) {
            this.updateStatus(null);
        }
    }

    private void updateStatus(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    private void imageSelection() {
        String uriText;
        LoadResourceAction.LoadResourceDialog dialog = new LoadResourceAction.LoadResourceDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        if (dialog.open() == 0 && (uriText = dialog.getURIText()) != null) {
            this.logoPathText.setText(uriText);
        }
    }
}

