/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.handlers.workspace;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.polarsys.kitalpha.ad.viewpoint.coredomain.viewpoint.model.Property;
import org.polarsys.kitalpha.ad.viewpoint.coredomain.viewpoint.model.PropertySet;
import org.polarsys.kitalpha.ad.viewpoint.coredomain.viewpoint.model.Viewpoint;
import org.polarsys.kitalpha.ad.viewpoint.coredomain.viewpoint.model.ViewpointFactory;
import org.polarsys.kitalpha.ad.viewpoint.coredomain.viewpoint.tools.model.ViewpointElement;
import org.polarsys.kitalpha.ad.viewpoint.handlers.IConfigurationHandler;
import org.polarsys.kitalpha.ad.viewpoint.handlers.ResourceManager;
import org.polarsys.kitalpha.ad.viewpoint.handlers.workspace.WorkspaceManager;

public class ConfigurationHandler
extends WorkspaceManager.ElementHandler
implements IConfigurationHandler {
    public ConfigurationHandler(Viewpoint viewpoint, ResourceManager mgr) {
        super(viewpoint, mgr);
    }

    private PropertySet createPropertySet() {
        PropertySet propertySet = ViewpointFactory.eINSTANCE.createPropertySet();
        propertySet.setTarget(this.getViewpoint());
        propertySet.setVpid(EcoreUtil.generateUUID());
        this.getWorkspace().getPropertySets().add((Object)propertySet);
        return propertySet;
    }

    @Override
    public void createProperty(String name) {
        if (this.getWorkspace() == null) {
            throw new IllegalStateException("no workspace available");
        }
        PropertySet set = this.getCurrentPropertySet();
        Property prop = ViewpointFactory.eINSTANCE.createProperty();
        prop.setName(name);
        prop.setVpid(EcoreUtil.generateUUID());
        set.getNewProperties().add((Object)prop);
        prop.setName(name);
        this.saveModel();
    }

    @Override
    public void removeProperties(List<Property> properties) {
        for (Property prop : properties) {
            if (!this.isRemovable((ViewpointElement)prop)) continue;
            PropertySet set = (PropertySet)prop.eContainer();
            set.getNewProperties().remove((Object)prop);
        }
        this.saveModel();
    }

    private PropertySet getCurrentPropertySet() {
        PropertySet set = this.getWorkspace().getPropertySet(this.getViewpoint());
        if (set == null) {
            set = this.createPropertySet();
        }
        return set;
    }

    @Override
    protected String getIdentifier(ViewpointElement elt) {
        return elt.getName();
    }

    @Override
    public List<ViewpointElement> getElements() {
        PropertySet set;
        EList toRemove = null;
        EList toAdd = null;
        HashMap<String, ViewpointElement> name2elt = new HashMap<String, ViewpointElement>();
        for (ViewpointElement elt : this.getViewpoint().getProperties()) {
            name2elt.put(this.getIdentifier(elt), elt);
        }
        if (this.getWorkspace() != null && (set = this.getWorkspace().getPropertySet(this.getViewpoint())) != null) {
            toRemove = set.getHiddenProperties();
            toAdd = set.getNewProperties();
        }
        return this.computeElements((List<? extends ViewpointElement>)this.getViewpoint().getProperties(), (List<? extends ViewpointElement>)toRemove, (List<? extends ViewpointElement>)toAdd);
    }

    @Override
    public List<ViewpointElement> getElementsFromParents() {
        HashMap<String, ViewpointElement> name2prop = new HashMap<String, ViewpointElement>();
        for (Viewpoint vp : this.getViewpoint().getAllParents()) {
            this.processViewpoint(vp, name2prop);
        }
        this.processViewpoint(this.getViewpoint(), name2prop);
        return new ArrayList<ViewpointElement>(name2prop.values());
    }

    private void processViewpoint(Viewpoint vp, Map<String, ViewpointElement> name2prop) {
        for (ViewpointElement elt : vp.getProperties()) {
            name2prop.put(this.getIdentifier(elt), elt);
        }
    }
}

